/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import cz.polreich.spagetka.SerialPortController;
import cz.polreich.spagetka.utils.ExceptionHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.util.Pair;

public class MDBController
extends SerialPortController {
    static String combine = "";
    private final List<String> responseStackProperty = new ArrayList();

    public List<String> getResponseStack() {
        return this.responseStackProperty;
    }

    public void addToResponseStack(String value) {
        this.responseStackProperty.add(value);
    }

    public MDBController(String portPath, int baudRate, int dataBits, int stopBits) {
        this.portPath = portPath;
        this.baudRate = baudRate;
        this.dataBits = dataBits;
        this.stopBits = stopBits;
        this.connection = SerialPort.getCommPort((String)this.portPath);
        this.connection.setBaudRate(this.baudRate);
        this.connection.setNumDataBits(this.dataBits);
        this.connection.setNumStopBits(this.stopBits);
        this.connection.setComPortTimeouts(1, 0, 0);
        this.connection.openPort();
        this.connection.addDataListener((SerialPortDataListener)new /* Unavailable Anonymous Inner Class!! */);
        this.input = this.connection.getInputStream();
        this.output = this.connection.getOutputStream();
        this.buffer = new byte[512];
    }

    public Pair<Boolean, String> sendMessage(String message, String expectedResponse) {
        return this.sendMessage(message, expectedResponse, 5000L, true);
    }

    public Pair<Boolean, String> sendMessage(String message, String expectedResponse, boolean awaitResponse) {
        return this.sendMessage(message, expectedResponse, 5000L, awaitResponse);
    }

    public Pair<Boolean, String> sendMessage(String message, String expectedResponse, boolean awaitResponse, boolean useRegex) {
        return this.sendMessage(message, expectedResponse, 5000L, awaitResponse, useRegex);
    }

    public Pair<Boolean, String> sendMessage(String message, String expectedResponse, long responseTimeout, boolean awaitResponse) {
        return this.sendMessage(message, expectedResponse, responseTimeout, awaitResponse, false);
    }

    public Pair<Boolean, String> sendMessage(String message, String expectedResponse, long responseTimeout, boolean awaitResponse, boolean useRegex) {
        return this.sendMessage(message, expectedResponse, responseTimeout, awaitResponse, useRegex, true);
    }

    public Pair<Boolean, String> sendMessage(String message, String expectedResponse, long responseTimeout, boolean awaitResponse, boolean useRegex, boolean repeatForUnknown) {
        try {
            String actualResponse = null;
            this.getResponseStack().clear();
            ArrayList response = new ArrayList();
            this.output.write((message + "\r\n").getBytes("US-ASCII"));
            if (awaitResponse) {
                Thread.sleep(1000L);
                long startTime = System.currentTimeMillis();
                boolean responseReceived = false;
                while (!responseReceived && System.currentTimeMillis() - startTime < responseTimeout) {
                    for (Object object : this.getResponseStack()) {
                    }
                    if (useRegex) {
                        Pattern pattern = Pattern.compile(expectedResponse);
                        for (String item : this.getResponseStack()) {
                            Matcher matcher = pattern.matcher(item);
                            if (matcher.find()) {
                                responseReceived = true;
                                actualResponse = item;
                                continue;
                            }
                            if (!item.equals("UNKNCMD") || !repeatForUnknown) continue;
                            return this.sendMessage(message, expectedResponse, responseTimeout, awaitResponse, useRegex, false);
                        }
                        continue;
                    }
                    if (this.getResponseStack().contains(expectedResponse)) {
                        responseReceived = true;
                        actualResponse = expectedResponse;
                        continue;
                    }
                    if (!this.getResponseStack().contains("UNKNCMD") || !repeatForUnknown) continue;
                    return this.sendMessage(message, expectedResponse, responseTimeout, awaitResponse, useRegex, false);
                }
                return new Pair((Object)responseReceived, actualResponse);
            }
            return new Pair((Object)true, null);
        }
        catch (IOException | InterruptedException e) {
            ExceptionHandler.logException((Exception)e);
            return new Pair((Object)false, null);
        }
    }

    public Object sendMessageGetResponse(String message, String expectedResponse, boolean awaitResponse, boolean useRegex) {
        return this.sendMessage(message, expectedResponse, 5000L, awaitResponse, useRegex);
    }

    public List<String> parseResponses(byte[] input) {
        String string = new String(input);
        return Arrays.asList(string.split("\n"));
    }

    public boolean enableBillAcceptor() {
        return this.enableBillAcceptor(true);
    }

    public boolean enableBillAcceptor(boolean awaitResponse) {
        return (Boolean)this.sendMessage("BILLENABLE", "BILLENABLEOK", awaitResponse).getKey();
    }

    public boolean disableBillAcceptor() {
        return this.disableBillAcceptor(true);
    }

    public boolean disableBillAcceptor(boolean awaitResponse) {
        return (Boolean)this.sendMessage("BILLDISABLE", "BILLDISABLEOK", awaitResponse).getKey();
    }

    public boolean enableCashless() {
        return this.enableCashless(true);
    }

    public boolean enableCashless(boolean awaitResponse) {
        return (Boolean)this.sendMessage("CSLS1ENABLE", "CSLS1ENABLEOK", awaitResponse).getKey();
    }

    public boolean disableCashless() {
        return this.disableCashless(true);
    }

    public boolean disableCashless(boolean awaitResponse) {
        return (Boolean)this.sendMessage("CSLS1DISABLE", "CSLS1DISABLEOK", awaitResponse).getKey();
    }

    public boolean enableAllDevices() {
        return this.enableAllDevices(true);
    }

    public boolean enableAllDevices(boolean awaitResponse) {
        boolean res1 = this.enableBillAcceptor(awaitResponse);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            ExceptionHandler.logException((Exception)e);
        }
        boolean res2 = this.enableCashless(awaitResponse);
        return res1 && res2;
    }

    public boolean disableAllDevices() {
        return this.disableAllDevices(true);
    }

    public boolean disableAllDevices(boolean awaitResponse) {
        boolean res1 = this.disableBillAcceptor(awaitResponse);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            ExceptionHandler.logException((Exception)e);
        }
        boolean res2 = this.disableCashless(awaitResponse);
        return res1 && res2;
    }

    public boolean checkCashlessInited() {
        return this.checkCashlessInited(true);
    }

    public boolean checkCashlessInited(boolean awaitResponse) {
        return (Boolean)this.sendMessage("CSLS1INITED?", "CSLS1INITEDOK", awaitResponse).getKey();
    }

    public boolean checkCashlessActive() {
        return this.checkCashlessActive(true);
    }

    public boolean checkCashlessActive(boolean awaitResponse) {
        return (Boolean)this.sendMessage("CSLS1ACTIVE?", "CSLS1ACTIVEOK", awaitResponse).getKey();
    }

    public boolean checkBillAcceptorInited() {
        return this.checkBillAcceptorInited(true);
    }

    public boolean checkBillAcceptorInited(boolean awaitResponse) {
        return (Boolean)this.sendMessage("BILLINITED?", "BILLINITEDOK", awaitResponse).getKey();
    }

    public boolean checkBillAcceptorActive() {
        return this.checkBillAcceptorActive(true);
    }

    public boolean checkBillAcceptorActive(boolean awaitResponse) {
        return (Boolean)this.sendMessage("BILLACTIVE?", "BILLACTIVEOK", awaitResponse).getKey();
    }

    public Pair<Boolean, String> getCashlessStatus() {
        return this.getCashlessStatus(true);
    }

    public Pair<Boolean, String> getCashlessStatus(boolean awaitResponse) {
        return this.sendMessage("CSLS1STATUS?", "CSLS1STATUS\\((?:[0-9]{1,2},){9}[0-9]{1,2}\\)", awaitResponse, true);
    }

    public boolean enableCashlessDisableBill() {
        return this.enableCashlessDisableBill(true);
    }

    public boolean enableCashlessDisableBill(boolean awaitResponse) {
        boolean res1 = this.enableCashless(awaitResponse);
        if (!awaitResponse) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e1) {
                ExceptionHandler.logException((Exception)e1);
            }
        }
        boolean res2 = this.disableBillAcceptor(false);
        return res1 && res2;
    }

    public boolean enableBillDisableCashless() {
        return this.enableBillDisableCashless(true);
    }

    public boolean enableBillDisableCashless(boolean awaitResponse) {
        boolean res1 = this.enableBillAcceptor(awaitResponse);
        if (!awaitResponse) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e1) {
                ExceptionHandler.logException((Exception)e1);
            }
        }
        boolean res2 = this.disableCashless(false);
        return res1 && res2;
    }

    public boolean startCashlessTransaction(int price, int product) {
        return this.startCashlessTransaction(price, product, true);
    }

    public boolean startCashlessTransaction(int price, int product, boolean awaitResponse) {
        return (Boolean)this.sendMessage("CSLS1VNDREQ(" + price + "," + product + ")", "CSLS1VNDREQOK", awaitResponse).getKey();
    }

    public boolean confirmVending(int product) {
        return this.confirmVending(product, true);
    }

    public boolean confirmVending(int product, boolean awaitResponse) {
        return (Boolean)this.sendMessage("CSLS1VNDSUCC(" + product + ")", "CSLS1VNDSUCCOK", awaitResponse).getKey();
    }

    public boolean acceptBill() {
        return this.acceptBill(true);
    }

    public boolean acceptBill(boolean awaitResponse) {
        return (Boolean)this.sendMessage("BILLACCEPT", "BILLACCEPTOK", awaitResponse).getKey();
    }

    public boolean rejectBill() {
        return this.rejectBill(true);
    }

    public boolean rejectBill(boolean awaitResponse) {
        return (Boolean)this.sendMessage("BILLREJECT", "BILLREJECTOK", awaitResponse).getKey();
    }

    public boolean cancelCashlessTransaction() {
        return this.cancelCashlessTransaction(true);
    }

    public boolean cancelCashlessTransaction(boolean awaitResponse) {
        return (Boolean)this.sendMessage("CSLS1CANCEL", "CSLS1CACELOK", awaitResponse).getKey();
    }

    public boolean makeSureCashlessIsEnabled() {
        return this.makeSureCashlessIsEnabled(true);
    }

    public boolean makeSureCashlessIsEnabled(boolean awaitResponse) {
        return this.checkCashlessActive(awaitResponse) || this.enableCashless(awaitResponse);
    }

    public void close() throws IOException {
        this.input.close();
        this.output.close();
        this.connection.closePort();
    }

    public String getPortPath() {
        return this.portPath;
    }

    public void setPortPath(String portPath) {
        this.portPath = portPath;
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public void setBaudRate(int baudRate) {
        this.baudRate = baudRate;
    }

    public int getDataBits() {
        return this.dataBits;
    }

    public void setDataBits(int dataBits) {
        this.dataBits = dataBits;
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public void setStopBits(int stopBits) {
        this.stopBits = stopBits;
    }
}

