/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.DTO;

import com.fasterxml.jackson.annotation.JsonProperty;
import cz.polreich.spagetka.models.Category;
import cz.polreich.spagetka.models.CategoryPackagingSettings;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class CategoryDTO {
    private int id;
    private String name;
    private String imageFilePath;
    private String imageBytesBase64;
    @JsonProperty(value="cook_position")
    private int cookPosition;
    private Map<String, Integer> packaging = new HashMap();

    public CategoryDTO(Category category) {
        this.id = category.getId();
        this.name = category.getName();
        this.imageFilePath = category.getImageFilePath();
        this.imageBytesBase64 = category.getImageBytes() == null ? null : Arrays.toString(Base64.getEncoder().encode(category.getImageBytes()));
        this.cookPosition = category.getCookPosition();
        for (CategoryPackagingSettings packagingSettings : category.getPackaging()) {
            this.packaging.put(packagingSettings.getPackagingSettingsId().getPackagingProductId(), packagingSettings.getQuantity());
        }
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getImageFilePath() {
        return this.imageFilePath;
    }

    public String getImageBytesBase64() {
        return this.imageBytesBase64;
    }

    public int getCookPosition() {
        return this.cookPosition;
    }

    public Map<String, Integer> getPackaging() {
        return this.packaging;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setImageFilePath(String imageFilePath) {
        this.imageFilePath = imageFilePath;
    }

    public void setImageBytesBase64(String imageBytesBase64) {
        this.imageBytesBase64 = imageBytesBase64;
    }

    @JsonProperty(value="cook_position")
    public void setCookPosition(int cookPosition) {
        this.cookPosition = cookPosition;
    }

    public void setPackaging(Map<String, Integer> packaging) {
        this.packaging = packaging;
    }

    public CategoryDTO() {
    }

    public CategoryDTO(int id, String name, String imageFilePath, String imageBytesBase64, int cookPosition, Map<String, Integer> packaging) {
        this.id = id;
        this.name = name;
        this.imageFilePath = imageFilePath;
        this.imageBytesBase64 = imageBytesBase64;
        this.cookPosition = cookPosition;
        this.packaging = packaging;
    }
}

