/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.restControllers;

import com.fasterxml.jackson.annotation.JsonFormat;
import cz.polreich.spagetka.DTO.ProductsGroupDTO;
import cz.polreich.spagetka.models.ProductsGroup;
import cz.polreich.spagetka.restControllers.BaseRestController;
import cz.polreich.spagetka.service.ProductsGroupService;
import cz.polreich.spagetka.utils.ExceptionHandler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.EntityNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/productsGroups"})
@Tag(name="Products Groups API", description="Handles Products Groups operations")
public class ProductsGroupController
extends BaseRestController {
    @Autowired
    public ProductsGroupService productsGroupService;

    @GetMapping
    @ResponseBody
    @Operation(summary="Returns all Products Groups")
    public ResponseEntity<List<ProductsGroupDTO>> getAll(@RequestHeader Map<String, String> headers) {
        return this.processRequest(headers, () -> this.productsGroupService.findAll().stream().map(ProductsGroupDTO::new).toList());
    }

    @GetMapping(value={"/{id}"})
    @ResponseBody
    @Operation(summary="Returns one Products Groups with specified ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ProductsGroupDTO.class))}), @ApiResponse(responseCode="404", description="Not Found - The Menu Option with specified ID was not found", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))}), @ApiResponse(responseCode="500", description="Internal Server Error - Exception occurred during execution", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))})})
    public ResponseEntity<ProductsGroupDTO> getOne(@RequestHeader Map<String, String> headers, @PathVariable String id) {
        return this.processRequest(headers, () -> {
            try {
                return new ProductsGroupDTO(this.productsGroupService.findById(id));
            }
            catch (Exception e) {
                ExceptionHandler.logException((Exception)e);
                if (e.getClass().equals(EntityNotFoundException.class)) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "The Products Group with specified ID was not found");
                }
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Exception while getting the Products Group!");
            }
        });
    }

    @PostMapping
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    @ResponseBody
    @Operation(summary="Save one or multiple new Products Groups", description="Both Array and Single object instance can be provided")
    public ResponseEntity<List<ProductsGroupDTO>> saveAll(@RequestHeader Map<String, String> headers, @RequestBody List<ProductsGroupDTO> dtos) {
        return this.processRequest(headers, () -> {
            ArrayList<ProductsGroup> productsGroups = new ArrayList<ProductsGroup>();
            for (ProductsGroupDTO dto : dtos) {
                ProductsGroup productsGroup = new ProductsGroup(dto);
                productsGroups.add(productsGroup);
            }
            this.productsGroupService.saveAll(productsGroups);
            return dtos;
        });
    }

    @PutMapping(value={"/{id}"})
    @ResponseBody
    @Operation(summary="Replace one Products Group with specified ID", description="Updates existing or creates a new Products Group in case none found with provided ID")
    public ResponseEntity<ProductsGroupDTO> replaceOne(@RequestHeader Map<String, String> headers, @RequestBody ProductsGroupDTO newItem, @PathVariable String id) {
        return this.processRequest(headers, () -> {
            newItem.setId(id);
            this.productsGroupService.save(new ProductsGroup(newItem));
            return newItem;
        });
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Deletes one Menu Option with specified ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found - The Menu Option with specified ID was not found", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))}), @ApiResponse(responseCode="500", description="Internal Server Error - Exception occurred during execution", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))})})
    public void deleteOne(@RequestHeader Map<String, String> headers, @PathVariable String id) {
        if (this.isValidRequest(headers)) {
            try {
                this.productsGroupService.deleteById(id);
            }
            catch (Exception e) {
                ExceptionHandler.logException((Exception)e);
                if (e.getClass().equals(EntityNotFoundException.class)) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "The Products Group with specified ID was not found");
                }
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Exception while deleting the Products Group!");
            }
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
    }
}

