/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.cashierController.inventoryPopup;

import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.controllers.popup.cashierController.InventoryPopup;
import cz.polreich.spagetka.controllers.popup.cashierController.inventoryPopup.ErrorAnchorPane;
import cz.polreich.spagetka.models.StockItem;
import cz.polreich.spagetka.models.StockMovementLogItem;
import cz.polreich.spagetka.models.enums.STOCK_MOVEMENT_ACTION;
import cz.polreich.spagetka.models.enums.STOCK_OUT_ERROR_TYPE;
import cz.polreich.spagetka.models.gui.buttons.YellowButton;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.InventoryUtils;
import cz.polreich.spagetka.utils.ValidationUtils;
import java.time.LocalDateTime;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StockInPopup {
    private static final Logger log = LoggerFactory.getLogger(StockInPopup.class);
    private final InventoryPopup parentPopup;
    private final Label labelTitle;
    private final FlowPane bottomButtonFlowPane;
    private final AnchorPane popupAnchor;
    private final CashierController cashierController;
    private TextField itemTextField;
    private TextField locationTextField;
    private TextField quantityTextField;
    private final ErrorAnchorPane errorAnchorPane;

    public StockInPopup(InventoryPopup parentPopup) {
        this.parentPopup = parentPopup;
        this.labelTitle = parentPopup.getLabelTitle();
        this.bottomButtonFlowPane = parentPopup.getBottomButtonFlowPane();
        this.popupAnchor = parentPopup.getPopupAnchor();
        this.cashierController = parentPopup.getCashierController();
        this.init();
        this.errorAnchorPane = new ErrorAnchorPane((Pane)this.popupAnchor, this.locationTextField, this.itemTextField);
    }

    private void init() {
        this.parentPopup.hideButtons();
        this.parentPopup.setWidePopup();
        this.labelTitle.setText("Naskladneni");
        Label locationLabel = new Label("Lokace:");
        locationLabel.setFont(this.cashierController.subtitleFont);
        AnchorPane.setTopAnchor((Node)locationLabel, (Double)150.0);
        AnchorPane.setLeftAnchor((Node)locationLabel, (Double)10.0);
        Label itemLabel = new Label("Polo\u017eka:");
        itemLabel.setFont(this.cashierController.subtitleFont);
        AnchorPane.setTopAnchor((Node)itemLabel, (Double)300.0);
        AnchorPane.setLeftAnchor((Node)itemLabel, (Double)10.0);
        Label quantityLabel = new Label("Mno\u017estv\u00ed:");
        quantityLabel.setFont(this.cashierController.subtitleFont);
        AnchorPane.setTopAnchor((Node)quantityLabel, (Double)450.0);
        AnchorPane.setLeftAnchor((Node)quantityLabel, (Double)10.0);
        this.locationTextField = new TextField();
        this.locationTextField.setFont(this.cashierController.subtitleFont);
        this.locationTextField.maxWidth(550.0);
        AnchorPane.setTopAnchor((Node)this.locationTextField, (Double)200.0);
        AnchorPane.setLeftAnchor((Node)this.locationTextField, (Double)50.0);
        this.itemTextField = new TextField();
        this.itemTextField.setFont(this.cashierController.subtitleFont);
        this.itemTextField.maxWidth(550.0);
        AnchorPane.setTopAnchor((Node)this.itemTextField, (Double)350.0);
        AnchorPane.setLeftAnchor((Node)this.itemTextField, (Double)50.0);
        this.quantityTextField = new TextField();
        this.quantityTextField.setFont(this.cashierController.subtitleFont);
        this.quantityTextField.maxWidth(550.0);
        AnchorPane.setTopAnchor((Node)this.quantityTextField, (Double)500.0);
        AnchorPane.setLeftAnchor((Node)this.quantityTextField, (Double)50.0);
        YellowButton resetButton = new YellowButton("Reset");
        resetButton.setFont(this.cashierController.subtitleFont);
        resetButton.setMinSize(160.0, 40.0);
        this.bottomButtonFlowPane.getChildren().add((Object)resetButton);
        resetButton.setOnMousePressed(mouseEvent -> {
            this.cleanAll();
            this.requestFocus((Control)this.itemTextField);
        });
        this.locationTextField.requestFocus();
        this.locationTextField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((Object)KeyCode.TAB)) {
                if (this.locationTextField.getText().startsWith("sto")) {
                    this.requestFocus((Control)this.itemTextField);
                } else {
                    this.locationTextField.setText("");
                    this.requestFocus((Control)this.locationTextField);
                    this.parentPopup.playErrorSound();
                }
                keyEvent.consume();
            }
        });
        this.itemTextField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((Object)KeyCode.TAB)) {
                if (this.itemTextField.getText().startsWith("sti")) {
                    this.requestFocus((Control)this.quantityTextField);
                } else {
                    this.itemTextField.setText("");
                    this.requestFocus((Control)this.itemTextField);
                    this.parentPopup.playErrorSound();
                }
                keyEvent.consume();
            }
        });
        this.quantityTextField.setOnKeyPressed(arg_0 -> this.quantityTextFieldAction(arg_0));
        this.popupAnchor.getChildren().addAll((Object[])new Node[]{itemLabel, locationLabel, quantityLabel, this.itemTextField, this.locationTextField, this.quantityTextField});
    }

    private void quantityTextFieldAction(KeyEvent keyEvent) {
        if (keyEvent.getCode().equals((Object)KeyCode.TAB)) {
            String qrCode = this.itemTextField.getText();
            String location = this.locationTextField.getText();
            Double quantity = ValidationUtils.tryParseDouble((String)this.quantityTextField.getText());
            if (quantity == null) {
                this.errorAnchorPane.create(STOCK_OUT_ERROR_TYPE.MISSING_QUANTITY);
                this.quantityTextField.setText("");
                this.requestFocus((Control)this.quantityTextField);
                this.parentPopup.playErrorSound();
                keyEvent.consume();
                return;
            }
            if (quantity < 0.0) {
                this.errorAnchorPane.create(STOCK_OUT_ERROR_TYPE.NEGATIVE_QUANTITY, (Object)quantity);
                keyEvent.consume();
                return;
            }
            if (qrCode.startsWith("sti") && location.startsWith("sto")) {
                try {
                    StockItem stockItem;
                    location = InventoryUtils.trimInventoryLocation((String)location);
                    boolean stockItemExists = this.cashierController.stockItemService.existsByQrCodeAndLocation(qrCode, location);
                    if (stockItemExists) {
                        stockItem = (StockItem)this.cashierController.stockItemService.findByQrCodeAndLocation(qrCode, location).get(0);
                        stockItem.setQuantity(stockItem.getQuantity() + quantity);
                    } else {
                        stockItem = InventoryUtils.parseQrCodeToStockItem((String)qrCode);
                        stockItem.setLocation(location);
                        stockItem.setQuantity(quantity.doubleValue());
                    }
                    this.cashierController.stockItemService.save(stockItem);
                    StockMovementLogItem stockItemMovement = new StockMovementLogItem();
                    stockItemMovement.setStockMovementAction(STOCK_MOVEMENT_ACTION.ADDED);
                    stockItemMovement.setQuantity(quantity);
                    stockItemMovement.setStockItem(stockItem);
                    stockItemMovement.setTimestamp(LocalDateTime.now());
                    this.cashierController.stockMovementLogItemsService.save(stockItemMovement);
                    System.out.println("Saving new stock item with id: " + qrCode + " to position " + location);
                    this.itemTextField.setText("");
                    this.locationTextField.setText("");
                    this.quantityTextField.setText("");
                    this.parentPopup.playSuccessSound();
                    this.requestFocus((Control)this.locationTextField);
                }
                catch (Exception e) {
                    System.out.println("Failed to process with id: " + qrCode + " to position " + location);
                    this.cleanAll();
                    this.requestFocus((Control)this.locationTextField);
                    ExceptionHandler.logException((Exception)e);
                    this.parentPopup.playErrorSound();
                }
                keyEvent.consume();
            } else {
                System.out.println("Read invalid data with id: " + qrCode + " to position " + location + " and quantity " + quantity);
                this.cleanAll();
                this.requestFocus((Control)this.itemTextField);
                this.parentPopup.playErrorSound();
            }
        }
        keyEvent.consume();
    }

    private void cleanAll() {
        this.itemTextField.setText("");
        this.locationTextField.setText("");
        this.quantityTextField.setText("");
    }

    private void requestFocus(Control element) {
        Platform.runLater(() -> ((Control)element).requestFocus());
    }
}

