/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models.gui.buttons;

import cz.polreich.spagetka.models.gui.buttons.ButtonColorPalette;
import javafx.scene.control.Button;

public class CustomColor3DButton
extends Button {
    private String baseColorHex = "#000000";
    private final String baseStyle;
    private final String hoverStyle;
    private final String pressedStyle;

    public CustomColor3DButton() {
        this("", "#000000");
    }

    public CustomColor3DButton(String text, String baseColorHex) {
        super(text);
        this.baseColorHex = baseColorHex;
        ButtonColorPalette colorPalette = new ButtonColorPalette(this.baseColorHex);
        this.baseStyle = "-fx-padding: 8 15 15 15; -fx-background-insets: 0,0 0 5 0, 0 0 6 0, 0 0 7 0; -fx-background-radius: 8; -fx-background-color: linear-gradient(from 0% 93% to 0% 100%, " + colorPalette.getGradientStart() + " 0%, " + colorPalette.getGradientEnd() + " 100%), " + colorPalette.getBase() + ", " + colorPalette.getLight() + ", radial-gradient(center 50% 50%, radius 100%, " + colorPalette.getLight() + ", " + colorPalette.getLighter() + "); -fx-effect: dropshadow( gaussian , " + colorPalette.getShadow() + " , 4,0,0,1 );";
        this.hoverStyle = "-fx-padding: 8 15 15 15; -fx-background-insets: 0,0 0 5 0, 0 0 6 0, 0 0 7 0; -fx-background-radius: 8; -fx-background-color: linear-gradient(from 0% 93% to 0% 100%, " + colorPalette.getGradientStart() + " 0%, " + colorPalette.getGradientEnd() + " 100%), " + colorPalette.getBase() + ", " + colorPalette.getLight() + ", radial-gradient(center 50% 50%, radius 100%, " + colorPalette.getHoverLight() + ", " + colorPalette.getLighter() + "); -fx-effect: dropshadow( gaussian , " + colorPalette.getShadow() + " , 4,0,0,1 );";
        this.pressedStyle = "-fx-padding: 10 15 13 15; -fx-background-insets: 2 0 0 0,2 0 3 0, 2 0 4 0, 2 0 5 0; -fx-background-radius: 8; -fx-background-color: linear-gradient(from 0% 93% to 0% 100%, " + colorPalette.getGradientStart() + " 0%, " + colorPalette.getGradientEnd() + " 100%), " + colorPalette.getBase() + ", " + colorPalette.getLight() + ", radial-gradient(center 50% 50%, radius 100%, " + colorPalette.getLight() + ", " + colorPalette.getLighter() + "); -fx-effect: dropshadow( gaussian , " + colorPalette.getShadow() + " , 4,0,0,1 );";
        this.setStyle(this.baseStyle);
        this.initializeEventListeners();
    }

    private void initializeEventListeners() {
        this.setOnMouseEntered(e -> this.setStyle(this.hoverStyle));
        this.setOnMouseExited(e -> this.setStyle(this.baseStyle));
        this.setOnMousePressed(e -> this.setStyle(this.pressedStyle));
        this.setOnMouseReleased(e -> this.setStyle(this.baseStyle));
    }
}

