/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.DTO.ProductGroupsPriceDTO;
import cz.polreich.spagetka.models.ProductsGroup;
import cz.polreich.spagetka.service.ProductsGroupService;
import cz.polreich.spagetka.utils.ApplicationContextUtils;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.security.InvalidParameterException;

@Entity
@Table(name="product_groups_prices")
public class ProductGroupsPrice {
    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    private String id;
    @ManyToOne
    @JoinColumn(name="products_group_id")
    private ProductsGroup productsGroup;
    @Column
    private Double price;

    public ProductGroupsPrice(ProductGroupsPriceDTO dto) {
        this.id = dto.getId();
        ProductsGroupService productsGroupService = (ProductsGroupService)ApplicationContextUtils.getApplicationContext().getBean(ProductsGroupService.class);
        if (!productsGroupService.existsById(String.valueOf(dto.getAdditionalGroupId()))) {
            throw new InvalidParameterException("Product Group with ID " + dto.getAdditionalGroupId() + " not found.");
        }
        this.productsGroup = productsGroupService.findById(String.valueOf(dto.getAdditionalGroupId()));
        this.price = dto.getPrice();
    }

    public String getId() {
        return this.id;
    }

    public ProductsGroup getProductsGroup() {
        return this.productsGroup;
    }

    public Double getPrice() {
        return this.price;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setProductsGroup(ProductsGroup productsGroup) {
        this.productsGroup = productsGroup;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public ProductGroupsPrice() {
    }

    public ProductGroupsPrice(String id, ProductsGroup productsGroup, Double price) {
        this.id = id;
        this.productsGroup = productsGroup;
        this.price = price;
    }
}

