/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.orderConfirmationController;

import cz.polreich.spagetka.controllers.CustomerBaseController;
import cz.polreich.spagetka.controllers.CustomerOrderConfirmationController;
import cz.polreich.spagetka.models.CountryPrefix;
import cz.polreich.spagetka.models.gui.buttons.CancelButton;
import cz.polreich.spagetka.models.gui.buttons.ConfirmButton;
import cz.polreich.spagetka.models.gui.buttons.GrayButton;
import cz.polreich.spagetka.utils.FontUtils;
import cz.polreich.spagetka.utils.LayoutUtils;
import cz.polreich.spagetka.utils.RandomGenerator;
import cz.polreich.spagetka.utils.ResourceHelper;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.stage.Popup;
import javafx.stage.Window;

public class CustomerLoginPopup
extends Popup {
    private CustomerOrderConfirmationController orderConfirmationController;
    private ConfirmButton confirmButton;
    private CancelButton cancelButton;
    private TextField phoneTextField;
    private ComboBox<CountryPrefix> prefixComboBox = new ComboBox();
    private ObjectProperty<CountryPrefix> selectedCountryPrefix = new SimpleObjectProperty();
    private ListProperty<Integer> phoneNumberSpacesList = new SimpleListProperty();
    private HBox phoneInputBox = new HBox();
    private FlowPane keyboardFlowPane = new FlowPane();
    private HBox codeInputBox = new HBox();

    public CustomerLoginPopup(CustomerOrderConfirmationController customerOrderConfirmationController) {
        this.orderConfirmationController = customerOrderConfirmationController;
        AnchorPane popupAnchor = new AnchorPane();
        Label title = new Label();
        this.orderConfirmationController.bindStringToLocale(title, "customerLogin.label.title", this.orderConfirmationController.titleFont);
        title.setMaxWidth(700.0);
        FontUtils.setIdealFont((Label)title, (Font)this.orderConfirmationController.titleFont);
        AnchorPane.setTopAnchor((Node)title, (Double)30.0);
        AnchorPane.setLeftAnchor((Node)title, (Double)100.0);
        AnchorPane.setRightAnchor((Node)title, (Double)100.0);
        title.setAlignment(Pos.CENTER);
        Label subtitle = new Label();
        this.orderConfirmationController.bindStringToLocale(subtitle, "customerLogin.label.subtitle", this.orderConfirmationController.subtitleFont);
        subtitle.setMaxWidth(700.0);
        FontUtils.setIdealFont((Label)subtitle, (Font)this.orderConfirmationController.subtitleFont);
        AnchorPane.setTopAnchor((Node)subtitle, (Double)130.0);
        AnchorPane.setLeftAnchor((Node)subtitle, (Double)100.0);
        AnchorPane.setRightAnchor((Node)subtitle, (Double)100.0);
        subtitle.setAlignment(Pos.CENTER);
        this.prefixComboBox.getItems().addAll((Collection)this.orderConfirmationController.activeConfig.getCountryPrefixes());
        this.prefixComboBox.setMaxSize(35.0, 76.0);
        this.prefixComboBox.setMinSize(300.0, 76.0);
        this.prefixComboBox.setCellFactory(comboBox -> new /* Unavailable Anonymous Inner Class!! */);
        this.prefixComboBox.setButtonCell((ListCell)this.prefixComboBox.getCellFactory().call(null));
        this.prefixComboBox.getItems().stream().filter(item -> "+420".equals(item.getPrefix())).findFirst().ifPresent(arg_0 -> ((ComboBox)this.prefixComboBox).setValue(arg_0));
        this.selectedCountryPrefix.bind((ObservableValue)this.prefixComboBox.getSelectionModel().selectedItemProperty());
        this.phoneNumberSpacesList.bind((ObservableValue)Bindings.createObjectBinding(() -> {
            if (this.selectedCountryPrefix.get() != null) {
                String pattern = ((CountryPrefix)this.selectedCountryPrefix.get()).getPhoneNumberPattern();
                return FXCollections.observableList((List)this.getListOfSpaces(pattern));
            }
            return FXCollections.observableArrayList();
        }, (Observable[])new Observable[]{this.selectedCountryPrefix}));
        this.phoneTextField = new TextField();
        this.phoneTextField.setFont(this.orderConfirmationController.titleFont);
        this.phoneTextField.promptTextProperty().bind((ObservableValue)Bindings.createStringBinding(() -> ((CountryPrefix)this.selectedCountryPrefix.get()).getPhoneNumberPattern(), (Observable[])new Observable[]{this.selectedCountryPrefix}));
        this.phoneTextField.setAlignment(Pos.CENTER);
        this.phoneTextField.setFocusTraversable(false);
        this.phoneTextField.requestFocus();
        this.phoneInputBox.getChildren().addAll((Object[])new Node[]{this.prefixComboBox, this.phoneTextField});
        AnchorPane.setTopAnchor((Node)this.phoneInputBox, (Double)250.0);
        AnchorPane.setLeftAnchor((Node)this.phoneInputBox, (Double)100.0);
        AnchorPane.setRightAnchor((Node)this.phoneInputBox, (Double)100.0);
        this.keyboardFlowPane.setAlignment(Pos.CENTER);
        AnchorPane.setTopAnchor((Node)this.keyboardFlowPane, (Double)350.0);
        AnchorPane.setLeftAnchor((Node)this.keyboardFlowPane, (Double)100.0);
        AnchorPane.setRightAnchor((Node)this.keyboardFlowPane, (Double)100.0);
        GridPane keyboardGridPane = this.createNumberKeyboard();
        this.keyboardFlowPane.getChildren().add((Object)keyboardGridPane);
        this.confirmButton = new ConfirmButton();
        this.confirmButton.setMaxWidth(400.0);
        this.orderConfirmationController.bindStringToLocale((Button)this.confirmButton, "customerLogin.button.confirm", this.orderConfirmationController.titleFont);
        this.confirmButton.setMinSize(160.0, 40.0);
        this.confirmButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.validatePhoneNumber(this.phoneTextField.getText()), (Observable[])new Observable[]{this.phoneTextField.textProperty()}));
        this.cancelButton = new CancelButton();
        this.cancelButton.setMaxWidth(400.0);
        this.cancelButton.setMinSize(160.0, 40.0);
        Label footer = new Label();
        this.orderConfirmationController.bindStringToLocale(footer, "customerLogin.label.footer", this.orderConfirmationController.normalFont);
        subtitle.setMaxWidth(700.0);
        AnchorPane.setBottomAnchor((Node)footer, (Double)150.0);
        AnchorPane.setLeftAnchor((Node)footer, (Double)50.0);
        AnchorPane.setRightAnchor((Node)footer, (Double)50.0);
        footer.setAlignment(Pos.CENTER);
        footer.setTextAlignment(TextAlignment.CENTER);
        footer.setWrapText(true);
        footer.setPadding(LayoutUtils.getInsets((double)10.0, (double)0.0, (double)10.0, (double)0.0));
        FlowPane buttonsFlowPane = new FlowPane();
        buttonsFlowPane.setOrientation(Orientation.HORIZONTAL);
        buttonsFlowPane.setAlignment(Pos.CENTER);
        buttonsFlowPane.setHgap(30.0);
        AnchorPane.setBottomAnchor((Node)buttonsFlowPane, (Double)50.0);
        AnchorPane.setLeftAnchor((Node)buttonsFlowPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)buttonsFlowPane, (Double)0.0);
        buttonsFlowPane.getChildren().addAll((Object[])new Node[]{this.confirmButton, this.cancelButton});
        popupAnchor.setMinWidth(650.0);
        popupAnchor.setMinHeight(1000.0);
        popupAnchor.setStyle("-fx-background-color: " + this.orderConfirmationController.popupBackgroundColor + ";");
        popupAnchor.getStyleClass().add((Object)"popup-main-pane");
        popupAnchor.getChildren().addAll((Object[])new Node[]{title, subtitle, this.phoneInputBox, this.keyboardFlowPane, footer, buttonsFlowPane});
        this.getContent().add((Object)popupAnchor);
    }

    public void loadPopup(boolean isPayment) {
        this.loadPopup(isPayment, false);
    }

    public void loadPopup() {
        this.loadPopup(false, false);
    }

    public void loadPopup(boolean isPayment, boolean returnToLoadDiscountCodes) {
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            CustomerBaseController.lastPressTime = System.currentTimeMillis();
        });
        this.addEventFilter(TouchEvent.TOUCH_PRESSED, touchEvent -> {
            CustomerBaseController.lastPressTime = System.currentTimeMillis();
        });
        this.orderConfirmationController.activeConfig.getOpenedPopups().add(this);
        this.confirmButton.setOnMouseClicked(mouseEvent -> {
            String phoneNumber = (((CountryPrefix)this.selectedCountryPrefix.getValue()).getPrefix() + this.phoneTextField.getText()).replace(" ", "").strip();
            this.orderConfirmationController.activeConfig.getCurrentOrder().setCustomerPhoneNumber(phoneNumber);
            this.hide();
            if (isPayment) {
                this.orderConfirmationController.goToPayment();
            } else if (returnToLoadDiscountCodes) {
                String code = RandomGenerator.generateRandomString((int)6, (boolean)true);
                String message = MessageFormat.format(this.orderConfirmationController.strings.getString("phoneConfirmation.smsMessage.yourCodeIs"), code);
                this.orderConfirmationController.activeConfig.getPartnerServerRestClient().sendSmsMessage(phoneNumber, message);
                this.hide();
                this.orderConfirmationController.getPhoneConfirmationPopup().loadPopup(code);
            }
        });
        if (isPayment) {
            this.orderConfirmationController.bindStringToLocale((Button)this.cancelButton, "customerLogin.button.cancel2", this.orderConfirmationController.titleFont);
        } else {
            this.orderConfirmationController.bindStringToLocale((Button)this.cancelButton, "customerLogin.button.cancel", this.orderConfirmationController.titleFont);
        }
        this.cancelButton.setOnMouseClicked(mouseEvent -> {
            this.hide();
            if (isPayment) {
                this.orderConfirmationController.goToPayment();
            } else if (returnToLoadDiscountCodes) {
                this.orderConfirmationController.getLoadDiscountCodePopup().loadPopup(false);
            }
        });
        this.show((Window)this.orderConfirmationController.stage);
        ((Node)this.getContent().get(0)).requestFocus();
    }

    private GridPane createNumberKeyboard() {
        int i;
        LinkedList<Integer> buttonsOrder = new LinkedList<Integer>(List.of(new Integer[]{7, 8, 9, 4, 5, 6, 1, 2, 3}));
        GridPane gridPane = new GridPane();
        for (i = 0; i <= 2; ++i) {
            ColumnConstraints column = new ColumnConstraints();
            column.setHgrow(Priority.SOMETIMES);
            column.setMinWidth(10.0);
            column.setPrefWidth(100.0);
            gridPane.getColumnConstraints().add((Object)column);
        }
        for (i = 0; i <= 3; ++i) {
            RowConstraints row = new RowConstraints();
            row.setVgrow(Priority.SOMETIMES);
            row.setMinHeight(10.0);
            row.setPrefHeight(100.0);
            gridPane.getRowConstraints().add((Object)row);
        }
        Integer i2 = 1;
        while (i2 <= 9) {
            Object button = this.createKeyboardButton(String.valueOf(i2));
            int buttonIndex = buttonsOrder.indexOf(i2);
            int rowNumber = (int)Math.floor((double)buttonIndex / 3.0);
            int columnNumber = buttonIndex % 3;
            gridPane.add((Node)button, columnNumber, rowNumber);
            button = i2;
            i2 = i2 + 1;
        }
        GrayButton buttonZero = this.createKeyboardButton(String.valueOf(0));
        gridPane.add((Node)buttonZero, 1, 3);
        GrayButton buttonBackSpace = this.createKeyboardButton("x");
        buttonBackSpace.setGraphic((Node)ResourceHelper.getImageViewFromResourceName((String)"/resources/images/backspace_64.png"));
        gridPane.add((Node)buttonBackSpace, 2, 3);
        return gridPane;
    }

    private GrayButton createKeyboardButton(String label) {
        GrayButton button = new GrayButton();
        button.setId("keyboard_" + label);
        button.setFont(this.orderConfirmationController.subtitleFont);
        button.setAlignment(Pos.CENTER);
        button.setContentDisplay(ContentDisplay.CENTER);
        button.setFocusTraversable(false);
        button.setOnMouseClicked(arg_0 -> this.phoneNumber_keyboard_clicked(arg_0));
        button.setOnTouchPressed(arg_0 -> this.phoneNumber_keyboard_clicked(arg_0));
        if (!label.equals("x")) {
            button.setText(label);
        }
        button.setMinWidth(70.0);
        button.setMinHeight(70.0);
        button.setMaxWidth(70.0);
        button.setMaxHeight(70.0);
        button.setPadding(LayoutUtils.getInsets((double)10.0, (double)30.0, (double)10.0, (double)30.0));
        GridPane.setMargin((Node)button, (Insets)LayoutUtils.getInsets((double)0.0, (double)0.0, (double)0.0, (double)33.0));
        return button;
    }

    private void phoneNumber_keyboard_clicked(Event e) {
        String buttonId = ((GrayButton)e.getSource()).getId();
        String number = buttonId.split("_")[1];
        if (number.equals("x")) {
            if (!this.phoneTextField.getText().isEmpty()) {
                int toDelete = 1;
                if (this.phoneNumberSpacesList.contains((Object)(this.phoneTextField.getText().length() - 1))) {
                    toDelete = 2;
                }
                this.phoneTextField.setText(this.phoneTextField.getText().substring(0, this.phoneTextField.getText().length() - toDelete));
            }
        } else if (this.phoneTextField.getText().length() < ((CountryPrefix)this.selectedCountryPrefix.get()).getPhoneNumberPattern().length()) {
            this.phoneTextField.setText(this.phoneTextField.getText() + number);
            if (this.phoneNumberSpacesList.contains((Object)this.phoneTextField.getText().length())) {
                this.phoneTextField.setText(this.phoneTextField.getText() + " ");
            }
        }
    }

    private List<Integer> getListOfSpaces(String input) {
        return IntStream.range(0, input.length()).filter(i -> input.charAt(i) == " ".charAt(0)).boxed().collect(Collectors.toList());
    }

    private boolean validatePhoneNumber(String phoneNumber) {
        String blankNumber = phoneNumber.replaceAll("[0-9]", "X").strip();
        return blankNumber.equals(((CountryPrefix)this.selectedCountryPrefix.get()).getPhoneNumberPattern());
    }

    public void hide() {
        this.phoneTextField.setText("");
        this.orderConfirmationController.activeConfig.getOpenedPopups().remove(this);
        super.hide();
    }
}

