/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.DTO;

import cz.polreich.spagetka.DTO.CompositionItemDTO;
import cz.polreich.spagetka.DTO.ProductFreeVariantCategoryDTO;
import cz.polreich.spagetka.DTO.ProductVariantDTO;
import cz.polreich.spagetka.models.Product;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;

public class ProductDTO {
    private String id;
    private String name;
    private String shortName;
    private String cookMonitorName;
    private String receiptName;
    private String stickerName;
    private int category;
    private String description;
    private Double amountValue;
    private String amountUnit;
    private String ingredients;
    private List<CompositionItemDTO> composition;
    private List<ProductVariantDTO> variants;
    private List<ProductFreeVariantCategoryDTO> categoriesVariants;
    private List<String> alergens;
    private List<Integer> tags;
    private Double originalPrice;
    private Double actualPrice;
    private Double vatPercent;
    private String imageFilePath;
    private String imageBytesBase64;
    private boolean allowedAtKiosk;
    private Integer order;
    private Boolean isPackaging;

    public ProductDTO(Product product) {
        this.id = product.getId();
        this.name = product.getName();
        this.shortName = product.getShortName();
        this.cookMonitorName = product.getCookMonitorName();
        this.receiptName = product.getReceiptName();
        this.stickerName = product.getStickerName();
        this.category = product.getCategory();
        this.description = product.getDescription();
        this.amountValue = product.getAmountValue();
        this.amountUnit = product.getAmountUnit();
        this.ingredients = product.getIngredientsString();
        this.composition = product.getIngredients().stream().map(CompositionItemDTO::new).toList();
        this.variants = product.getProductVariants().stream().map(ProductVariantDTO::new).toList();
        this.categoriesVariants = product.getProductFreeVariantCategories().stream().map(ProductFreeVariantCategoryDTO::new).toList();
        this.alergens = product.getAlergens();
        this.tags = product.getTags().stream().map(Integer::valueOf).toList();
        this.originalPrice = product.getOriginalPrice();
        this.actualPrice = product.getActualPrice();
        this.vatPercent = product.getVatPercent();
        this.imageFilePath = product.getImageFilePath();
        this.imageBytesBase64 = product.getImageBytes() == null ? null : Arrays.toString(Base64.getEncoder().encode(product.getImageBytes()));
        this.allowedAtKiosk = product.isEnabled();
        this.order = product.getItemOrder();
        this.isPackaging = product.getPackagingItem();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getCookMonitorName() {
        return this.cookMonitorName;
    }

    public String getReceiptName() {
        return this.receiptName;
    }

    public String getStickerName() {
        return this.stickerName;
    }

    public int getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public Double getAmountValue() {
        return this.amountValue;
    }

    public String getAmountUnit() {
        return this.amountUnit;
    }

    public String getIngredients() {
        return this.ingredients;
    }

    public List<CompositionItemDTO> getComposition() {
        return this.composition;
    }

    public List<ProductVariantDTO> getVariants() {
        return this.variants;
    }

    public List<ProductFreeVariantCategoryDTO> getCategoriesVariants() {
        return this.categoriesVariants;
    }

    public List<String> getAlergens() {
        return this.alergens;
    }

    public List<Integer> getTags() {
        return this.tags;
    }

    public Double getOriginalPrice() {
        return this.originalPrice;
    }

    public Double getActualPrice() {
        return this.actualPrice;
    }

    public Double getVatPercent() {
        return this.vatPercent;
    }

    public String getImageFilePath() {
        return this.imageFilePath;
    }

    public String getImageBytesBase64() {
        return this.imageBytesBase64;
    }

    public boolean isAllowedAtKiosk() {
        return this.allowedAtKiosk;
    }

    public Integer getOrder() {
        return this.order;
    }

    public Boolean getIsPackaging() {
        return this.isPackaging;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public void setCookMonitorName(String cookMonitorName) {
        this.cookMonitorName = cookMonitorName;
    }

    public void setReceiptName(String receiptName) {
        this.receiptName = receiptName;
    }

    public void setStickerName(String stickerName) {
        this.stickerName = stickerName;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAmountValue(Double amountValue) {
        this.amountValue = amountValue;
    }

    public void setAmountUnit(String amountUnit) {
        this.amountUnit = amountUnit;
    }

    public void setIngredients(String ingredients) {
        this.ingredients = ingredients;
    }

    public void setComposition(List<CompositionItemDTO> composition) {
        this.composition = composition;
    }

    public void setVariants(List<ProductVariantDTO> variants) {
        this.variants = variants;
    }

    public void setCategoriesVariants(List<ProductFreeVariantCategoryDTO> categoriesVariants) {
        this.categoriesVariants = categoriesVariants;
    }

    public void setAlergens(List<String> alergens) {
        this.alergens = alergens;
    }

    public void setTags(List<Integer> tags) {
        this.tags = tags;
    }

    public void setOriginalPrice(Double originalPrice) {
        this.originalPrice = originalPrice;
    }

    public void setActualPrice(Double actualPrice) {
        this.actualPrice = actualPrice;
    }

    public void setVatPercent(Double vatPercent) {
        this.vatPercent = vatPercent;
    }

    public void setImageFilePath(String imageFilePath) {
        this.imageFilePath = imageFilePath;
    }

    public void setImageBytesBase64(String imageBytesBase64) {
        this.imageBytesBase64 = imageBytesBase64;
    }

    public void setAllowedAtKiosk(boolean allowedAtKiosk) {
        this.allowedAtKiosk = allowedAtKiosk;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public void setIsPackaging(Boolean isPackaging) {
        this.isPackaging = isPackaging;
    }

    public ProductDTO() {
    }

    public ProductDTO(String id, String name, String shortName, String cookMonitorName, String receiptName, String stickerName, int category, String description, Double amountValue, String amountUnit, String ingredients, List<CompositionItemDTO> composition, List<ProductVariantDTO> variants, List<ProductFreeVariantCategoryDTO> categoriesVariants, List<String> alergens, List<Integer> tags, Double originalPrice, Double actualPrice, Double vatPercent, String imageFilePath, String imageBytesBase64, boolean allowedAtKiosk, Integer order, Boolean isPackaging) {
        this.id = id;
        this.name = name;
        this.shortName = shortName;
        this.cookMonitorName = cookMonitorName;
        this.receiptName = receiptName;
        this.stickerName = stickerName;
        this.category = category;
        this.description = description;
        this.amountValue = amountValue;
        this.amountUnit = amountUnit;
        this.ingredients = ingredients;
        this.composition = composition;
        this.variants = variants;
        this.categoriesVariants = categoriesVariants;
        this.alergens = alergens;
        this.tags = tags;
        this.originalPrice = originalPrice;
        this.actualPrice = actualPrice;
        this.vatPercent = vatPercent;
        this.imageFilePath = imageFilePath;
        this.imageBytesBase64 = imageBytesBase64;
        this.allowedAtKiosk = allowedAtKiosk;
        this.order = order;
        this.isPackaging = isPackaging;
    }
}

