/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.utils;

import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.ProductFreeVariant;
import cz.polreich.spagetka.models.gui.buttons.GrayButton;
import cz.polreich.spagetka.utils.FormatUtils;
import cz.polreich.spagetka.utils.ResourceHelper;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;

/*
 * Exception performing whole class analysis ignored.
 */
public class LayoutUtils {
    public static Insets getInsets(double top, double right, double bottom, double left) {
        return new Insets(top, right, bottom, left);
    }

    public static void setImageForButton(String pathImage, Button button, int height, int weight) {
        InputStream is = LayoutUtils.class.getResourceAsStream(pathImage);
        Image image = new Image(is);
        ImageView imageView = new ImageView(image);
        imageView.setPreserveRatio(true);
        imageView.setFitHeight((double)height);
        imageView.setFitWidth((double)weight);
        button.setGraphic((Node)imageView);
    }

    public static Button createCircleButton(double radius, String imageName) {
        double diameter = 2.0 * radius;
        Button button = new Button();
        button.setShape((Shape)new Circle(radius));
        button.setMinSize(diameter, diameter);
        button.setMaxSize(diameter, diameter);
        button.setAlignment(Pos.CENTER);
        ImageView imageView = ResourceHelper.getImageViewFromResourceName((String)imageName);
        imageView.setFitHeight(radius);
        imageView.setFitWidth(radius);
        imageView.setPreserveRatio(true);
        button.setGraphic((Node)imageView);
        return button;
    }

    public static GridPane createNumberKeyboard(Font keyFont, EventHandler<? super Event> keyPressMethod) {
        int i;
        LinkedList<Integer> buttonsOrder = new LinkedList<Integer>(List.of(new Integer[]{7, 8, 9, 4, 5, 6, 1, 2, 3}));
        GridPane gridPane = new GridPane();
        for (i = 0; i <= 2; ++i) {
            ColumnConstraints column = new ColumnConstraints();
            column.setHgrow(Priority.SOMETIMES);
            column.setMinWidth(10.0);
            column.setPrefWidth(100.0);
            gridPane.getColumnConstraints().add((Object)column);
        }
        for (i = 0; i <= 3; ++i) {
            RowConstraints row = new RowConstraints();
            row.setVgrow(Priority.SOMETIMES);
            row.setMinHeight(10.0);
            row.setPrefHeight(100.0);
            gridPane.getRowConstraints().add((Object)row);
        }
        Integer i2 = 1;
        while (i2 <= 9) {
            Object button = LayoutUtils.createKeyboardButton((String)String.valueOf(i2), (Font)keyFont, keyPressMethod);
            int buttonIndex = buttonsOrder.indexOf(i2);
            int rowNumber = (int)Math.floor((double)buttonIndex / 3.0);
            int columnNumber = buttonIndex % 3;
            gridPane.add((Node)button, columnNumber, rowNumber);
            button = i2;
            i2 = i2 + 1;
        }
        GrayButton buttonZero = LayoutUtils.createKeyboardButton((String)String.valueOf(0), (Font)keyFont, keyPressMethod);
        gridPane.add((Node)buttonZero, 1, 3);
        GrayButton buttonBackSpace = LayoutUtils.createKeyboardButton((String)"x", (Font)keyFont, keyPressMethod);
        buttonBackSpace.setGraphic((Node)ResourceHelper.getImageViewFromResourceName((String)"/resources/images/backspace_64.png"));
        gridPane.add((Node)buttonBackSpace, 2, 3);
        return gridPane;
    }

    public static GrayButton createKeyboardButton(String label, Font font, EventHandler<? super Event> keyPressMethod) {
        GrayButton button = new GrayButton();
        button.setId("keyboard_" + label);
        button.setFont(font);
        button.setAlignment(Pos.CENTER);
        button.setContentDisplay(ContentDisplay.CENTER);
        button.setFocusTraversable(false);
        button.setOnMouseClicked(keyPressMethod);
        button.setOnTouchPressed(keyPressMethod);
        if (!label.equals("x")) {
            button.setText(label);
        }
        button.setMinWidth(70.0);
        button.setMinHeight(70.0);
        button.setMaxWidth(70.0);
        button.setMaxHeight(70.0);
        button.setPadding(LayoutUtils.getInsets((double)10.0, (double)30.0, (double)10.0, (double)30.0));
        GridPane.setMargin((Node)button, (Insets)LayoutUtils.getInsets((double)0.0, (double)0.0, (double)0.0, (double)33.0));
        return button;
    }

    public static HBox createOrderItemsList(OrderItem orderItem, String currencySymbol) {
        return LayoutUtils.createOrderItemsList((OrderItem)orderItem, (String)currencySymbol, (double)464.0);
    }

    public static HBox createOrderItemsList(OrderItem orderItem, String currencySymbol, double hBoxMaxWidth) {
        HBox orderItemsHBox = new HBox(10.0);
        orderItemsHBox.setMaxWidth(hBoxMaxWidth);
        Label quantityLabel = new Label(orderItem.getQuantity() + "x");
        quantityLabel.setMinWidth(30.0);
        quantityLabel.setPrefWidth(30.0);
        quantityLabel.setAlignment(Pos.CENTER_RIGHT);
        Label orderItemNameLabel = new Label(orderItem.getDisplayName());
        for (Product addProduct : orderItem.getAdditionalProducts()) {
            orderItemNameLabel.setText(orderItemNameLabel.getText() + "\n  - " + addProduct.getName());
        }
        for (ProductFreeVariant freeVariant : orderItem.getFreeVariants()) {
            orderItemNameLabel.setText(orderItemNameLabel.getText() + "\n  - " + freeVariant.getName());
        }
        double orderItemLabelWidth = hBoxMaxWidth - 114.0;
        orderItemNameLabel.setMinWidth(orderItemLabelWidth);
        orderItemNameLabel.setMaxWidth(orderItemLabelWidth);
        orderItemNameLabel.setWrapText(true);
        Label orderItemTotalPriceLabel = new Label(FormatUtils.formatCurrency((double)orderItem.getFinalPrice(), (String)currencySymbol));
        orderItemTotalPriceLabel.setMinWidth(80.0);
        orderItemTotalPriceLabel.setAlignment(Pos.CENTER_RIGHT);
        orderItemsHBox.getChildren().addAll((Object[])new Node[]{quantityLabel, orderItemNameLabel, orderItemTotalPriceLabel});
        return orderItemsHBox;
    }

    public static void setAnchors(Node node, Integer top, Integer right, Integer bottom, Integer left) {
        LayoutUtils.setAnchors((Node)node, (Double)(top != null ? Double.valueOf(top.doubleValue()) : null), (Double)(right != null ? Double.valueOf(right.doubleValue()) : null), (Double)(bottom != null ? Double.valueOf(bottom.doubleValue()) : null), left != null ? Double.valueOf(left.doubleValue()) : null);
    }

    public static void setAnchors(Node node, Double top, Double right, Double bottom, Double left) {
        AnchorPane.setTopAnchor((Node)node, (Double)top);
        AnchorPane.setRightAnchor((Node)node, (Double)right);
        AnchorPane.setBottomAnchor((Node)node, (Double)bottom);
        AnchorPane.setLeftAnchor((Node)node, (Double)left);
    }
}

