/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service.monitoring.service;

import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.models.User;
import cz.polreich.spagetka.service.monitoring.model.MonitoringData;
import javafx.beans.property.ObjectProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CashierActiveConfigService {
    private final CashierController cashierController;

    @Autowired
    public CashierActiveConfigService(CashierController cashierController) {
        this.cashierController = cashierController;
    }

    public void serLoggedUserForKioskStage(MonitoringData data) {
        ObjectProperty userProperty = this.cashierController.getActiveConfig().getLoggedInCashier();
        if (userProperty != null) {
            User user = (User)userProperty.getValue();
            if (user != null) {
                data.setUserLoggedIn(true);
                data.setUserId(String.valueOf(user.getId()));
            } else {
                data.setUserLoggedIn(false);
                data.setUserId("");
            }
        } else {
            data.setUserLoggedIn(false);
            data.setUserId("");
        }
    }

    public String getKioskName() {
        return this.cashierController.getActiveConfig().getKioskName().isEmpty() ? "No kiosk name" : this.cashierController.getActiveConfig().getKioskName();
    }
}

