/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service;

import cz.polreich.spagetka.models.InventoryCheckReportItem;
import cz.polreich.spagetka.repository.InventoryCheckReportsItemsRepository;
import jakarta.persistence.EntityNotFoundException;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InventoryCheckReportItemsService {
    @Autowired
    private InventoryCheckReportsItemsRepository inventoryCheckReportsItemsRepository;

    public void saveAll(List<InventoryCheckReportItem> items) {
        this.inventoryCheckReportsItemsRepository.saveAll(items);
    }

    public List<InventoryCheckReportItem> findAll() {
        return this.inventoryCheckReportsItemsRepository.findAll();
    }

    public List<InventoryCheckReportItem> findAllNonZero() {
        return this.inventoryCheckReportsItemsRepository.findAll();
    }

    public InventoryCheckReportItem findById(String id) {
        if (this.inventoryCheckReportsItemsRepository.findById((Object)id).isPresent()) {
            return (InventoryCheckReportItem)this.inventoryCheckReportsItemsRepository.findById((Object)id).get();
        }
        throw new EntityNotFoundException("[InventoryCheckReportItemsService] - InventoryCheckReportItem with ID: " + id + "was not found. (E-154)");
    }

    public void save(InventoryCheckReportItem item) {
        this.inventoryCheckReportsItemsRepository.save((Object)item);
    }

    public boolean existsById(String id) {
        return this.inventoryCheckReportsItemsRepository.existsById((Object)id);
    }

    public void deleteById(String id) {
        if (!this.inventoryCheckReportsItemsRepository.findById((Object)id).isPresent()) {
            throw new EntityNotFoundException("[InventoryCheckReportItemsService] - InventoryCheckReportItem with ID: " + id + "was not found. (E-154)");
        }
        this.inventoryCheckReportsItemsRepository.deleteById((Object)id);
    }

    public List<InventoryCheckReportItem> findAllFromDateTime(LocalDateTime fromDateTime) {
        return this.findAllInDateTimeFrame(fromDateTime, LocalDateTime.now());
    }

    public List<InventoryCheckReportItem> findAllToDateTime(LocalDateTime toDateTime) {
        return this.findAllInDateTimeFrame(LocalDateTime.parse("2024-01-01T00:00:00"), toDateTime);
    }

    public List<InventoryCheckReportItem> findAllInDateTimeFrame(LocalDateTime fromDateTime, LocalDateTime toDateTime) {
        return this.inventoryCheckReportsItemsRepository.findInventoryCheckItemsBetweenDateTimes(fromDateTime, toDateTime);
    }

    public List<InventoryCheckReportItem> findAllNonZeroFromDateTime(LocalDateTime fromDateTime) {
        return this.findAllNonZeroInDateTimeFrame(fromDateTime, LocalDateTime.now());
    }

    public List<InventoryCheckReportItem> findAllNonZeroToDateTime(LocalDateTime toDateTime) {
        return this.findAllNonZeroInDateTimeFrame(LocalDateTime.parse("2024-01-01T00:00:00"), toDateTime);
    }

    public List<InventoryCheckReportItem> findAllNonZeroInDateTimeFrame(LocalDateTime fromDateTime, LocalDateTime toDateTime) {
        return this.inventoryCheckReportsItemsRepository.findAllNonZeroBetweenDates(fromDateTime, toDateTime);
    }
}

