/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.restControllers;

import com.fasterxml.jackson.annotation.JsonFormat;
import cz.polreich.spagetka.DTO.IngredientDTO;
import cz.polreich.spagetka.models.Ingredient;
import cz.polreich.spagetka.restControllers.BaseRestController;
import cz.polreich.spagetka.service.IngredientService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/ingredients"})
@Tag(name="Ingredients API", description="Handles Ingredients operations")
public class IngredientController
extends BaseRestController {
    @Autowired
    public IngredientService ingredientService;

    @GetMapping
    @ResponseBody
    @Operation(summary="Returns all Ingredients")
    public ResponseEntity<List<IngredientDTO>> getAll(@RequestHeader Map<String, String> headers) {
        return this.processRequest(headers, () -> this.ingredientService.findAll().stream().map(IngredientDTO::new).toList());
    }

    @GetMapping(value={"/{id}"})
    @ResponseBody
    @Operation(summary="Returns one Ingredient with specified ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=IngredientDTO.class))}), @ApiResponse(responseCode="404", description="Not Found - The Ingredient with specified ID was not found", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))})})
    public ResponseEntity<IngredientDTO> getOne(@RequestHeader Map<String, String> headers, @PathVariable String id) {
        return this.processRequest(headers, () -> {
            if (this.ingredientService.existsById(id)) {
                return new IngredientDTO(this.ingredientService.findById(id));
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Ingredient with ID: " + id + " not found!");
        });
    }

    @PostMapping
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    @ResponseBody
    @Operation(summary="Save one or multiple new Ingredients", description="Both Array and Single object instance can be provided")
    public ResponseEntity<List<IngredientDTO>> saveAll(@RequestHeader Map<String, String> headers, @RequestBody List<IngredientDTO> dtos) {
        return this.processRequest(headers, () -> {
            ArrayList<Ingredient> categories = new ArrayList<Ingredient>();
            for (IngredientDTO dto : dtos) {
                Ingredient ingredient = new Ingredient(dto);
                categories.add(ingredient);
            }
            this.ingredientService.saveAll(categories);
            return dtos;
        });
    }

    @PutMapping(value={"/{id}"})
    @ResponseBody
    @Operation(summary="Replace one Ingredient with specified ID", description="Updates existing or creates a new Ingredient in case none found with provided ID")
    public ResponseEntity<IngredientDTO> replaceOne(@RequestHeader Map<String, String> headers, @RequestBody IngredientDTO newItem, @PathVariable String id) {
        return this.processRequest(headers, () -> {
            newItem.setId(id);
            this.ingredientService.save(new Ingredient(newItem));
            return newItem;
        });
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Deletes one Ingredient with specified ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found - The Ingredient with specified ID was not found", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))})})
    public void deleteOne(@RequestHeader Map<String, String> headers, @PathVariable String id) {
        if (this.isValidRequest(headers)) {
            if (!this.ingredientService.existsById(id)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Ingredient with ID: " + id + " not found!");
            }
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        this.ingredientService.deleteById(id);
    }
}

