/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.customerMainController;

import cz.polreich.spagetka.controllers.CustomerBaseController;
import cz.polreich.spagetka.controllers.CustomerMainController;
import cz.polreich.spagetka.controllers.popup.customerMainController.IceCreamPopup;
import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.ProductFreeVariant;
import cz.polreich.spagetka.models.ProductFreeVariantCategory;
import cz.polreich.spagetka.models.gui.buttons.CancelButton;
import cz.polreich.spagetka.models.gui.buttons.ConfirmButton;
import cz.polreich.spagetka.models.gui.panes.TouchScrollPane;
import cz.polreich.spagetka.utils.FontUtils;
import cz.polreich.spagetka.utils.FormatUtils;
import cz.polreich.spagetka.utils.ImageUtils;
import cz.polreich.spagetka.utils.LayoutUtils;
import cz.polreich.spagetka.utils.ResourceHelper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.stage.Popup;
import javafx.stage.Window;

/*
 * Exception performing whole class analysis ignored.
 */
public class IceCreamPopup
extends Popup {
    private CustomerMainController customerMainController;
    private FlowPane variantsMainFlowPane = new FlowPane();
    private AnchorPane productSelectionMainAnchorPane = new AnchorPane();
    private FlowPane bottomFlowPane = new FlowPane();
    private Label popupTitle = new Label();
    private TilePane topTilePane = new TilePane();
    private CancelButton backButton = new CancelButton();
    private double tileMinWidth;
    private double tileMinHeight;
    private double popupMinWidth;
    private double popupMinHeight;
    private double popupMaxWidth;
    private double popupMaxHeight;
    private List<ProductFreeVariantCategory> variantCategories;
    private TilePane lastStepInnerTilePane;
    private TouchScrollPane lastStepInnerScrollPane;
    private ObservableMap<String, String> selectedAddProducts;
    private ConfirmButton lastStepConfirmButton;
    private Product product;
    private List<ProductFreeVariant> allProductVariants;

    public IceCreamPopup(CustomerMainController customerMainController) {
        this.customerMainController = customerMainController;
        this.allProductVariants = customerMainController.productFreeVariantService.findAll();
        customerMainController.bindStringToLocale((Button)this.backButton, "iceCream.button.back", customerMainController.titleFont);
        this.backButton.setPrefWidth(296.0);
        this.backButton.setPrefHeight(100.0);
        FontUtils.setIdealFont((Button)this.backButton, (Font)customerMainController.titleFont);
        int tileColumns = 2;
        this.popupMinWidth = (double)customerMainController.activeConfig.getDisplayConfig().getResolution().getWidth() * 0.89;
        this.popupMinHeight = (double)customerMainController.activeConfig.getDisplayConfig().getResolution().getHeight() * 0.89;
        this.popupMaxWidth = (double)customerMainController.activeConfig.getDisplayConfig().getResolution().getWidth() * 0.89;
        this.popupMaxHeight = (double)customerMainController.activeConfig.getDisplayConfig().getResolution().getHeight() * 0.89;
        double topTileMinHeight = this.popupMinHeight * 0.7;
        this.tileMinHeight = this.tileMinWidth = this.popupMinWidth * 0.85 / (double)tileColumns;
        Insets popupPadding = new Insets(this.popupMinWidth * 0.1);
        this.variantsMainFlowPane.getStyleClass().add((Object)"popup-main-pane");
        this.variantsMainFlowPane.setStyle("-fx-background-color: " + customerMainController.popupBackgroundColor + ";");
        this.variantsMainFlowPane.setMinWidth(this.popupMinWidth);
        this.variantsMainFlowPane.setMinHeight(this.popupMinHeight);
        this.variantsMainFlowPane.setMaxWidth(this.popupMaxWidth);
        this.variantsMainFlowPane.setMaxHeight(this.popupMaxHeight);
        this.variantsMainFlowPane.setPadding(popupPadding);
        this.topTilePane.setMinWidth(this.popupMinWidth);
        this.topTilePane.setMinHeight(topTileMinHeight);
        this.topTilePane.setOrientation(Orientation.HORIZONTAL);
        this.topTilePane.setPrefColumns(tileColumns);
        this.topTilePane.setAlignment(Pos.CENTER);
        this.topTilePane.setHgap(50.0);
        this.topTilePane.setVgap(50.0);
        this.backButton.setOnMouseClicked(mouseEvent -> this.handlePopupBackButtonClick(1));
        this.backButton.setOnTouchPressed(touchEvent -> this.handlePopupBackButtonClick(1));
        this.bottomFlowPane.setOrientation(Orientation.HORIZONTAL);
        this.bottomFlowPane.setHgap(50.0);
        this.bottomFlowPane.setAlignment(Pos.CENTER);
        this.bottomFlowPane.getChildren().removeAll((Collection)this.bottomFlowPane.getChildren());
        this.bottomFlowPane.getChildren().add((Object)this.backButton);
        this.bottomFlowPane.setMinWidth(this.popupMinWidth);
        this.topTilePane.getChildren().removeAll((Collection)this.topTilePane.getChildren());
        this.popupTitle.setText(customerMainController.strings.getString("iceCream.label.title1"));
        this.popupTitle.getStyleClass().add((Object)"popup-title");
        this.popupTitle.setFont(customerMainController.popupTitleFont);
        this.variantsMainFlowPane.setAlignment(Pos.TOP_CENTER);
        this.variantsMainFlowPane.getChildren().add(0, (Object)this.popupTitle);
        this.variantsMainFlowPane.getChildren().add(1, (Object)this.topTilePane);
        this.variantsMainFlowPane.getChildren().add(2, (Object)this.bottomFlowPane);
        this.getContent().add((Object)this.variantsMainFlowPane);
        this.setAutoHide(false);
    }

    public void loadPopup(Product product) {
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            CustomerBaseController.lastPressTime = System.currentTimeMillis();
        });
        this.addEventFilter(TouchEvent.TOUCH_PRESSED, touchEvent -> {
            CustomerBaseController.lastPressTime = System.currentTimeMillis();
        });
        this.customerMainController.activeConfig.getOpenedPopups().add(this);
        this.product = product;
        this.variantCategories = product.getProductFreeVariantCategories();
        this.loadFirstMenu();
        this.show((Window)this.customerMainController.stage);
        ((Node)this.getContent().get(0)).requestFocus();
    }

    public void loadFirstMenu() {
        this.topTilePane.getChildren().removeAll((Collection)this.topTilePane.getChildren());
        VBox menuButtonVBox = this.createFirstLevelTile(TOP_LEVEL_TYPE.MENU, this.tileMinWidth, this.tileMinHeight);
        VBox individualButtonVBox = this.createFirstLevelTile(TOP_LEVEL_TYPE.INDIVIDUAL, this.tileMinWidth, this.tileMinHeight);
        this.topTilePane.getChildren().addAll((Object[])new Node[]{menuButtonVBox, individualButtonVBox});
    }

    private void handlePopupBackButtonClick(int mode) {
        switch (mode) {
            case 1: {
                this.hide();
                break;
            }
            case 2: {
                this.popupTitle.setText(this.customerMainController.strings.getString("iceCream.label.title1"));
                this.loadFirstMenu();
                this.backButton.setOnMouseClicked(mouseEvent -> this.handlePopupBackButtonClick(1));
                this.backButton.setOnTouchPressed(touchEvent -> this.handlePopupBackButtonClick(1));
                break;
            }
            case 3: {
                this.getContent().remove((Object)this.productSelectionMainAnchorPane);
                this.getContent().add((Object)this.variantsMainFlowPane);
                this.bottomFlowPane.getChildren().removeAll((Collection)this.bottomFlowPane.getChildren());
                this.bottomFlowPane.getChildren().add((Object)this.backButton);
                this.variantsMainFlowPane.getChildren().add(2, (Object)this.bottomFlowPane);
                this.backButton.setOnMouseClicked(mouseEvent -> this.handlePopupBackButtonClick(2));
                this.backButton.setOnTouchPressed(touchEvent -> this.handlePopupBackButtonClick(2));
            }
        }
    }

    private VBox createFirstLevelTile(TOP_LEVEL_TYPE type, double tileMinWidth, double tileMinHeight) {
        double tileWidth = tileMinWidth;
        double tileHeight = tileMinHeight;
        int tileCornerRadius = 50;
        int borderWidth = 1;
        double internalTileWidth = tileWidth - (double)(2 * borderWidth);
        double internalTileHeight = tileHeight - (double)(2 * borderWidth);
        double imageHeight = internalTileHeight * 0.6;
        double imageWidth = internalTileWidth * 1.0;
        double nameLabelTopAnchor = imageHeight + 5.0;
        double buttonWidth = tileWidth / 3.0;
        VBox vBox = new VBox(5.0);
        vBox.setMinSize(tileWidth, tileHeight);
        vBox.setMaxSize(tileWidth, tileHeight);
        vBox.setStyle("-fx-border-color:  lightgray;\n  -fx-border-width: " + borderWidth + "px;\n  -fx-border-style: solid;\n  -fx-border-radius: " + tileCornerRadius + "px;\n  -fx-background-color: white;\n  -fx-background-radius: " + tileCornerRadius + "px;\n  -fx-effect: dropshadow( gaussian , rgba(0,0,0,0.75) , 4,0,0,2 );");
        AnchorPane anchorPane = new AnchorPane();
        anchorPane.setMaxSize(internalTileWidth, internalTileHeight);
        anchorPane.setMinSize(internalTileWidth, internalTileHeight);
        String filePath = "";
        if (type == TOP_LEVEL_TYPE.MENU) {
            filePath = "/resources/images/iceCreamExtra.png";
        } else if (type == TOP_LEVEL_TYPE.INDIVIDUAL) {
            filePath = this.customerMainController.activeConfig.isAlwaysFetchFromDB() ? this.customerMainController.productService.findById(this.product.getId()).getImageFilePath() : this.customerMainController.activeConfig.getCurrentOffer().getProducts().stream().filter(p -> p.getId().equals(this.product.getId())).findFirst().get().getImageFilePath();
        }
        InputStream is = ResourceHelper.getImageAsStream((String)filePath);
        Image fullImage = new Image(is);
        ImageView imageView = ImageUtils.getCroppedImageView((Image)fullImage, (double)imageWidth, (double)imageHeight);
        imageView.setPreserveRatio(true);
        imageView.setFitWidth(imageWidth);
        imageView.setFitHeight(imageHeight);
        imageView.setClip((Node)ImageUtils.round((ImageView)imageView, (double)tileCornerRadius, (double)tileCornerRadius, (double)0.0, (double)0.0));
        StackPane stackPane = new StackPane();
        stackPane.setAlignment(Pos.CENTER);
        AnchorPane.setTopAnchor((Node)stackPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)stackPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)stackPane, (Double)0.0);
        stackPane.getChildren().add((Object)imageView);
        String labelText = "";
        if (type == TOP_LEVEL_TYPE.MENU) {
            labelText = this.customerMainController.strings.getString("iceCream.label.iceCreamExtra");
        } else if (type == TOP_LEVEL_TYPE.INDIVIDUAL) {
            labelText = this.customerMainController.strings.getString("iceCream.label.iceCreamOnly");
        }
        Label nameLabel = new Label(labelText);
        nameLabel.setFont(this.customerMainController.productTitleFont);
        nameLabel.setWrapText(true);
        nameLabel.setAlignment(Pos.CENTER);
        nameLabel.setTextAlignment(TextAlignment.CENTER);
        AnchorPane.setTopAnchor((Node)nameLabel, (Double)nameLabelTopAnchor);
        AnchorPane.setBottomAnchor((Node)nameLabel, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)nameLabel, (Double)2.0);
        AnchorPane.setRightAnchor((Node)nameLabel, (Double)2.0);
        anchorPane.getChildren().addAll((Object[])new Node[]{stackPane, nameLabel});
        vBox.getChildren().add((Object)anchorPane);
        vBox.setAlignment(Pos.CENTER);
        if (type == TOP_LEVEL_TYPE.MENU) {
            vBox.setOnMouseClicked(mouseEvent -> this.loadVariants());
            vBox.setOnTouchPressed(touchEvent -> this.loadVariants());
        } else if (type == TOP_LEVEL_TYPE.INDIVIDUAL) {
            vBox.setOnMouseClicked(mouseEvent -> {
                this.hide();
                this.customerMainController.addProductToOrder(this.product);
            });
        }
        this.backButton.setOnMouseClicked(mouseEvent -> this.handlePopupBackButtonClick(1));
        return vBox;
    }

    private void loadVariants() {
        List variantCategories = this.product.getProductFreeVariantCategories();
        if (!variantCategories.isEmpty()) {
            SimpleStringProperty selectedTab = new SimpleStringProperty(((ProductFreeVariantCategory)variantCategories.get(0)).getName());
            double leftPaneWidth = 200.0;
            Label newTitle = new Label();
            newTitle.setText(this.customerMainController.strings.getString("iceCream.label.title2"));
            newTitle.getStyleClass().add((Object)"popup-title");
            newTitle.setFont(this.customerMainController.popupTitleFont);
            newTitle.setMinWidth(this.popupMaxWidth);
            newTitle.setAlignment(Pos.CENTER);
            AnchorPane.setTopAnchor((Node)newTitle, (Double)50.0);
            AnchorPane.setLeftAnchor((Node)newTitle, (Double)0.0);
            AnchorPane.setRightAnchor((Node)newTitle, (Double)0.0);
            OrderItem orderItem = new OrderItem(this.product);
            this.selectedAddProducts = FXCollections.observableHashMap();
            this.lastStepConfirmButton = new ConfirmButton();
            this.customerMainController.bindStringToLocale((Button)this.lastStepConfirmButton, "iceCream.button.confirm", this.customerMainController.titleFont);
            this.lastStepConfirmButton.setPrefWidth(296.0);
            this.lastStepConfirmButton.setPrefHeight(100.0);
            FontUtils.setIdealFont((Button)this.lastStepConfirmButton, (Font)this.customerMainController.titleFont);
            this.lastStepConfirmButton.setDisable(true);
            this.lastStepConfirmButton.setOnMouseClicked(mouseEvent -> {
                List<String> selectedIds = this.selectedAddProducts.values().stream().filter(v -> !v.startsWith("0")).toList();
                orderItem.setFreeVariants(this.allProductVariants.stream().filter(var -> selectedIds.contains(var.getId())).toList());
                this.hide();
                this.customerMainController.addOrderItemToOrder(orderItem);
            });
            CancelButton secondBackButton = new CancelButton();
            this.customerMainController.bindStringToLocale((Button)secondBackButton, "iceCream.button.back", this.customerMainController.titleFont);
            secondBackButton.setPrefWidth(296.0);
            secondBackButton.setPrefHeight(100.0);
            FontUtils.setIdealFont((Button)secondBackButton, (Font)this.customerMainController.titleFont);
            secondBackButton.setOnMouseClicked(mouseEvent -> this.handlePopupBackButtonClick(3));
            secondBackButton.setOnTouchPressed(touchEvent -> this.handlePopupBackButtonClick(3));
            this.bottomFlowPane.getChildren().removeAll((Collection)this.bottomFlowPane.getChildren());
            this.bottomFlowPane.getChildren().addAll((Object[])new Node[]{secondBackButton, this.lastStepConfirmButton});
            AnchorPane.setLeftAnchor((Node)this.bottomFlowPane, (Double)0.0);
            AnchorPane.setRightAnchor((Node)this.bottomFlowPane, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)this.bottomFlowPane, (Double)50.0);
            this.productSelectionMainAnchorPane = new AnchorPane();
            this.productSelectionMainAnchorPane.getStyleClass().add((Object)"popup-main-pane");
            this.productSelectionMainAnchorPane.setStyle("-fx-background-color: " + this.customerMainController.popupBackgroundColor + ";");
            this.productSelectionMainAnchorPane.setMinWidth(this.popupMinWidth);
            this.productSelectionMainAnchorPane.setMinHeight(this.popupMaxHeight);
            this.productSelectionMainAnchorPane.setMaxWidth(this.popupMaxWidth);
            this.productSelectionMainAnchorPane.setMaxHeight(this.popupMaxHeight);
            this.lastStepInnerTilePane = new TilePane();
            this.lastStepInnerTilePane.setPadding(LayoutUtils.getInsets((double)10.0, (double)5.0, (double)10.0, (double)20.0));
            this.lastStepInnerTilePane.setStyle("-fx-background-color: " + this.customerMainController.popupBackgroundColor + ";");
            this.lastStepInnerTilePane.setPrefColumns(2);
            this.lastStepInnerTilePane.setHgap(20.0);
            this.lastStepInnerTilePane.setVgap(20.0);
            this.lastStepInnerScrollPane = new TouchScrollPane();
            this.lastStepInnerScrollPane.getStyleClass().add((Object)"edge-to-edge");
            this.lastStepInnerScrollPane.setStyle("    -fx-background-color: " + this.customerMainController.popupBackgroundColor + ";\n-fx-background-radius: 10 10 10 10;\n-fx-border-radius: 10 10 10 10;");
            this.lastStepInnerScrollPane.setContent((Node)this.lastStepInnerTilePane);
            AnchorPane.setTopAnchor((Node)this.lastStepInnerScrollPane, (Double)230.0);
            AnchorPane.setBottomAnchor((Node)this.lastStepInnerScrollPane, (Double)230.0);
            AnchorPane.setLeftAnchor((Node)this.lastStepInnerScrollPane, (Double)(leftPaneWidth + 20.0));
            AnchorPane.setRightAnchor((Node)this.lastStepInnerScrollPane, (Double)10.0);
            FlowPane leftFlowPane = new FlowPane();
            leftFlowPane.setMinWidth(leftPaneWidth);
            leftFlowPane.setMaxWidth(leftPaneWidth);
            leftFlowPane.setOrientation(Orientation.VERTICAL);
            leftFlowPane.setAlignment(Pos.TOP_CENTER);
            leftFlowPane.setVgap(30.0);
            leftFlowPane.setStyle("    -fx-background-color: " + this.customerMainController.popupBackgroundColor + ";\n-fx-background-radius: 30 30 30 30;\n-fx-border-radius: 30 30 30 30;\n");
            AnchorPane.setTopAnchor((Node)leftFlowPane, (Double)230.0);
            AnchorPane.setBottomAnchor((Node)leftFlowPane, (Double)230.0);
            AnchorPane.setLeftAnchor((Node)leftFlowPane, (Double)10.0);
            String buttonStyle = "    -fx-background-color: " + this.customerMainController.activeConfig.getColors().getPrimary() + ";\n-fx-background-radius: 30 30 30 30;\n-fx-border-radius: 30 30 30 30;\n-fx-font-size: 40px;\n-fx-font-family: \"lobster\";\n";
            String buttonStyleUnselected = buttonStyle + "\n-fx-effect: dropshadow( gaussian , rgba(0,0,0,0.75) , 4,0,0,2 );";
            String buttonStyleSelected = buttonStyle + "\n-fx-effect: innershadow( gaussian , gray , 4,0,0,2 );";
            ArrayList<ProductFreeVariantCategory> invalidCategories = new ArrayList<ProductFreeVariantCategory>();
            for (ProductFreeVariantCategory variantCategory : variantCategories) {
                if (variantCategory != null && variantCategory.getFreeVariants().stream().anyMatch(ProductFreeVariant::isEnabled)) {
                    InputStream greenTickIs = ResourceHelper.getImageAsStream((String)"/resources/images/green_tick_64.png");
                    Image greenTickImage = new Image(greenTickIs);
                    ImageView greenTickImageView = new ImageView();
                    greenTickImageView.setImage(greenTickImage);
                    greenTickImageView.setPreserveRatio(true);
                    greenTickImageView.setFitWidth(60.0);
                    greenTickImageView.setFitHeight(60.0);
                    ImageView emptyImageView = new ImageView();
                    emptyImageView.setFitWidth(60.0);
                    emptyImageView.setFitHeight(60.0);
                    Button button = IceCreamPopup.cerateVariantButton((ProductFreeVariantCategory)variantCategory, (StringProperty)selectedTab);
                    button.styleProperty().bind((ObservableValue)Bindings.createStringBinding(() -> IceCreamPopup.lambda$loadVariants$18((StringProperty)selectedTab, variantCategory, buttonStyleSelected, buttonStyleUnselected), (Observable[])new Observable[]{selectedTab}));
                    BooleanBinding containsKeyBinding = Bindings.createBooleanBinding(() -> this.selectedAddProducts.containsKey((Object)variantCategory.getId()), (Observable[])new Observable[]{this.selectedAddProducts});
                    button.graphicProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)containsKeyBinding).then((Object)greenTickImageView).otherwise((Object)emptyImageView));
                    leftFlowPane.getChildren().add((Object)button);
                    continue;
                }
                invalidCategories.add(variantCategory);
            }
            variantCategories.removeAll(invalidCategories);
            selectedTab.addListener((obs, oldValue, newValue) -> {
                this.lastStepInnerTilePane.getChildren().clear();
                ProductFreeVariantCategory variantCategory = variantCategories.stream().filter(g -> g.getName().equals(newValue)).findFirst().orElse(null);
                this.selectTab(variantCategory);
            });
            ProductFreeVariantCategory variantCategory = (ProductFreeVariantCategory)variantCategories.get(0);
            this.selectTab(variantCategory);
            this.productSelectionMainAnchorPane.getChildren().addAll((Object[])new Node[]{leftFlowPane, newTitle, this.lastStepInnerScrollPane, this.bottomFlowPane});
            this.getContent().remove((Object)this.variantsMainFlowPane);
            this.getContent().add((Object)this.productSelectionMainAnchorPane);
        } else {
            OrderItem orderItem = new OrderItem(this.product);
            this.hide();
            this.customerMainController.addOrderItemToOrder(orderItem);
        }
    }

    private static Button cerateVariantButton(ProductFreeVariantCategory variantCategory, StringProperty selectedTab) {
        Button button = new Button(variantCategory.getName());
        button.setFocusTraversable(false);
        button.setMinWidth(200.0);
        button.setMaxWidth(200.0);
        button.setMinHeight(200.0);
        button.setMaxHeight(200.0);
        button.setOnMouseClicked(mouseEvent -> selectedTab.set((Object)variantCategory.getName()));
        button.setOnTouchPressed(touchEvent -> selectedTab.set((Object)variantCategory.getName()));
        button.setGraphicTextGap(20.0);
        button.setContentDisplay(ContentDisplay.BOTTOM);
        return button;
    }

    private void selectTab(ProductFreeVariantCategory variantCategory) {
        if (variantCategory != null && variantCategory.getFreeVariants().stream().anyMatch(ProductFreeVariant::isEnabled)) {
            for (ProductFreeVariant variant : variantCategory.getFreeVariants()) {
                String selectedProductId;
                if (!variant.isEnabled()) continue;
                VBox tile = this.createProductTile(variant);
                if (this.selectedAddProducts.get((Object)variantCategory.getId()) != null && (selectedProductId = (String)this.selectedAddProducts.get((Object)variantCategory.getId())).equals(variant.getId())) {
                    tile.getStyleClass().add((Object)"selected");
                }
                tile.setOnMouseClicked(mouseEvent -> {
                    this.lastStepInnerTilePane.getChildren().forEach(ch -> ch.getStyleClass().remove((Object)"selected"));
                    this.selectedAddProducts.put((Object)variantCategory.getId(), (Object)variant.getId());
                    tile.getStyleClass().add((Object)"selected");
                    this.lastStepConfirmButton.setDisable(this.selectedAddProducts.size() != this.variantCategories.size());
                });
                tile.setOnTouchPressed(touchEvent -> {
                    this.lastStepInnerTilePane.getChildren().forEach(ch -> ch.getStyleClass().remove((Object)"selected"));
                    this.selectedAddProducts.put((Object)variantCategory.getId(), (Object)variant.getId());
                    tile.getStyleClass().add((Object)"selected");
                    this.lastStepConfirmButton.setDisable(this.selectedAddProducts.size() != this.variantCategories.size());
                });
                this.lastStepInnerTilePane.getChildren().add((Object)tile);
            }
        }
    }

    public VBox createProductTile(ProductFreeVariant variant) {
        int tileWidth = 325;
        int tileHeight = 325;
        int tileCornerRadius = 50;
        int borderWidth = 0;
        int nameLabelHeight = 30;
        int buttonHeight = 30;
        int internalTileWidth = tileWidth - 2 * borderWidth;
        int internalTileHeight = tileHeight - 2 * borderWidth;
        double imageViewFitHeight = (double)internalTileHeight * 0.6;
        double imageViewFitWidth = (double)internalTileWidth * 1.0;
        double nameLabelTopAnchor = imageViewFitHeight + 5.0;
        double imageBottomAnchor = (double)internalTileHeight - imageViewFitHeight;
        int buttonWidth = tileWidth / 3;
        VBox vBox = new VBox(5.0);
        vBox.setMinSize((double)tileWidth, (double)tileHeight);
        vBox.setMaxSize((double)tileWidth, (double)tileHeight);
        vBox.setStyle("-fx-border-color:  lightgray;\n  -fx-border-width: " + borderWidth + "px;\n  -fx-border-style: solid;\n  -fx-border-radius: " + tileCornerRadius + "px;\n  -fx-background-radius: " + tileCornerRadius + "px;");
        vBox.getStyleClass().add((Object)"product-vbox");
        AnchorPane anchorPane = new AnchorPane();
        anchorPane.setMaxSize((double)internalTileWidth, (double)internalTileHeight);
        anchorPane.setMinSize((double)internalTileWidth, (double)internalTileHeight);
        InputStream is = ResourceHelper.getImageAsStream((String)variant.getImageFilePath());
        Image fullImage = new Image(is);
        ImageView imageView = ImageUtils.getCroppedImageView((Image)fullImage, (double)imageViewFitWidth, (double)imageViewFitHeight);
        imageView.setPreserveRatio(true);
        imageView.setFitWidth(imageViewFitWidth);
        imageView.setFitHeight(imageViewFitHeight);
        imageView.setClip((Node)ImageUtils.round((ImageView)imageView, (double)tileCornerRadius, (double)tileCornerRadius, (double)0.0, (double)0.0));
        StackPane stackPane = new StackPane();
        stackPane.setAlignment(Pos.CENTER);
        AnchorPane.setTopAnchor((Node)stackPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)stackPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)stackPane, (Double)0.0);
        stackPane.getChildren().add((Object)imageView);
        Label nameLabel = new Label(variant.getName());
        nameLabel.setFont(this.customerMainController.productTitleFont);
        nameLabel.setWrapText(true);
        nameLabel.setAlignment(Pos.CENTER);
        nameLabel.setTextAlignment(TextAlignment.CENTER);
        AnchorPane.setTopAnchor((Node)nameLabel, (Double)nameLabelTopAnchor);
        AnchorPane.setLeftAnchor((Node)nameLabel, (Double)2.0);
        AnchorPane.setRightAnchor((Node)nameLabel, (Double)2.0);
        AnchorPane.setBottomAnchor((Node)nameLabel, (Double)39.0);
        InputStream tickIs = ResourceHelper.getImageAsStream((String)"/resources/images/green_tick_64.png");
        Image tickImage = new Image(tickIs);
        ImageView tickImageView = new ImageView();
        tickImageView.setImage(tickImage);
        tickImageView.setPreserveRatio(true);
        tickImageView.setFitWidth(60.0);
        tickImageView.setFitHeight(60.0);
        AnchorPane.setBottomAnchor((Node)tickImageView, (Double)10.0);
        AnchorPane.setLeftAnchor((Node)tickImageView, (Double)20.0);
        tickImageView.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> vBox.getStyleClass().contains((Object)"selected"), (Observable[])new Observable[]{vBox.getStyleClass()}));
        Label priceLabel = new Label(FormatUtils.formatCurrency((double)variant.getPrice(), (String)this.customerMainController.activeConfig.getKioskInfo().getCurrency().getSymbol(this.customerMainController.activeConfig.getSelectedLocale())));
        priceLabel.setAlignment(Pos.CENTER);
        priceLabel.setFont(this.customerMainController.priceLabelFont);
        AnchorPane.setBottomAnchor((Node)priceLabel, (Double)10.0);
        AnchorPane.setRightAnchor((Node)priceLabel, (Double)20.0);
        anchorPane.getChildren().addAll((Object[])new Node[]{stackPane, nameLabel, priceLabel, tickImageView});
        vBox.getChildren().add((Object)anchorPane);
        vBox.setAlignment(Pos.CENTER);
        vBox.setOnMouseClicked(mouseEvent -> this.handleProductSelection(variant));
        vBox.setOnTouchPressed(touchEvent -> this.handleProductSelection(variant));
        return vBox;
    }

    private void handleProductSelection(ProductFreeVariant variant) {
    }

    public void hide() {
        this.customerMainController.activeConfig.getOpenedPopups().remove(this);
        super.hide();
        this.customerMainController.refreshIceCreamPopup();
    }

    private static /* synthetic */ String lambda$loadVariants$18(StringProperty selectedTab, ProductFreeVariantCategory variantCategory, String buttonStyleSelected, String buttonStyleUnselected) throws Exception {
        return ((String)selectedTab.get()).equals(variantCategory.getName()) ? buttonStyleSelected : buttonStyleUnselected;
    }
}

