/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.cashierController;

import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.models.BranchStateItem;
import cz.polreich.spagetka.models.User;
import cz.polreich.spagetka.models.enums.BRANCH_STATE;
import cz.polreich.spagetka.models.gui.buttons.GrayButton;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.LayoutUtils;
import cz.polreich.spagetka.utils.ResourceHelper;
import java.util.LinkedList;
import java.util.List;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.stage.Popup;
import javafx.stage.Window;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class LogInPopup
extends Popup {
    private CashierController cashierController;
    private Label invalidDataLabel;
    private TextField passwordTextField = new TextField("");
    private String keyboardPresses = "";

    public LogInPopup(CashierController cashierController) {
        this.cashierController = cashierController;
        int popupWidth = 650;
        int popupHeight = 700;
        AnchorPane popupAnchor = new AnchorPane();
        popupAnchor.setOnKeyPressed(event -> {
            KeyCode code = event.getCode();
            if (code.isDigitKey()) {
                this.keyboardPresses = this.keyboardPresses + event.getText();
                System.out.println("keyboardPresses: " + this.keyboardPresses);
            }
            if (code == KeyCode.ENTER && !this.keyboardPresses.isEmpty()) {
                System.out.println("Trying login with: " + this.keyboardPresses);
                try {
                    User user = cashierController.userService.findByRfid(this.keyboardPresses);
                    if (user != null) {
                        this.loginUser(user);
                        this.hidePopup();
                        cashierController.deliveryTilePaneAction();
                    } else {
                        this.invalidDataLabel.setText("Neplatn\u00e1 karta");
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.logException((Exception)e);
                    this.invalidDataLabel.setText("Neplatn\u00e1 karta");
                }
                this.keyboardPresses = "";
            }
        });
        Label labelTitle = new Label();
        labelTitle.setText(cashierController.strings.getString("login"));
        AnchorPane.setTopAnchor((Node)labelTitle, (Double)15.0);
        AnchorPane.setLeftAnchor((Node)labelTitle, (Double)100.0);
        AnchorPane.setRightAnchor((Node)labelTitle, (Double)100.0);
        labelTitle.setAlignment(Pos.CENTER);
        labelTitle.setPadding(new Insets(20.0));
        labelTitle.setStyle("-fx-font-size: 40px;");
        this.invalidDataLabel = new Label("");
        this.invalidDataLabel.setMaxWidth(300.0);
        this.invalidDataLabel.setAlignment(Pos.CENTER);
        this.invalidDataLabel.setStyle("-fx-font-size: 22px; -fx-text-fill: red;");
        AnchorPane.setTopAnchor((Node)this.invalidDataLabel, (Double)170.0);
        AnchorPane.setLeftAnchor((Node)this.invalidDataLabel, (Double)150.0);
        AnchorPane.setRightAnchor((Node)this.invalidDataLabel, (Double)150.0);
        this.passwordTextField.setPromptText(cashierController.strings.getString("password"));
        this.passwordTextField.setAlignment(Pos.CENTER);
        AnchorPane.setTopAnchor((Node)this.passwordTextField, (Double)120.0);
        AnchorPane.setLeftAnchor((Node)this.passwordTextField, (Double)100.0);
        AnchorPane.setRightAnchor((Node)this.passwordTextField, (Double)100.0);
        this.passwordTextField.setFocusTraversable(false);
        this.passwordTextField.getStyleClass().add((Object)"login_text_field");
        this.passwordTextField.getProperties().put((Object)"vkType", (Object)"none");
        FlowPane keyboardFlowPane = new FlowPane();
        keyboardFlowPane.setAlignment(Pos.CENTER);
        AnchorPane.setTopAnchor((Node)keyboardFlowPane, (Double)180.0);
        AnchorPane.setLeftAnchor((Node)keyboardFlowPane, (Double)100.0);
        AnchorPane.setRightAnchor((Node)keyboardFlowPane, (Double)100.0);
        GridPane keyboardGridPane = this.createNumberKeyboard();
        keyboardFlowPane.getChildren().add((Object)keyboardGridPane);
        Button cancelButton = new Button(cashierController.strings.getString("cancel"));
        cancelButton.setMinSize(160.0, 40.0);
        AnchorPane.setBottomAnchor((Node)cancelButton, (Double)15.0);
        AnchorPane.setLeftAnchor((Node)cancelButton, (Double)100.0);
        cancelButton.getStyleClass().add((Object)"login_button");
        Button okButton = new Button(cashierController.strings.getString("signIn"));
        okButton.setMinSize(160.0, 40.0);
        AnchorPane.setBottomAnchor((Node)okButton, (Double)15.0);
        AnchorPane.setRightAnchor((Node)okButton, (Double)100.0);
        okButton.getStyleClass().add((Object)"login_button");
        okButton.setOnMouseClicked(mouseEvent -> this.okButtonAction(this.passwordTextField.getText()));
        okButton.setOnTouchPressed(touchEvent -> this.okButtonAction(this.passwordTextField.getText()));
        cancelButton.setOnMouseClicked(mouseEvent -> this.hidePopup());
        cancelButton.setOnTouchPressed(touchEvent -> this.hidePopup());
        popupAnchor.setMinWidth((double)popupWidth);
        popupAnchor.setMaxWidth((double)popupWidth);
        popupAnchor.setMinHeight((double)popupHeight);
        popupAnchor.setMaxHeight((double)popupHeight);
        popupAnchor.getStyleClass().add((Object)"login_anchor_pane");
        popupAnchor.getChildren().addAll((Object[])new Node[]{labelTitle, this.passwordTextField, keyboardFlowPane, this.invalidDataLabel, cancelButton, okButton});
        this.getContent().add((Object)popupAnchor);
    }

    public void loadPopup() {
        this.show((Window)this.cashierController.stage);
        ((Node)this.getContent().get(0)).requestFocus();
    }

    public void okButtonAction(String password) {
        block5: {
            if (!password.isEmpty()) {
                try {
                    User user = this.cashierController.userService.findByPassword(password);
                    if (user != null) {
                        this.loginUser(user);
                        this.hidePopup();
                        this.cashierController.deliveryTilePaneAction();
                        break block5;
                    }
                    this.invalidDataLabel.setText("Neplatn\u00e9 heslo");
                }
                catch (Exception e) {
                    ExceptionHandler.logException((Exception)e);
                    this.invalidDataLabel.setText("Neplatn\u00e9 heslo");
                }
            } else {
                this.invalidDataLabel.setText("Pros\u00edm zadejte heslo");
            }
        }
    }

    private void loginUser(User user) {
        this.cashierController.activeConfig.getLoggedInCashier().set((Object)user);
        this.cashierController.activeConfig.setNewBranchState(new BranchStateItem(BRANCH_STATE.OPEN, user));
    }

    public void hidePopup() {
        this.passwordTextField.setText("");
        this.invalidDataLabel.setText("");
        this.hide();
    }

    private GridPane createNumberKeyboard() {
        int i;
        LinkedList<Integer> buttonsOrder = new LinkedList<Integer>(List.of(new Integer[]{7, 8, 9, 4, 5, 6, 1, 2, 3}));
        GridPane gridPane = new GridPane();
        for (i = 0; i <= 2; ++i) {
            ColumnConstraints column = new ColumnConstraints();
            column.setHgrow(Priority.SOMETIMES);
            column.setMinWidth(10.0);
            column.setPrefWidth(100.0);
            gridPane.getColumnConstraints().add((Object)column);
        }
        for (i = 0; i <= 3; ++i) {
            RowConstraints row = new RowConstraints();
            row.setVgrow(Priority.SOMETIMES);
            row.setMinHeight(10.0);
            row.setPrefHeight(100.0);
            gridPane.getRowConstraints().add((Object)row);
        }
        Integer i2 = 1;
        while (i2 <= 9) {
            Object button = this.createKeyboardButton(String.valueOf(i2));
            int buttonIndex = buttonsOrder.indexOf(i2);
            int rowNumber = (int)Math.floor((double)buttonIndex / 3.0);
            int columnNumber = buttonIndex % 3;
            gridPane.add((Node)button, columnNumber, rowNumber);
            button = i2;
            i2 = i2 + 1;
        }
        GrayButton buttonZero = this.createKeyboardButton(String.valueOf(0));
        gridPane.add((Node)buttonZero, 1, 3);
        GrayButton buttonBackSpace = this.createKeyboardButton("x");
        buttonBackSpace.setGraphic((Node)ResourceHelper.getImageViewFromResourceName((String)"/resources/images/backspace_64.png"));
        gridPane.add((Node)buttonBackSpace, 2, 3);
        return gridPane;
    }

    private GrayButton createKeyboardButton(String label) {
        GrayButton button = new GrayButton();
        button.setId("keyboard_" + label);
        button.setFont(this.cashierController.subtitleFont);
        button.setAlignment(Pos.CENTER);
        button.setContentDisplay(ContentDisplay.CENTER);
        button.setFocusTraversable(false);
        button.setOnMouseClicked(arg_0 -> this.number_keyboard_clicked(arg_0));
        button.setOnTouchPressed(arg_0 -> this.number_keyboard_clicked(arg_0));
        if (!label.equals("x")) {
            button.setText(label);
        }
        button.setMinWidth(70.0);
        button.setMinHeight(70.0);
        button.setMaxWidth(70.0);
        button.setMaxHeight(70.0);
        button.setPadding(LayoutUtils.getInsets((double)10.0, (double)30.0, (double)10.0, (double)30.0));
        GridPane.setMargin((Node)button, (Insets)LayoutUtils.getInsets((double)0.0, (double)0.0, (double)0.0, (double)33.0));
        return button;
    }

    private void number_keyboard_clicked(Event e) {
        String buttonId = ((GrayButton)e.getSource()).getId();
        String number = buttonId.split("_")[1];
        if (number.equals("x")) {
            if (!this.passwordTextField.getText().isEmpty()) {
                int toDelete = 1;
                this.passwordTextField.setText(this.passwordTextField.getText().substring(0, this.passwordTextField.getText().length() - toDelete));
            }
        } else {
            this.passwordTextField.setText(this.passwordTextField.getText() + number);
        }
    }
}

