/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.cashierController;

import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.controllers.popup.cashierController.inventoryPopup.StockInPopup;
import cz.polreich.spagetka.controllers.popup.cashierController.inventoryPopup.StockOutPopup;
import cz.polreich.spagetka.guiElements.RadioToggleButton;
import cz.polreich.spagetka.models.CashManipulationItem;
import cz.polreich.spagetka.models.Ingredient;
import cz.polreich.spagetka.models.InventoryCheckReportItem;
import cz.polreich.spagetka.models.StockItem;
import cz.polreich.spagetka.models.StockMovementLogItem;
import cz.polreich.spagetka.models.User;
import cz.polreich.spagetka.models.enums.STOCK_MOVEMENT_ACTION;
import cz.polreich.spagetka.models.gui.buttons.CancelButton;
import cz.polreich.spagetka.models.gui.buttons.ConfirmButton;
import cz.polreich.spagetka.models.gui.buttons.GrayButton;
import cz.polreich.spagetka.models.gui.buttons.YellowButton;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.FormatUtils;
import cz.polreich.spagetka.utils.InventoryUtils;
import cz.polreich.spagetka.utils.LayoutUtils;
import cz.polreich.spagetka.utils.ReceiptPrinter;
import cz.polreich.spagetka.utils.ResourceHelper;
import cz.polreich.spagetka.utils.Triple;
import cz.polreich.spagetka.utils.ValidationUtils;
import cz.polreich.spagetka.utils.exceptions.PastaMakingValidationException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.text.TextAlignment;
import javafx.stage.Popup;
import javafx.stage.Screen;
import javafx.stage.Window;
import javafx.util.Duration;

public class InventoryPopup
extends Popup {
    private CashierController cashierController;
    private Button stockInButton;
    private Button stockOutButton;
    private Button inventoryCheckButton;
    private Button pastaMakingButton;
    private Button todayIncomeButton;
    private Button cashDiaryButton;
    private Label todayIncomeLabel;
    private AnchorPane popupAnchor;
    private static final Media soundError = new Media(Objects.requireNonNull(InventoryPopup.class.getResource("/resources/sounds/error-126627-2.mp3")).toExternalForm());
    private static final Media soundSuccess = new Media(Objects.requireNonNull(InventoryPopup.class.getResource("/resources/sounds/success-1-6297-2.mp3")).toExternalForm());
    private static MediaPlayer errorMediaPlayer = new MediaPlayer(soundError);
    private static MediaPlayer successMediaPlayer = new MediaPlayer(soundSuccess);
    private Label labelTitle;
    private FlowPane actionButtonFlowPane;
    private FlowPane bottomButtonFlowPane;
    private TextField amountTextField;
    private CancelButton cancelButton;

    public InventoryPopup(CashierController cashierController) {
        this.cashierController = cashierController;
        int popupWidth = 300;
        int popupHeight = 720;
        int minButtonWidth = 220;
        int maxButtonWidth = 300;
        this.popupAnchor = new AnchorPane();
        this.popupAnchor.setMinWidth((double)popupWidth);
        this.popupAnchor.setMaxWidth((double)popupWidth);
        this.popupAnchor.setMinHeight((double)popupHeight);
        this.popupAnchor.setMaxHeight((double)popupHeight);
        this.popupAnchor.getStyleClass().add((Object)"login_anchor_pane");
        this.labelTitle = new Label();
        this.labelTitle.setText(cashierController.strings.getString("inventory"));
        AnchorPane.setTopAnchor((Node)this.labelTitle, (Double)15.0);
        AnchorPane.setLeftAnchor((Node)this.labelTitle, (Double)10.0);
        AnchorPane.setRightAnchor((Node)this.labelTitle, (Double)10.0);
        this.labelTitle.setAlignment(Pos.CENTER);
        this.labelTitle.setPadding(new Insets(20.0));
        this.labelTitle.setStyle("-fx-font-size: 40px;");
        this.stockInButton = new Button("Naskladn\u011bn\u00ed");
        this.stockInButton.getStyleClass().add((Object)"login_button");
        this.stockInButton.maxWidth((double)maxButtonWidth);
        this.stockInButton.minWidth((double)minButtonWidth);
        this.stockInButton.setOnMouseClicked(mouseEvent -> this.stockInAction());
        this.stockInButton.setOnTouchPressed(touchEvent -> this.stockInAction());
        this.stockOutButton = new Button("Vyskladn\u011bn\u00ed");
        this.stockOutButton.getStyleClass().add((Object)"login_button");
        this.stockOutButton.maxWidth((double)maxButtonWidth);
        this.stockOutButton.minWidth((double)minButtonWidth);
        this.stockOutButton.setOnMouseClicked(mouseEvent -> this.stockOutAction());
        this.stockOutButton.setOnTouchPressed(touchEvent -> this.stockOutAction());
        this.inventoryCheckButton = new Button("Inventura");
        this.inventoryCheckButton.getStyleClass().add((Object)"login_button");
        this.inventoryCheckButton.maxWidth((double)maxButtonWidth);
        this.inventoryCheckButton.minWidth((double)minButtonWidth);
        this.inventoryCheckButton.setOnMouseClicked(mouseEvent -> this.inventoryCheckAction());
        this.inventoryCheckButton.setOnTouchPressed(touchEvent -> this.inventoryCheckAction());
        this.pastaMakingButton = new Button("V\u00fdroba t\u011bstovin");
        this.pastaMakingButton.getStyleClass().add((Object)"login_button");
        this.pastaMakingButton.maxWidth((double)maxButtonWidth);
        this.pastaMakingButton.minWidth((double)minButtonWidth);
        this.pastaMakingButton.setOnMouseClicked(mouseEvent -> this.pastaMakingAction());
        this.pastaMakingButton.setOnTouchPressed(touchEvent -> this.pastaMakingAction());
        this.todayIncomeButton = new Button("Dne\u0161n\u00ed tr\u017eba");
        this.todayIncomeButton.getStyleClass().add((Object)"login_button");
        this.todayIncomeButton.maxWidth((double)maxButtonWidth);
        this.todayIncomeButton.minWidth((double)minButtonWidth);
        this.todayIncomeButton.setOnMouseClicked(mouseEvent -> this.todayIncomeAction());
        this.todayIncomeButton.setOnTouchPressed(touchEvent -> this.todayIncomeAction());
        this.cashDiaryButton = new Button("Pokladna");
        this.cashDiaryButton.getStyleClass().add((Object)"login_button");
        this.cashDiaryButton.maxWidth((double)maxButtonWidth);
        this.cashDiaryButton.minWidth((double)minButtonWidth);
        this.cashDiaryButton.setOnMouseClicked(mouseEvent -> this.cashDiaryAction());
        this.cashDiaryButton.setOnTouchPressed(touchEvent -> this.cashDiaryAction());
        this.todayIncomeLabel = new Label();
        this.todayIncomeLabel.setFont(cashierController.subtitleFont);
        this.todayIncomeLabel.setAlignment(Pos.CENTER_LEFT);
        this.todayIncomeLabel.maxWidth((double)maxButtonWidth);
        AnchorPane.setTopAnchor((Node)this.todayIncomeLabel, (Double)350.0);
        AnchorPane.setRightAnchor((Node)this.todayIncomeLabel, (Double)20.0);
        this.actionButtonFlowPane = new FlowPane();
        this.actionButtonFlowPane.setOrientation(Orientation.VERTICAL);
        this.actionButtonFlowPane.setVgap(10.0);
        this.actionButtonFlowPane.setAlignment(Pos.TOP_LEFT);
        this.actionButtonFlowPane.setPrefHeight(600.0);
        AnchorPane.setTopAnchor((Node)this.actionButtonFlowPane, (Double)100.0);
        AnchorPane.setLeftAnchor((Node)this.actionButtonFlowPane, (Double)20.0);
        AnchorPane.setRightAnchor((Node)this.actionButtonFlowPane, (Double)20.0);
        this.bottomButtonFlowPane = new FlowPane();
        this.bottomButtonFlowPane.setOrientation(Orientation.HORIZONTAL);
        this.bottomButtonFlowPane.setHgap(20.0);
        this.bottomButtonFlowPane.setVgap(20.0);
        this.bottomButtonFlowPane.setAlignment(Pos.CENTER);
        AnchorPane.setBottomAnchor((Node)this.bottomButtonFlowPane, (Double)15.0);
        AnchorPane.setLeftAnchor((Node)this.bottomButtonFlowPane, (Double)20.0);
        AnchorPane.setRightAnchor((Node)this.bottomButtonFlowPane, (Double)20.0);
        this.cancelButton = new CancelButton(cashierController.strings.getString("cancel"));
        this.cancelButton.setMinSize(160.0, 40.0);
        this.cancelButton.setFont(cashierController.subtitleFont);
        this.cancelButton.setOnMouseClicked(mouseEvent -> this.hidePopup());
        this.cancelButton.setOnTouchPressed(touchEvent -> this.hidePopup());
        this.actionButtonFlowPane.getChildren().addAll((Object[])new Node[]{this.stockInButton, this.stockOutButton, this.inventoryCheckButton, this.pastaMakingButton, this.todayIncomeButton, this.cashDiaryButton});
        this.bottomButtonFlowPane.getChildren().add((Object)this.cancelButton);
        this.popupAnchor.getChildren().addAll((Object[])new Node[]{this.labelTitle, this.actionButtonFlowPane, this.todayIncomeLabel, this.bottomButtonFlowPane});
        this.getContent().add((Object)this.popupAnchor);
    }

    public void loadPopup() {
        this.show((Window)this.cashierController.stage);
    }

    private void hidePopup() {
        this.cashierController.hideInventoryPopup();
    }

    public void hideButtons() {
        this.stockInButton.setVisible(false);
        this.stockOutButton.setVisible(false);
        this.inventoryCheckButton.setVisible(false);
        this.pastaMakingButton.setVisible(false);
        this.todayIncomeButton.setVisible(false);
        this.cashDiaryButton.setVisible(false);
        this.todayIncomeLabel.setVisible(false);
    }

    private void setPopupWidth(double popupWidth) {
        this.popupAnchor.setMinWidth(popupWidth);
        this.popupAnchor.setMaxWidth(popupWidth);
        Platform.runLater(() -> this.recenterPopup());
    }

    private void setNarrowPopup() {
        this.setPopupWidth(300.0);
    }

    public void setWidePopup() {
        this.setPopupWidth(650.0);
    }

    private void setExtendedPopup() {
        this.setPopupWidth(1000.0);
    }

    private void todayIncomeAction() {
        this.setWidePopup();
        Triple todayIncome = this.cashierController.receiptService.getIncomeForToday();
        String total = FormatUtils.formatCurrency((BigDecimal)((BigDecimal)todayIncome.getFirst()), (String)this.cashierController.activeConfig.getKioskInfo().getCurrency().getSymbol(this.cashierController.activeConfig.getSelectedLocale()));
        String cash = FormatUtils.formatCurrency((BigDecimal)((BigDecimal)todayIncome.getSecond()), (String)this.cashierController.activeConfig.getKioskInfo().getCurrency().getSymbol(this.cashierController.activeConfig.getSelectedLocale()));
        String card = FormatUtils.formatCurrency((BigDecimal)((BigDecimal)todayIncome.getThird()), (String)this.cashierController.activeConfig.getKioskInfo().getCurrency().getSymbol(this.cashierController.activeConfig.getSelectedLocale()));
        String manipulations = FormatUtils.formatCurrency((double)this.cashierController.cashManipulationItemsService.getCashManipulationsForToday(), (String)this.cashierController.activeConfig.getKioskInfo().getCurrency().getSymbol(this.cashierController.activeConfig.getSelectedLocale()));
        this.todayIncomeLabel.setText("Celkem: " + total + "\nHotov\u011b: " + cash + "\nKartou: " + card + "\n Zm\u011bny: " + manipulations);
    }

    private void pastaMakingAction() {
        this.hideButtons();
        this.setWidePopup();
        this.labelTitle.setText("V\u00fdroba t\u011bstovin");
        Label codeLabel = new Label("K\u00f3d sm\u011bsi:");
        codeLabel.setFont(this.cashierController.subtitleFont);
        AnchorPane.setTopAnchor((Node)codeLabel, (Double)100.0);
        AnchorPane.setLeftAnchor((Node)codeLabel, (Double)10.0);
        ToggleGroup pastaTypeToggleGroup = new ToggleGroup();
        RadioToggleButton spaghettiButton = new RadioToggleButton();
        spaghettiButton.setText("\u0160pagety");
        spaghettiButton.setFont(this.cashierController.subtitleFont);
        spaghettiButton.setToggleGroup(pastaTypeToggleGroup);
        spaghettiButton.setPrefWidth(250.0);
        spaghettiButton.setId("pastaMakingButton_" + this.cashierController.activeConfig.getSpaghettiIngredientId());
        AnchorPane.setTopAnchor((Node)spaghettiButton, (Double)270.0);
        AnchorPane.setLeftAnchor((Node)spaghettiButton, (Double)50.0);
        RadioToggleButton fusilliButton = new RadioToggleButton();
        fusilliButton.setText("Fusilli");
        fusilliButton.setFont(this.cashierController.subtitleFont);
        fusilliButton.setToggleGroup(pastaTypeToggleGroup);
        fusilliButton.setPrefWidth(250.0);
        fusilliButton.setId("pastaMakingButton_" + this.cashierController.activeConfig.getFusilliIngredientId());
        AnchorPane.setTopAnchor((Node)fusilliButton, (Double)270.0);
        AnchorPane.setLeftAnchor((Node)fusilliButton, (Double)310.0);
        spaghettiButton.setSelected(true);
        Label typeLabel = new Label("Druh:");
        typeLabel.setFont(this.cashierController.subtitleFont);
        AnchorPane.setTopAnchor((Node)typeLabel, (Double)220.0);
        AnchorPane.setLeftAnchor((Node)typeLabel, (Double)10.0);
        Label quantityLabel = new Label("Mno\u017estv\u00ed:");
        quantityLabel.setFont(this.cashierController.subtitleFont);
        AnchorPane.setTopAnchor((Node)quantityLabel, (Double)360.0);
        AnchorPane.setLeftAnchor((Node)quantityLabel, (Double)10.0);
        TextField codeTextField = new TextField();
        codeTextField.setFont(this.cashierController.subtitleFont);
        codeTextField.maxWidth(550.0);
        AnchorPane.setTopAnchor((Node)codeTextField, (Double)150.0);
        AnchorPane.setLeftAnchor((Node)codeTextField, (Double)50.0);
        TextField quantityTextField = new TextField();
        quantityTextField.setFont(this.cashierController.subtitleFont);
        quantityTextField.maxWidth(550.0);
        AnchorPane.setTopAnchor((Node)quantityTextField, (Double)410.0);
        AnchorPane.setLeftAnchor((Node)quantityTextField, (Double)50.0);
        ConfirmButton confirmButton = new ConfirmButton("Potvrdit");
        confirmButton.setFont(this.cashierController.titleFont);
        confirmButton.setMinSize(160.0, 40.0);
        this.bottomButtonFlowPane.getChildren().add((Object)confirmButton);
        codeTextField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((Object)KeyCode.TAB)) {
                if (codeTextField.getText().startsWith("sti")) {
                    quantityTextField.requestFocus();
                } else {
                    codeTextField.setText("");
                    codeTextField.requestFocus();
                    this.playErrorSound();
                }
                keyEvent.consume();
            }
        });
        confirmButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> pastaTypeToggleGroup.getSelectedToggle() == null || !pastaTypeToggleGroup.getSelectedToggle().isSelected() || codeTextField.getText().isEmpty() || quantityTextField.getText().isEmpty(), (Observable[])new Observable[]{pastaTypeToggleGroup.selectedToggleProperty(), codeTextField.textProperty(), quantityTextField.textProperty()}));
        confirmButton.setOnMousePressed(mouseEvent -> {
            try {
                String ingredientId;
                if (ValidationUtils.isStringNotNullOrEmpty((String)codeTextField.getText()) && ValidationUtils.isStringNotNullOrEmpty((String)quantityTextField.getText()) && codeTextField.getText().startsWith("sti") && ValidationUtils.isNumeric((String)quantityTextField.getText())) {
                    String[] typeTextField = ((RadioToggleButton)pastaTypeToggleGroup.getSelectedToggle()).getId().split("_");
                    StockItem stockItem = this.cashierController.stockItemService.findByQrCode(codeTextField.getText());
                    if (stockItem == null) {
                        // empty if block
                    }
                    this.cashierController.stockItemService.useStockItemInRecipe(stockItem, Double.valueOf(1.0));
                    ingredientId = this.cashierController.activeConfig.getSpaghettiIngredientId();
                    if (typeTextField.length >= 1) {
                        ingredientId = typeTextField[1];
                    }
                } else {
                    throw new PastaMakingValidationException("Validation failed for making pasta.");
                }
                Ingredient ingredient = this.cashierController.ingredientService.findById(ingredientId);
                double quantity = Double.parseDouble(quantityTextField.getText());
                LocalDateTime expirationDate = LocalDateTime.now().plusHours(48L);
                StockItem pastaStockItem = this.cashierController.stockItemService.createPastaStockItem(Double.valueOf(quantity), ingredient, expirationDate);
                ReceiptPrinter.printExpirationDate((String)this.cashierController.activeConfig.getPrinterConfig().getPrinterName(), (LocalDateTime)LocalDateTime.now(), (StockItem)pastaStockItem, (String)this.cashierController.activeConfig.getPrinterConfig().getCodepage(), (LocalDateTime)expirationDate);
                this.hidePopup();
            }
            catch (Exception e) {
                ExceptionHandler.logException((Exception)e);
                this.playErrorSound();
            }
        });
        this.popupAnchor.getChildren().addAll((Object[])new Node[]{codeLabel, typeLabel, spaghettiButton, fusilliButton, quantityLabel, codeTextField, quantityTextField});
    }

    private void stockOutAction() {
        new StockOutPopup(this);
    }

    private void stockInAction() {
        new StockInPopup(this);
    }

    private void inventoryCheckAction() {
        this.hideButtons();
        this.setExtendedPopup();
        ObservableList positionReports = FXCollections.observableArrayList();
        ArrayList checkedQrCodes = new ArrayList();
        boolean deleteNotFound = true;
        Label locationLabel = new Label("Lokace:");
        locationLabel.setFont(this.cashierController.subtitleFont);
        AnchorPane.setTopAnchor((Node)locationLabel, (Double)100.0);
        AnchorPane.setLeftAnchor((Node)locationLabel, (Double)10.0);
        this.labelTitle.setText("Inventura");
        Label itemLabel = new Label("Polo\u017eka:");
        itemLabel.setFont(this.cashierController.subtitleFont);
        AnchorPane.setTopAnchor((Node)itemLabel, (Double)220.0);
        AnchorPane.setLeftAnchor((Node)itemLabel, (Double)10.0);
        Label quantityLabel = new Label("Mno\u017estv\u00ed:");
        quantityLabel.setFont(this.cashierController.subtitleFont);
        AnchorPane.setTopAnchor((Node)quantityLabel, (Double)340.0);
        AnchorPane.setLeftAnchor((Node)quantityLabel, (Double)10.0);
        Label locationLabel2 = new Label();
        locationLabel2.setFont(this.cashierController.subtitleFont);
        AnchorPane.setTopAnchor((Node)locationLabel2, (Double)150.0);
        AnchorPane.setLeftAnchor((Node)locationLabel2, (Double)50.0);
        locationLabel2.setVisible(false);
        TextField locationTextField = new TextField();
        locationTextField.setFont(this.cashierController.subtitleFont);
        locationTextField.maxWidth(450.0);
        AnchorPane.setTopAnchor((Node)locationTextField, (Double)150.0);
        AnchorPane.setLeftAnchor((Node)locationTextField, (Double)50.0);
        TextField itemTextField = new TextField();
        itemTextField.setFont(this.cashierController.subtitleFont);
        itemTextField.maxWidth(450.0);
        AnchorPane.setTopAnchor((Node)itemTextField, (Double)270.0);
        AnchorPane.setLeftAnchor((Node)itemTextField, (Double)50.0);
        TextField quantityTextField = new TextField();
        quantityTextField.setFont(this.cashierController.subtitleFont);
        quantityTextField.maxWidth(450.0);
        AnchorPane.setTopAnchor((Node)quantityTextField, (Double)390.0);
        AnchorPane.setLeftAnchor((Node)quantityTextField, (Double)50.0);
        YellowButton confirmButton = new YellowButton("Ukon\u010dit se zbytkem");
        confirmButton.setFont(this.cashierController.subtitleFont);
        confirmButton.setMinSize(160.0, 40.0);
        this.bottomButtonFlowPane.getChildren().add((Object)confirmButton);
        ConfirmButton confirmAndDeleteButton = new ConfirmButton("Ukon\u010dit lokaci");
        confirmAndDeleteButton.setFont(this.cashierController.subtitleFont);
        confirmAndDeleteButton.setMinSize(160.0, 40.0);
        this.bottomButtonFlowPane.getChildren().add((Object)confirmAndDeleteButton);
        VBox onLocationVBox = new VBox();
        onLocationVBox.setAlignment(Pos.CENTER);
        AnchorPane.setTopAnchor((Node)onLocationVBox, (Double)100.0);
        AnchorPane.setLeftAnchor((Node)onLocationVBox, (Double)550.0);
        Label onLocationLabel = new Label("Na lokaci:");
        onLocationLabel.setFont(this.cashierController.subtitleFont);
        onLocationLabel.setTextAlignment(TextAlignment.CENTER);
        onLocationLabel.setAlignment(Pos.CENTER);
        onLocationVBox.getChildren().add((Object)onLocationLabel);
        positionReports.addListener(change -> {
            onLocationVBox.getChildren().clear();
            onLocationVBox.getChildren().add((Object)onLocationLabel);
            for (InventoryCheckReportItem reportItem : positionReports) {
                HBox onLocationItem = this.createOnLocationItem(reportItem);
                onLocationVBox.getChildren().add((Object)onLocationItem);
            }
            while (change.next()) {
                if (!change.wasAdded()) continue;
                System.out.println("Items added: " + change.getAddedSubList());
                for (InventoryCheckReportItem item : change.getAddedSubList()) {
                    item.getNewQuantityProperty().addListener((observable, oldValue, newValue) -> {
                        System.out.println("Quantity changed from " + oldValue + " to " + newValue);
                        onLocationVBox.getChildren().clear();
                        onLocationVBox.getChildren().add((Object)onLocationLabel);
                        for (InventoryCheckReportItem reportItem : positionReports) {
                            HBox onLocationItem = this.createOnLocationItem(reportItem);
                            onLocationVBox.getChildren().add((Object)onLocationItem);
                        }
                    });
                }
            }
        });
        locationTextField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((Object)KeyCode.TAB)) {
                if (locationTextField.getText().startsWith("sto")) {
                    locationLabel2.setText(InventoryUtils.trimInventoryLocation((String)locationTextField.getText()));
                    locationTextField.setVisible(false);
                    locationLabel2.setVisible(true);
                    itemTextField.requestFocus();
                } else {
                    locationTextField.setText("");
                    locationTextField.requestFocus();
                    this.playErrorSound();
                }
                keyEvent.consume();
            }
        });
        itemTextField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((Object)KeyCode.TAB)) {
                if (itemTextField.getText().startsWith("sti")) {
                    quantityTextField.requestFocus();
                } else {
                    itemTextField.setText("");
                    itemTextField.requestFocus();
                    this.playErrorSound();
                }
                keyEvent.consume();
            }
        });
        quantityTextField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((Object)KeyCode.TAB)) {
                String qrCode = itemTextField.getText();
                String location = locationTextField.getText();
                Double newQuantity = ValidationUtils.tryParseDouble((String)quantityTextField.getText());
                if (newQuantity == null) {
                    quantityTextField.setText("");
                    quantityTextField.requestFocus();
                    this.playErrorSound();
                } else {
                    location = InventoryUtils.trimInventoryLocation((String)locationTextField.getText());
                    Optional<InventoryCheckReportItem> optionalReportItem = positionReports.stream().filter(item -> item.getQrCode().equals(qrCode)).findFirst();
                    if (optionalReportItem.isPresent()) {
                        InventoryCheckReportItem existingItem = optionalReportItem.get();
                        existingItem.setDateTime(LocalDateTime.now());
                        existingItem.setNewQuantity(Double.valueOf(existingItem.getNewQuantity() + newQuantity));
                        existingItem.setDifference(Double.valueOf(existingItem.getNewQuantity() - existingItem.getOriginalQuantity()));
                    } else {
                        boolean stockItemExists = this.cashierController.stockItemService.existsByQrCodeAndLocation(qrCode, location);
                        if (stockItemExists) {
                            StockItem stockItem = (StockItem)this.cashierController.stockItemService.findByQrCodeAndLocation(qrCode, location).get(0);
                            double originalQuantity = stockItem.getQuantity();
                            checkedQrCodes.add(qrCode);
                            InventoryCheckReportItem reportItem = this.createReportItem(stockItem, Double.valueOf(originalQuantity), newQuantity, location);
                            positionReports.add((Object)reportItem);
                        } else {
                            StockItem stockItem = InventoryUtils.parseQrCodeToStockItem((String)qrCode);
                            stockItem.setLocation(location);
                            double originalQuantity = 0.0;
                            this.cashierController.stockItemService.save(stockItem);
                            checkedQrCodes.add(qrCode);
                            InventoryCheckReportItem reportItem = this.createReportItem(stockItem, Double.valueOf(originalQuantity), newQuantity, location);
                            positionReports.add((Object)reportItem);
                        }
                    }
                    keyEvent.consume();
                    itemTextField.setText("");
                    quantityTextField.setText("");
                    itemTextField.requestFocus();
                }
            }
        });
        confirmButton.setOnMousePressed(mouseEvent -> {
            for (InventoryCheckReportItem reportItem : positionReports) {
                this.processReportItem(reportItem);
            }
            this.resetTextFields(locationLabel2, locationTextField, itemTextField, quantityTextField, confirmButton);
            positionReports.clear();
        });
        confirmAndDeleteButton.setOnMousePressed(mouseEvent -> {
            for (InventoryCheckReportItem reportItem : positionReports) {
                this.processReportItem(reportItem);
            }
            String location = InventoryUtils.trimInventoryLocation((String)locationTextField.getText());
            List notFoundItems = this.cashierController.stockItemService.findByLocation(location);
            List<StockItem> filteredNotFoundItems = notFoundItems.stream().filter(item -> item.getQuantity() != 0.0).toList();
            this.removeNotFoundStockItems(filteredNotFoundItems, (List)checkedQrCodes, location);
            this.resetTextFields(locationLabel2, locationTextField, itemTextField, quantityTextField, confirmButton);
            positionReports.clear();
        });
        this.popupAnchor.getChildren().addAll((Object[])new Node[]{itemLabel, locationLabel, locationLabel2, quantityLabel, itemTextField, locationTextField, quantityTextField, onLocationVBox});
    }

    private HBox createOnLocationItem(InventoryCheckReportItem reportItem) {
        HBox onLocationItem = new HBox();
        onLocationItem.setSpacing(10.0);
        Label onLocationItemLabel = new Label("Nezn\u00e1m\u00e9");
        onLocationItemLabel.setMaxWidth(350.0);
        onLocationItemLabel.setFont(this.cashierController.normalFont);
        Label onLocationItemQuantity = new Label(": N/Ax");
        onLocationItemQuantity.setMaxWidth(100.0);
        onLocationItemQuantity.setFont(this.cashierController.normalFont);
        if (reportItem.getStockItem() != null && reportItem.getStockItem().getIngredient() != null && reportItem.getStockItem().getIngredient().getName() != null) {
            onLocationItemLabel.setText(reportItem.getStockItem().getIngredient().getName());
        }
        if (reportItem.getNewQuantity() != null) {
            onLocationItemQuantity.setText(": " + new DecimalFormat("0.##").format(reportItem.getNewQuantity()) + "x");
        }
        onLocationItem.getChildren().addAll((Object[])new Node[]{onLocationItemLabel, onLocationItemQuantity});
        return onLocationItem;
    }

    private void resetTextFields(Label locationLabel2, TextField locationTextField, TextField itemTextField, TextField quantityTextField, YellowButton confirmButton) {
        itemTextField.setText("");
        locationTextField.setText("");
        quantityTextField.setText("");
        locationTextField.setVisible(true);
        locationLabel2.setVisible(false);
        Platform.runLater(() -> locationTextField.requestFocus());
    }

    private void processReportItem(InventoryCheckReportItem reportItem) {
        StockItem stockItem = reportItem.getStockItem();
        Double newQuantity = reportItem.getNewQuantity();
        stockItem.setQuantity(newQuantity.doubleValue());
        stockItem.setLocation(reportItem.getLocation());
        this.cashierController.stockItemService.save(stockItem);
        Double difference = reportItem.getDifference();
        if (difference != 0.0) {
            STOCK_MOVEMENT_ACTION action = difference > 0.0 ? STOCK_MOVEMENT_ACTION.ADDED : STOCK_MOVEMENT_ACTION.REMOVED;
            StockMovementLogItem stockMovementItem = new StockMovementLogItem();
            stockMovementItem.setTimestamp(LocalDateTime.now());
            stockMovementItem.setStockMovementAction(action);
            stockMovementItem.setQuantity(difference);
            stockMovementItem.setStockItem(stockItem);
            this.cashierController.stockMovementLogItemsService.save(stockMovementItem);
        }
        this.cashierController.inventoryCheckReportItemsService.save(reportItem);
    }

    private void removeNotFoundStockItems(List<StockItem> notFoundItems, List<String> checkedQrCodes, String location) {
        if (!notFoundItems.isEmpty()) {
            for (StockItem item : notFoundItems) {
                if (checkedQrCodes.contains(item.getQrcode())) continue;
                double originalQuantity = item.getQuantity();
                item.setQuantity(0.0);
                this.cashierController.stockItemService.save(item);
                InventoryCheckReportItem reportItem = this.createReportItem(item, Double.valueOf(originalQuantity), Double.valueOf(0.0), location);
                this.cashierController.inventoryCheckReportItemsService.save(reportItem);
            }
        }
    }

    private void cashDiaryAction() {
        this.hideButtons();
        this.setWidePopup();
        this.popupAnchor.getChildren().remove((Object)this.labelTitle);
        ToggleGroup toggleGroup = new ToggleGroup();
        RadioToggleButton addButton = new RadioToggleButton();
        addButton.setText("P\u0159idat");
        addButton.setFont(this.cashierController.subtitleFont);
        addButton.setToggleGroup(toggleGroup);
        AnchorPane.setTopAnchor((Node)addButton, (Double)50.0);
        AnchorPane.setLeftAnchor((Node)addButton, (Double)50.0);
        RadioToggleButton removeButton = new RadioToggleButton();
        removeButton.setText("Odebrat");
        removeButton.setFont(this.cashierController.subtitleFont);
        removeButton.setToggleGroup(toggleGroup);
        AnchorPane.setTopAnchor((Node)removeButton, (Double)50.0);
        AnchorPane.setRightAnchor((Node)removeButton, (Double)50.0);
        addButton.setSelected(true);
        this.amountTextField = new TextField();
        this.amountTextField.setFont(this.cashierController.subtitleFont);
        AnchorPane.setTopAnchor((Node)this.amountTextField, (Double)135.0);
        AnchorPane.setLeftAnchor((Node)this.amountTextField, (Double)50.0);
        AnchorPane.setRightAnchor((Node)this.amountTextField, (Double)50.0);
        GridPane keyboard = this.createNumberKeyboard();
        AnchorPane.setTopAnchor((Node)keyboard, (Double)200.0);
        AnchorPane.setLeftAnchor((Node)keyboard, (Double)100.0);
        AnchorPane.setRightAnchor((Node)keyboard, (Double)100.0);
        ConfirmButton confirmButton = new ConfirmButton("Potvrdit");
        confirmButton.setFont(this.cashierController.titleFont);
        AnchorPane.setBottomAnchor((Node)confirmButton, (Double)150.0);
        AnchorPane.setLeftAnchor((Node)confirmButton, (Double)150.0);
        AnchorPane.setRightAnchor((Node)confirmButton, (Double)150.0);
        confirmButton.setOnMousePressed(mouseEvent -> {
            CashManipulationItem newItem = new CashManipulationItem();
            newItem.setAmount(Double.valueOf(Double.parseDouble(this.amountTextField.getText().trim())));
            if (removeButton.isSelected()) {
                newItem.setAmount(Double.valueOf(newItem.getAmount() - 2.0 * newItem.getAmount()));
            }
            newItem.setTimestamp(LocalDateTime.now());
            User user = (User)this.cashierController.activeConfig.getLoggedInCashier().get();
            newItem.setEmployeeName(user.getFirstName() + " " + user.getLastName());
            this.cashierController.cashManipulationItemsService.save(newItem);
            this.hidePopup();
        });
        this.bottomButtonFlowPane.getChildren().add((Object)confirmButton);
        this.popupAnchor.getChildren().addAll((Object[])new Node[]{addButton, removeButton, this.amountTextField, keyboard});
    }

    private GridPane createNumberKeyboard() {
        int i;
        LinkedList<Integer> buttonsOrder = new LinkedList<Integer>(List.of(new Integer[]{7, 8, 9, 4, 5, 6, 1, 2, 3}));
        GridPane gridPane = new GridPane();
        for (i = 0; i <= 2; ++i) {
            ColumnConstraints column = new ColumnConstraints();
            column.setHgrow(Priority.SOMETIMES);
            column.setMinWidth(10.0);
            column.setPrefWidth(100.0);
            gridPane.getColumnConstraints().add((Object)column);
        }
        for (i = 0; i <= 3; ++i) {
            RowConstraints row = new RowConstraints();
            row.setVgrow(Priority.SOMETIMES);
            row.setMinHeight(10.0);
            row.setPrefHeight(100.0);
            gridPane.getRowConstraints().add((Object)row);
        }
        Integer i2 = 1;
        while (i2 <= 9) {
            Object button = this.createKeyboardButton(String.valueOf(i2));
            int buttonIndex = buttonsOrder.indexOf(i2);
            int rowNumber = (int)Math.floor((double)buttonIndex / 3.0);
            int columnNumber = buttonIndex % 3;
            gridPane.add((Node)button, columnNumber, rowNumber);
            button = i2;
            i2 = i2 + 1;
        }
        GrayButton buttonZero = this.createKeyboardButton(String.valueOf(0));
        gridPane.add((Node)buttonZero, 1, 3);
        GrayButton buttonBackSpace = this.createKeyboardButton("x");
        buttonBackSpace.setGraphic((Node)ResourceHelper.getImageViewFromResourceName((String)"/resources/images/backspace_64.png"));
        gridPane.add((Node)buttonBackSpace, 2, 3);
        return gridPane;
    }

    private GrayButton createKeyboardButton(String label) {
        GrayButton button = new GrayButton();
        button.setId("keyboard_" + label);
        button.setFont(this.cashierController.subtitleFont);
        button.setAlignment(Pos.CENTER);
        button.setContentDisplay(ContentDisplay.CENTER);
        button.setFocusTraversable(false);
        button.setOnMouseClicked(arg_0 -> this.number_keyboard_clicked(arg_0));
        button.setOnTouchPressed(arg_0 -> this.number_keyboard_clicked(arg_0));
        if (!label.equals("x")) {
            button.setText(label);
        }
        button.setMinWidth(70.0);
        button.setMinHeight(70.0);
        button.setMaxWidth(70.0);
        button.setMaxHeight(70.0);
        button.setPadding(LayoutUtils.getInsets((double)10.0, (double)30.0, (double)10.0, (double)30.0));
        GridPane.setMargin((Node)button, (Insets)LayoutUtils.getInsets((double)0.0, (double)0.0, (double)0.0, (double)33.0));
        return button;
    }

    private void number_keyboard_clicked(Event e) {
        String buttonId = ((GrayButton)e.getSource()).getId();
        String number = buttonId.split("_")[1];
        if (number.equals("x")) {
            if (!this.amountTextField.getText().isEmpty()) {
                int toDelete = 1;
                this.amountTextField.setText(this.amountTextField.getText().substring(0, this.amountTextField.getText().length() - toDelete));
            }
        } else {
            this.amountTextField.setText(this.amountTextField.getText() + number);
        }
    }

    private InventoryCheckReportItem createReportItem(StockItem stockItem, Double originalQuantity, Double newQuantity, String location) {
        double difference = newQuantity - originalQuantity;
        InventoryCheckReportItem reportItem = new InventoryCheckReportItem();
        reportItem.setDateTime(LocalDateTime.now());
        reportItem.setStockItem(stockItem);
        reportItem.setOriginalQuantity(originalQuantity);
        reportItem.setNewQuantity(newQuantity);
        reportItem.setDifference(Double.valueOf(difference));
        reportItem.setQrCode(stockItem.getQrcode());
        reportItem.setLocation(location);
        reportItem.setUser((User)this.cashierController.activeConfig.getLoggedInCashier().get());
        return reportItem;
    }

    private void recenterPopup() {
        Rectangle2D screenBounds = Screen.getPrimary().getBounds();
        double popupWidth = this.getWidth();
        double popupHeight = this.getHeight();
        double centerX = (screenBounds.getWidth() - popupWidth) / 2.0;
        double centerY = (screenBounds.getHeight() - popupHeight) / 2.0;
        this.setX(centerX);
        this.setY(centerY);
    }

    public void playErrorSound() {
        errorMediaPlayer.stop();
        errorMediaPlayer.seek(Duration.ZERO);
        errorMediaPlayer.play();
    }

    public void playSuccessSound() {
        successMediaPlayer.stop();
        successMediaPlayer.seek(Duration.ZERO);
        successMediaPlayer.play();
    }

    public CashierController getCashierController() {
        return this.cashierController;
    }

    public AnchorPane getPopupAnchor() {
        return this.popupAnchor;
    }

    public Label getLabelTitle() {
        return this.labelTitle;
    }

    public FlowPane getBottomButtonFlowPane() {
        return this.bottomButtonFlowPane;
    }
}

