/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service.screensaver;

import cz.polreich.spagetka.DTO.promos.PromoDTO;
import cz.polreich.spagetka.event.NewPromoEvent;
import cz.polreich.spagetka.event.UpdateScreensaverResourceEvent;
import cz.polreich.spagetka.models.wrapper.ImageWrapper;
import cz.polreich.spagetka.models.wrapper.MediaWrapper;
import cz.polreich.spagetka.service.screensaver.resourceService.ScreensaverResourcesServiceFromResourcesFolder;
import cz.polreich.spagetka.utils.ConditionalOnHostname;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@ConditionalOnHostname(anyOf={"kioskOrder*"})
@Service
public class ScreensaverResourcesManager {
    private static final Logger log = LoggerFactory.getLogger(ScreensaverResourcesManager.class);
    private final ScreensaverResourcesServiceFromResourcesFolder screensaverResourcesService;
    private List<ImageWrapper> imageList = Collections.synchronizedList(new ArrayList());
    private int imageListSize;
    private List<MediaWrapper> mediaList = Collections.synchronizedList(new ArrayList());
    private int mediaListSize;
    private final AtomicInteger currentIndexImage = new AtomicInteger(0);
    private final AtomicInteger currentIndexMedia = new AtomicInteger(0);
    private boolean needsToUpdateResources;
    private List<PromoDTO> promoDTOList = new ArrayList();
    private NewPromoEvent newPromoEvent = null;

    @Autowired
    public ScreensaverResourcesManager(ScreensaverResourcesServiceFromResourcesFolder screensaverResourcesService) {
        this.screensaverResourcesService = screensaverResourcesService;
        this.needsToUpdateResources = false;
    }

    @EventListener
    public void handlePromoList(NewPromoEvent event) {
        log.info("[HANDLE NEW PROMO EVENT] - setting up promos. Event isInitResources is {}", (Object)event.isInitResources());
        if (event.isInitResources()) {
            this.initLists();
        } else {
            this.needsToUpdateResources = true;
            this.newPromoEvent = event;
        }
    }

    private void initLists() {
        this.imageList = this.screensaverResourcesService.getImageList();
        this.imageListSize = this.imageList.size();
        this.mediaList = this.screensaverResourcesService.getMediaList();
        this.mediaListSize = this.mediaList.size();
    }

    @EventListener
    public void updateResources(UpdateScreensaverResourceEvent event) {
        log.info("[UPDATING SCREENSAVER RESOURCES] - checks does resources is needed to be updated - {}", (Object)this.needsToUpdateResources);
        if (!this.needsToUpdateResources) {
            return;
        }
        log.info("[UPDATING SCREENSAVER RESOURCES] - need to be updated. Started");
        this.needsToUpdateResources = false;
        try {
            this.installResources(this.newPromoEvent.getInstallList());
            this.deleteResources(this.newPromoEvent.getDeleteList());
            log.info("[UPDATING SCREENSAVER RESOURCES] - a screensaver resources and list are updated");
        }
        catch (Exception e) {
            log.error("Exception - {}", (Object)e.getMessage());
        }
        finally {
            this.needsToUpdateResources = false;
        }
    }

    public Optional<MediaWrapper> nextMedia() {
        if (this.mediaListSize == 0) {
            return Optional.empty();
        }
        int nextIndex = this.currentIndexMedia.getAndUpdate(i -> (i + 1) % this.mediaListSize);
        return this.getMedia(nextIndex);
    }

    public Optional<ImageWrapper> nextImage() {
        if (this.getImageListSize() == 0) {
            return Optional.empty();
        }
        int nextIndex = this.currentIndexImage.getAndUpdate(i -> (i + 1) % this.getImageListSize());
        return this.getImage(nextIndex);
    }

    public int getImageListSize() {
        return this.imageList.size();
    }

    private Optional<ImageWrapper> getImage(int index) {
        if (index < 0 || index >= this.getImageListSize()) {
            return Optional.empty();
        }
        return Optional.ofNullable((ImageWrapper)this.imageList.get(index));
    }

    private Optional<MediaWrapper> getMedia(int index) {
        if (index < 0 || index >= this.mediaListSize) {
            log.error("Index is out of size of media list or less then 0");
            return Optional.empty();
        }
        return Optional.of((MediaWrapper)this.mediaList.get(index));
    }

    private void installResources(List<PromoDTO> promosToInstall) {
        for (PromoDTO promo : promosToInstall) {
            String url = promo.getUrl();
            if (this.isMedia(url)) {
                this.processMediaInstall(url);
                continue;
            }
            if (!this.isImage(url)) continue;
            this.processImageInstall(url);
        }
    }

    private void deleteResources(List<PromoDTO> promosToDelete) {
        for (PromoDTO promo : promosToDelete) {
            String url = promo.getUrl();
            if (this.isMedia(url)) {
                this.processMediaDelete(promo);
                continue;
            }
            if (!this.isImage(url)) continue;
            this.processImageDelete(promo);
        }
    }

    private boolean isMedia(String url) {
        return url.endsWith(".mp4");
    }

    private boolean isImage(String url) {
        return url.endsWith(".png") || url.endsWith(".jpg") || url.endsWith(".gif");
    }

    private void processMediaInstall(String url) {
        MediaWrapper media = this.screensaverResourcesService.installMedia(url);
        this.mediaList.add(media);
        log.info("Installed media resource: {}", (Object)url);
    }

    private void processImageInstall(String url) {
        ImageWrapper image = this.screensaverResourcesService.installImage(url);
        this.imageList.add(image);
        log.info("Installed image resource: {}", (Object)url);
    }

    private void processMediaDelete(PromoDTO promo) {
        boolean deleted = this.screensaverResourcesService.deleteMediaFromResources(promo.getUrl());
        if (deleted) {
            this.mediaList = this.mediaList.stream().filter(m -> !m.getId().equals(promo.getId())).collect(Collectors.toList());
            log.info("Deleted media resource: {}", (Object)promo.getUrl());
        } else {
            log.warn("Failed to delete media resource: {}", (Object)promo.getUrl());
        }
    }

    private void processImageDelete(PromoDTO promo) {
        boolean deleted = this.screensaverResourcesService.deleteImageFromResources(promo.getUrl());
        if (deleted) {
            this.imageList = this.imageList.stream().filter(i -> !i.getId().equals(promo.getId())).collect(Collectors.toList());
            log.info("Deleted image resource: {}", (Object)promo.getUrl());
        } else {
            log.warn("Failed to delete image resource: {}", (Object)promo.getUrl());
        }
    }

    public int getMediaListSize() {
        return this.mediaListSize;
    }

    public boolean isNeedsToUpdateResources() {
        return this.needsToUpdateResources;
    }
}

