/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service;

import cz.polreich.spagetka.models.StockItem;
import cz.polreich.spagetka.models.StockMovementLogItem;
import cz.polreich.spagetka.models.enums.STOCK_MOVEMENT_ACTION;
import cz.polreich.spagetka.repository.StockMovementLogItemsRepository;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StockMovementLogItemsService {
    @Autowired
    private StockMovementLogItemsRepository stockMovementLogItemsRepository;

    public void saveAll(List<StockMovementLogItem> items) {
        this.stockMovementLogItemsRepository.saveAll(items);
    }

    public List<StockMovementLogItem> findAll() {
        return this.stockMovementLogItemsRepository.findAll();
    }

    public StockMovementLogItem findById(String id) {
        return (StockMovementLogItem)this.stockMovementLogItemsRepository.findById((Object)id).get();
    }

    public void save(StockMovementLogItem items) {
        this.stockMovementLogItemsRepository.save((Object)items);
    }

    public boolean existsById(String id) {
        return this.stockMovementLogItemsRepository.existsById((Object)id);
    }

    public void deleteById(String id) {
        this.stockMovementLogItemsRepository.deleteById((Object)id);
    }

    public List<StockMovementLogItem> findAllFromDateTime(LocalDateTime fromDateTime) {
        return this.findAllInDateTimeFrame(fromDateTime, LocalDateTime.now());
    }

    public List<StockMovementLogItem> findAllToDateTime(LocalDateTime toDateTime) {
        return this.findAllInDateTimeFrame(LocalDateTime.parse("2024-01-01T00:00:00"), toDateTime);
    }

    public List<StockMovementLogItem> findAllInDateTimeFrame(LocalDateTime fromDateTime, LocalDateTime toDateTime) {
        return this.stockMovementLogItemsRepository.findStockMovementsBetweenDateTimes(fromDateTime, toDateTime);
    }

    public void createUsedStockMovementForStockItem(StockItem stockItem, Double quantity, STOCK_MOVEMENT_ACTION action) {
        StockMovementLogItem stockItemMovement = new StockMovementLogItem();
        stockItemMovement.setStockMovementAction(action);
        stockItemMovement.setQuantity(quantity);
        stockItemMovement.setStockItem(stockItem);
        stockItemMovement.setTimestamp(LocalDateTime.now());
        this.save(stockItemMovement);
    }
}

