/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service;

import cz.polreich.spagetka.DTO.OrderDTO;
import cz.polreich.spagetka.PartnerServerRestClient;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.ProductFreeVariant;
import cz.polreich.spagetka.models.enums.ORDER_STATUS;
import cz.polreich.spagetka.models.enums.ORDER_TYPE;
import cz.polreich.spagetka.repository.OrderItemRepository;
import cz.polreich.spagetka.repository.OrderRepository;
import jakarta.annotation.PostConstruct;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.LockModeType;
import jakarta.persistence.PersistenceContext;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderService {
    @Autowired
    private OrderRepository orderRepository;
    @Autowired
    private OrderItemRepository orderItemRepository;
    @PersistenceContext
    private EntityManager entityManager;
    private PartnerServerRestClient partnerServerRestClient;
    private Set<String> usedOrderNumbers = new HashSet();

    public OrderService() {
    }

    public OrderService(PartnerServerRestClient partnerServerRestClient) {
        this.partnerServerRestClient = partnerServerRestClient;
    }

    @PostConstruct
    public void init() {
        this.initializeUsedOrderNumbers();
    }

    private void initializeUsedOrderNumbers() {
        System.out.println("XXXXXXXX - Initializing order numbers - XXXXXXXXX");
        LocalDate today = LocalDate.now();
        LocalDate monday = today.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        LocalDateTime mondayMidnight = LocalDateTime.of(monday, LocalTime.MIDNIGHT);
        this.usedOrderNumbers = this.orderRepository.findAllOrderNumbersSinceDate(mondayMidnight);
    }

    private void updateUsedOrderNumbers() {
        this.initializeUsedOrderNumbers();
    }

    @Transactional
    public String saveNewPersonalOrder(Order order) {
        String newId = String.valueOf(UUID.randomUUID());
        System.out.println("[DBG23] Creating new Order part 1: " + newId);
        order.setId(newId);
        order.setCustomerFirstName("Stanek");
        if (order.getOrderType() == null) {
            order.setOrderType(ORDER_TYPE.PERSONAL_HERE);
        }
        order.setCreationDateTime(LocalDateTime.now());
        order.setToBeFinishedDateTime(LocalDateTime.now().plusMinutes(10L));
        order.setOrderStatus(ORDER_STATUS.WAITING_FOR_PAYMENT);
        this.createNew(order);
        return newId;
    }

    @Transactional
    public Order processWoltOrder(Order order) {
        String orderId = order.getId();
        boolean orderExists = this.orderRepository.existsById((Object)orderId);
        if (orderExists) {
            Order existingOrder = (Order)this.orderRepository.findById((Object)orderId).get();
            order.setAnnounced(Boolean.valueOf(existingOrder.isAnnounced()));
            order.setOrderStatus(existingOrder.getOrderStatus());
        } else {
            order.setExpectedResponseTime(LocalDateTime.now().plusSeconds(60L));
        }
        this.debugOrderProcessing(order);
        this.orderRepository.save((Object)order);
        return order;
    }

    @Transactional
    public Order processOnlineOrder(Order order) {
        String orderId = order.getId();
        boolean orderExists = this.orderRepository.existsById((Object)orderId);
        if (orderExists) {
            Order existingOrder = (Order)this.orderRepository.findById((Object)orderId).get();
            order.setOrderNumber(existingOrder.getOrderNumber());
            order.setOrderType(existingOrder.getOrderType());
            order.setAnnounced(Boolean.valueOf(existingOrder.isAnnounced()));
            order.setOrderStatus(existingOrder.getOrderStatus());
        } else {
            order.setOrderNumber(this.generateUniqueOrderNumber());
        }
        this.debugOrderProcessing(order);
        this.orderRepository.save((Object)order);
        return order;
    }

    @Transactional
    public Order processDeliveryOrder(Order order) {
        String orderId = order.getId();
        boolean orderExists = this.orderRepository.existsById((Object)orderId);
        if (orderExists) {
            Order existingOrder = (Order)this.orderRepository.findById((Object)orderId).get();
            order.setOrderNumber(existingOrder.getOrderNumber());
            order.setOrderType(existingOrder.getOrderType());
            order.setAnnounced(Boolean.valueOf(existingOrder.isAnnounced()));
            order.setOrderStatus(existingOrder.getOrderStatus());
        } else {
            order.setOrderNumber(this.generateUniqueOrderNumber());
        }
        this.debugOrderProcessing(order);
        this.orderRepository.save((Object)order);
        return order;
    }

    @Transactional
    public Order processPersonalOrder(Order order, boolean sendToPartnerWeb) {
        order.setOrderNumber(this.generateUniqueOrderNumber());
        this.deduplicateOrder(order);
        this.orderRepository.save((Object)order);
        if (sendToPartnerWeb) {
            new Thread(() -> this.partnerServerRestClient.sendOrder(new OrderDTO(order))).start();
        }
        this.debugOrderProcessing(order);
        return order;
    }

    private void deduplicateOrder(Order order) {
        HashMap uniqueProductFreeVariants = new HashMap();
        HashMap uniqueItems = new HashMap();
        for (OrderItem item : order.getOrderItems()) {
            List<ProductFreeVariant> deduped = item.getFreeVariants().stream().map(v -> uniqueProductFreeVariants.computeIfAbsent(v.getId(), id -> v)).toList();
            item.setFreeVariants(deduped);
        }
        this.deduplicateOrderItems(order.getOrderItems(), uniqueItems);
    }

    public void deduplicateOrderItems(List<OrderItem> items, Map<String, OrderItem> itemMap) {
        for (int i = 0; i < items.size(); ++i) {
            OrderItem canonical;
            OrderItem current = items.get(i);
            if (current.getId() != null) {
                String id = current.getId();
                canonical = itemMap.getOrDefault(id, current);
                itemMap.putIfAbsent(id, canonical);
                items.set(i, canonical);
            } else {
                canonical = current;
            }
            if (canonical.getSubItems() == null) continue;
            this.deduplicateOrderItems(canonical.getSubItems(), itemMap);
        }
    }

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Transactional
    public Order createNew(Order order) {
        return this.createNew(order, true);
    }

    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    @Transactional
    public Order createNew(Order order, boolean sendToPartnerWeb) {
        if (order.getOrderType() != null) {
            if (order.getOrderType().equals((Object)ORDER_TYPE.DELIVERY)) {
                return this.processDeliveryOrder(order);
            }
            if (order.getOrderType().equals((Object)ORDER_TYPE.WOLT) || order.getOrderType().equals((Object)ORDER_TYPE.WOLT_PICKUP)) {
                return this.processWoltOrder(order);
            }
            if (order.getOrderType().equals((Object)ORDER_TYPE.ONLINE)) {
                return this.processOnlineOrder(order);
            }
            if (order.getOrderType().equals((Object)ORDER_TYPE.PERSONAL_HERE) || order.getOrderType().equals((Object)ORDER_TYPE.PERSONAL_TAKE_AWAY)) {
                return this.processPersonalOrder(order, sendToPartnerWeb);
            }
            throw new IllegalArgumentException("Invalid order type: " + order.getOrderType());
        }
        return null;
    }

    private void debugOrderProcessing(Order order) {
        System.out.println("[DBG23] Creating new Order part 2: " + order.getOrderNumber());
        for (OrderItem parentItem : order.getOrderItems()) {
            for (OrderItem subItem : parentItem.getSubItems()) {
                System.out.println("Is subItem managed? " + this.entityManager.contains((Object)subItem));
                if (!this.entityManager.contains((Object)subItem)) {
                    this.entityManager.merge((Object)subItem);
                }
                System.out.println("Is subItem managed? " + this.entityManager.contains((Object)subItem));
            }
        }
        for (OrderItem parentItem : order.getOrderItems()) {
            System.out.println("ParentItem: " + parentItem);
            for (OrderItem subItem : parentItem.getSubItems()) {
                System.out.println("SubItem: " + subItem);
                System.out.println("SubItem Product: " + subItem.getMainProduct());
            }
        }
        this.orderRepository.save((Object)order);
        System.out.println("[DBG23] Order saved: " + order.getOrderNumber() + " | with status: " + order.getOrderStatus());
    }

    public Order update(Order order) {
        this.update(order, true);
        return order;
    }

    public Order update(Order order, boolean sendToPartnerWeb) {
        this.orderRepository.save((Object)order);
        System.out.println("[DBG23] Order updated: " + order.getOrderNumber() + " | new status: " + order.getOrderStatus());
        if (sendToPartnerWeb) {
            new Thread(() -> this.partnerServerRestClient.sendOrder(new OrderDTO(order))).start();
        }
        return order;
    }

    public List<Order> updateAll(List<Order> orders) {
        this.updateAll(orders, true);
        return orders;
    }

    public List<Order> updateAll(List<Order> orders, boolean sendToPartnerWeb) {
        this.orderRepository.saveAll(orders);
        if (sendToPartnerWeb) {
            new Thread(() -> this.partnerServerRestClient.sendOrders(orders.stream().map(OrderDTO::new).toList())).start();
        }
        return orders;
    }

    @Transactional
    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    public List<Order> createAll(List<Order> orders) {
        return this.createAll(orders, true);
    }

    @Transactional
    @Lock(value=LockModeType.PESSIMISTIC_WRITE)
    public List<Order> createAll(List<Order> orders, boolean sendToPartnerWeb) {
        ArrayList<Order> ret = new ArrayList<Order>();
        for (Order order : orders) {
            ret.add(this.createNew(order, sendToPartnerWeb));
        }
        return ret;
    }

    public List<Order> findAll() {
        return this.orderRepository.findAll();
    }

    public List<Order> findAllFromDateTime(LocalDateTime fromDateTime) {
        return this.findAllInDateTimeFrame(fromDateTime, LocalDateTime.now());
    }

    public List<Order> findAllToDateTime(LocalDateTime toDateTime) {
        return this.findAllInDateTimeFrame(LocalDateTime.parse("2024-01-01T00:00:00"), toDateTime);
    }

    public List<Order> findAllInDateTimeFrame(LocalDateTime fromDateTime, LocalDateTime toDateTime) {
        return this.orderRepository.findCreatedOrdersBetweenDateTimes(fromDateTime, toDateTime);
    }

    public Order findById(String id) {
        if (this.orderRepository.findById((Object)id).isPresent()) {
            return (Order)this.orderRepository.findById((Object)id).get();
        }
        throw new EntityNotFoundException("[OrderService] - Order with ID: " + id + "was not found. (E-154)");
    }

    public Order findByIdQuery(String id) {
        return this.orderRepository.findByIdQuery(id);
    }

    public List<Order> updateStatusOfOrdersByStatus(ORDER_STATUS oldStatus, ORDER_STATUS newStatus) {
        List orders = this.orderRepository.findByOrderStatus(oldStatus);
        orders.forEach(o -> o.setOrderStatus(newStatus));
        this.updateAll(orders);
        return orders;
    }

    public void deleteById(String id) {
        if (!this.orderRepository.findById((Object)id).isPresent()) {
            throw new EntityNotFoundException("[OrderService] - Order with ID: " + id + "was not found. (E-154)");
        }
        this.orderRepository.deleteById((Object)id);
    }

    public void deleteByOrderType(ORDER_TYPE type) {
        this.orderRepository.deleteByOrderType(type);
    }

    public List<Order> findByOrderStatus(ORDER_STATUS orderStatus) {
        return this.orderRepository.findByOrderStatus(orderStatus);
    }

    public Order findByOrderNumber(String orderNumber) {
        return this.orderRepository.findByOrderNumber(orderNumber);
    }

    public List<Order> findAllByOrderNumber(String orderNumber) {
        return this.orderRepository.findAllByOrderNumber(orderNumber);
    }

    public Order findByOrderNumberByToday(String orderNumber) {
        LocalDate currentDate = LocalDate.now();
        int day = currentDate.getDayOfMonth();
        int month = currentDate.getMonthValue();
        int year = currentDate.getYear();
        return this.orderRepository.findByOrderNumberByToday(orderNumber, day, month, year);
    }

    public long countByCurrentDate() {
        LocalDate currentDate = LocalDate.now();
        int day = currentDate.getDayOfMonth();
        int month = currentDate.getMonthValue();
        int year = currentDate.getYear();
        return this.orderRepository.countOrdersByCurrentDate(day, month, year);
    }

    public long countSinceWeekStart() {
        LocalDate today = LocalDate.now();
        LocalDate monday = today.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        LocalDateTime mondayMidnight = LocalDateTime.of(monday, LocalTime.MIDNIGHT);
        return this.orderRepository.countOrderSinceDate(mondayMidnight);
    }

    public String generateUniqueOrderNumber() {
        String orderNumber;
        boolean isUnique;
        this.updateUsedOrderNumbers();
        Random random = new Random();
        while (!(isUnique = !this.usedOrderNumbers.contains(orderNumber = String.valueOf(random.nextInt(999) + 1)))) {
        }
        this.usedOrderNumbers.add(orderNumber);
        return orderNumber;
    }

    public List<Order> findAllOrdersByTodayAndOrdersStatus(ORDER_STATUS orderStatus) {
        LocalDate currentDate = LocalDate.now();
        int day = currentDate.getDayOfMonth();
        int month = currentDate.getMonthValue();
        int year = currentDate.getYear();
        return this.orderRepository.findAllOrdersByTodayAndOrdersStatus(orderStatus, day, month, year);
    }

    public int countAllOrdersByTodayAndOrdersStatusList(List<ORDER_STATUS> orderStatusList) {
        LocalDate currentDate = LocalDate.now();
        int day = currentDate.getDayOfMonth();
        int month = currentDate.getMonthValue();
        int year = currentDate.getYear();
        return this.orderRepository.countAllOrdersByTodayAndOrdersStatusList(day, month, year, orderStatusList);
    }

    public List<Order> findAllOrdersByToday() {
        LocalDate currentDate = LocalDate.now();
        int day = currentDate.getDayOfMonth();
        int month = currentDate.getMonthValue();
        int year = currentDate.getYear();
        return this.orderRepository.findAllOrdersByToday(day, month, year);
    }

    public List<Order> findAllOrdersByTodayWithoutTHISOrderStatus(ORDER_STATUS orderStatus) {
        LocalDate currentDate = LocalDate.now();
        int day = currentDate.getDayOfMonth();
        int month = currentDate.getMonthValue();
        int year = currentDate.getYear();
        return this.orderRepository.findAllOrdersByTodayWithoutOrderStatus(orderStatus, day, month, year);
    }

    public List<Order> getOrdersFrom6AMToNextDay6AM() {
        LocalDateTime startDateTime = LocalDateTime.of(LocalDate.now(), LocalTime.of(6, 0));
        LocalDateTime endDateTime = startDateTime.plusDays(1L);
        return this.orderRepository.findCreatedOrdersBetweenDateTimes(startDateTime, endDateTime);
    }

    public List<Order> getOrdersCreatedFrom6AmToNextDay6AmWithTHISOrderStatus(ORDER_STATUS orderStatus) {
        LocalDateTime startDateTime = LocalDateTime.of(LocalDate.now(), LocalTime.of(6, 0));
        LocalDateTime endDateTime = startDateTime.plusDays(1L);
        return this.orderRepository.findOrdersCreatedBetweenWithOrderStatus(startDateTime, endDateTime, orderStatus);
    }

    public List<Order> getOrdersCreatedFrom6AmToNextDay6AmWithTHISOrderStatuses(List<ORDER_STATUS> orderStatuses) {
        LocalDateTime startDateTime = LocalDateTime.of(LocalDate.now(), LocalTime.of(0, 0));
        LocalDateTime endDateTime = startDateTime.plusDays(1L);
        return this.orderRepository.findOrdersCreatedBetweenWithOrderStatuses(startDateTime, endDateTime, orderStatuses);
    }

    public List<Order> getOrdersCreatedFrom6AmToNextDay6AmWithoutTHISOrderStatus(ORDER_STATUS orderStatus) {
        LocalDateTime startDateTime = LocalDateTime.of(LocalDate.now(), LocalTime.of(6, 0));
        LocalDateTime endDateTime = startDateTime.plusDays(1L);
        return this.orderRepository.findOrdersCreatedBetweenWithoutOrderStatus(startDateTime, endDateTime, orderStatus);
    }

    public List<Order> getOrdersCreatedFrom6AmToNextDay6AmWithoutTHISOrderStatuses(List<ORDER_STATUS> orderStatuses) {
        LocalDateTime startDateTime = LocalDateTime.of(LocalDate.now(), LocalTime.of(0, 0));
        LocalDateTime endDateTime = startDateTime.plusDays(1L);
        return this.orderRepository.findOrdersCreatedBetweenWithoutOrderStatuses(startDateTime, endDateTime, orderStatuses);
    }

    public List<Order> getOrdersToBeFinishedFrom6AmToNextDay6AmWithTHISOrderStatus(ORDER_STATUS orderStatus) {
        LocalDateTime startDateTime = LocalDateTime.of(LocalDate.now(), LocalTime.of(6, 0));
        LocalDateTime endDateTime = startDateTime.plusDays(1L);
        return this.orderRepository.findOrdersToBeFinishedBetweenWithOrderStatus(startDateTime, endDateTime, orderStatus);
    }

    public List<Order> getOrdersToBeFinishedFrom6AmToNextDay6AmWithTHISOrderStatuses(List<ORDER_STATUS> orderStatuses) {
        LocalDateTime startDateTime = LocalDateTime.of(LocalDate.now(), LocalTime.of(0, 0));
        LocalDateTime endDateTime = startDateTime.plusDays(1L);
        return this.orderRepository.findOrdersToBeFinishedBetweenWithOrderStatuses(startDateTime, endDateTime, orderStatuses);
    }

    public List<Order> getOrdersToBeFinishedFrom6AmToNextDay6AmWithoutTHISOrderStatus(ORDER_STATUS orderStatus) {
        LocalDateTime startDateTime = LocalDateTime.of(LocalDate.now(), LocalTime.of(6, 0));
        LocalDateTime endDateTime = startDateTime.plusDays(1L);
        return this.orderRepository.findOrdersToBeFinishedBetweenWithoutOrderStatus(startDateTime, endDateTime, orderStatus);
    }

    public List<Order> getOrdersToBeFinishedFrom6AmToNextDay6AmWithoutTHISOrderStatuses(List<ORDER_STATUS> orderStatuses) {
        LocalDateTime startDateTime = LocalDateTime.of(LocalDate.now(), LocalTime.of(0, 0));
        LocalDateTime endDateTime = startDateTime.plusDays(1L);
        return this.orderRepository.findOrdersToBeFinishedBetweenWithoutOrderStatuses(startDateTime, endDateTime, orderStatuses);
    }

    public List<String> findAllIds() {
        return this.orderRepository.findAllIds();
    }

    public Order findByIdNamed(String id) {
        return this.orderRepository.findByIdNamed(id);
    }

    public List<Order> findOrdersToBePrepared() {
        LocalDateTime dateTime = LocalDateTime.now().plusMinutes(15L);
        List<ORDER_STATUS> allowedStatuses = Arrays.asList(ORDER_STATUS.CONFIRMED, ORDER_STATUS.PREPARING);
        return this.orderRepository.findOrderWithToBeFinishedInBeforeDateTimeWithOrderStatuses(dateTime, allowedStatuses);
    }

    public List<Order> findOrdersByOrderTypeAndOrderStatus(ORDER_TYPE orderType, ORDER_STATUS orderStatus) {
        return this.orderRepository.findByOrderTypeInAndOrderStatusIn(List.of(orderType), List.of(orderStatus));
    }

    public List<Order> findOrdersByOrderTypeAndOrderStatus(List<ORDER_TYPE> orderTypes, List<ORDER_STATUS> orderStatuses) {
        return this.orderRepository.findByOrderTypeInAndOrderStatusIn(orderTypes, orderStatuses);
    }
}

