/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.restControllers;

import com.fasterxml.jackson.annotation.JsonFormat;
import cz.polreich.spagetka.DTO.RecipeStepDTO;
import cz.polreich.spagetka.models.RecipeStep;
import cz.polreich.spagetka.restControllers.BaseRestController;
import cz.polreich.spagetka.service.RecipeStepService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/recipeSteps"})
@Tag(name="Recipe Steps API", description="Handles Recipes Steps operations")
public class RecipeStepController
extends BaseRestController {
    @Autowired
    public RecipeStepService recipeStepService;

    @GetMapping
    @ResponseBody
    @Operation(summary="Returns all Recipe Steps")
    public ResponseEntity<List<RecipeStepDTO>> getAll(@RequestHeader Map<String, String> headers) {
        return this.processRequest(headers, () -> this.recipeStepService.findAll().stream().map(RecipeStepDTO::new).toList());
    }

    @GetMapping(value={"/{id}"})
    @ResponseBody
    @Operation(summary="Returns one Recipe Step with specified ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RecipeStepDTO.class))}), @ApiResponse(responseCode="404", description="Not Found - The Recipe Step with specified ID was not found", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))})})
    public ResponseEntity<RecipeStepDTO> getOne(@RequestHeader Map<String, String> headers, @PathVariable String id) {
        return this.processRequest(headers, () -> {
            if (this.recipeStepService.existsById(id)) {
                return new RecipeStepDTO(this.recipeStepService.findById(id));
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Recipe Step with ID: " + id + " not found!");
        });
    }

    @PostMapping
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    @ResponseBody
    @Operation(summary="Save one or multiple new Recipe Steps", description="Both Array and Single object instance can be provided")
    public ResponseEntity<List<RecipeStepDTO>> saveAll(@RequestHeader Map<String, String> headers, @RequestBody List<RecipeStepDTO> dtos) {
        return this.processRequest(headers, () -> {
            ArrayList<RecipeStep> categories = new ArrayList<RecipeStep>();
            for (RecipeStepDTO dto : dtos) {
                RecipeStep recipeStep = new RecipeStep(dto);
                categories.add(recipeStep);
            }
            this.recipeStepService.saveAll(categories);
            return dtos;
        });
    }

    @PutMapping(value={"/{id}"})
    @ResponseBody
    @Operation(summary="Replace one Recipe Step with specified ID", description="Updates existing or creates a new Recipe Step in case none found with provided ID")
    public ResponseEntity<RecipeStepDTO> replaceOne(@RequestHeader Map<String, String> headers, @RequestBody RecipeStepDTO newItem, @PathVariable String id) {
        return this.processRequest(headers, () -> {
            newItem.setId(id);
            this.recipeStepService.save(new RecipeStep(newItem));
            return newItem;
        });
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Deletes one Recipe Step with specified ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found - The Recipe Step with specified ID was not found", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))})})
    public void deleteOne(@RequestHeader Map<String, String> headers, @PathVariable String id) {
        if (this.isValidRequest(headers)) {
            if (!this.recipeStepService.existsById(id)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Recipe Step with ID: " + id + " not found!");
            }
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        this.recipeStepService.deleteById(id);
    }
}

