/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.restControllers;

import com.fasterxml.jackson.annotation.JsonFormat;
import cz.polreich.spagetka.DTO.AttendanceLogItemDTO;
import cz.polreich.spagetka.models.AttendanceLogItem;
import cz.polreich.spagetka.restControllers.BaseRestController;
import cz.polreich.spagetka.service.AttendanceLogItemsService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/attendanceLogs"})
@Tag(name="AttendanceLogItems API", description="Handles AttendanceLogItems operations")
public class AttendanceLogItemsController
extends BaseRestController {
    @Autowired
    public AttendanceLogItemsService attendanceLogItemService;

    @GetMapping
    @ResponseBody
    @Operation(summary="Returns all Attendance Log Items")
    public ResponseEntity<List<AttendanceLogItemDTO>> getAll(@RequestHeader Map<String, String> headers, @RequestParam(required=false, name="fromDateTime") @DateTimeFormat(pattern="dd.MM.yyyy'T'HH:mm:ss") String fromDateTimeString, @RequestParam(required=false, name="toDateTime") @DateTimeFormat(pattern="dd.MM.yyyy'T'HH:mm:ss") String toDateTimeString) {
        return this.processRequest(headers, () -> new BaseRestController.DateRangeHandler((BaseRestController)this).handleDateRange(fromDateTimeString, toDateTimeString, arg_0 -> ((AttendanceLogItemsService)this.attendanceLogItemService).findAllFromDateTime(arg_0), arg_0 -> ((AttendanceLogItemsService)this.attendanceLogItemService).findAllToDateTime(arg_0), (arg_0, arg_1) -> ((AttendanceLogItemsService)this.attendanceLogItemService).findAllInDateTimeFrame(arg_0, arg_1), () -> ((AttendanceLogItemsService)this.attendanceLogItemService).findAll(), AttendanceLogItemDTO::new));
    }

    @GetMapping(value={"/{id}"})
    @ResponseBody
    @Operation(summary="Returns one Attendance Log Item with specified ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AttendanceLogItemDTO.class))}), @ApiResponse(responseCode="404", description="Not Found - The Attendance Log Item with specified ID was not found", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))})})
    public ResponseEntity<AttendanceLogItemDTO> getOne(@RequestHeader Map<String, String> headers, @PathVariable String id) {
        return this.processRequest(headers, () -> {
            if (this.attendanceLogItemService.existsById(id)) {
                return new AttendanceLogItemDTO(this.attendanceLogItemService.findById(id));
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Attendance Log Item with ID: " + id + " not found!");
        });
    }

    @PostMapping
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    @ResponseBody
    @Operation(summary="Save one or multiple new Attendance Log Items", description="Both Array and Single object instance can be provided")
    public ResponseEntity<List<AttendanceLogItemDTO>> saveAll(@RequestHeader Map<String, String> headers, @RequestBody List<AttendanceLogItemDTO> dtos) {
        return this.processRequest(headers, () -> {
            ArrayList<AttendanceLogItem> categories = new ArrayList<AttendanceLogItem>();
            for (AttendanceLogItemDTO dto : dtos) {
                AttendanceLogItem attendanceLogItem = new AttendanceLogItem(dto);
                categories.add(attendanceLogItem);
            }
            this.attendanceLogItemService.saveAll(categories);
            return dtos;
        });
    }

    @PutMapping(value={"/{id}"})
    @ResponseBody
    @Operation(summary="Replace one Attendance Log Item with specified ID", description="Updates existing or creates a new Attendance Log Item in case none found with provided ID")
    public ResponseEntity<AttendanceLogItemDTO> replaceOne(@RequestHeader Map<String, String> headers, @RequestBody AttendanceLogItemDTO newItem, @PathVariable String id) {
        return this.processRequest(headers, () -> {
            newItem.setId(id);
            this.attendanceLogItemService.save(new AttendanceLogItem(newItem));
            return newItem;
        });
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Deletes one Attendance Log Item with specified ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found - The Attendance Log Item with specified ID was not found", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))})})
    public void deleteOne(@RequestHeader Map<String, String> headers, @PathVariable String id) {
        if (this.isValidRequest(headers)) {
            if (!this.attendanceLogItemService.existsById(id)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Attendance Log Item with ID: " + id + " not found!");
            }
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        this.attendanceLogItemService.deleteById(id);
    }
}

