/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.loading;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import cz.polreich.spagetka.DTO.CategoryDTO;
import cz.polreich.spagetka.DTO.ProductFreeVariantCategoryDTO;
import cz.polreich.spagetka.DTO.ProductFreeVariantDTO;
import cz.polreich.spagetka.DTO.ProductVariantDTO;
import cz.polreich.spagetka.PartnerServerRestClient;
import cz.polreich.spagetka.controllers.Controller;
import cz.polreich.spagetka.models.Allergen;
import cz.polreich.spagetka.models.Category;
import cz.polreich.spagetka.models.CompositionItem;
import cz.polreich.spagetka.models.CountryPrefix;
import cz.polreich.spagetka.models.Ingredient;
import cz.polreich.spagetka.models.KioskInfo;
import cz.polreich.spagetka.models.MenuOption;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.ProductFreeVariant;
import cz.polreich.spagetka.models.ProductFreeVariantCategory;
import cz.polreich.spagetka.models.ProductVariant;
import cz.polreich.spagetka.models.ProductsGroup;
import cz.polreich.spagetka.models.User;
import cz.polreich.spagetka.models.external.UserExternal;
import cz.polreich.spagetka.service.AllergenService;
import cz.polreich.spagetka.service.CategoryService;
import cz.polreich.spagetka.service.CompositionItemService;
import cz.polreich.spagetka.service.IngredientService;
import cz.polreich.spagetka.service.KioskInfoService;
import cz.polreich.spagetka.service.MenuOptionService;
import cz.polreich.spagetka.service.OrderService;
import cz.polreich.spagetka.service.ProductService;
import cz.polreich.spagetka.service.ProductVariantService;
import cz.polreich.spagetka.service.ProductsGroupService;
import cz.polreich.spagetka.service.RecipeStepService;
import cz.polreich.spagetka.service.StockItemService;
import cz.polreich.spagetka.service.UserService;
import cz.polreich.spagetka.utils.BugsnagSingleton;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.ResourceHelper;
import cz.polreich.spagetka.utils.ValidationUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class BaseLoadingController
extends Controller {
    @Autowired
    protected CategoryService categoryService;
    @Autowired
    protected IngredientService ingredientService;
    @Autowired
    protected MenuOptionService menuOptionService;
    @Autowired
    protected ProductService productService;
    @Autowired
    protected ProductsGroupService productsGroupService;
    @Autowired
    protected RecipeStepService recipeStepService;
    @Autowired
    protected UserService userService;
    @Autowired
    protected AllergenService allergenService;
    @Autowired
    protected KioskInfoService kioskInfoService;
    @Autowired
    protected OrderService orderService;
    @Autowired
    protected CompositionItemService compositionItemService;
    @Autowired
    protected ProductVariantService productVariantService;
    @Autowired
    protected StockItemService stockItemService;
    protected List<Product> filteredProducts = new ArrayList();
    protected BugsnagSingleton bugsnag;
    @Autowired
    protected ApplicationEventPublisher applicationEventPublisher;

    protected void downloadDataFromPartnerServer() {
        this.prepareDB();
        PartnerServerRestClient partnerServerRestClient = new PartnerServerRestClient(this.config.getCommon().getRestClientConfig());
        this.config.getSelectedConfig().setPartnerServerRestClient(partnerServerRestClient);
        List categoriesDTO = partnerServerRestClient.getCategories();
        List<Category> categories = categoriesDTO.stream().map(c -> new Category(c, true)).toList();
        this.categoryService.saveAll(categories);
        List<Ingredient> ingredients = partnerServerRestClient.getIngredients().stream().map(Ingredient::new).toList();
        this.ingredientService.saveAll(ingredients);
        List productsDTO = partnerServerRestClient.getProducts();
        List<Product> products = productsDTO.stream().map(p -> new Product(p, true)).toList();
        this.filteredProducts = new ArrayList<Product>(products);
        for (Product product : products) {
            this.calculateProductAvailability(product);
            if (product.getCategory() == this.config.getCommon().getSpaghettiCategoryId() || product.getCategory() == this.config.getCommon().getFusilliCategoryId()) {
                this.processPastaIngredients(product);
            }
            if (product.getProductVariants() != null && !product.getProductVariants().isEmpty() && product.getCategory() == this.config.getCommon().getCoffeeCategoryId()) {
                this.processCoffeeVariants(product);
            }
            if (product.getProductFreeVariantCategories() == null || product.getProductFreeVariantCategories().isEmpty() || product.getCategory() != this.config.getCommon().getIceCreamCategoryId()) continue;
            this.processIceCreamVariants(product);
        }
        this.productService.saveAll(this.filteredProducts);
        List<ProductsGroup> productsGroups = partnerServerRestClient.getProductsGroups().stream().map(ProductsGroup::new).toList();
        this.productsGroupService.saveAll(productsGroups);
        List menuOptionsDTO = partnerServerRestClient.getMenuOptions();
        List<MenuOption> menuOptions = menuOptionsDTO.stream().map(m -> new MenuOption(m, true)).toList();
        this.menuOptionService.saveAll(menuOptions);
        KioskInfo kioskInfo = new KioskInfo(partnerServerRestClient.getInfo());
        this.kioskInfoService.save(kioskInfo);
        List usersExternal = partnerServerRestClient.getUsers();
        List<User> kioskUsers = usersExternal.stream().filter(UserExternal::isAccessKiosk).map(User::new).toList();
        this.userService.saveAll(kioskUsers);
        List<Allergen> allergens = partnerServerRestClient.getAllergens().stream().map(Allergen::new).toList();
        this.allergenService.saveAll(allergens);
        for (CategoryDTO dto : categoriesDTO) {
            System.out.println("Downloading Category image: " + dto.getImageFilePath());
            partnerServerRestClient.downloadResource(dto.getImageFilePath());
        }
        for (CategoryDTO dto : productsDTO) {
            System.out.println("Downloading Product image: " + dto.getImageFilePath());
            partnerServerRestClient.downloadResource(dto.getImageFilePath());
            for (ProductVariantDTO variantDTO : dto.getVariants()) {
                System.out.println("Downloading Variant image: " + variantDTO.getImageFilePath());
                partnerServerRestClient.downloadResource(variantDTO.getImageFilePath());
            }
            for (ProductFreeVariantCategoryDTO variantCategory : dto.getCategoriesVariants()) {
                for (ProductFreeVariantDTO variantDTO : variantCategory.getFreeVariants()) {
                    System.out.println("Downloading FreeVariant image: " + variantDTO.getImageFilePath());
                    partnerServerRestClient.downloadResource(variantDTO.getImageFilePath());
                }
            }
        }
        for (CategoryDTO dto : menuOptionsDTO) {
            System.out.println("Downloading MenuOption image: " + dto.getImageFilePath());
            partnerServerRestClient.downloadResource(dto.getImageFilePath());
        }
    }

    public void configureBugsnag() {
        this.bugsnag.addToTab("location", "kioskId", this.config.getCommon().getKioskInfo().getKioskId());
        this.bugsnag.addToTab("location", "kioskName", this.config.getCommon().getKioskName());
    }

    protected void syncImagesToOrder() {
        System.out.println("Syncing images to Order1");
        ResourceHelper.syncImagesByNameOnly((String)"/home/user/spagetka/resources/images", (String)"/home/user/spagetka/resources/images", (String)"kioskOrder1.local");
        System.out.println("Syncing images to Order2");
        ResourceHelper.syncImagesByNameOnly((String)"/home/user/spagetka/resources/images", (String)"/home/user/spagetka/resources/images", (String)"kioskOrder2.local");
    }

    private void prepareDB() {
        this.productService.removeAllCompositionItemsFromProducts();
        this.productVariantService.removeAllCompositionItemsFromProductVariants();
        this.compositionItemService.deleteAll();
        this.createPastaIngredients();
        this.menuOptionService.disableAllMenuOptions();
    }

    private void createPastaIngredients() {
        String spaghettiId = this.config.getCommon().getSpaghettiIngredientId();
        String fusilliId = this.config.getCommon().getFusilliIngredientId();
        if (!this.ingredientService.existsById(spaghettiId)) {
            Ingredient spaghettiIngredient = new Ingredient();
            spaghettiIngredient.setId(spaghettiId);
            spaghettiIngredient.setName("\u0160pagety");
            spaghettiIngredient.setUnit("pc");
            spaghettiIngredient.setCookSee(Boolean.valueOf(true));
            spaghettiIngredient.setAlternativeUnit("pc");
            spaghettiIngredient.setAlternativeUnitRatio(Double.valueOf(1.0));
            spaghettiIngredient.setCriticalComponent(Boolean.valueOf(true));
            this.ingredientService.save(spaghettiIngredient);
        }
        if (!this.ingredientService.existsById(fusilliId)) {
            Ingredient fusilliIngredient = new Ingredient();
            fusilliIngredient.setId(fusilliId);
            fusilliIngredient.setName("Fusilli");
            fusilliIngredient.setUnit("pc");
            fusilliIngredient.setCookSee(Boolean.valueOf(true));
            fusilliIngredient.setAlternativeUnit("pc");
            fusilliIngredient.setAlternativeUnitRatio(Double.valueOf(1.0));
            fusilliIngredient.setCriticalComponent(Boolean.valueOf(true));
            this.ingredientService.save(fusilliIngredient);
        }
    }

    public List<CountryPrefix> loadCountryPrefixes() {
        ObjectMapper objectMapper = new ObjectMapper();
        Collection countryPrefixDataList = null;
        InputStream resourceStream = ResourceHelper.getResourceAsStream((String)"/resources/countries.json");
        try {
            countryPrefixDataList = (List)objectMapper.readValue((Reader)new InputStreamReader(resourceStream), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            ExceptionHandler.logException((Exception)e);
        }
        if (countryPrefixDataList != null) {
            return countryPrefixDataList.stream().map(data -> new CountryPrefix(data.getCountry(), data.getPrefix(), ResourceHelper.createImage((String)("/resources/images/flags/" + data.getCountryCode() + ".png")), data.getPattern())).collect(Collectors.toList());
        }
        return new ArrayList<CountryPrefix>();
    }

    private void processPastaIngredients(Product product) {
        CompositionItem compositionItem = new CompositionItem();
        if (product.getCategory() == this.config.getCommon().getSpaghettiCategoryId()) {
            compositionItem.setIngredient(this.ingredientService.findById(this.config.getCommon().getSpaghettiIngredientId()));
            compositionItem.setQuantity(this.config.getCommon().getSpaghettiPortionMultiplier());
        } else if (product.getCategory() == this.config.getCommon().getFusilliCategoryId()) {
            compositionItem.setIngredient(this.ingredientService.findById(this.config.getCommon().getFusilliIngredientId()));
            compositionItem.setQuantity(this.config.getCommon().getFusilliPortionMultiplier());
        }
        product.getIngredients().add(compositionItem);
    }

    private void calculateProductAvailability(Product product) {
        boolean available = true;
        for (CompositionItem compositionItem : product.getIngredients()) {
            if (!compositionItem.getIngredient().getCriticalComponent().booleanValue()) continue;
        }
        product.setAvailable(available);
    }

    private void processCoffeeVariants(Product product) {
        List variants = product.getProductVariants();
        for (ProductVariant variant : variants) {
            ProductVariant variantFromProduct = new ProductVariant(product);
            List existingProductList = this.filteredProducts.stream().filter(p -> p.getName().equals(variant.getName())).collect(Collectors.toList());
            if (existingProductList.isEmpty()) {
                Product productFromVariant = new Product(variant, product, true);
                productFromVariant.addVariant(variantFromProduct);
                this.calculateProductAvailability(productFromVariant);
                this.filteredProducts.add(productFromVariant);
                continue;
            }
            Product existingProduct = (Product)existingProductList.get(0);
            Product newProduct = new Product(existingProduct);
            newProduct.addVariant(variantFromProduct);
            this.filteredProducts.remove(existingProduct);
            this.filteredProducts.add(newProduct);
        }
        this.filteredProducts.remove(product);
        product.setEnabled(false);
        for (ProductVariant vari : product.getProductVariants()) {
            vari.setEnabled(false);
        }
        this.filteredProducts.add(product);
    }

    private void processIceCreamVariants(Product product) {
        for (ProductFreeVariantCategory variantCategory : product.getProductFreeVariantCategories()) {
            if (!ValidationUtils.isListNotNullOrEmpty((List)variantCategory.getFreeVariants())) continue;
            for (ProductFreeVariant variant : variantCategory.getFreeVariants()) {
                if (variant.getPrice() != null) continue;
                variant.setPrice(this.config.getCommon().getFreeVariantPrice());
            }
            ProductFreeVariant emptyVariant = new ProductFreeVariant();
            emptyVariant.setId("0" + variantCategory.getId());
            emptyVariant.setName("\u017d\u00e1dn\u00e9");
            emptyVariant.setImageFilePath("/resources/images/red_cross.png");
            emptyVariant.setPrice(Double.valueOf(0.0));
            emptyVariant.setEnabled(true);
            emptyVariant.setImageBytes(new byte[0]);
            ArrayList<ProductFreeVariant> newVariantList = new ArrayList<ProductFreeVariant>(variantCategory.getFreeVariants());
            newVariantList.add(emptyVariant);
            variantCategory.setFreeVariants(newVariantList);
        }
    }

    protected KioskInfo downloadKioskInfo() {
        PartnerServerRestClient partnerServerRestClient = this.config.getCommon().getPartnerServerRestClient();
        return new KioskInfo(partnerServerRestClient.getInfo());
    }

    protected void downloadImages() {
        PartnerServerRestClient partnerServerRestClient = this.config.getCommon().getPartnerServerRestClient();
        List categories = this.categoryService.findAll();
        List products = this.productService.findAll();
        List menuOptions = this.menuOptionService.findAll();
        for (Category cat : categories) {
            System.out.println("Downloading Category image: " + cat.getRemoteImagePath());
            partnerServerRestClient.downloadResource(cat.getRemoteImagePath());
        }
        for (Product product : products) {
            System.out.println("Downloading Product image: " + product.getRemoteImagePath());
            partnerServerRestClient.downloadResource(product.getRemoteImagePath());
            for (ProductVariant productVariant : product.getProductVariants()) {
                System.out.println("Downloading Variant image: " + productVariant.getRemoteImagePath());
                partnerServerRestClient.downloadResource(productVariant.getRemoteImagePath());
            }
            for (ProductFreeVariantCategory variantCategory : product.getProductFreeVariantCategories()) {
                for (ProductFreeVariant variant : variantCategory.getFreeVariants()) {
                    if (!ValidationUtils.isStringNotNullOrEmpty((String)variant.getRemoteImagePath())) continue;
                    System.out.println("Downloading FreeVariant image: " + variant.getRemoteImagePath());
                    partnerServerRestClient.downloadResource(variant.getRemoteImagePath());
                }
            }
        }
        for (MenuOption menuOption : menuOptions) {
            System.out.println("Downloading MenuOption image: " + menuOption.getRemoteImagePath());
            partnerServerRestClient.downloadResource(menuOption.getRemoteImagePath());
        }
    }
}

