/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service.monitoring;

import cz.polreich.spagetka.models.enums.ORDER_STATUS;
import cz.polreich.spagetka.service.OrderService;
import cz.polreich.spagetka.service.monitoring.SshCommandExecutor;
import cz.polreich.spagetka.service.monitoring.model.KioskStage;
import cz.polreich.spagetka.service.monitoring.model.MonitoringData;
import cz.polreich.spagetka.service.monitoring.service.CashierActiveConfigService;
import cz.polreich.spagetka.utils.appmetadata.AppMetadataUtil;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MonitoringService {
    private static final Logger log = LoggerFactory.getLogger(MonitoringService.class);
    private final CashierActiveConfigService cashierActiveConfigService;
    private final OrderService orderService;
    private final SshCommandExecutor sshCommandExecutor;
    @Value(value="#{'${spagetka.monitoring.kioskStageNameList}'.split(',')}")
    private List<String> kioskStageNameList;

    @Autowired
    public MonitoringService(CashierActiveConfigService cashierActiveConfigService, OrderService orderService, SshCommandExecutor sshCommandExecutor) {
        this.cashierActiveConfigService = cashierActiveConfigService;
        this.orderService = orderService;
        this.sshCommandExecutor = sshCommandExecutor;
    }

    public MonitoringData createMonitoringData() {
        Objects.requireNonNull(this.kioskStageNameList, "kioskStageNameList must not be null");
        MonitoringData data = new MonitoringData();
        data.setKioskName(this.cashierActiveConfigService.getKioskName());
        data.setTimestamp(System.currentTimeMillis());
        this.cashierActiveConfigService.serLoggedUserForKioskStage(data);
        data.setConfirmedOrdersQuantity(this.orderService.countAllOrdersByTodayAndOrdersStatusList(List.of(ORDER_STATUS.CONFIRMED)));
        data.setPendingOrdersQuantity(this.orderService.countAllOrdersByTodayAndOrdersStatusList(List.of(ORDER_STATUS.WAITING_FOR_PICKUP, ORDER_STATUS.WAITING_FOR_DELIVERY)));
        for (String stageName : this.kioskStageNameList) {
            data.addKioskStage(this.createKioskStage(data.getKioskName(), stageName));
        }
        data.setVersion(AppMetadataUtil.getAppVersionNumber());
        log.debug(data.toString());
        return data;
    }

    private KioskStage createKioskStage(String kioskName, String stageName) {
        KioskStage kioskStage = new KioskStage();
        kioskStage.setKioskStageName(stageName);
        kioskStage.setKioskName(kioskName);
        if (stageName.equals("Cashier")) {
            this.sshCommandExecutor.setFreeSpaceInMBForStage(kioskStage, false);
        } else {
            this.sshCommandExecutor.setFreeSpaceInMBForStage(kioskStage, true);
        }
        log.debug(kioskStage.toString());
        return kioskStage;
    }
}

