/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.DTO.MenuOptionDTO;
import cz.polreich.spagetka.DTO.ProductGroupsPriceDTO;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.ProductGroupsPrice;
import cz.polreich.spagetka.models.ProductsGroup;
import cz.polreich.spagetka.service.ProductService;
import cz.polreich.spagetka.service.ProductsGroupService;
import cz.polreich.spagetka.utils.ApplicationContextUtils;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="menuOptions")
public class MenuOption {
    @Id
    private String id;
    @ManyToOne
    @JoinColumn(name="mainProductId", referencedColumnName="id")
    private Product mainProduct;
    @Transient
    private List<ProductsGroup> additionalProductsGroups = new ArrayList();
    @ManyToMany(cascade={CascadeType.MERGE}, fetch=FetchType.EAGER)
    @JoinTable(name="menu_additional_products_groups_prices", joinColumns={@JoinColumn(name="menuId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="addProductGroupId", referencedColumnName="id")})
    private List<ProductGroupsPrice> additionalProductsPrices = new ArrayList();
    @Column
    private Double price;
    @Column
    private String name;
    @Column
    private String description;
    @Column
    private String imageFilePath;
    @Column
    private String remoteImagePath;
    @Column
    private boolean enabled;

    public MenuOption(MenuOptionDTO dto) {
        this.createFromDTO(dto, false);
    }

    public MenuOption(MenuOptionDTO dto, boolean fromExternal) {
        this.createFromDTO(dto, fromExternal);
    }

    private void createFromDTO(MenuOptionDTO dto, boolean fromExternal) {
        this.id = dto.getId();
        ProductService productService = (ProductService)ApplicationContextUtils.getApplicationContext().getBean(ProductService.class);
        if (productService.existsById(dto.getMainProductId())) {
            this.mainProduct = productService.findById(dto.getMainProductId());
        }
        ProductsGroupService additionalProductsGroupService = (ProductsGroupService)ApplicationContextUtils.getApplicationContext().getBean(ProductsGroupService.class);
        if (fromExternal) {
            for (ProductGroupsPriceDTO priceDto : dto.getAdditionalProductsPrices()) {
                this.additionalProductsPrices.add(new ProductGroupsPrice(priceDto));
            }
        } else {
            for (ProductGroupsPriceDTO priceDto : dto.getAdditionalProductsPrices()) {
                if (priceDto.getId() != null && additionalProductsGroupService.existsById(priceDto.getId())) {
                    this.additionalProductsPrices.add(new ProductGroupsPrice(priceDto));
                    continue;
                }
                System.out.println("WARNING: ProductGroupPrice with ID " + priceDto.getId() + " not found");
            }
        }
        this.price = dto.getPrice();
        this.name = dto.getName();
        this.description = dto.getDescription();
        if (fromExternal) {
            int index = dto.getImageFilePath().lastIndexOf("/");
            String fileName = dto.getImageFilePath().substring(index + 1);
            this.imageFilePath = "/resources/images/" + fileName;
        } else {
            this.imageFilePath = dto.getImageFilePath();
        }
        this.remoteImagePath = dto.getImageFilePath();
        this.enabled = dto.getAllowedAtKiosk() != null ? dto.getAllowedAtKiosk() : false;
    }

    public List<ProductsGroup> getAdditionalProductsGroups() {
        return this.additionalProductsPrices.stream().map(ProductGroupsPrice::getProductsGroup).toList();
    }

    public MenuOption() {
    }

    public MenuOption(String id, Product mainProduct, List<ProductsGroup> additionalProductsGroups, List<ProductGroupsPrice> additionalProductsPrices, Double price, String name, String description, String imageFilePath, String remoteImagePath, boolean enabled) {
        this.id = id;
        this.mainProduct = mainProduct;
        this.additionalProductsGroups = additionalProductsGroups;
        this.additionalProductsPrices = additionalProductsPrices;
        this.price = price;
        this.name = name;
        this.description = description;
        this.imageFilePath = imageFilePath;
        this.remoteImagePath = remoteImagePath;
        this.enabled = enabled;
    }

    public String getId() {
        return this.id;
    }

    public Product getMainProduct() {
        return this.mainProduct;
    }

    public List<ProductGroupsPrice> getAdditionalProductsPrices() {
        return this.additionalProductsPrices;
    }

    public Double getPrice() {
        return this.price;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getImageFilePath() {
        return this.imageFilePath;
    }

    public String getRemoteImagePath() {
        return this.remoteImagePath;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMainProduct(Product mainProduct) {
        this.mainProduct = mainProduct;
    }

    public void setAdditionalProductsGroups(List<ProductsGroup> additionalProductsGroups) {
        this.additionalProductsGroups = additionalProductsGroups;
    }

    public void setAdditionalProductsPrices(List<ProductGroupsPrice> additionalProductsPrices) {
        this.additionalProductsPrices = additionalProductsPrices;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setImageFilePath(String imageFilePath) {
        this.imageFilePath = imageFilePath;
    }

    public void setRemoteImagePath(String remoteImagePath) {
        this.remoteImagePath = remoteImagePath;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

