/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.orderConfirmationController;

import cz.polreich.spagetka.controllers.CustomerBaseController;
import cz.polreich.spagetka.controllers.CustomerOrderConfirmationController;
import cz.polreich.spagetka.models.gui.buttons.CancelButton;
import cz.polreich.spagetka.utils.FontUtils;
import cz.polreich.spagetka.utils.LayoutUtils;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.stage.Popup;
import javafx.stage.Window;

public class ChoosePaymentPopup
extends Popup {
    private CustomerOrderConfirmationController orderConfirmationController;
    private Button payByCardButton;
    private Button payByCashButton;
    private CancelButton cancelButton;
    public Label statusLabel;

    public ChoosePaymentPopup(CustomerOrderConfirmationController orderConfirmationController) {
        this.orderConfirmationController = orderConfirmationController;
        int tileCornerRadius = 20;
        int borderWidth = 1;
        AnchorPane popupAnchor = new AnchorPane();
        Label label = new Label();
        label.setMaxWidth(800.0);
        orderConfirmationController.bindStringToLocale(label, "choosePayment.label.title", orderConfirmationController.titleFont);
        FontUtils.setIdealFont((Label)label, (Font)orderConfirmationController.titleFont);
        AnchorPane.setTopAnchor((Node)label, (Double)30.0);
        AnchorPane.setLeftAnchor((Node)label, (Double)100.0);
        AnchorPane.setRightAnchor((Node)label, (Double)100.0);
        label.setAlignment(Pos.CENTER);
        label.setPadding(new Insets(20.0));
        this.payByCardButton = new Button();
        this.payByCardButton.setMinSize(200.0, 200.0);
        this.payByCardButton.setMaxSize(300.0, 300.0);
        this.payByCardButton.setStyle("-fx-border-color:  lightgray;\n  -fx-border-width: " + borderWidth + "px;\n  -fx-border-style: solid;\n  -fx-border-radius: " + tileCornerRadius + "px ;\n  -fx-background-radius: " + tileCornerRadius + "px ;");
        this.payByCardButton.setFocusTraversable(false);
        orderConfirmationController.bindStringToLocale(this.payByCardButton, "choosePayment.button.card", orderConfirmationController.subtitleFont);
        this.payByCardButton.setContentDisplay(ContentDisplay.BOTTOM);
        FontUtils.setIdealFont((Button)this.payByCardButton, (Font)orderConfirmationController.subtitleFont);
        LayoutUtils.setImageForButton((String)"/resources/images/cards_256.png", (Button)this.payByCardButton, (int)200, (int)200);
        this.payByCashButton = new Button();
        this.payByCashButton.setMinSize(200.0, 200.0);
        this.payByCashButton.setMaxSize(400.0, 400.0);
        this.payByCashButton.setStyle("-fx-border-color:  lightgray;\n  -fx-border-width: " + borderWidth + "px;\n  -fx-border-style: solid;\n  -fx-border-radius: " + tileCornerRadius + "px ;\n  -fx-background-radius: " + tileCornerRadius + "px ;");
        this.payByCashButton.setFocusTraversable(false);
        orderConfirmationController.bindStringToLocale(this.payByCashButton, "choosePayment.button.cash", orderConfirmationController.subtitleFont);
        this.payByCashButton.setContentDisplay(ContentDisplay.BOTTOM);
        FontUtils.setIdealFont((Button)this.payByCashButton, (Font)orderConfirmationController.subtitleFont);
        LayoutUtils.setImageForButton((String)"/resources/images/cash_dollars_256.png", (Button)this.payByCashButton, (int)200, (int)200);
        FlowPane buttonsFlowPane = new FlowPane();
        buttonsFlowPane.setOrientation(Orientation.HORIZONTAL);
        buttonsFlowPane.setAlignment(Pos.CENTER);
        buttonsFlowPane.setHgap(30.0);
        AnchorPane.setTopAnchor((Node)buttonsFlowPane, (Double)200.0);
        AnchorPane.setLeftAnchor((Node)buttonsFlowPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)buttonsFlowPane, (Double)0.0);
        buttonsFlowPane.getChildren().addAll((Object[])new Node[]{this.payByCardButton, this.payByCashButton});
        this.statusLabel = new Label();
        AnchorPane.setTopAnchor((Node)this.statusLabel, (Double)200.0);
        AnchorPane.setLeftAnchor((Node)this.statusLabel, (Double)90.0);
        this.statusLabel.setVisible(false);
        this.statusLabel.setStyle("-fx-font-size: 30px; -fx-font-family: \"lobster\";");
        this.statusLabel.textProperty().addListener((observableValue, s, t1) -> System.out.println("New label text: " + t1));
        this.cancelButton = new CancelButton();
        this.cancelButton.setMaxWidth(300.0);
        orderConfirmationController.bindStringToLocale((Button)this.cancelButton, "choosePayment.button.cancel", orderConfirmationController.titleFont);
        this.cancelButton.setMinSize(160.0, 40.0);
        FontUtils.setIdealFont((Button)this.cancelButton, (Font)orderConfirmationController.titleFont);
        FlowPane cancelButtonFlowPane = new FlowPane();
        cancelButtonFlowPane.setOrientation(Orientation.HORIZONTAL);
        cancelButtonFlowPane.setAlignment(Pos.CENTER);
        AnchorPane.setBottomAnchor((Node)cancelButtonFlowPane, (Double)40.0);
        AnchorPane.setLeftAnchor((Node)cancelButtonFlowPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)cancelButtonFlowPane, (Double)0.0);
        cancelButtonFlowPane.getChildren().add((Object)this.cancelButton);
        popupAnchor.setMinWidth(650.0);
        popupAnchor.setMinHeight(650.0);
        popupAnchor.setStyle("-fx-background-color: " + orderConfirmationController.popupBackgroundColor + ";");
        popupAnchor.getStyleClass().add((Object)"popup-main-pane");
        popupAnchor.getChildren().addAll((Object[])new Node[]{label, buttonsFlowPane, cancelButtonFlowPane, this.statusLabel});
        this.getContent().add((Object)popupAnchor);
        this.cancelButton.setOnMouseClicked(mouseEvent -> this.hide());
        this.cancelButton.setOnTouchPressed(touchEvent -> this.hide());
        this.payByCardButton.setOnMouseClicked(mouseEvent -> this.handleCardButton());
        this.payByCardButton.setOnTouchPressed(touchEvent -> this.handleCardButton());
        this.payByCashButton.setOnMouseClicked(mouseEvent -> orderConfirmationController.payByCashButtonAction());
        this.payByCashButton.setOnTouchPressed(touchEvent -> orderConfirmationController.payByCashButtonAction());
    }

    public void loadPopup() {
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            CustomerBaseController.lastPressTime = System.currentTimeMillis();
        });
        this.addEventFilter(TouchEvent.TOUCH_PRESSED, touchEvent -> {
            CustomerBaseController.lastPressTime = System.currentTimeMillis();
        });
        Platform.runLater(() -> {
            boolean partnerWebConnectionAvailable = this.orderConfirmationController.getInternetConnectivityService().checkPartnerWebReachable();
            boolean mdbEnabled = this.orderConfirmationController.activeConfig.getMdbConfig().isEnabled();
            if (!partnerWebConnectionAvailable || !mdbEnabled) {
                this.payByCardButton.setDisable(true);
                this.orderConfirmationController.bindStringToLocale(this.payByCardButton, "choosePayment.label.unavailable", this.orderConfirmationController.subtitleFont);
                this.payByCardButton.setTextFill(Paint.valueOf((String)"#FF0000"));
            } else {
                this.payByCardButton.setDisable(false);
                this.orderConfirmationController.bindStringToLocale(this.payByCardButton, "choosePayment.button.card", this.orderConfirmationController.subtitleFont);
                this.payByCardButton.setTextFill(Paint.valueOf((String)"#000000"));
            }
        });
        this.orderConfirmationController.activeConfig.getOpenedPopups().add(this);
        this.show((Window)this.orderConfirmationController.stage);
        ((Node)this.getContent().get(0)).requestFocus();
    }

    private void handleCardButton() {
        Platform.runLater(() -> {
            this.hideButtons();
            this.statusLabel.setVisible(true);
            this.setStatusLabelText(this.orderConfirmationController.strings.getString("choosePayment.label.terminalCommunication"));
        });
        new Thread(() -> this.orderConfirmationController.payByCardButtonAction()).start();
    }

    public void showButtons() {
        this.payByCardButton.setVisible(true);
        this.payByCashButton.setVisible(true);
    }

    public void hideButtons() {
        this.payByCardButton.setVisible(false);
        this.payByCashButton.setVisible(false);
    }

    public void setStatusLabelText(String text) {
        this.statusLabel.setText(text);
        this.statusLabel.setVisible(false);
        this.statusLabel.setVisible(true);
    }

    public void hideStatusLabel() {
        this.statusLabel.setVisible(false);
    }

    public void disableCancelButton() {
        this.cancelButton.setDisable(true);
    }

    public void enableCancelButton() {
        this.cancelButton.setDisable(false);
    }

    public void hide() {
        this.orderConfirmationController.activeConfig.getOpenedPopups().remove(this);
        super.hide();
    }
}

