/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka;

import cz.polreich.spagetka.CookStarter;
import cz.polreich.spagetka.StageReadyEvent;
import cz.polreich.spagetka.controllers.CookController;
import cz.polreich.spagetka.models.config.Config;
import cz.polreich.spagetka.models.config.CookConfig;
import cz.polreich.spagetka.models.config.ScreenResolution;
import java.io.IOException;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCombination;
import javafx.stage.Screen;
import javafx.stage.Stage;
import org.scenicview.ScenicView;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class CookApp
extends Application {
    private ConfigurableApplicationContext springContext;
    private CookController cookController;
    private Config config;
    private CookConfig activeConfig;
    private ScreenResolution screenResolution;

    public void start(Stage stage) throws Exception {
        this.springContext.publishEvent((ApplicationEvent)new StageReadyEvent(stage));
        this.config = (Config)this.springContext.getBean(Config.class);
        this.config.setCookSelected();
        this.activeConfig = this.config.getCook();
        this.loadScene(stage);
    }

    public void stop() {
        this.springContext.stop();
        Platform.exit();
    }

    public void init() {
        this.springContext = new SpringApplicationBuilder(new Class[]{CookStarter.class}).run(new String[0]);
    }

    public void loadScene(Stage stage) throws IOException {
        Rectangle2D screenBounds;
        FXMLLoader loader = new FXMLLoader(CookApp.class.getResource("cook.fxml"));
        loader.setControllerFactory(arg_0 -> ((ConfigurableApplicationContext)this.springContext).getBean(arg_0));
        Parent root = (Parent)loader.load();
        this.cookController = (CookController)loader.getController();
        this.cookController.setupStage(stage);
        this.screenResolution = this.activeConfig.getDisplayConfig().getResolution();
        Scene scene = new Scene(root);
        stage.setScene(scene);
        stage.setResizable(false);
        if (this.activeConfig.getDisplayConfig().isFullscreen()) {
            stage.setFullScreen(true);
            stage.setFullScreenExitKeyCombination(KeyCombination.NO_MATCH);
        }
        stage.setTitle("Spagetka cook master v0.0.1");
        try {
            screenBounds = ((Screen)Screen.getScreens().get(this.activeConfig.getDisplayConfig().getScreenId())).getVisualBounds();
        }
        catch (Exception e) {
            screenBounds = ((Screen)Screen.getScreens().get(0)).getVisualBounds();
        }
        stage.setWidth((double)this.activeConfig.getDisplayConfig().getResolution().getWidth());
        stage.setHeight((double)this.activeConfig.getDisplayConfig().getResolution().getHeight());
        stage.setX(screenBounds.getMinX());
        stage.setY(screenBounds.getMinY());
        stage.show();
        if (this.activeConfig.isOpenScenicView()) {
            ScenicView.show((Scene)scene);
        }
    }

    public static void main(String[] args) {
        CookApp.launch(CookApp.class, (String[])args);
    }
}

