/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import cz.polreich.spagetka.DTO.BranchStateItemDTO;
import cz.polreich.spagetka.PartnerServerRestClient;
import cz.polreich.spagetka.models.BranchStateItem;
import cz.polreich.spagetka.models.CountryPrefix;
import cz.polreich.spagetka.models.KioskInfo;
import cz.polreich.spagetka.models.config.RestClientConfig;
import cz.polreich.spagetka.models.enums.BRANCH_STATE;
import java.util.ArrayList;
import java.util.List;

public class CommonConfig {
    @JsonProperty
    public RestClientConfig restClientConfig;
    @JsonProperty
    private int spaghettiCategoryId;
    @JsonProperty
    private int fusilliCategoryId;
    @JsonProperty
    private int coffeeCategoryId;
    @JsonProperty
    private int iceCreamCategoryId;
    @JsonProperty
    private Double freeVariantPrice;
    @JsonProperty
    private String spaghettiIngredientId;
    @JsonProperty
    private String fusilliIngredientId;
    @JsonProperty
    private Double spaghettiPortionMultiplier = 1.0;
    @JsonProperty
    private Double fusilliPortionMultiplier = 1.0;
    @JsonProperty
    private String kioskName = "";
    @JsonIgnore
    private PartnerServerRestClient partnerServerRestClient;
    @JsonIgnore
    private KioskInfo kioskInfo;
    @JsonIgnore
    private BranchStateItem branchState = new BranchStateItem(BRANCH_STATE.CLOSED, null);
    @JsonIgnore
    private List<CountryPrefix> countryPrefixes = new ArrayList();

    public PartnerServerRestClient getPartnerServerRestClient() {
        if (this.partnerServerRestClient == null) {
            this.partnerServerRestClient = new PartnerServerRestClient(this.restClientConfig);
        }
        return this.partnerServerRestClient;
    }

    public void setNewBranchState(BranchStateItem branchState) {
        this.branchState = branchState;
        new Thread(() -> this.getPartnerServerRestClient().sendBranchStatusUpdate(new BranchStateItemDTO(branchState))).start();
    }

    public RestClientConfig getRestClientConfig() {
        return this.restClientConfig;
    }

    public int getSpaghettiCategoryId() {
        return this.spaghettiCategoryId;
    }

    public int getFusilliCategoryId() {
        return this.fusilliCategoryId;
    }

    public int getCoffeeCategoryId() {
        return this.coffeeCategoryId;
    }

    public int getIceCreamCategoryId() {
        return this.iceCreamCategoryId;
    }

    public Double getFreeVariantPrice() {
        return this.freeVariantPrice;
    }

    public String getSpaghettiIngredientId() {
        return this.spaghettiIngredientId;
    }

    public String getFusilliIngredientId() {
        return this.fusilliIngredientId;
    }

    public Double getSpaghettiPortionMultiplier() {
        return this.spaghettiPortionMultiplier;
    }

    public Double getFusilliPortionMultiplier() {
        return this.fusilliPortionMultiplier;
    }

    public String getKioskName() {
        return this.kioskName;
    }

    public KioskInfo getKioskInfo() {
        return this.kioskInfo;
    }

    public BranchStateItem getBranchState() {
        return this.branchState;
    }

    public List<CountryPrefix> getCountryPrefixes() {
        return this.countryPrefixes;
    }

    @JsonProperty
    public void setRestClientConfig(RestClientConfig restClientConfig) {
        this.restClientConfig = restClientConfig;
    }

    @JsonProperty
    public void setSpaghettiCategoryId(int spaghettiCategoryId) {
        this.spaghettiCategoryId = spaghettiCategoryId;
    }

    @JsonProperty
    public void setFusilliCategoryId(int fusilliCategoryId) {
        this.fusilliCategoryId = fusilliCategoryId;
    }

    @JsonProperty
    public void setCoffeeCategoryId(int coffeeCategoryId) {
        this.coffeeCategoryId = coffeeCategoryId;
    }

    @JsonProperty
    public void setIceCreamCategoryId(int iceCreamCategoryId) {
        this.iceCreamCategoryId = iceCreamCategoryId;
    }

    @JsonProperty
    public void setFreeVariantPrice(Double freeVariantPrice) {
        this.freeVariantPrice = freeVariantPrice;
    }

    @JsonProperty
    public void setSpaghettiIngredientId(String spaghettiIngredientId) {
        this.spaghettiIngredientId = spaghettiIngredientId;
    }

    @JsonProperty
    public void setFusilliIngredientId(String fusilliIngredientId) {
        this.fusilliIngredientId = fusilliIngredientId;
    }

    @JsonProperty
    public void setSpaghettiPortionMultiplier(Double spaghettiPortionMultiplier) {
        this.spaghettiPortionMultiplier = spaghettiPortionMultiplier;
    }

    @JsonProperty
    public void setFusilliPortionMultiplier(Double fusilliPortionMultiplier) {
        this.fusilliPortionMultiplier = fusilliPortionMultiplier;
    }

    @JsonProperty
    public void setKioskName(String kioskName) {
        this.kioskName = kioskName;
    }

    @JsonIgnore
    public void setPartnerServerRestClient(PartnerServerRestClient partnerServerRestClient) {
        this.partnerServerRestClient = partnerServerRestClient;
    }

    @JsonIgnore
    public void setKioskInfo(KioskInfo kioskInfo) {
        this.kioskInfo = kioskInfo;
    }

    @JsonIgnore
    public void setBranchState(BranchStateItem branchState) {
        this.branchState = branchState;
    }

    @JsonIgnore
    public void setCountryPrefixes(List<CountryPrefix> countryPrefixes) {
        this.countryPrefixes = countryPrefixes;
    }
}

