/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.cashierController;

import cz.polreich.spagetka.DTO.discountCodes.DiscountCodeForClubResponse;
import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.models.CountryPrefix;
import cz.polreich.spagetka.models.gui.buttons.CancelButton;
import cz.polreich.spagetka.models.gui.buttons.ConfirmButton;
import cz.polreich.spagetka.models.gui.buttons.GrayButton;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.LayoutUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.Event;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Font;
import javafx.stage.Popup;
import javafx.stage.Window;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class DiscountCodeGenerationPopup
extends Popup {
    private CashierController cashierController;
    private TextField textField;
    private ComboBox<CountryPrefix> prefixComboBox = new ComboBox();
    private CancelButton cancelButton;
    private ConfirmButton generateButton;
    private FlowPane keyboardFlowPane;
    private HBox phoneInputBox;
    private FlowPane buttonsFlowPane;
    private AnchorPane popupAnchor;
    private Label codeLabel;
    private Label validityLabel;
    private ObjectProperty<CountryPrefix> selectedCountryPrefix = new SimpleObjectProperty();
    private ListProperty<Integer> phoneNumberSpacesList = new SimpleListProperty();

    public DiscountCodeGenerationPopup(CashierController cashierController) {
        this.cashierController = cashierController;
        this.popupAnchor = new AnchorPane();
        Label labelTitle = new Label();
        labelTitle.setText(cashierController.strings.getString("discountCodeGeneration"));
        labelTitle.setFont(cashierController.titleFont);
        AnchorPane.setTopAnchor((Node)labelTitle, (Double)10.0);
        AnchorPane.setLeftAnchor((Node)labelTitle, (Double)100.0);
        AnchorPane.setRightAnchor((Node)labelTitle, (Double)100.0);
        labelTitle.setAlignment(Pos.CENTER);
        this.prefixComboBox.getItems().addAll((Collection)cashierController.activeConfig.getCountryPrefixes());
        this.prefixComboBox.setMaxSize(350.0, 76.0);
        this.prefixComboBox.setMinSize(300.0, 76.0);
        this.prefixComboBox.setCellFactory(comboBox -> new /* Unavailable Anonymous Inner Class!! */);
        this.prefixComboBox.setButtonCell((ListCell)this.prefixComboBox.getCellFactory().call(null));
        this.prefixComboBox.getItems().stream().filter(item -> "+420".equals(item.getPrefix())).findFirst().ifPresent(arg_0 -> ((ComboBox)this.prefixComboBox).setValue(arg_0));
        this.selectedCountryPrefix.bind((ObservableValue)this.prefixComboBox.getSelectionModel().selectedItemProperty());
        this.phoneNumberSpacesList.bind((ObservableValue)Bindings.createObjectBinding(() -> {
            if (this.selectedCountryPrefix.get() != null) {
                String pattern = ((CountryPrefix)this.selectedCountryPrefix.get()).getPhoneNumberPattern();
                return FXCollections.observableList((List)this.getListOfSpaces(pattern));
            }
            return FXCollections.observableArrayList();
        }, (Observable[])new Observable[]{this.selectedCountryPrefix}));
        this.textField = new TextField();
        this.textField.setFont(cashierController.titleFont);
        this.textField.promptTextProperty().bind((ObservableValue)Bindings.createStringBinding(() -> ((CountryPrefix)this.selectedCountryPrefix.get()).getPhoneNumberPattern(), (Observable[])new Observable[]{this.selectedCountryPrefix}));
        this.textField.setAlignment(Pos.CENTER);
        this.textField.setFocusTraversable(false);
        this.textField.requestFocus();
        this.phoneInputBox = new HBox();
        this.phoneInputBox.getChildren().addAll((Object[])new Node[]{this.prefixComboBox, this.textField});
        AnchorPane.setTopAnchor((Node)this.phoneInputBox, (Double)100.0);
        AnchorPane.setLeftAnchor((Node)this.phoneInputBox, (Double)50.0);
        AnchorPane.setRightAnchor((Node)this.phoneInputBox, (Double)50.0);
        this.keyboardFlowPane = new FlowPane();
        this.keyboardFlowPane.setAlignment(Pos.CENTER_RIGHT);
        AnchorPane.setTopAnchor((Node)this.keyboardFlowPane, (Double)200.0);
        AnchorPane.setRightAnchor((Node)this.keyboardFlowPane, (Double)100.0);
        GridPane keyboardGridPane = LayoutUtils.createNumberKeyboard((Font)cashierController.subtitleFont, arg_0 -> this.phoneNumber_keyboard_clicked(arg_0));
        this.keyboardFlowPane.getChildren().add((Object)keyboardGridPane);
        this.cancelButton = new CancelButton(cashierController.strings.getString("cancel"));
        this.cancelButton.setMinSize(160.0, 40.0);
        this.cancelButton.setFont(cashierController.titleFont);
        this.cancelButton.setOnMouseClicked(mouseEvent -> this.hide());
        this.cancelButton.setOnTouchPressed(touchEvent -> this.hide());
        this.generateButton = new ConfirmButton(cashierController.strings.getString("generate"));
        this.generateButton.setMinSize(160.0, 40.0);
        this.generateButton.setFont(cashierController.titleFont);
        this.generateButton.setOnMouseClicked(mouseEvent -> this.generateButtonAction());
        this.generateButton.setOnTouchPressed(touchEvent -> this.generateButtonAction());
        this.generateButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.validatePhoneNumber(this.textField.getText()), (Observable[])new Observable[]{this.textField.textProperty()}));
        this.buttonsFlowPane = new FlowPane();
        this.buttonsFlowPane.setOrientation(Orientation.VERTICAL);
        this.buttonsFlowPane.setAlignment(Pos.CENTER);
        this.buttonsFlowPane.setVgap(60.0);
        AnchorPane.setBottomAnchor((Node)this.buttonsFlowPane, (Double)100.0);
        AnchorPane.setLeftAnchor((Node)this.buttonsFlowPane, (Double)100.0);
        this.buttonsFlowPane.getChildren().addAll((Object[])new Node[]{this.generateButton, this.cancelButton});
        this.codeLabel = new Label();
        this.codeLabel.setFont(cashierController.subtitleFont);
        AnchorPane.setTopAnchor((Node)this.codeLabel, (Double)250.0);
        AnchorPane.setRightAnchor((Node)this.codeLabel, (Double)150.0);
        this.validityLabel = new Label();
        this.validityLabel.setFont(cashierController.subtitleFont);
        AnchorPane.setTopAnchor((Node)this.validityLabel, (Double)300.0);
        AnchorPane.setRightAnchor((Node)this.validityLabel, (Double)150.0);
        this.popupAnchor.setMinWidth(650.0);
        this.popupAnchor.setMinHeight(650.0);
        this.popupAnchor.setStyle("-fx-background-color: khaki");
        this.popupAnchor.getChildren().addAll((Object[])new Node[]{labelTitle, this.phoneInputBox, this.keyboardFlowPane, this.buttonsFlowPane, this.codeLabel, this.validityLabel});
        this.enableCreationMode();
        this.getContent().add((Object)this.popupAnchor);
    }

    public void loadPopup() {
        this.show((Window)this.cashierController.stage);
        ((Node)this.getContent().get(0)).requestFocus();
    }

    private void enableCreationMode() {
        this.codeLabel.setVisible(false);
        this.validityLabel.setVisible(false);
        this.keyboardFlowPane.setVisible(true);
        this.generateButton.setVisible(true);
        this.cancelButton.setText("Zru\u0161it");
    }

    private void enableDisplayMode(String code, LocalDateTime validity) {
        this.codeLabel.setText("K\u00f3d vytvo\u0159en: " + code);
        this.codeLabel.setVisible(true);
        this.validityLabel.setText("Platnost do: " + validity.format(DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm")));
        this.validityLabel.setVisible(true);
        this.generateButton.setVisible(false);
        this.keyboardFlowPane.setVisible(false);
        this.cancelButton.setText("Zav\u0159\u00edt");
    }

    private void generateButtonAction() {
        String phoneNumber = (((CountryPrefix)this.selectedCountryPrefix.getValue()).getPrefix() + this.textField.getText()).replace(" ", "").strip();
        DiscountCodeForClubResponse response = this.cashierController.activeConfig.getPartnerServerRestClient().requestCodeCreationForClub(phoneNumber);
        if (response != null) {
            try {
                String code = response.getDiscountCode();
                LocalDateTime date = LocalDateTime.parse(response.getValidUntil(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                this.enableDisplayMode(code, date);
                this.cashierController.printDiscountCode(code, date);
            }
            catch (Exception e) {
                ExceptionHandler.logException((Exception)e);
            }
        } else {
            throw new RuntimeException("Club discount code response is null");
        }
    }

    private void phoneNumber_keyboard_clicked(Event e) {
        String buttonId = ((GrayButton)e.getSource()).getId();
        String number = buttonId.split("_")[1];
        if (number.equals("x")) {
            if (!this.textField.getText().isEmpty()) {
                int toDelete = 1;
                if (this.phoneNumberSpacesList.contains((Object)(this.textField.getText().length() - 1))) {
                    toDelete = 2;
                }
                this.textField.setText(this.textField.getText().substring(0, this.textField.getText().length() - toDelete));
            }
        } else if (this.textField.getText().length() < ((CountryPrefix)this.selectedCountryPrefix.get()).getPhoneNumberPattern().length()) {
            this.textField.setText(this.textField.getText() + number);
            if (this.phoneNumberSpacesList.contains((Object)this.textField.getText().length())) {
                this.textField.setText(this.textField.getText() + " ");
            }
        }
    }

    private List<Integer> getListOfSpaces(String input) {
        return IntStream.range(0, input.length()).filter(i -> input.charAt(i) == " ".charAt(0)).boxed().collect(Collectors.toList());
    }

    public boolean validatePhoneNumber(String phoneNumber) {
        String blankNumber = phoneNumber.replaceAll("[0-9]", "X").strip();
        return blankNumber.equals(((CountryPrefix)this.selectedCountryPrefix.get()).getPhoneNumberPattern());
    }

    public void hide() {
        this.textField.setText("");
        this.enableCreationMode();
        this.prefixComboBox.getItems().stream().filter(item -> "+420".equals(item.getPrefix())).findFirst().ifPresent(arg_0 -> ((ComboBox)this.prefixComboBox).setValue(arg_0));
        super.hide();
    }
}

