/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.DTO.StockMovementLogItemDTO;
import cz.polreich.spagetka.models.StockItem;
import cz.polreich.spagetka.models.enums.STOCK_MOVEMENT_ACTION;
import cz.polreich.spagetka.service.StockItemService;
import cz.polreich.spagetka.utils.ApplicationContextUtils;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.time.LocalDateTime;

@Entity
@Table(name="StockMovements")
public class StockMovementLogItem {
    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    private String id;
    @ManyToOne
    @JoinColumn(name="stock_item_id")
    private StockItem stockItem;
    @Column
    @Enumerated(value=EnumType.STRING)
    private STOCK_MOVEMENT_ACTION stockMovementAction;
    @Column
    private Double quantity;
    @Column
    private LocalDateTime timestamp;

    public StockMovementLogItem(StockMovementLogItemDTO dto) {
        this.id = dto.getId();
        StockItemService stockItemService = (StockItemService)ApplicationContextUtils.getApplicationContext().getBean(StockItemService.class);
        this.stockItem = stockItemService.findById(dto.getStockItemId());
        this.stockMovementAction = dto.getStockMovementAction();
        this.quantity = dto.getQuantity();
        this.timestamp = LocalDateTime.parse(dto.getTimestamp());
    }

    public String getId() {
        return this.id;
    }

    public StockItem getStockItem() {
        return this.stockItem;
    }

    public STOCK_MOVEMENT_ACTION getStockMovementAction() {
        return this.stockMovementAction;
    }

    public Double getQuantity() {
        return this.quantity;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setStockItem(StockItem stockItem) {
        this.stockItem = stockItem;
    }

    public void setStockMovementAction(STOCK_MOVEMENT_ACTION stockMovementAction) {
        this.stockMovementAction = stockMovementAction;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public StockMovementLogItem() {
    }

    public StockMovementLogItem(String id, StockItem stockItem, STOCK_MOVEMENT_ACTION stockMovementAction, Double quantity, LocalDateTime timestamp) {
        this.id = id;
        this.stockItem = stockItem;
        this.stockMovementAction = stockMovementAction;
        this.quantity = quantity;
        this.timestamp = timestamp;
    }
}

