/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.DTO.ReceiptDTO;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.ReceiptItem;
import cz.polreich.spagetka.models.User;
import cz.polreich.spagetka.models.VatAmount;
import cz.polreich.spagetka.models.enums.PAYMENT_METHOD;
import cz.polreich.spagetka.service.UserService;
import cz.polreich.spagetka.utils.ApplicationContextUtils;
import cz.polreich.spagetka.utils.BigDecimalUtils;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.InvalidParameterException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.hibernate.annotations.UuidGenerator;

@Entity
@Table(name="Receipts")
public class Receipt {
    @Id
    @UuidGenerator(style=UuidGenerator.Style.TIME)
    private String id;
    @Column
    private String orderId;
    @Column(name="header", nullable=false)
    @ElementCollection(targetClass=String.class, fetch=FetchType.EAGER)
    @CollectionTable(name="receiptHeaders", joinColumns={@JoinColumn(name="receipt_id")})
    private List<String> header;
    @Column
    private LocalDateTime dateTime;
    @Column
    private String location;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="ItemsOfReceipts", joinColumns={@JoinColumn(name="receiptId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="itemId", referencedColumnName="id")})
    private List<ReceiptItem> receiptItems = new ArrayList();
    @Column(precision=10, scale=2)
    private BigDecimal totalAmount;
    @Column(precision=10, scale=2)
    private BigDecimal baseAmount;
    @Column(precision=10, scale=2)
    private BigDecimal vatAmount;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="VatAmountsOfReceipts", joinColumns={@JoinColumn(name="receiptId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="vatAmountId", referencedColumnName="id")})
    private List<VatAmount> vatAmounts;
    @Column
    private String footer;
    @Column(precision=10, scale=2)
    private BigDecimal discount;
    @Column
    @Enumerated(value=EnumType.STRING)
    private PAYMENT_METHOD paymentMethod = PAYMENT_METHOD.CASH;
    @Column(precision=10, scale=2)
    private BigDecimal rounding = new BigDecimal(0);
    @Column(precision=10, scale=2)
    private BigDecimal totalAmountAfterRounding;
    @ManyToOne
    @JoinColumn(name="user_created_id")
    private User userCreated;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Receipt(Order order, Integer userId) {
        BigDecimal discountBD = BigDecimal.valueOf(order.getDiscount()).setScale(2, RoundingMode.HALF_UP);
        BigDecimal orderItemsCountBD = BigDecimal.valueOf(order.getOrderItems().size()).setScale(2, RoundingMode.HALF_UP);
        this.orderId = order.getId();
        this.dateTime = LocalDateTime.now();
        this.location = "\u0160pagetka";
        this.discount = discountBD;
        ArrayList itemsList = new ArrayList();
        if (order.getDiscountPercentage() > 0.0) {
            percentage = BigDecimal.valueOf(order.getDiscountPercentage()).setScale(2, RoundingMode.HALF_UP);
            fixedPercentage = BigDecimalUtils.isGreaterThan((BigDecimal)percentage, (int)100) ? BigDecimal.valueOf(100L) : percentage;
            this.receiptItems = order.getOrderItems().stream().map(oi -> new ReceiptItem(oi, fixedPercentage)).toList();
        } else if (order.getDiscount() > 0.0) {
            percentage = discountBD.divide(BigDecimal.valueOf(order.getSubTotalPrice()), 6, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
            fixedPercentage = BigDecimalUtils.isGreaterThan((BigDecimal)percentage, (int)100) ? BigDecimal.valueOf(100L) : percentage;
            this.receiptItems = order.getOrderItems().stream().map(oi -> new ReceiptItem(oi, fixedPercentage)).toList();
        } else {
            this.receiptItems = order.getOrderItems().stream().map(oi -> new ReceiptItem(oi, BigDecimal.ZERO)).toList();
        }
        BigDecimal expectedPrice = BigDecimal.valueOf(order.getTotalPrice()).setScale(2, RoundingMode.HALF_UP);
        BigDecimal sumOfTotalAmounts = this.receiptItems.stream().map(ReceiptItem::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (!BigDecimalUtils.isEqualTo((BigDecimal)expectedPrice, (BigDecimal)sumOfTotalAmounts)) {
            System.out.println("[ERR] Difference between expected price and sum of prices: " + expectedPrice.subtract(sumOfTotalAmounts));
            BigDecimal difference = expectedPrice.subtract(sumOfTotalAmounts);
            ReceiptItem mostExpensiveItem = this.receiptItems.stream().max(Comparator.comparing(ReceiptItem::getTotalPrice)).orElse(null);
            if (mostExpensiveItem != null && BigDecimalUtils.isGreaterThan((BigDecimal)mostExpensiveItem.getTotalPrice(), (BigDecimal)difference)) {
                mostExpensiveItem.setTotalPrice(mostExpensiveItem.getTotalPrice().add(difference));
            }
        }
        this.recalculateFields();
        sumOfTotalAmounts = this.receiptItems.stream().map(ReceiptItem::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        double originalPrice = order.getSubTotalPrice();
        double newPrice = order.getTotalPrice();
        BigDecimal receiptTotal = this.totalAmount;
        double diff = originalPrice - newPrice;
        BigDecimal differnceReceipt = BigDecimal.valueOf(originalPrice).subtract(receiptTotal);
        if (diff != this.discount.doubleValue()) {
            System.out.println("[ERR] Difference between order and receipt: " + diff);
        }
        if (sumOfTotalAmounts.compareTo(receiptTotal) != 0) {
            System.out.println("[ERR] Difference between sum of prices and receipt total: " + sumOfTotalAmounts.subtract(receiptTotal));
        }
        if (differnceReceipt.compareTo(BigDecimal.valueOf(diff)) != 0) {
            System.out.println("[ERR] Difference between receipt and order: " + differnceReceipt.subtract(BigDecimal.valueOf(diff)));
        }
        if (differnceReceipt.compareTo(this.discount) != 0) {
            System.out.println("[ERR] Difference between receipt and discount: " + differnceReceipt.subtract(this.discount));
        }
        if (receiptTotal.compareTo(sumOfTotalAmounts) != 0) {
            System.out.println("[ERR] Difference between receipt and sum of prices: " + receiptTotal.subtract(sumOfTotalAmounts));
        }
        if (BigDecimal.valueOf(newPrice).compareTo(sumOfTotalAmounts) != 0) {
            System.out.println("[ERR] Difference between new price and sum of prices: " + BigDecimal.valueOf(newPrice).subtract(sumOfTotalAmounts));
        }
        this.paymentMethod = order.getPaymentMethod();
        if (userId != null) {
            UserService userService = (UserService)ApplicationContextUtils.getApplicationContext().getBean(UserService.class);
            if (!userService.existsById(userId.intValue())) throw new InvalidParameterException("User with ID " + userId + " not found.");
            this.userCreated = userService.findById(userId.intValue());
            return;
        } else {
            this.userCreated = null;
        }
    }

    public Receipt(ReceiptDTO dto) {
        this.id = dto.getId();
        this.orderId = dto.getOrderId();
        this.header = dto.getHeader();
        this.dateTime = LocalDateTime.parse(dto.getDateTime());
        this.location = dto.getLocation();
        this.receiptItems = dto.getReceiptItems().stream().map(ReceiptItem::new).toList();
        this.totalAmount = BigDecimal.valueOf(dto.getTotalAmount()).setScale(2, RoundingMode.HALF_UP);
        this.totalAmountAfterRounding = BigDecimal.valueOf(dto.getTotalAmountAfterRounding()).setScale(2, RoundingMode.HALF_UP);
        this.baseAmount = BigDecimal.valueOf(dto.getBaseAmount()).setScale(2, RoundingMode.HALF_UP);
        this.vatAmount = BigDecimal.valueOf(dto.getVatAmount()).setScale(2, RoundingMode.HALF_UP);
        this.vatAmounts = dto.getVatAmounts().stream().map(VatAmount::new).toList();
        this.footer = dto.getFooter();
        this.paymentMethod = dto.getPaymentMethod();
        UserService userService = (UserService)ApplicationContextUtils.getApplicationContext().getBean(UserService.class);
        if (!userService.existsById(dto.getUserCreatedId())) {
            throw new InvalidParameterException("User with ID " + dto.getUserCreatedId() + " not found.");
        }
        this.userCreated = userService.findById(dto.getUserCreatedId());
    }

    public void recalculateFields() {
        this.totalAmountAfterRounding = this.totalAmount = this.receiptItems.stream().map(ReceiptItem::getTotalPrice).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.baseAmount = this.receiptItems.stream().map(ReceiptItem::getBaseAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.vatAmount = this.receiptItems.stream().map(ReceiptItem::getVatAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<Double, VatAmount> vatLevels = new HashMap<Double, VatAmount>();
        for (ReceiptItem receiptItem : this.receiptItems) {
            if (receiptItem.getSubItems().isEmpty()) {
                if (vatLevels.containsKey(receiptItem.getVatPercent())) {
                    ((VatAmount)vatLevels.get(receiptItem.getVatPercent())).addBaseAmount(receiptItem.getBaseAmount());
                    ((VatAmount)vatLevels.get(receiptItem.getVatPercent())).addVatAmount(receiptItem.getVatAmount());
                    ((VatAmount)vatLevels.get(receiptItem.getVatPercent())).addTotalAmount(receiptItem.getTotalPrice());
                    continue;
                }
                VatAmount newVatAmount = new VatAmount();
                newVatAmount.setVatPercent(receiptItem.getVatPercent());
                newVatAmount.setBaseAmount(receiptItem.getBaseAmount());
                newVatAmount.setVatAmount(receiptItem.getVatAmount());
                newVatAmount.setTotalAmount(receiptItem.getTotalPrice());
                vatLevels.put(receiptItem.getVatPercent(), newVatAmount);
                continue;
            }
            receiptItem.getSubItems().forEach(subItem -> {
                if (vatLevels.containsKey(subItem.getVatPercent())) {
                    ((VatAmount)vatLevels.get(subItem.getVatPercent())).addBaseAmount(subItem.getBaseAmount());
                    ((VatAmount)vatLevels.get(subItem.getVatPercent())).addVatAmount(subItem.getVatAmount());
                    ((VatAmount)vatLevels.get(subItem.getVatPercent())).addTotalAmount(subItem.getTotalPrice());
                } else {
                    VatAmount newVatAmount = new VatAmount();
                    newVatAmount.setVatPercent(subItem.getVatPercent());
                    newVatAmount.setBaseAmount(subItem.getBaseAmount());
                    newVatAmount.setVatAmount(subItem.getVatAmount());
                    newVatAmount.setTotalAmount(subItem.getTotalPrice());
                    vatLevels.put(subItem.getVatPercent(), newVatAmount);
                }
            });
        }
        this.vatAmounts = new ArrayList(vatLevels.values());
        if (this.paymentMethod.equals((Object)PAYMENT_METHOD.CASH) || this.paymentMethod.equals((Object)PAYMENT_METHOD.CARD)) {
            this.totalAmountAfterRounding = this.totalAmount.setScale(2, RoundingMode.HALF_UP);
            this.rounding = this.totalAmountAfterRounding.subtract(this.totalAmount);
        }
    }

    public void addReceiptItem(ReceiptItem receiptItem) {
        this.receiptItems.add(receiptItem);
    }

    public String getId() {
        return this.id;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public List<String> getHeader() {
        return this.header;
    }

    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    public String getLocation() {
        return this.location;
    }

    public List<ReceiptItem> getReceiptItems() {
        return this.receiptItems;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public BigDecimal getBaseAmount() {
        return this.baseAmount;
    }

    public BigDecimal getVatAmount() {
        return this.vatAmount;
    }

    public List<VatAmount> getVatAmounts() {
        return this.vatAmounts;
    }

    public String getFooter() {
        return this.footer;
    }

    public BigDecimal getDiscount() {
        return this.discount;
    }

    public PAYMENT_METHOD getPaymentMethod() {
        return this.paymentMethod;
    }

    public BigDecimal getRounding() {
        return this.rounding;
    }

    public BigDecimal getTotalAmountAfterRounding() {
        return this.totalAmountAfterRounding;
    }

    public User getUserCreated() {
        return this.userCreated;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public void setHeader(List<String> header) {
        this.header = header;
    }

    public void setDateTime(LocalDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setReceiptItems(List<ReceiptItem> receiptItems) {
        this.receiptItems = receiptItems;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public void setBaseAmount(BigDecimal baseAmount) {
        this.baseAmount = baseAmount;
    }

    public void setVatAmount(BigDecimal vatAmount) {
        this.vatAmount = vatAmount;
    }

    public void setVatAmounts(List<VatAmount> vatAmounts) {
        this.vatAmounts = vatAmounts;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public void setPaymentMethod(PAYMENT_METHOD paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public void setRounding(BigDecimal rounding) {
        this.rounding = rounding;
    }

    public void setTotalAmountAfterRounding(BigDecimal totalAmountAfterRounding) {
        this.totalAmountAfterRounding = totalAmountAfterRounding;
    }

    public void setUserCreated(User userCreated) {
        this.userCreated = userCreated;
    }

    public Receipt() {
    }

    public Receipt(String id, String orderId, List<String> header, LocalDateTime dateTime, String location, List<ReceiptItem> receiptItems, BigDecimal totalAmount, BigDecimal baseAmount, BigDecimal vatAmount, List<VatAmount> vatAmounts, String footer, BigDecimal discount, PAYMENT_METHOD paymentMethod, BigDecimal rounding, BigDecimal totalAmountAfterRounding, User userCreated) {
        this.id = id;
        this.orderId = orderId;
        this.header = header;
        this.dateTime = dateTime;
        this.location = location;
        this.receiptItems = receiptItems;
        this.totalAmount = totalAmount;
        this.baseAmount = baseAmount;
        this.vatAmount = vatAmount;
        this.vatAmounts = vatAmounts;
        this.footer = footer;
        this.discount = discount;
        this.paymentMethod = paymentMethod;
        this.rounding = rounding;
        this.totalAmountAfterRounding = totalAmountAfterRounding;
        this.userCreated = userCreated;
    }
}

