/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.orderConfirmationController;

import cz.polreich.spagetka.controllers.CustomerBaseController;
import cz.polreich.spagetka.controllers.CustomerOrderConfirmationController;
import cz.polreich.spagetka.models.gui.buttons.CancelButton;
import cz.polreich.spagetka.models.gui.buttons.ConfirmButton;
import cz.polreich.spagetka.models.gui.buttons.GrayButton;
import cz.polreich.spagetka.utils.FontUtils;
import cz.polreich.spagetka.utils.LayoutUtils;
import cz.polreich.spagetka.utils.ResourceHelper;
import cz.polreich.spagetka.utils.VK_TYPE;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.stage.Popup;
import javafx.stage.Screen;
import javafx.stage.Window;

public class PhoneConfirmationPopup
extends Popup {
    private CustomerOrderConfirmationController orderConfirmationController;
    private TextField textField;
    private Label messageLabel;
    private AnchorPane popupAnchor;
    private ConfirmButton enterButton;
    private FlowPane keyboardFlowPane;
    private CancelButton cancelButton;
    private BooleanProperty enterButtonDisableOverride = new SimpleBooleanProperty(false);
    private String expectedCode = "";
    private String enteredCode = "";

    public PhoneConfirmationPopup(CustomerOrderConfirmationController orderConfirmationController) {
        GrayButton button;
        List<String> letters1 = List.of("Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P");
        List<String> letters2 = List.of("A", "S", "D", "F", "G", "H", "J", "K", "L");
        List<String> letters3 = List.of("Z", "X", "C", "V", "B", "N", "M");
        List<String> numbers = List.of("1", "2", "3", "4", "5", "6", "7", "8", "9", "0");
        this.orderConfirmationController = orderConfirmationController;
        this.popupAnchor = new AnchorPane();
        Label label = new Label();
        label.setMaxWidth(800.0);
        orderConfirmationController.bindStringToLocale(label, "phoneConfirmation.label.title", orderConfirmationController.titleFont);
        AnchorPane.setTopAnchor((Node)label, (Double)30.0);
        AnchorPane.setLeftAnchor((Node)label, (Double)100.0);
        AnchorPane.setRightAnchor((Node)label, (Double)100.0);
        label.setAlignment(Pos.CENTER);
        label.setPadding(new Insets(20.0));
        FontUtils.setIdealFont((Label)label, (Font)orderConfirmationController.titleFont);
        this.textField = new TextField();
        this.textField.setFont(orderConfirmationController.normalFont);
        this.textField.setAlignment(Pos.CENTER);
        this.textField.setPromptText(orderConfirmationController.strings.getString("phoneConfirmation.prompt.enterCode"));
        this.textField.setFocusTraversable(false);
        this.textField.getProperties().put((Object)"vkType", (Object)VK_TYPE.TEXT.getCode());
        AnchorPane.setTopAnchor((Node)this.textField, (Double)250.0);
        AnchorPane.setLeftAnchor((Node)this.textField, (Double)100.0);
        AnchorPane.setRightAnchor((Node)this.textField, (Double)100.0);
        FlowPane numbersFlowPane = new FlowPane();
        numbersFlowPane.setOrientation(Orientation.HORIZONTAL);
        numbersFlowPane.setHgap(10.0);
        numbersFlowPane.setVgap(10.0);
        numbersFlowPane.setMinWidth(900.0);
        numbersFlowPane.setMaxWidth(900.0);
        numbersFlowPane.setAlignment(Pos.CENTER);
        FlowPane letters1FlowPane = new FlowPane();
        letters1FlowPane.setOrientation(Orientation.HORIZONTAL);
        letters1FlowPane.setHgap(10.0);
        letters1FlowPane.setVgap(10.0);
        letters1FlowPane.setMinWidth(900.0);
        letters1FlowPane.setMaxWidth(900.0);
        letters1FlowPane.setAlignment(Pos.CENTER);
        FlowPane letters2FlowPane = new FlowPane();
        letters2FlowPane.setOrientation(Orientation.HORIZONTAL);
        letters2FlowPane.setHgap(10.0);
        letters2FlowPane.setVgap(10.0);
        letters2FlowPane.setMinWidth(900.0);
        letters2FlowPane.setMaxWidth(900.0);
        letters2FlowPane.setAlignment(Pos.CENTER);
        FlowPane letters3FlowPane = new FlowPane();
        letters3FlowPane.setOrientation(Orientation.HORIZONTAL);
        letters3FlowPane.setHgap(10.0);
        letters3FlowPane.setVgap(10.0);
        letters3FlowPane.setMinWidth(900.0);
        letters3FlowPane.setMaxWidth(900.0);
        letters3FlowPane.setAlignment(Pos.CENTER);
        GrayButton removeButton = this.createKeyboardButton("*");
        removeButton.setGraphic((Node)ResourceHelper.getImageViewFromResourceName((String)"/resources/images/backspace_64.png"));
        removeButton.setMinWidth(210.0);
        removeButton.setMaxWidth(210.0);
        FlowPane removeFlowPane = new FlowPane();
        removeFlowPane.setOrientation(Orientation.HORIZONTAL);
        removeFlowPane.setHgap(10.0);
        removeFlowPane.setVgap(10.0);
        removeFlowPane.setMinWidth(900.0);
        removeFlowPane.setMaxWidth(900.0);
        removeFlowPane.setAlignment(Pos.CENTER);
        removeFlowPane.getChildren().add((Object)removeButton);
        this.keyboardFlowPane = new FlowPane();
        this.keyboardFlowPane.setOrientation(Orientation.VERTICAL);
        this.keyboardFlowPane.setVgap(10.0);
        this.keyboardFlowPane.setMinWidth(900.0);
        this.keyboardFlowPane.setMaxWidth(900.0);
        this.keyboardFlowPane.setAlignment(Pos.CENTER);
        AnchorPane.setLeftAnchor((Node)this.keyboardFlowPane, (Double)10.0);
        AnchorPane.setRightAnchor((Node)this.keyboardFlowPane, (Double)10.0);
        AnchorPane.setTopAnchor((Node)this.keyboardFlowPane, (Double)350.0);
        this.keyboardFlowPane.getChildren().addAll((Object[])new Node[]{numbersFlowPane, letters1FlowPane, letters2FlowPane, letters3FlowPane, removeFlowPane});
        this.cancelButton = new CancelButton();
        this.cancelButton.setMaxWidth(400.0);
        orderConfirmationController.bindStringToLocale((Button)this.cancelButton, "phoneConfirmation.button.cancel", orderConfirmationController.titleFont);
        this.cancelButton.setMinSize(160.0, 40.0);
        FontUtils.setIdealFont((Button)this.cancelButton, (Font)orderConfirmationController.titleFont);
        AnchorPane.setBottomAnchor((Node)this.cancelButton, (Double)40.0);
        AnchorPane.setLeftAnchor((Node)this.cancelButton, (Double)100.0);
        this.enterButton = new ConfirmButton();
        this.enterButton.setMaxWidth(400.0);
        orderConfirmationController.bindStringToLocale((Button)this.enterButton, "phoneConfirmation.button.confirm", orderConfirmationController.titleFont);
        this.enterButton.setMinSize(160.0, 40.0);
        this.enterButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.textField.getText().isEmpty() || this.enterButtonDisableOverride.get(), (Observable[])new Observable[]{this.textField.textProperty(), this.enterButtonDisableOverride}));
        FontUtils.setIdealFont((Button)this.enterButton, (Font)orderConfirmationController.titleFont);
        AnchorPane.setBottomAnchor((Node)this.enterButton, (Double)40.0);
        AnchorPane.setRightAnchor((Node)this.enterButton, (Double)100.0);
        ProgressIndicator progressIndicator = new ProgressIndicator();
        progressIndicator.setPrefWidth(100.0);
        progressIndicator.setPrefHeight(100.0);
        progressIndicator.setVisible(false);
        AnchorPane.setBottomAnchor((Node)progressIndicator, (Double)300.0);
        AnchorPane.setLeftAnchor((Node)progressIndicator, (Double)10.0);
        AnchorPane.setRightAnchor((Node)progressIndicator, (Double)10.0);
        this.messageLabel = new Label();
        this.messageLabel.setText("");
        this.messageLabel.setAlignment(Pos.CENTER);
        this.messageLabel.setTextAlignment(TextAlignment.CENTER);
        this.messageLabel.setStyle("-fx-text-fill: red;");
        this.messageLabel.setFont(orderConfirmationController.subtitleFont);
        this.messageLabel.setWrapText(true);
        AnchorPane.setBottomAnchor((Node)this.messageLabel, (Double)300.0);
        AnchorPane.setLeftAnchor((Node)this.messageLabel, (Double)10.0);
        AnchorPane.setRightAnchor((Node)this.messageLabel, (Double)10.0);
        this.enterButton.setOnMousePressed(mouseEvent -> {
            this.messageLabel.setText("");
            this.enteredCode = this.textField.getText().trim().toUpperCase();
            if (this.enteredCode.equals(this.expectedCode)) {
                this.hide();
                orderConfirmationController.getLoadDiscountCodePopup().loadPopup(true);
            } else {
                this.messageLabel.setText(orderConfirmationController.strings.getString("phoneConfirmation.message.invalidCode"));
            }
        });
        for (String letter : numbers) {
            button = this.createKeyboardButton(letter);
            numbersFlowPane.getChildren().add((Object)button);
        }
        for (String letter : letters1) {
            button = this.createKeyboardButton(letter);
            letters1FlowPane.getChildren().add((Object)button);
        }
        for (String letter : letters2) {
            button = this.createKeyboardButton(letter);
            letters2FlowPane.getChildren().add((Object)button);
        }
        for (String letter : letters3) {
            button = this.createKeyboardButton(letter);
            letters3FlowPane.getChildren().add((Object)button);
        }
        this.popupAnchor.setMinWidth(900.0);
        this.popupAnchor.setMaxWidth(900.0);
        this.popupAnchor.setMinHeight(1200.0);
        this.popupAnchor.setMaxHeight(1200.0);
        this.popupAnchor.getStyleClass().add((Object)"popup-main-pane");
        this.popupAnchor.setStyle("-fx-background-color: " + orderConfirmationController.popupBackgroundColor + ";");
        this.popupAnchor.getChildren().addAll((Object[])new Node[]{label, this.textField, this.keyboardFlowPane, this.messageLabel, progressIndicator, this.cancelButton, this.enterButton});
        this.getContent().add((Object)this.popupAnchor);
        this.cancelButton.setOnMouseClicked(mouseEvent -> this.hide());
    }

    private void disable() {
        this.keyboardFlowPane.setDisable(true);
        this.cancelButton.setDisable(true);
        this.enterButtonDisableOverride.set(true);
    }

    private void enable() {
        this.keyboardFlowPane.setDisable(false);
        this.cancelButton.setDisable(false);
        this.enterButtonDisableOverride.set(false);
    }

    public void hide() {
        this.textField.setText("");
        this.messageLabel.setText("");
        this.orderConfirmationController.activeConfig.getOpenedPopups().remove(this);
        super.hide();
    }

    private GrayButton createKeyboardButton(String label) {
        GrayButton button = new GrayButton();
        button.setId("keyboard_" + label);
        button.setFont(this.orderConfirmationController.subtitleFont);
        button.setAlignment(Pos.CENTER);
        button.setContentDisplay(ContentDisplay.CENTER);
        button.setFocusTraversable(false);
        button.setOnMouseClicked(arg_0 -> this.keyboardClicked(arg_0));
        button.setOnTouchPressed(arg_0 -> this.keyboardClicked(arg_0));
        if (!label.equals("*")) {
            button.setText(label);
        }
        button.setMinWidth(70.0);
        button.setMinHeight(70.0);
        button.setMaxWidth(70.0);
        button.setMaxHeight(70.0);
        button.setPadding(LayoutUtils.getInsets((double)10.0, (double)30.0, (double)10.0, (double)30.0));
        GridPane.setMargin((Node)button, (Insets)LayoutUtils.getInsets((double)0.0, (double)0.0, (double)0.0, (double)33.0));
        return button;
    }

    private void keyboardClicked(Event e) {
        String buttonId = ((GrayButton)e.getSource()).getId();
        String number = buttonId.split("_")[1];
        if (number.equals("*")) {
            if (!this.textField.getText().isEmpty()) {
                int toDelete = 1;
                this.textField.setText(this.textField.getText().substring(0, this.textField.getText().length() - toDelete));
            }
        } else {
            this.textField.setText(this.textField.getText() + number);
        }
        this.messageLabel.setText("");
    }

    public void loadPopup(String code) {
        this.expectedCode = code;
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            CustomerBaseController.lastPressTime = System.currentTimeMillis();
        });
        this.addEventFilter(TouchEvent.TOUCH_PRESSED, touchEvent -> {
            CustomerBaseController.lastPressTime = System.currentTimeMillis();
        });
        this.orderConfirmationController.activeConfig.getOpenedPopups().add(this);
        this.show((Window)this.orderConfirmationController.stage);
        Platform.runLater(() -> this.recenterPopup());
    }

    private void recenterPopup() {
        Rectangle2D screenBounds = Screen.getPrimary().getBounds();
        double popupWidth = this.getWidth();
        double popupHeight = this.getHeight();
        double centerX = (screenBounds.getWidth() - popupWidth) / 2.0;
        double centerY = (screenBounds.getHeight() - popupHeight) / 2.0;
        this.setX(centerX);
        this.setY(centerY);
    }
}

