/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.orderConfirmationController;

import cz.polreich.spagetka.DTO.discountCodes.DiscountCodeVerifyResponse;
import cz.polreich.spagetka.controllers.CustomerBaseController;
import cz.polreich.spagetka.controllers.CustomerOrderConfirmationController;
import cz.polreich.spagetka.controllers.popup.orderConfirmationController.LoadDiscountCodePopup;
import cz.polreich.spagetka.models.DiscountCode;
import cz.polreich.spagetka.models.enums.DISCOUNT_CODE_TYPE;
import cz.polreich.spagetka.models.gui.buttons.CancelButton;
import cz.polreich.spagetka.models.gui.buttons.ConfirmButton;
import cz.polreich.spagetka.models.gui.buttons.GrayButton;
import cz.polreich.spagetka.utils.FontUtils;
import cz.polreich.spagetka.utils.FormatUtils;
import cz.polreich.spagetka.utils.ImageUtils;
import cz.polreich.spagetka.utils.LayoutUtils;
import cz.polreich.spagetka.utils.RandomGenerator;
import cz.polreich.spagetka.utils.ResourceHelper;
import java.io.InputStream;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.stage.Popup;
import javafx.stage.Screen;
import javafx.stage.Window;

public class LoadDiscountCodePopup
extends Popup {
    private CustomerOrderConfirmationController orderConfirmationController;
    private TextField textField;
    private Label messageLabel;
    private AnchorPane popupAnchor;
    private ConfirmButton enterButton;
    private FlowPane keyboardFlowPane;
    private CancelButton cancelButton;
    private FlowPane mainButtonsFlowPane = new FlowPane();
    private FlowPane codesFlowPane = new FlowPane();
    private FlowPane pagingFlowPane = new FlowPane();
    private GrayButton previousPageButton = new GrayButton();
    private GrayButton nextPageButton = new GrayButton();
    private Label pagingLabel = new Label();
    private double popupWidth;
    private double popupHeight;
    private BooleanProperty paging = new SimpleBooleanProperty(false);
    private IntegerProperty currentPage = new SimpleIntegerProperty(0);
    private IntegerProperty pages = new SimpleIntegerProperty(0);
    private Label label;
    private Label label2;

    public LoadDiscountCodePopup(CustomerOrderConfirmationController orderConfirmationController) {
        this.orderConfirmationController = orderConfirmationController;
        this.popupWidth = 900.0;
        this.popupHeight = 1000.0;
        this.popupAnchor = new AnchorPane();
        this.label = new Label();
        this.label.setMaxWidth(800.0);
        orderConfirmationController.bindStringToLocale(this.label, "discountCode.label.codeTypeLabel", orderConfirmationController.titleFont);
        LayoutUtils.setAnchors((Node)this.label, (Integer)10, (Integer)10, null, (Integer)10);
        this.label.setAlignment(Pos.CENTER);
        this.label.setPadding(new Insets(20.0));
        FontUtils.setIdealFont((Label)this.label, (Font)orderConfirmationController.titleFont);
        this.label2 = new Label();
        this.label2.setMaxWidth(800.0);
        orderConfirmationController.bindStringToLocale(this.label2, "discountCode.label.chooseCodeLabel", orderConfirmationController.titleFont);
        LayoutUtils.setAnchors((Node)this.label2, (Integer)10, (Integer)10, null, (Integer)10);
        this.label2.setAlignment(Pos.CENTER);
        this.label2.setPadding(new Insets(20.0));
        FontUtils.setIdealFont((Label)this.label2, (Font)orderConfirmationController.titleFont);
        this.label2.setVisible(false);
        this.mainButtonsFlowPane.getStyleClass().add((Object)"popup-main-pane");
        this.mainButtonsFlowPane.setPadding(new Insets(20.0));
        this.mainButtonsFlowPane.setAlignment(Pos.CENTER);
        this.mainButtonsFlowPane.setVgap(20.0);
        this.mainButtonsFlowPane.setHgap(20.0);
        LayoutUtils.setAnchors((Node)this.mainButtonsFlowPane, (Integer)200, (Integer)0, (Integer)200, (Integer)0);
        this.codesFlowPane.getStyleClass().add((Object)"popup-main-pane");
        this.codesFlowPane.setMinWidth(this.popupWidth);
        this.codesFlowPane.setMinHeight(this.popupHeight - 100.0);
        this.codesFlowPane.setMaxWidth(this.popupWidth);
        this.codesFlowPane.setMaxHeight(this.popupHeight - 100.0);
        this.codesFlowPane.setPadding(LayoutUtils.getInsets((double)0.0, (double)20.0, (double)0.0, (double)20.0));
        this.codesFlowPane.setVisible(false);
        this.codesFlowPane.setAlignment(Pos.CENTER);
        this.codesFlowPane.setVgap(20.0);
        this.codesFlowPane.setHgap(20.0);
        AnchorPane.setTopAnchor((Node)this.codesFlowPane, (Double)100.0);
        AnchorPane.setBottomAnchor((Node)this.codesFlowPane, (Double)250.0);
        this.pagingFlowPane.getStyleClass().add((Object)"popup-main-pane");
        this.pagingFlowPane.setMinWidth(this.popupWidth);
        this.pagingFlowPane.setMinHeight(100.0);
        this.pagingFlowPane.setMaxWidth(this.popupWidth);
        this.pagingFlowPane.setMaxHeight(100.0);
        this.pagingFlowPane.setPadding(new Insets(20.0));
        this.pagingFlowPane.setVisible(false);
        this.pagingFlowPane.setAlignment(Pos.CENTER);
        this.pagingFlowPane.setVgap(20.0);
        this.pagingFlowPane.setHgap(20.0);
        AnchorPane.setBottomAnchor((Node)this.pagingFlowPane, (Double)140.0);
        this.previousPageButton.setText(orderConfirmationController.strings.getString("discountCode.button.prevPage"));
        this.previousPageButton.setFont(orderConfirmationController.titleFont);
        this.previousPageButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.currentPage.get() < 1, (Observable[])new Observable[]{this.currentPage, this.pages}));
        this.nextPageButton.setText(orderConfirmationController.strings.getString("discountCode.button.nextPage"));
        this.nextPageButton.setFont(orderConfirmationController.titleFont);
        this.nextPageButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.currentPage.get() >= this.pages.get() - 1, (Observable[])new Observable[]{this.currentPage, this.pages}));
        this.pagingLabel.setVisible(false);
        this.pagingLabel.setFont(orderConfirmationController.subtitleFont);
        this.pagingLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> this.currentPage.get() + 1 + " / " + this.pages.get(), (Observable[])new Observable[]{this.currentPage, this.pages}));
        this.pagingLabel.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.pagingFlowPane.isVisible(), (Observable[])new Observable[]{this.pagingFlowPane.visibleProperty()}));
        this.pagingFlowPane.getChildren().addAll((Object[])new Node[]{this.previousPageButton, this.pagingLabel, this.nextPageButton});
        VBox loadTile = this.createFirstLevelTile(TILE_BUTTON_TYPE.LOAD, 300.0, 300.0);
        VBox manualTile = this.createFirstLevelTile(TILE_BUTTON_TYPE.MANUAL, 300.0, 300.0);
        this.mainButtonsFlowPane.getChildren().addAll((Object[])new Node[]{loadTile, manualTile});
        this.cancelButton = new CancelButton();
        this.cancelButton.setPrefHeight(100.0);
        this.cancelButton.setPrefWidth(250.0);
        orderConfirmationController.bindStringToLocale((Button)this.cancelButton, "phoneConfirmation.button.cancel", orderConfirmationController.titleFont);
        this.cancelButton.setOnMouseClicked(mouseEvent -> this.hide());
        LayoutUtils.setAnchors((Node)this.cancelButton, null, (Integer)100, (Integer)20, (Integer)100);
        this.messageLabel = new Label();
        this.messageLabel.setVisible(false);
        this.messageLabel.setAlignment(Pos.CENTER);
        this.messageLabel.setTextAlignment(TextAlignment.CENTER);
        this.messageLabel.setStyle("-fx-text-fill: red;");
        this.messageLabel.setFont(orderConfirmationController.subtitleFont);
        this.messageLabel.setMaxWidth(800.0);
        this.messageLabel.setWrapText(true);
        this.popupAnchor.setMinWidth(this.popupWidth);
        this.popupAnchor.setMaxWidth(this.popupWidth);
        this.popupAnchor.setMinHeight(this.popupHeight);
        this.popupAnchor.setMaxHeight(this.popupHeight);
        this.popupAnchor.getStyleClass().add((Object)"popup-main-pane");
        this.popupAnchor.setStyle("-fx-background-color: " + orderConfirmationController.popupBackgroundColor + ";");
        this.popupAnchor.getChildren().addAll((Object[])new Node[]{this.label, this.label2, this.mainButtonsFlowPane, this.codesFlowPane, this.pagingFlowPane, this.cancelButton});
        this.getContent().add((Object)this.popupAnchor);
    }

    private VBox createFirstLevelTile(TILE_BUTTON_TYPE type, double tileMinWidth, double tileMinHeight) {
        double tileWidth = tileMinWidth;
        double tileHeight = tileMinHeight;
        int tileCornerRadius = 50;
        int borderWidth = 1;
        double internalTileWidth = tileWidth - (double)(2 * borderWidth);
        double internalTileHeight = tileHeight - (double)(2 * borderWidth);
        double imageHeight = internalTileHeight * 0.7;
        double imageWidth = internalTileWidth * 1.0;
        double nameLabelTopAnchor = imageHeight + 5.0;
        double buttonWidth = tileWidth / 3.0;
        VBox vBox = new VBox(5.0);
        vBox.setMinSize(tileWidth, tileHeight);
        vBox.setMaxSize(tileWidth, tileHeight);
        vBox.setStyle("-fx-border-color:  lightgray;\n  -fx-border-width: " + borderWidth + "px;\n  -fx-border-style: solid;\n  -fx-border-radius: " + tileCornerRadius + "px;\n  -fx-background-color: white;\n  -fx-background-radius: " + tileCornerRadius + "px;\n  -fx-effect: dropshadow( gaussian , rgba(0,0,0,0.75) , 4,0,0,2 );");
        AnchorPane anchorPane = new AnchorPane();
        anchorPane.setMaxSize(internalTileWidth, internalTileHeight);
        anchorPane.setMinSize(internalTileWidth, internalTileHeight);
        String filePath = "";
        if (type == TILE_BUTTON_TYPE.LOAD) {
            filePath = "/resources/images/downloadCodes_1024.png";
        } else if (type == TILE_BUTTON_TYPE.MANUAL) {
            filePath = "/resources/images/codeManually_1024.png";
        }
        InputStream is = ResourceHelper.getImageAsStream((String)filePath);
        Image fullImage = new Image(is);
        ImageView imageView = ImageUtils.getCroppedImageView((Image)fullImage, (double)imageWidth, (double)imageHeight);
        imageView.setPreserveRatio(true);
        imageView.setFitWidth(imageWidth);
        imageView.setFitHeight(imageHeight);
        imageView.setClip((Node)ImageUtils.round((ImageView)imageView, (double)tileCornerRadius, (double)tileCornerRadius, (double)0.0, (double)0.0));
        StackPane stackPane = new StackPane();
        stackPane.setAlignment(Pos.CENTER);
        AnchorPane.setTopAnchor((Node)stackPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)stackPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)stackPane, (Double)0.0);
        stackPane.getChildren().add((Object)imageView);
        String labelText = "";
        if (type == TILE_BUTTON_TYPE.LOAD) {
            labelText = this.orderConfirmationController.strings.getString("discountCode.label.loadFromAccount");
        } else if (type == TILE_BUTTON_TYPE.MANUAL) {
            labelText = this.orderConfirmationController.strings.getString("discountCode.label.enterManually");
        }
        Label nameLabel = new Label(labelText);
        nameLabel.setFont(this.orderConfirmationController.productTitleFont);
        nameLabel.setWrapText(true);
        nameLabel.setAlignment(Pos.CENTER);
        nameLabel.setTextAlignment(TextAlignment.CENTER);
        AnchorPane.setTopAnchor((Node)nameLabel, (Double)nameLabelTopAnchor);
        AnchorPane.setBottomAnchor((Node)nameLabel, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)nameLabel, (Double)2.0);
        AnchorPane.setRightAnchor((Node)nameLabel, (Double)2.0);
        anchorPane.getChildren().addAll((Object[])new Node[]{stackPane, nameLabel});
        vBox.getChildren().add((Object)anchorPane);
        vBox.setAlignment(Pos.CENTER);
        if (type == TILE_BUTTON_TYPE.LOAD) {
            vBox.setOnMouseClicked(mouseEvent -> this.loadButtonAction());
        } else if (type == TILE_BUTTON_TYPE.MANUAL) {
            vBox.setOnMouseClicked(mouseEvent -> this.manualButtonAction());
        }
        return vBox;
    }

    private void loadButtonAction() {
        if (!this.orderConfirmationController.activeConfig.getCurrentOrder().getCustomerPhoneNumber().trim().isEmpty()) {
            String code = RandomGenerator.generateRandomString((int)6, (boolean)true);
            String message = MessageFormat.format(this.orderConfirmationController.strings.getString("phoneConfirmation.smsMessage.yourCodeIs"), code);
            this.orderConfirmationController.activeConfig.getPartnerServerRestClient().sendSmsMessage(this.orderConfirmationController.activeConfig.getCurrentOrder().getCustomerPhoneNumber().trim(), message);
            this.hide();
            this.orderConfirmationController.getPhoneConfirmationPopup().loadPopup(code);
        } else {
            this.hide();
            this.orderConfirmationController.getCustomerLoginPopup().loadPopup(false, true);
        }
    }

    private void manualButtonAction() {
        this.hide();
        this.orderConfirmationController.getEnterDiscountCodePopup().loadPopup();
    }

    private void goToCodesList() {
        this.label.setVisible(false);
        this.label2.setVisible(true);
        int codesPerPage = 9;
        this.codesFlowPane.getChildren().clear();
        this.codesFlowPane.getChildren().add((Object)this.messageLabel);
        List<DiscountCode> customerCodes = this.orderConfirmationController.getDiscountCodesForCustomer().stream().sorted(Comparator.comparing(DiscountCode::getValidUntil)).toList();
        if (!customerCodes.isEmpty()) {
            this.paging.set(customerCodes.size() > codesPerPage);
            this.pages.set((int)Math.ceil((double)customerCodes.size() / (double)codesPerPage));
            this.setCodesPage(customerCodes, codesPerPage);
            if (this.paging.get()) {
                this.currentPage.set(0);
                this.pagingFlowPane.setVisible(true);
            }
            this.nextPageButton.setOnMouseClicked(mouseEvent -> {
                this.currentPage.set(this.currentPage.get() + 1);
                this.setCodesPage(customerCodes, codesPerPage);
            });
            this.previousPageButton.setOnMouseClicked(mouseEvent -> {
                this.currentPage.set(this.currentPage.get() - 1);
                this.setCodesPage(customerCodes, codesPerPage);
            });
        } else {
            this.messageLabel.setText("Nenalezen \u017e\u00e1dn\u00fd platn\u00fd slevov\u00fd k\u00f3d k tomuto z\u00e1kaznick\u00e9mu \u00fa\u010dtu");
            this.messageLabel.setVisible(true);
        }
        this.mainButtonsFlowPane.setVisible(false);
        this.codesFlowPane.setVisible(true);
    }

    private void setCodesPage(List<DiscountCode> customerCodes, int codesPerPage) {
        this.codesFlowPane.getChildren().clear();
        for (int i = this.currentPage.get() * codesPerPage; i < codesPerPage * (this.currentPage.get() + 1) && i < customerCodes.size(); ++i) {
            DiscountCode discountCode = customerCodes.get(i);
            VBox codeTile = this.createDiscountCodeTile(discountCode);
            this.codesFlowPane.getChildren().add((Object)codeTile);
        }
    }

    private VBox createDiscountCodeTile(DiscountCode discountCode) {
        VBox vbox = new VBox(5.0);
        vbox.setMinHeight(200.0);
        vbox.setMinWidth(250.0);
        vbox.setMaxHeight(200.0);
        vbox.setMaxWidth(280.0);
        vbox.setStyle("-fx-border-color:  lightgray;\n-fx-border-width: 1px;\n-fx-border-style: solid;\n-fx-border-radius: 10px;\n-fx-background-color: white;\n-fx-background-radius: 10px;\n-fx-effect: dropshadow( gaussian , rgba(0,0,0,0.75) , 4,0,0,2 );");
        String codeValue = String.valueOf((int)discountCode.getAmount());
        DISCOUNT_CODE_TYPE codeType = discountCode.getCodeType();
        Label valueLabel = new Label(codeValue);
        Label typeLabel = new Label();
        ConfirmButton useButton = new ConfirmButton();
        useButton.setMaxWidth(200.0);
        this.orderConfirmationController.bindStringToLocale((Button)useButton, "discountCode.button.useCode", this.orderConfirmationController.subtitleFont);
        useButton.setOnMouseClicked(mouseEvent -> {
            DiscountCodeVerifyResponse verifyResponse = this.orderConfirmationController.activeConfig.getPartnerServerRestClient().verifyDiscountCodeValidity(discountCode.getDiscountCode(), this.orderConfirmationController.activeConfig.getCurrentOrder().getCustomerPhoneNumber().trim());
            boolean exists = verifyResponse.isValid();
            if (exists) {
                if (verifyResponse.getType().isComplimentary()) {
                    Platform.runLater(() -> {
                        String message = this.orderConfirmationController.strings.getString("discountCode.message.complimentary");
                        this.messageLabel.setText(message);
                        this.messageLabel.setVisible(true);
                    });
                } else {
                    Platform.runLater(() -> {
                        this.orderConfirmationController.useDiscount(verifyResponse, discountCode.getDiscountCode());
                        this.hide();
                    });
                }
            } else {
                String reason = verifyResponse.getCommentary();
                String[] reasonSplit = reason.split("-");
                Platform.runLater(() -> {
                    String message = this.orderConfirmationController.strings.getString("discountCode.message.default");
                    if (reasonSplit.length > 0) {
                        String reasonCode = reasonSplit[0].trim();
                        message = this.orderConfirmationController.strings.getString("discountCode.message." + reasonCode);
                    }
                    this.messageLabel.setText(message);
                    this.messageLabel.setVisible(true);
                });
            }
            this.hide();
        });
        if (codeType.equals((Object)DISCOUNT_CODE_TYPE.MONETARY)) {
            valueLabel.setText(valueLabel.getText() + " " + this.orderConfirmationController.activeConfig.getKioskInfo().getCurrency().getSymbol(this.orderConfirmationController.activeConfig.getSelectedLocale()));
        } else if (codeType.equals((Object)DISCOUNT_CODE_TYPE.PERCENTAGE)) {
            valueLabel.setText(valueLabel.getText() + " %");
        }
        valueLabel.setMaxWidth(280.0);
        valueLabel.setAlignment(Pos.CENTER);
        FontUtils.setIdealFont((Label)valueLabel, (Font)this.orderConfirmationController.titleFont);
        Label validityLabel = new Label(MessageFormat.format(this.orderConfirmationController.strings.getString("discountCode.label.validity"), FormatUtils.formatDate((LocalDateTime)discountCode.getValidUntil())));
        validityLabel.setMaxWidth(240.0);
        validityLabel.setAlignment(Pos.CENTER);
        FontUtils.setIdealFont((Label)validityLabel, (Font)this.orderConfirmationController.productTitleFont);
        vbox.getChildren().addAll((Object[])new Node[]{valueLabel, validityLabel, useButton});
        vbox.setAlignment(Pos.CENTER);
        return vbox;
    }

    public void loadPopup() {
        this.loadPopup(false);
    }

    public void loadPopup(boolean goToLoadDirectly) {
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            CustomerBaseController.lastPressTime = System.currentTimeMillis();
        });
        this.addEventFilter(TouchEvent.TOUCH_PRESSED, touchEvent -> {
            CustomerBaseController.lastPressTime = System.currentTimeMillis();
        });
        this.orderConfirmationController.activeConfig.getOpenedPopups().add(this);
        this.show((Window)this.orderConfirmationController.stage);
        Platform.runLater(() -> this.recenterPopup());
        if (goToLoadDirectly) {
            this.goToCodesList();
        } else {
            Platform.runLater(() -> {
                boolean partnerWebConnectionAvailable = this.orderConfirmationController.getInternetConnectivityService().checkPartnerWebReachable();
                ((Node)this.mainButtonsFlowPane.getChildren().get(0)).setDisable(!partnerWebConnectionAvailable);
            });
            this.label.setVisible(true);
            this.label2.setVisible(false);
            this.pagingFlowPane.setVisible(false);
            this.messageLabel.setVisible(false);
            this.mainButtonsFlowPane.setVisible(true);
            this.codesFlowPane.setVisible(false);
        }
    }

    private void recenterPopup() {
        Rectangle2D screenBounds = Screen.getPrimary().getBounds();
        double popupWidth = this.getWidth();
        double popupHeight = this.getHeight();
        double centerX = (screenBounds.getWidth() - popupWidth) / 2.0;
        double centerY = (screenBounds.getHeight() - popupHeight) / 2.0;
        this.setX(centerX);
        this.setY(centerY);
    }

    public void hide() {
        this.orderConfirmationController.activeConfig.getOpenedPopups().remove(this);
        super.hide();
    }
}

