/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.cashierController;

import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.models.MenuOption;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.ProductGroupsPrice;
import cz.polreich.spagetka.models.Receipt;
import cz.polreich.spagetka.models.ReceiptItem;
import cz.polreich.spagetka.models.enums.COMPUTER;
import cz.polreich.spagetka.models.enums.COMPUTER_MANAGEMENT_ACTION;
import cz.polreich.spagetka.utils.BigDecimalUtils;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.LayoutUtils;
import cz.polreich.spagetka.utils.ObjectFlattener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.TilePane;
import javafx.stage.Popup;
import javafx.stage.Window;

/*
 * Exception performing whole class analysis ignored.
 */
public class KioskManagementPopup
extends Popup {
    private CashierController cashierController;
    private static final String FILE_PATH = "migration_pecin_4.txt";
    private static final String DIVIDER = "----- Divider -----";
    private static BufferedWriter writer;

    public KioskManagementPopup(CashierController cashierController) {
        this.cashierController = cashierController;
        int popupWidth = 650;
        int popupHeight = 650;
        AnchorPane popupAnchor = new AnchorPane();
        popupAnchor.getStyleClass().add((Object)"logout_anchor_pane");
        Label labelTitle = new Label();
        labelTitle.setText(cashierController.strings.getString("kioskManagement"));
        AnchorPane.setTopAnchor((Node)labelTitle, (Double)30.0);
        AnchorPane.setLeftAnchor((Node)labelTitle, (Double)100.0);
        AnchorPane.setRightAnchor((Node)labelTitle, (Double)100.0);
        labelTitle.setAlignment(Pos.CENTER);
        labelTitle.setPadding(new Insets(20.0));
        labelTitle.setStyle("-fx-font-size: 24px;");
        TilePane tilePane = new TilePane();
        AnchorPane.setTopAnchor((Node)tilePane, (Double)150.0);
        AnchorPane.setLeftAnchor((Node)tilePane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)tilePane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)tilePane, (Double)50.0);
        tilePane.setHgap(20.0);
        tilePane.setVgap(20.0);
        tilePane.setAlignment(Pos.TOP_CENTER);
        for (COMPUTER computer : COMPUTER.values()) {
            for (COMPUTER_MANAGEMENT_ACTION action : COMPUTER_MANAGEMENT_ACTION.values()) {
                String label = computer.toString() + " " + action.toString();
                Button button = this.createButton(label, computer, action);
                button.setStyle("-fx-font-size: 24px");
                button.setPadding(LayoutUtils.getInsets((double)15.0, (double)5.0, (double)15.0, (double)5.0));
                tilePane.getChildren().add((Object)button);
            }
        }
        Button closeButton = new Button();
        closeButton.setText(cashierController.strings.getString("close"));
        closeButton.setStyle("fx-font-size: 24px");
        closeButton.setPrefWidth(150.0);
        closeButton.setPrefHeight(50.0);
        double anchor = ((double)popupWidth - closeButton.getPrefWidth()) / 2.0;
        AnchorPane.setBottomAnchor((Node)closeButton, (Double)20.0);
        AnchorPane.setLeftAnchor((Node)closeButton, (Double)anchor);
        AnchorPane.setRightAnchor((Node)closeButton, (Double)anchor);
        closeButton.setOnMouseClicked(mouseEvent -> this.hide());
        closeButton.setOnTouchPressed(touchEvent -> this.hide());
        Button fixReceiptsButton = new Button();
        closeButton.setText("Fix Receipts");
        closeButton.setStyle("fx-font-size: 24px");
        closeButton.setPrefWidth(150.0);
        closeButton.setPrefHeight(50.0);
        AnchorPane.setBottomAnchor((Node)closeButton, (Double)20.0);
        AnchorPane.setLeftAnchor((Node)closeButton, (Double)10.0);
        closeButton.setOnMouseClicked(mouseEvent -> {
            try {
                this.fixReceipts();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    ExceptionHandler.logException((Exception)e);
                }
            }
        });
        popupAnchor.setMaxWidth((double)popupWidth);
        popupAnchor.setMinHeight((double)popupHeight);
        popupAnchor.getChildren().addAll((Object[])new Node[]{tilePane, closeButton, fixReceiptsButton});
        this.getContent().addAll((Object[])new Node[]{popupAnchor});
    }

    private void checkFile() {
        try {
            File file = new File("migration_pecin_4.txt");
            boolean fileExists = file.exists();
            System.out.println("Using migration file: " + file.getAbsolutePath());
            writer = new BufferedWriter(new FileWriter(file, true));
            if (!fileExists) {
                file.createNewFile();
            } else {
                KioskManagementPopup.insertDivider();
            }
        }
        catch (IOException e) {
            ExceptionHandler.logException((Exception)e);
        }
    }

    private static void writeLine(String line) throws IOException {
        writer.write(line);
        writer.newLine();
    }

    private static void insertDivider() throws IOException {
        writer.newLine();
        writer.write("----- Divider -----");
        writer.newLine();
    }

    private void createMissingOrderItems() {
        List allReceipts = this.cashierController.receiptService.findAllIds();
        for (String receiptID : allReceipts) {
            List orderItems;
            Order order;
            Receipt receipt = null;
            try {
                receipt = this.cashierController.receiptService.findById(receiptID);
            }
            catch (Exception e) {
                this.logMigrationException(e);
                continue;
            }
            if (receipt == null) continue;
            if (BigDecimalUtils.isNegative((BigDecimal)receipt.getTotalAmount())) {
                // empty if block
            }
            if (this.cashierController.receiptService.findByOrderId(receipt.getOrderId()).size() > 1 || receipt.getOrderId() == null || (order = this.cashierController.orderService.findById(receipt.getOrderId())) == null || (orderItems = order.getOrderItems()) == null || orderItems.isEmpty()) continue;
            for (OrderItem orderItem : orderItems) {
                try {
                    String mainProductId;
                    double remainingPrice;
                    if (!orderItem.isMenu()) continue;
                    if (orderItem.getMenuOption() == null) {
                        remainingPrice = orderItem.getFinalPrice() - orderItem.getSubItems().stream().mapToDouble(OrderItem::getFinalPrice).sum();
                        mainProductId = orderItem.getMainProduct().getId();
                    } else {
                        MenuOption menuOption = orderItem.getMenuOption();
                        remainingPrice = menuOption.getPrice() - menuOption.getAdditionalProductsPrices().stream().mapToDouble(ProductGroupsPrice::getPrice).sum();
                        mainProductId = menuOption.getMainProduct().getId();
                    }
                    ProductGroupsPrice tempPriceGroup = new ProductGroupsPrice();
                    tempPriceGroup.setPrice(Double.valueOf(remainingPrice));
                    orderItem.addSubItem(new OrderItem(this.cashierController.productService.findById(mainProductId), tempPriceGroup));
                    this.cashierController.orderService.update(order);
                }
                catch (Exception e) {
                    this.logMigrationException(e);
                }
            }
        }
    }

    private void fixReceipts() throws IOException {
        this.checkFile();
        List allReceipts = this.cashierController.receiptService.findAllIds();
        for (String receiptID : allReceipts) {
            boolean isReturnReceipt = false;
            KioskManagementPopup.insertDivider();
            KioskManagementPopup.writeLine((String)("Trying to obtain receipt with ID: " + receiptID));
            Receipt receipt = null;
            try {
                receipt = this.cashierController.receiptService.findById(receiptID);
            }
            catch (Exception e) {
                this.logMigrationException(e);
                continue;
            }
            KioskManagementPopup.writeLine((String)"Original: ");
            KioskManagementPopup.writeLine((String)ObjectFlattener.flattenObjectToString((Object)receipt));
            if (receipt != null) {
                if (BigDecimalUtils.isNegative((BigDecimal)receipt.getTotalAmount())) {
                    KioskManagementPopup.writeLine((String)("[WARN] Found return receipt with ID: " + receiptID + "."));
                }
                if (this.cashierController.receiptService.findByOrderId(receipt.getOrderId()).size() > 1) {
                    KioskManagementPopup.writeLine((String)("[SKIP] Found multiple receipts with Order ID: " + receipt.getOrderId() + " | Receipt ID: " + receiptID + ". Skipping."));
                    continue;
                }
                int originalReceiptItemsCount = receipt.getReceiptItems().size();
                if (receipt.getOrderId() != null) {
                    Order order = this.cashierController.orderService.findById(receipt.getOrderId());
                    if (order != null) {
                        List orderItems = order.getOrderItems();
                        if (orderItems != null) {
                            if (!orderItems.isEmpty()) {
                                try {
                                    receipt.getReceiptItems().clear();
                                    for (OrderItem orderItem : orderItems) {
                                        ReceiptItem receiptItem;
                                        BigDecimal discountBD = BigDecimal.valueOf(order.getDiscount()).setScale(2, RoundingMode.HALF_UP);
                                        BigDecimal orderItemsCountBD = BigDecimal.valueOf(order.getOrderItems().size()).setScale(2, RoundingMode.HALF_UP);
                                        if (order.getDiscountPercentage() > 0.0) {
                                            percentage = BigDecimal.valueOf(order.getDiscountPercentage()).setScale(2, RoundingMode.HALF_UP);
                                            fixedPercentage = BigDecimalUtils.isGreaterThan((BigDecimal)percentage, (int)100) ? BigDecimal.valueOf(100L) : percentage;
                                            receiptItem = new ReceiptItem(orderItem, fixedPercentage);
                                        } else if (order.getDiscount() > 0.0) {
                                            percentage = discountBD.divide(BigDecimal.valueOf(order.getSubTotalPrice()), 6, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
                                            fixedPercentage = BigDecimalUtils.isGreaterThan((BigDecimal)percentage, (int)100) ? BigDecimal.valueOf(100L) : percentage;
                                            receiptItem = new ReceiptItem(orderItem, fixedPercentage);
                                        } else {
                                            receiptItem = new ReceiptItem(orderItem, BigDecimal.ZERO);
                                        }
                                        receipt.getReceiptItems().add(receiptItem);
                                        receipt.recalculateFields();
                                    }
                                    if (receipt.getReceiptItems().size() == originalReceiptItemsCount) {
                                        KioskManagementPopup.writeLine((String)"New before save: ");
                                        KioskManagementPopup.writeLine((String)ObjectFlattener.flattenObjectToString((Object)receipt));
                                        this.cashierController.receiptService.save(receipt, false);
                                        Receipt newlyLoadedReceipt = this.cashierController.receiptService.findById(receiptID);
                                        KioskManagementPopup.writeLine((String)"New loaded: ");
                                        KioskManagementPopup.writeLine((String)ObjectFlattener.flattenObjectToString((Object)newlyLoadedReceipt));
                                        continue;
                                    }
                                    this.logMigrationException((Exception)new IllegalArgumentException("[ERR] Order with ID: " + receipt.getOrderId() + " ReceiptItems count mismatch"));
                                }
                                catch (Exception e) {
                                    this.logMigrationException(e);
                                }
                                continue;
                            }
                            this.logMigrationException((Exception)new IllegalArgumentException("[ERR] Order with ID: " + receipt.getOrderId() + " OrderItems is empty"));
                            continue;
                        }
                        this.logMigrationException((Exception)new IllegalArgumentException("[ERR] Order with ID: " + receipt.getOrderId() + " OrderItems is null"));
                        continue;
                    }
                    this.logMigrationException((Exception)new IllegalArgumentException("[ERR] Order with ID: " + receipt.getOrderId() + " not found for Receipt with ID: " + receiptID));
                    continue;
                }
                this.logMigrationException((Exception)new IllegalArgumentException("[ERR] Receipt with ID: " + receiptID + " has no Order ID"));
                continue;
            }
            this.logMigrationException((Exception)new IllegalArgumentException("[ERR] Receipt with ID: " + receiptID + " not found"));
        }
        writer.close();
    }

    private void logMigrationException(Exception e) {
        ExceptionHandler.logException((Exception)e);
        try {
            KioskManagementPopup.writeLine((String)("[ERR] " + e.getMessage()));
            KioskManagementPopup.writeLine((String)KioskManagementPopup.stackTraceToString((StackTraceElement[])e.getStackTrace()));
            KioskManagementPopup.insertDivider();
        }
        catch (IOException ioException) {
            ExceptionHandler.logException((Exception)ioException);
        }
    }

    public static String stackTraceToString(StackTraceElement[] stackTrace) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : stackTrace) {
            sb.append("\tat ").append(element.toString()).append(System.lineSeparator());
        }
        return sb.toString();
    }

    public void loadPopup() {
        this.show((Window)this.cashierController.stage);
        ((Node)this.getContent().get(0)).requestFocus();
    }

    private Button createButton(String label, COMPUTER computer, COMPUTER_MANAGEMENT_ACTION action) {
        Button button = new Button();
        button.setText(label);
        button.setOnMouseClicked(mouseEvent -> this.handleManagementAction(computer, action));
        return button;
    }

    private void handleManagementAction(COMPUTER computer, COMPUTER_MANAGEMENT_ACTION action) {
        String hostname = computer.getHostname();
        String username = "user";
        String remoteCommand = action.getCommand();
        String sshCommand = "ssh " + username + "@" + hostname + " " + remoteCommand;
        String[] commandArray = new String[]{"ssh", username + "@" + hostname, remoteCommand};
        String commandPrefix = "";
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            commandPrefix = "powershell.exe";
        } else if (os.contains("nix") || os.contains("aix") || os.contains("nux")) {
            commandPrefix = "/bin/bash -c";
        }
        try {
            System.out.println("Running command: " + commandPrefix + " \"" + sshCommand + "\"");
            Process process = Runtime.getRuntime().exec(commandPrefix + " \"" + sshCommand + "\"");
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
    }
}

