/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.DTO;

import cz.polreich.spagetka.DTO.ProductGroupsPriceDTO;
import cz.polreich.spagetka.models.MenuOption;
import java.util.ArrayList;
import java.util.List;

public class MenuOptionDTO {
    private String id;
    private String mainProductId;
    private List<ProductGroupsPriceDTO> additionalProductsPrices = new ArrayList();
    private Double price;
    private String name;
    private String description;
    private String imageFilePath;
    private Boolean allowedAtKiosk;

    public MenuOptionDTO(MenuOption menuOption) {
        this.id = menuOption.getId();
        this.mainProductId = menuOption.getMainProduct().getId();
        this.additionalProductsPrices = menuOption.getAdditionalProductsPrices().stream().map(ProductGroupsPriceDTO::new).toList();
        this.price = menuOption.getPrice();
        this.name = menuOption.getName();
        this.description = menuOption.getDescription();
        this.imageFilePath = menuOption.getImageFilePath();
        this.allowedAtKiosk = menuOption.isEnabled();
    }

    public MenuOptionDTO() {
    }

    public MenuOptionDTO(String id, String mainProductId, List<ProductGroupsPriceDTO> additionalProductsPrices, Double price, String name, String description, String imageFilePath, Boolean allowedAtKiosk) {
        this.id = id;
        this.mainProductId = mainProductId;
        this.additionalProductsPrices = additionalProductsPrices;
        this.price = price;
        this.name = name;
        this.description = description;
        this.imageFilePath = imageFilePath;
        this.allowedAtKiosk = allowedAtKiosk;
    }

    public String getId() {
        return this.id;
    }

    public String getMainProductId() {
        return this.mainProductId;
    }

    public List<ProductGroupsPriceDTO> getAdditionalProductsPrices() {
        return this.additionalProductsPrices;
    }

    public Double getPrice() {
        return this.price;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getImageFilePath() {
        return this.imageFilePath;
    }

    public Boolean getAllowedAtKiosk() {
        return this.allowedAtKiosk;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMainProductId(String mainProductId) {
        this.mainProductId = mainProductId;
    }

    public void setAdditionalProductsPrices(List<ProductGroupsPriceDTO> additionalProductsPrices) {
        this.additionalProductsPrices = additionalProductsPrices;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setImageFilePath(String imageFilePath) {
        this.imageFilePath = imageFilePath;
    }

    public void setAllowedAtKiosk(Boolean allowedAtKiosk) {
        this.allowedAtKiosk = allowedAtKiosk;
    }
}

