/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.DTO.StockItemDTO;
import cz.polreich.spagetka.models.Ingredient;
import cz.polreich.spagetka.service.IngredientService;
import cz.polreich.spagetka.utils.ApplicationContextUtils;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.security.InvalidParameterException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.jetbrains.annotations.NotNull;

@Entity
@Embeddable
@Table(name="stock_items")
public class StockItem {
    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    private String id;
    @ManyToOne(cascade={CascadeType.MERGE}, fetch=FetchType.EAGER)
    @JoinColumn(name="ingredient_id")
    private Ingredient ingredient;
    @Column
    private double quantity;
    @Column
    private String location;
    @Column
    private LocalDate expirationDate;
    @Column
    private String qrcode;
    @Column
    private Boolean criticalComponent = true;
    @Column
    private Boolean cookRelevant = true;

    public StockItem(@NotNull StockItemDTO dto) {
        this.id = dto.getId();
        IngredientService ingredientService = (IngredientService)ApplicationContextUtils.getApplicationContext().getBean(IngredientService.class);
        if (!ingredientService.existsById(dto.getIngredientId())) {
            throw new InvalidParameterException("Ingredient with ID " + dto.getIngredientId() + " not found.");
        }
        this.ingredient = ingredientService.findById(dto.getIngredientId());
        this.quantity = dto.getQuantity();
        this.location = dto.getLocation();
        this.expirationDate = LocalDateTime.parse(dto.getExpiration().replace(" ", "T")).toLocalDate();
        this.qrcode = dto.getQrcode();
        this.criticalComponent = dto.getCriticalComponent() != null ? dto.getCriticalComponent() : true;
        this.cookRelevant = dto.getCookSee() != null ? dto.getCookSee() : true;
    }

    public StockItem() {
    }

    public StockItem(String id, Ingredient ingredient, double quantity, String location, LocalDate expirationDate, String qrcode, Boolean criticalComponent, Boolean cookRelevant) {
        this.id = id;
        this.ingredient = ingredient;
        this.quantity = quantity;
        this.location = location;
        this.expirationDate = expirationDate;
        this.qrcode = qrcode;
        this.criticalComponent = criticalComponent;
        this.cookRelevant = cookRelevant;
    }

    public String getId() {
        return this.id;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public String getLocation() {
        return this.location;
    }

    public LocalDate getExpirationDate() {
        return this.expirationDate;
    }

    public String getQrcode() {
        return this.qrcode;
    }

    public Boolean getCriticalComponent() {
        return this.criticalComponent;
    }

    public Boolean getCookRelevant() {
        return this.cookRelevant;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIngredient(Ingredient ingredient) {
        this.ingredient = ingredient;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setExpirationDate(LocalDate expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setQrcode(String qrcode) {
        this.qrcode = qrcode;
    }

    public void setCriticalComponent(Boolean criticalComponent) {
        this.criticalComponent = criticalComponent;
    }

    public void setCookRelevant(Boolean cookRelevant) {
        this.cookRelevant = cookRelevant;
    }
}

