/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.DTO.CategoryDTO;
import cz.polreich.spagetka.utils.ResourceHelper;
import cz.polreich.spagetka.utils.ValidationUtils;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import javax.xml.bind.DatatypeConverter;

@Entity
@Table(name="Categories")
public class Category {
    @Id
    private int id;
    @Column
    private String name;
    @Column
    private String imageFilePath;
    @Column(length=1000000)
    private byte[] imageBytes;
    @Column
    private String remoteImagePath;
    @Column
    private int cookPosition;

    public Category(CategoryDTO dto) {
        this.createFromDTO(dto, false);
    }

    public Category(CategoryDTO dto, boolean fromExternal) {
        this.createFromDTO(dto, fromExternal);
    }

    private void createFromDTO(CategoryDTO dto, boolean fromExternal) {
        this.id = dto.getId();
        this.name = dto.getName();
        this.imageFilePath = fromExternal ? ResourceHelper.convertImagePathFromExternal((String)dto.getImageFilePath()) : dto.getImageFilePath();
        this.remoteImagePath = dto.getImageFilePath();
        this.imageBytes = ValidationUtils.isStringNotNullOrEmpty((String)dto.getImageBytesBase64()) ? DatatypeConverter.parseBase64Binary((String)dto.getImageBytesBase64()) : new byte[]{};
        this.cookPosition = dto.getCookPosition();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getImageFilePath() {
        return this.imageFilePath;
    }

    public byte[] getImageBytes() {
        return this.imageBytes;
    }

    public String getRemoteImagePath() {
        return this.remoteImagePath;
    }

    public int getCookPosition() {
        return this.cookPosition;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setImageFilePath(String imageFilePath) {
        this.imageFilePath = imageFilePath;
    }

    public void setImageBytes(byte[] imageBytes) {
        this.imageBytes = imageBytes;
    }

    public void setRemoteImagePath(String remoteImagePath) {
        this.remoteImagePath = remoteImagePath;
    }

    public void setCookPosition(int cookPosition) {
        this.cookPosition = cookPosition;
    }

    public Category() {
    }

    public Category(int id, String name, String imageFilePath, byte[] imageBytes, String remoteImagePath, int cookPosition) {
        this.id = id;
        this.name = name;
        this.imageFilePath = imageFilePath;
        this.imageBytes = imageBytes;
        this.remoteImagePath = remoteImagePath;
        this.cookPosition = cookPosition;
    }
}

