/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.cashierController;

import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.enums.ORDER_STATUS;
import cz.polreich.spagetka.models.gui.buttons.CancelButton;
import cz.polreich.spagetka.models.gui.buttons.ConfirmButton;
import cz.polreich.spagetka.utils.FormatUtils;
import cz.polreich.spagetka.utils.LayoutUtils;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Popup;
import javafx.stage.Window;
import javafx.util.Duration;

public class NewDeliveryOrderPopup
extends Popup {
    private AnchorPane popupAnchor = new AnchorPane();
    private FlowPane orderFlowPane = new FlowPane();
    private CashierController cashierController;
    private Map<String, VBox> orderBoxesMap = new HashMap();
    private Map<String, Label> countdownLabelsMap = new HashMap();
    private Map<String, ProgressIndicator> progressIndicatorsMap = new HashMap();
    private ObservableList<Order> relevantOrders = FXCollections.observableArrayList();

    public NewDeliveryOrderPopup(CashierController cashierController) {
        this.cashierController = cashierController;
        int popupWidth = 700;
        int popupHeight = 700;
        AnchorPane.setTopAnchor((Node)this.orderFlowPane, (Double)100.0);
        AnchorPane.setLeftAnchor((Node)this.orderFlowPane, (Double)25.0);
        AnchorPane.setRightAnchor((Node)this.orderFlowPane, (Double)25.0);
        AnchorPane.setBottomAnchor((Node)this.orderFlowPane, (Double)100.0);
        this.popupAnchor.getChildren().add((Object)this.orderFlowPane);
        this.popupAnchor.getStyleClass().add((Object)"login_anchor_pane");
        Label titleLabel = new Label("Nov\u00e1 objedn\u00e1vka rozvozu");
        titleLabel.setFont(cashierController.titleFont);
        this.popupAnchor.getChildren().add((Object)titleLabel);
        this.relevantOrders.addListener(change -> {
            System.out.println("[WOLT-DEBUG-POPUP] Relevant orders listener called");
            Platform.runLater(() -> {
                System.out.println("[WOLT-DEBUG-POPUP] Thread for update started");
                this.updateOrders(this.relevantOrders);
                System.out.println("[WOLT-DEBUG-POPUP] Thread for update finished");
            });
        });
        this.orderFlowPane.setVgap(20.0);
        this.getContent().add((Object)this.popupAnchor);
    }

    public void loadPopup() {
        System.out.println("[WOLT-DEBUG-POPUP] Loading popup");
        this.show((Window)this.cashierController.stage);
        System.out.println("[WOLT-DEBUG-POPUP] Stage showed, getting orders");
        this.relevantOrders.setAll(this.cashierController.orderVboxService.getOrders().stream().filter(order -> order.getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_CASHIER_APPROVEMENT)).toList());
    }

    private void updateOrders(ObservableList<Order> relevantOrders) {
        System.out.println("[WOLT-DEBUG-POPUP-UPDATE] Update started, clearing children");
        this.orderFlowPane.getChildren().clear();
        System.out.println("[WOLT-DEBUG-POPUP-UPDATE] Children cleared, getting orders");
        relevantOrders = relevantOrders.filtered(order -> order.getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_CASHIER_APPROVEMENT));
        System.out.println("[WOLT-DEBUG-POPUP-UPDATE] Got orders");
        System.out.println("[WOLT-DEBUG-POPUP-UPDATE] Orders count: " + relevantOrders.size());
        if (relevantOrders.isEmpty()) {
            System.out.println("[WOLT-DEBUG-POPUP-UPDATE] Relevant orders is empty, hiding popup");
            this.hidePopup();
            System.out.println("[WOLT-DEBUG-POPUP-UPDATE] Popup hidden");
            return;
        }
        for (String orderId : this.orderBoxesMap.keySet()) {
            System.out.println("[WOLT-DEBUG-POPUP-UPDATE] Looping map");
            System.out.println("[WOLT-DEBUG-POPUP-UPDATE] Now processing order " + orderId);
            if (!relevantOrders.stream().noneMatch(order -> order.getId().equals(orderId))) continue;
            System.out.println("[WOLT-DEBUG-POPUP-UPDATE] No match, calling resolve");
            this.resolveOrder(orderId);
            System.out.println("[WOLT-DEBUG-POPUP-UPDATE] Resolve finished");
        }
        for (Order order2 : relevantOrders) {
            System.out.println("[WOLT-DEBUG-POPUP-UPDATE] Looping relevant orders");
            System.out.println("[WOLT-DEBUG-POPUP-UPDATE] Now processing: " + order2.getId() + " | " + order2.getOrderNumber());
            String orderId = order2.getId();
            if (!this.orderBoxesMap.containsKey(orderId)) {
                System.out.println("[WOLT-DEBUG-POPUP-UPDATE] No match in map 2");
                System.out.println("[WOLT-DEBUG-POPUP-UPDATE] Creatiung orderVBox");
                this.createOrderVBox(order2);
                System.out.println("[WOLT-DEBUG-POPUP-UPDATE] OrderVBox created");
            }
            System.out.println("[WOLT-DEBUG-POPUP-UPDATE] Adding child to pane");
            this.orderFlowPane.getChildren().add((Object)((Node)this.orderBoxesMap.get(orderId)));
            System.out.println("[WOLT-DEBUG-POPUP-UPDATE] Finished");
        }
    }

    private void createOrderVBox(Order order) {
        System.out.println("[WOLT-DEBUG-POPUP-CREATE] Started, setting variables");
        String orderId = order.getId();
        VBox orderVBox = new VBox();
        HBox headerHBox = new HBox();
        orderVBox.setPrefWidth(650.0);
        orderVBox.setPrefHeight(100.0);
        orderVBox.getStyleClass().add((Object)"orderVBox");
        System.out.println("[WOLT-DEBUG-POPUP-CREATE] 2");
        Label label = new Label("\u010c. obj.: " + order.getOrderNumber());
        Label countdownLabel = new Label();
        System.out.println("[WOLT-DEBUG-POPUP-CREATE] 3");
        Label priceLabel = new Label("Cena: " + FormatUtils.formatCurrency((double)order.getTotalPrice(), (String)this.cashierController.activeConfig.getKioskInfo().getCurrency().getSymbol(this.cashierController.activeConfig.getSelectedLocale())));
        System.out.println("[WOLT-DEBUG-POPUP-CREATE] 4");
        ProgressIndicator progressIndicator = new ProgressIndicator(1.0);
        progressIndicator.setStyle(".percentage { visibility: hidden; }.text { visibility: hidden; }");
        System.out.println("[WOLT-DEBUG-POPUP-CREATE] 5");
        headerHBox.getChildren().addAll((Object[])new Node[]{label});
        System.out.println("[WOLT-DEBUG-POPUP-CREATE] 6");
        VBox orderItemsVBox = new VBox();
        for (OrderItem orderItem : order.getOrderItems()) {
            System.out.println("[WOLT-DEBUG-POPUP-CREATE] Adding order items");
            System.out.println("[WOLT-DEBUG-POPUP-CREATE] Now processing: " + orderItem.getId() + " | " + orderItem.getDisplayName());
            HBox orderItemsHBox = LayoutUtils.createOrderItemsList((OrderItem)orderItem, (String)this.cashierController.activeConfig.getKioskInfo().getCurrency().getSymbol(this.cashierController.activeConfig.getSelectedLocale()));
            System.out.println("[WOLT-DEBUG-POPUP-CREATE] 7");
            orderItemsVBox.getChildren().add((Object)orderItemsHBox);
            System.out.println("[WOLT-DEBUG-POPUP-CREATE] 8");
        }
        System.out.println("[WOLT-DEBUG-POPUP-CREATE] 9");
        HBox buttonsHBox = new HBox();
        buttonsHBox.getStyleClass().add((Object)"buttonsHBox");
        System.out.println("[WOLT-DEBUG-POPUP-CREATE] 10");
        ConfirmButton acceptButton = new ConfirmButton("P\u0159ijmout");
        acceptButton.setOnMouseClicked(event -> Platform.runLater(() -> {
            System.out.println("[WOLT-DEBUG-POPUP-CREATE] 11");
            this.acceptOrder(order);
            System.out.println("[WOLT-DEBUG-POPUP-CREATE] 12");
            this.resolveOrder(orderId);
            System.out.println("[WOLT-DEBUG-POPUP-CREATE] 13");
            buttonsHBox.setVisible(false);
            System.out.println("[WOLT-DEBUG-POPUP-CREATE] 14");
        }));
        CancelButton rejectButton = new CancelButton("Odm\u00edtnout");
        rejectButton.setOnMouseClicked(event -> Platform.runLater(() -> {
            System.out.println("[WOLT-DEBUG-POPUP-CREATE] 15");
            this.rejectOrder(order);
            System.out.println("[WOLT-DEBUG-POPUP-CREATE] 16");
            this.resolveOrder(orderId);
            System.out.println("[WOLT-DEBUG-POPUP-CREATE] 17");
            buttonsHBox.setVisible(false);
            System.out.println("[WOLT-DEBUG-POPUP-CREATE] 18");
        }));
        System.out.println("[WOLT-DEBUG-POPUP-CREATE] 19");
        buttonsHBox.setSpacing(20.0);
        buttonsHBox.getChildren().addAll((Object[])new Node[]{progressIndicator, countdownLabel, acceptButton, rejectButton});
        System.out.println("[WOLT-DEBUG-POPUP-CREATE] 20");
        orderVBox.setSpacing(10.0);
        orderVBox.getChildren().addAll((Object[])new Node[]{headerHBox, priceLabel, orderItemsVBox, buttonsHBox});
        System.out.println("[WOLT-DEBUG-POPUP-CREATE] 21");
        this.orderBoxesMap.put(orderId, orderVBox);
        System.out.println("[WOLT-DEBUG-POPUP-CREATE] 22");
        this.countdownLabelsMap.put(orderId, countdownLabel);
        System.out.println("[WOLT-DEBUG-POPUP-CREATE] 23");
        this.progressIndicatorsMap.put(orderId, progressIndicator);
        System.out.println("[WOLT-DEBUG-POPUP-CREATE] 24");
        this.startCountdown(order.getExpectedResponseTime(), countdownLabel, progressIndicator, order);
        System.out.println("[WOLT-DEBUG-POPUP-CREATE] 25");
    }

    private void startCountdown(LocalDateTime expectedResponseTime, Label countdownLabel, ProgressIndicator progressIndicator, Order order) {
        System.out.println("[WOLT-DEBUG-POPUP-START] A");
        int totalDuration = (int)this.getRemainingSeconds(expectedResponseTime);
        System.out.println("[WOLT-DEBUG-POPUP-START] B");
        AtomicReference<Timeline> timelineRef = new AtomicReference<Timeline>();
        System.out.println("[WOLT-DEBUG-POPUP-START] C");
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.1), event -> {
            System.out.println("[WOLT-DEBUG-POPUP-START] D");
            long remainingSeconds = this.getRemainingSeconds(expectedResponseTime);
            System.out.println("[WOLT-DEBUG-POPUP-START] E");
            if (remainingSeconds <= 0L) {
                System.out.println("[WOLT-DEBUG-POPUP-START] F");
                countdownLabel.setText("Time's up!");
                progressIndicator.setProgress(0.0);
                if (order.getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_CASHIER_APPROVEMENT)) {
                    System.out.println("[WOLT-DEBUG-POPUP-START] G");
                    this.resolveOrder(order.getId());
                    System.out.println("[WOLT-DEBUG-POPUP-START] H");
                    this.acceptOrder(order);
                    System.out.println("[WOLT-DEBUG-POPUP-START] I");
                }
                System.out.println("[WOLT-DEBUG-POPUP-START] J");
                ((Timeline)timelineRef.get()).stop();
                System.out.println("[WOLT-DEBUG-POPUP-START] K");
            } else {
                System.out.println("[WOLT-DEBUG-POPUP-START] L");
                countdownLabel.setText(remainingSeconds + "s");
                System.out.println("[WOLT-DEBUG-POPUP-START] M");
                progressIndicator.setProgress((double)remainingSeconds / (double)totalDuration);
                System.out.println("[WOLT-DEBUG-POPUP-START] N");
            }
        }, new KeyValue[0])});
        System.out.println("[WOLT-DEBUG-POPUP-START] O");
        timelineRef.set(timeline);
        System.out.println("[WOLT-DEBUG-POPUP-START] P");
        timeline.setCycleCount(-1);
        System.out.println("[WOLT-DEBUG-POPUP-START] Q");
        timeline.play();
        System.out.println("[WOLT-DEBUG-POPUP-START] R");
    }

    private void resolveOrder(String orderId) {
        System.out.println("[WOLT-DEBUG-POPUP-RESOLVE] Started resolve, removing child from flowpane");
        this.orderFlowPane.getChildren().remove(this.orderBoxesMap.get(orderId));
        System.out.println("[WOLT-DEBUG-POPUP-RESOLVE] Removing from map");
        this.removeOrderFromMaps(orderId);
        System.out.println("[WOLT-DEBUG-POPUP-RESOLVE] Removing from relevantOrders");
        this.relevantOrders.removeIf(order -> order.getId().equals(orderId));
    }

    private void removeOrderFromMaps(String orderId) {
        System.out.println("[WOLT-DEBUG-POPUP-REMOVEMAPS] Started removal from maps");
        this.orderBoxesMap.remove(orderId);
        System.out.println("[WOLT-DEBUG-POPUP-REMOVEMAPS] Removed 1");
        this.countdownLabelsMap.remove(orderId);
        System.out.println("[WOLT-DEBUG-POPUP-REMOVEMAPS] Removed 2");
        this.progressIndicatorsMap.remove(orderId);
        System.out.println("[WOLT-DEBUG-POPUP-REMOVEMAPS] Removed 3");
    }

    private void acceptOrder(Order order) {
        System.out.println("[WOLT-DEBUG-POPUP-ACCEPT] Setting orde status to Confirmed");
        order.setOrderStatus(ORDER_STATUS.CONFIRMED);
        System.out.println("[WOLT-DEBUG-POPUP-ACCEPT] Updating order");
        this.cashierController.orderService.update(order);
        System.out.println("[WOLT-DEBUG-POPUP-ACCEPT] Finished");
    }

    private void rejectOrder(Order order) {
        System.out.println("[WOLT-DEBUG-POPUP-REJECT] Setting orde status to Rejected");
        order.setOrderStatus(ORDER_STATUS.REJECTED);
        System.out.println("[WOLT-DEBUG-POPUP-REJECT] Updating order");
        this.cashierController.orderService.update(order);
        System.out.println("[WOLT-DEBUG-POPUP-REJECT] Finished");
    }

    private long getRemainingSeconds(LocalDateTime expectedResponseTime) {
        LocalDateTime expiryTime = expectedResponseTime.minusSeconds(1L);
        return Math.max(0L, ChronoUnit.SECONDS.between(LocalDateTime.now(), expiryTime));
    }

    public void hidePopup() {
        this.hide();
    }
}

