/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers;

import cz.polreich.spagetka.controllers.CustomerBaseController;
import cz.polreich.spagetka.controllers.CustomerMainController;
import cz.polreich.spagetka.controllers.popup.customerMainController.CancelConfirmationPopup;
import cz.polreich.spagetka.controllers.popup.customerMainController.IceCreamPopup;
import cz.polreich.spagetka.controllers.popup.customerMainController.MenuOptionPopup;
import cz.polreich.spagetka.controllers.popup.customerMainController.ProductDetailPopup;
import cz.polreich.spagetka.controllers.popup.customerMainController.VariantSelectionPopup;
import cz.polreich.spagetka.models.Category;
import cz.polreich.spagetka.models.MenuOption;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.ProductFreeVariant;
import cz.polreich.spagetka.models.ProductVariant;
import cz.polreich.spagetka.models.enums.ORDER_TYPE;
import cz.polreich.spagetka.models.gui.buttons.CancelButton;
import cz.polreich.spagetka.models.gui.buttons.ConfirmButton;
import cz.polreich.spagetka.models.gui.panes.ScreensaverPaneComponents;
import cz.polreich.spagetka.models.gui.panes.TouchScrollPane;
import cz.polreich.spagetka.service.AllergenService;
import cz.polreich.spagetka.service.CategoryService;
import cz.polreich.spagetka.service.MenuOptionService;
import cz.polreich.spagetka.service.ProductFreeVariantService;
import cz.polreich.spagetka.service.ProductService;
import cz.polreich.spagetka.service.ProductVariantService;
import cz.polreich.spagetka.service.ProductsGroupService;
import cz.polreich.spagetka.service.StockItemService;
import cz.polreich.spagetka.service.screensaver.ScreensaverService;
import cz.polreich.spagetka.utils.FontUtils;
import cz.polreich.spagetka.utils.FormatUtils;
import cz.polreich.spagetka.utils.ImageUtils;
import cz.polreich.spagetka.utils.LayoutUtils;
import cz.polreich.spagetka.utils.MockDataHandler;
import cz.polreich.spagetka.utils.ResourceHelper;
import cz.polreich.spagetka.utils.ThreadUtils;
import cz.polreich.spagetka.utils.ValidationUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.PauseTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.InnerShadow;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.scene.media.MediaView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.VLineTo;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class CustomerMainController
extends CustomerBaseController
implements Initializable {
    @FXML
    private BorderPane mainPane;
    @FXML
    private AnchorPane leftAnchorPane;
    @FXML
    private TouchScrollPane rightScrollPane;
    @FXML
    private TouchScrollPane bottomScrollPane;
    @FXML
    private VBox bottomAnchorPane;
    @FXML
    private ConfirmButton finishOrder_button;
    @FXML
    private CancelButton cancelOrder_button;
    @FXML
    private TilePane products_tilePane;
    @FXML
    private VBox orderOverview_vBox;
    @FXML
    private VBox menuButtonsVBox;
    @FXML
    private ImageView imageView1;
    @FXML
    private ImageView imageView2;
    @FXML
    private MediaView mediaView;
    @FXML
    private AnchorPane screensaverAnchorPane;
    @FXML
    private Button goToWelcomePageButton;
    @FXML
    AnchorPane welcomeMainAnchorPane;
    @FXML
    Label welcomeMainTitle;
    @FXML
    ImageView welcomeLogoImageView;
    @FXML
    Label welcomeLogoTitle;
    @FXML
    AnchorPane welcomeOrderTypeAnchorPane;
    @FXML
    Label welcomeOrderTypeTitle;
    @FXML
    FlowPane welcomeOrderTypeFlowPane;
    @FXML
    Button welcomeHereButton;
    @FXML
    Button welcomeTakeAwayButton;
    @FXML
    AnchorPane welcomeLanguageAnchorPane;
    @FXML
    Label welcomeLanguageTitle;
    @FXML
    FlowPane welcomeLanguageFlowPane;
    @FXML
    Label categoryTitle;
    @FXML
    HBox topHBox;
    @FXML
    StackPane outerStackPane;
    @Autowired
    public ProductService productService;
    @Autowired
    CategoryService categoryService;
    @Autowired
    public MockDataHandler mockDataHandler;
    @Autowired
    public MenuOptionService menuOptionService;
    @Autowired
    public AllergenService allergenService;
    @Autowired
    public ProductVariantService productVariantService;
    @Autowired
    public StockItemService stockItemService;
    @Autowired
    public ProductFreeVariantService productFreeVariantService;
    @Autowired
    public ProductsGroupService productsGroupService;
    @Autowired
    private ScreensaverService screensaverService;
    private HashMap<Integer, Button> mainMenuButtons = new HashMap();
    public MenuOptionPopup menuOptionPopup;
    public ProductDetailPopup productDetailPopup;
    public VariantSelectionPopup variantSelectionPopup;
    public IceCreamPopup iceCreamPopup;
    public CancelConfirmationPopup cancelConfirmationPopup;
    private BooleanProperty isPopupOpen = new SimpleBooleanProperty(false);
    private InnerShadow innerShadow;
    private BooleanBinding orderOverviewVbox_hasChildren;
    private BooleanProperty overrideMainDisableProperty = new SimpleBooleanProperty(false);
    private VBox cartAnimationVBox;

    public void initialize(URL url, ResourceBundle resourceBundle) {
    }

    public void setupScene() {
        super.setupScene();
        this.bindStrings();
        this.menuOptionPopup = new MenuOptionPopup(this);
        this.variantSelectionPopup = new VariantSelectionPopup(this);
        this.iceCreamPopup = new IceCreamPopup(this);
        this.cancelConfirmationPopup = new CancelConfirmationPopup(this);
        this.popups.add(this.menuOptionPopup);
        this.popups.add(this.productDetailPopup);
        this.popups.add(this.variantSelectionPopup);
        this.popups.add(this.iceCreamPopup);
        this.popups.add(this.cancelConfirmationPopup);
        this.isPopupOpen.bind((ObservableValue)this.menuOptionPopup.showingProperty().or((ObservableBooleanValue)this.variantSelectionPopup.showingProperty()).or((ObservableBooleanValue)this.iceCreamPopup.showingProperty()).or((ObservableBooleanValue)this.cancelConfirmationPopup.showingProperty()));
        this.mainPane.disableProperty().bind((ObservableValue)this.isPopupOpen.or((ObservableBooleanValue)this.overrideMainDisableProperty));
        this.products_tilePane.setPadding(LayoutUtils.getInsets((double)10.0, (double)0.0, (double)0.0, (double)0.0));
        this.mainPane.setStyle("-fx-background-color: " + this.mainBackgroundColor + ";");
        this.products_tilePane.setStyle("-fx-background-color: " + this.mainBackgroundColor + ";");
        this.leftAnchorPane.setStyle("-fx-background-color: " + this.mainBackgroundColor + ";");
        this.bottomAnchorPane.setStyle("-fx-background-color: " + this.mainBackgroundColor + ";");
        this.rightScrollPane.setStyle("-fx-background-color: " + this.mainBackgroundColor + ";");
        this.bottomScrollPane.setStyle("-fx-background-color: " + this.mainBackgroundColor + ";");
        this.innerShadow = new InnerShadow();
        this.innerShadow.setBlurType(BlurType.GAUSSIAN);
        this.innerShadow.setColor(Color.GRAY);
        this.innerShadow.setChoke(0.5);
        this.innerShadow.setOffsetX(0.0);
        this.innerShadow.setOffsetY(0.0);
        this.innerShadow.setRadius(10.0);
        this.orderOverviewVbox_hasChildren = Bindings.createBooleanBinding(() -> !this.orderOverview_vBox.getChildren().isEmpty(), (Observable[])new Observable[]{this.orderOverview_vBox.getChildren()});
        this.bottomScrollPane.effectProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.orderOverviewVbox_hasChildren).then((Object)this.innerShadow).otherwise((Object)this.innerShadow));
        this.categoryTitle.setFont(this.titleFont);
        this.categoryTitle.setAlignment(Pos.CENTER);
        this.categoryTitle.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.refreshOrderOverview();
        this.setupButtons();
        this.switchToCategoryView(1);
        this.setupWelcomePane();
        this.createCartAnimation();
        this.createCartAnimation();
        this.startResetThread();
        this.setupScreensaver();
    }

    private void setupScreensaver() {
        this.screensaverAnchorPane.setStyle("-fx-background-color: " + this.mainBackgroundColor + ";");
        this.goToWelcomePageButton.setAlignment(Pos.CENTER);
        this.goToWelcomePageButton.setPrefHeight(200.0);
        this.goToWelcomePageButton.setPrefWidth((double)this.activeConfig.getDisplayConfig().getResolution().getWidth());
        this.goToWelcomePageButton.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        ScreensaverPaneComponents components = ScreensaverPaneComponents.builder().anchorPane(this.screensaverAnchorPane).imageView1(this.imageView1).imageView2(this.imageView2).mediaView(this.mediaView).goToWelcomePageButton(this.goToWelcomePageButton).build();
        this.screensaverService.registerScreensaverPane(components);
    }

    private void bindStrings() {
        this.bindStringToLocale((Button)this.finishOrder_button, "main.button.confirmOrder", this.titleFont);
        this.bindStringToLocale((Button)this.cancelOrder_button, "main.button.cancelOrder", this.titleFont);
        this.bindStringToLocale(this.welcomeMainTitle, "welcome.title", this.welcomeMainTitleFont);
        this.bindStringToLocale(this.welcomeLanguageTitle, "welcome.language.title", this.welcomeSubtitleFont);
        this.bindStringToLocale(this.welcomeOrderTypeTitle, "welcome.orderType.title", this.welcomeSubtitleFont);
        this.bindStringToLocale(this.welcomeHereButton, "welcome.orderType.button.here", this.subtitleFont);
        this.bindStringToLocale(this.welcomeTakeAwayButton, "welcome.orderType.button.takeAway", this.subtitleFont);
        this.bindStringToLocale(this.goToWelcomePageButton, "screensaver.orderType.button.placeOrder", this.welcomeMainTitleFont);
    }

    private void createCartAnimation() {
        this.cartAnimationVBox = new VBox();
        this.cartAnimationVBox.setStyle("-fx-background-color: " + this.mainBackgroundColor + "; -fx-background-radius : 10 10 10 10;");
        Label label = new Label();
        label.setFont(this.subtitleFont);
        label.setText(this.strings.getString("main.label.cartAnimation"));
        label.setPrefWidth(500.0);
        label.setAlignment(Pos.CENTER);
        ImageView imageView = ResourceHelper.getImageViewFromResourceName((String)"/resources/images/shopping-cart_black_512.png");
        imageView.setFitHeight(300.0);
        imageView.setFitWidth(300.0);
        this.cartAnimationVBox.setPadding(new Insets(50.0, 50.0, 50.0, 50.0));
        this.cartAnimationVBox.setAlignment(Pos.CENTER);
        this.cartAnimationVBox.setPrefWidth(600.0);
        this.cartAnimationVBox.setMaxWidth(600.0);
        this.cartAnimationVBox.setPrefHeight(400.0);
        this.cartAnimationVBox.setMaxHeight(450.0);
        this.cartAnimationVBox.getChildren().addAll((Object[])new Node[]{label, imageView});
        this.cartAnimationVBox.setVisible(false);
        this.cartAnimationVBox.setLayoutX(700.0);
        this.cartAnimationVBox.setLayoutY(240.0);
        this.outerStackPane.getChildren().add((Object)this.cartAnimationVBox);
    }

    private void setupWelcomePane() {
        this.welcomeMainAnchorPane.setVisible(this.activeConfig.getCurrentOrder().getOrderType() == null);
        this.welcomeMainAnchorPane.setStyle("-fx-background-color: " + this.mainBackgroundColor + ";");
        FontUtils.setIdealFont((Label)this.welcomeMainTitle, (Font)this.welcomeMainTitleFont);
        FontUtils.setIdealFont((Label)this.welcomeOrderTypeTitle, (Font)this.welcomeSubtitleFont);
        FontUtils.setIdealFont((Label)this.welcomeLanguageTitle, (Font)this.welcomeSubtitleFont);
        this.welcomeLogoTitle.setFont(this.welcomeLogoTitleFont);
        this.welcomeLogoTitle.setText(this.activeConfig.getKioskName());
        this.setupWelcomeLogo();
        this.setupWelcomeOrderTypeButtons();
        this.setupWelcomeLanguagesButtons();
    }

    private void setupWelcomeLogo() {
        String imagePath = "/resources/images/spagetka-logo.png";
        InputStream is = ResourceHelper.getImageAsStream((String)imagePath);
        Image image = new Image(is);
        this.welcomeLogoImageView.setPreserveRatio(true);
        this.welcomeLogoImageView.setImage(image);
        ImageUtils.centerImage((ImageView)this.welcomeLogoImageView);
    }

    private void setupWelcomeLanguagesButtons() {
        String[] languages;
        for (String language : languages = new String[]{"cs_CZ", "en_GB", "de_DE", "ua_UA", "pl_PL", "sk_SK", "es_ES"}) {
            this.setupWelcomeLanguageButton(language);
        }
        int perRow = 4;
        int rowSize = Math.min(languages.length, perRow);
        int emptySpace = this.activeConfig.getDisplayConfig().getResolution().getWidth() - rowSize * 200;
        int gapSize = emptySpace / (rowSize + 1);
        this.welcomeLanguageFlowPane.setHgap((double)gapSize);
        this.welcomeLanguageFlowPane.setVgap(30.0);
        this.welcomeLanguageFlowPane.setMinHeight(100.0);
    }

    private void setupWelcomeLanguageButton(String language) {
        int buttonWidth = 200;
        double buttonHeight = (double)buttonWidth * 0.67;
        if (language.contains("_")) {
            String country = language.split("_")[1];
            String imagePath = "/resources/images/flags/" + country + "_W250.png";
            Button button = new Button();
            button.setId("languageButton-" + language);
            button.setPrefWidth((double)buttonWidth);
            button.setPrefHeight(buttonHeight);
            button.setOnMouseClicked(mouseEvent -> this.switchLanguage(language));
            if (!imagePath.trim().isEmpty()) {
                InputStream is = ResourceHelper.getImageAsStream((String)imagePath);
                Image image = new Image(is);
                ImageView imageView = new ImageView(image);
                imageView.setPreserveRatio(true);
                imageView.setFitWidth((double)buttonWidth);
                imageView.setFitHeight(buttonHeight);
                button.setGraphic((Node)imageView);
            } else {
                button.setText(language);
                button.setFont(this.productTitleFont);
            }
            this.welcomeLanguageFlowPane.getChildren().add((Object)button);
        }
    }

    private void switchLanguage(String newLang) {
        Locale newLocale = Locale.forLanguageTag(newLang.replace("_", "-"));
        this.strings = ResourceBundle.getBundle("resources/strings/customer", newLocale);
        this.activeConfig.setSelectedLocale(newLocale);
    }

    private void setupWelcomeOrderTypeButtons() {
        Map<Button, String> buttons = Map.of(this.welcomeHereButton, "/resources/images/dine_in_256.png", this.welcomeTakeAwayButton, "/resources/images/take_away_256.png");
        for (Button button : buttons.keySet()) {
            this.setupWelcomeOrderTypeButton(button, buttons.get(button));
        }
        double emptySpace = (double)this.activeConfig.getDisplayConfig().getResolution().getWidth() - (this.welcomeHereButton.getPrefWidth() + this.welcomeTakeAwayButton.getPrefWidth());
        double gapSize = emptySpace / (double)(buttons.size() + 1);
        this.welcomeOrderTypeFlowPane.setHgap(gapSize);
        this.welcomeOrderTypeFlowPane.setMinHeight(500.0);
    }

    private void setupWelcomeOrderTypeButton(Button button, String imagePath) {
        button.setPrefWidth(300.0);
        button.setPrefHeight(300.0);
        FontUtils.setIdealFont((Button)button, (Font)this.subtitleFont);
        button.getStyleClass().add((Object)"glass");
        if (imagePath != null && !imagePath.trim().isEmpty()) {
            InputStream is = ResourceHelper.getImageAsStream((String)imagePath);
            Image image = new Image(is);
            ImageView imageView = new ImageView(image);
            imageView.setPreserveRatio(true);
            imageView.setFitWidth(200.0);
            imageView.setFitHeight(200.0);
            button.setGraphic((Node)imageView);
        }
        button.setGraphicTextGap(10.0);
        button.setContentDisplay(ContentDisplay.BOTTOM);
    }

    @FXML
    private void welcomeHereButtonAction() {
        this.activeConfig.getCurrentOrder().setOrderType(ORDER_TYPE.PERSONAL_HERE);
        this.welcomeMainAnchorPane.setVisible(false);
    }

    @FXML
    private void welcomeTakeAwayButtonAction() {
        this.activeConfig.getCurrentOrder().setOrderType(ORDER_TYPE.PERSONAL_TAKE_AWAY);
        this.welcomeMainAnchorPane.setVisible(false);
    }

    private void runCartAnimation() {
        this.cartAnimationVBox.setVisible(true);
        ScaleTransition initShrink = new ScaleTransition(Duration.millis((double)10.0), (Node)this.cartAnimationVBox);
        initShrink.setFromX(1.0);
        initShrink.setToX(0.001);
        initShrink.setFromY(1.0);
        initShrink.setToY(0.001);
        initShrink.setInterpolator(Interpolator.LINEAR);
        ScaleTransition grow = new ScaleTransition(Duration.seconds((double)0.5), (Node)this.cartAnimationVBox);
        grow.setFromX(0.5);
        grow.setToX(1.75);
        grow.setFromY(0.5);
        grow.setToY(1.75);
        grow.setInterpolator(Interpolator.LINEAR);
        PauseTransition pause = new PauseTransition(Duration.seconds((double)0.5));
        ScaleTransition shrink = new ScaleTransition(Duration.seconds((double)0.25), (Node)this.cartAnimationVBox);
        shrink.setToX(0.001);
        shrink.setToY(0.001);
        TranslateTransition translate = new TranslateTransition(Duration.seconds((double)0.25), (Node)this.cartAnimationVBox);
        translate.setToX(0.0);
        translate.setToY(600.0);
        ParallelTransition second = new ParallelTransition(new Animation[]{shrink, translate});
        TranslateTransition resetTranslate = new TranslateTransition(Duration.millis((double)10.0), (Node)this.cartAnimationVBox);
        resetTranslate.setToX(0.0);
        resetTranslate.setToY(0.0);
        SequentialTransition animation = new SequentialTransition(new Animation[]{initShrink, grow, pause, second, resetTranslate});
        animation.play();
    }

    private void startResetThread() {
        Thread existingThread = ThreadUtils.getThreadByName((String)"ResetThreadCustomerMain");
        if (existingThread == null || !existingThread.isAlive()) {
            Thread taskThread = new Thread(() -> this.run());
            taskThread.setName("ResetThreadCustomerMain");
            taskThread.setDaemon(true);
            taskThread.start();
        } else {
            existingThread.interrupt();
            this.startResetThread();
        }
    }

    private void setupButtons() {
        if (this.activeConfig.isAlwaysFetchFromDB()) {
            List categories = this.categoryService.findAll();
            for (Category category : categories) {
                if (this.productService.findEnabledByCategory(category.getId()).isEmpty() || category.getId() == 5) continue;
                this.setupMainMenuButton(category.getImageFilePath(), category.getName(), category.getId());
            }
        } else {
            List categories = this.activeConfig.getCurrentOffer().getCategories();
            for (Category category : categories) {
                if (this.activeConfig.getCurrentOffer().getProducts().stream().filter(p -> p.getCategory() == category.getId()).toList().isEmpty() || category.getId() == 5) continue;
                this.setupMainMenuButton(category.getImageFilePath(), category.getName(), category.getId());
            }
        }
        FontUtils.setIdealFont((Button)this.finishOrder_button, (Font)this.titleFont);
        FontUtils.setIdealFont((Button)this.cancelOrder_button, (Font)this.titleFont);
        this.orderOverview_vBox.setSpacing(10.0);
        this.orderOverview_vBox.setPadding(LayoutUtils.getInsets((double)10.0, (double)0.0, (double)0.0, (double)0.0));
        this.orderOverview_vBox.setStyle("-fx-background-color: " + this.mainBackgroundColor + ";");
    }

    private void setupMainMenuButton(String imageFileName, String text, int category) {
        Button button = new Button();
        button.setMnemonicParsing(false);
        button.setPrefHeight(100.0);
        button.setPrefWidth(296.0);
        VBox.setMargin((Node)button, (Insets)new Insets(10.0, 10.0, 0.0, 10.0));
        if (imageFileName != null && !imageFileName.trim().isEmpty()) {
            InputStream is = ResourceHelper.getImageAsStream((String)imageFileName);
            Image image = new Image(is);
            ImageView imageView = new ImageView(image);
            imageView.setPreserveRatio(true);
            imageView.setFitWidth(60.0);
            button.setGraphic((Node)imageView);
        }
        button.setText(text);
        button.setFont(this.titleFont);
        button.setGraphicTextGap(10.0);
        button.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        button.getStyleClass().add((Object)"mainMenuButton");
        button.setStyle("-fx-background-color: " + this.activeConfig.getColors().getPrimary());
        button.setOnMouseClicked(mouseEvent -> this.switchToCategoryView(category));
        button.setOnTouchPressed(touchEvent -> this.switchToCategoryView(category));
        this.mainMenuButtons.put(category, button);
        this.menuButtonsVBox.getChildren().add((Object)button);
        this.menuButtonsVBox.setStyle("-fx-background-color: " + this.mainBackgroundColor + ";");
    }

    private void switchToCategoryView(int categoryId) {
        List<Product> products;
        Category category = this.categoryService.findById(Integer.valueOf(categoryId));
        this.categoryTitle.setText(category.getName());
        this.removeAllChildren((Pane)this.products_tilePane);
        Iterator iterator = this.mainMenuButtons.keySet().iterator();
        while (iterator.hasNext()) {
            int cat = (Integer)iterator.next();
            if (cat == categoryId) {
                ((Button)this.mainMenuButtons.get(cat)).setStyle("-fx-background-color: " + this.activeConfig.getColors().getPrimary());
                ((Button)this.mainMenuButtons.get(cat)).getStyleClass().add((Object)"selected");
                continue;
            }
            ((Button)this.mainMenuButtons.get(cat)).setStyle("-fx-background-color: " + this.activeConfig.getColors().getPrimaryHover());
            ((Button)this.mainMenuButtons.get(cat)).getStyleClass().remove((Object)"selected");
        }
        if (this.activeConfig.isAlwaysFetchFromDB()) {
            products = this.productService.findEnabledByCategory(categoryId);
            products.sort((Comparator<Product>)new ProductIdComparator());
        } else {
            products = this.activeConfig.getCurrentOffer().getProducts().stream().filter(p -> p.getCategory() == categoryId).sorted((Comparator<Product>)new ProductIdComparator()).toList();
        }
        for (Product product : products) {
            if (!product.isEnabled()) continue;
            this.products_tilePane.getChildren().add((Object)this.createProductTile(product));
        }
    }

    private Node getProductImageViewClip(ImageView imageView, double radiusTopLeft, double radiusTopRight) {
        double height = imageView.getFitHeight();
        double width = imageView.getFitWidth();
        double radius1 = height * radiusTopLeft;
        double radius2 = height * radiusTopRight;
        double radius3 = height;
        double radius4 = height;
        Path clip = new Path(new PathElement[]{new MoveTo(0.0, radius1), new ArcTo(radius1, radius1, 0.0, radius1, 0.0, false, true), new HLineTo(width - radius2), new ArcTo(radius2, radius2, 0.0, width, radius2, false, true), new VLineTo(radius4), new HLineTo(radius3)});
        clip.setFill((Paint)Color.ALICEBLUE);
        return clip;
    }

    public VBox createProductTile(Product product) {
        int tileWidth = 325;
        int tileHeight = 325;
        int tileCornerRadius = 50;
        int borderWidth = 0;
        int nameLabelHeight = 30;
        int buttonHeight = 30;
        int internalTileWidth = tileWidth - 2 * borderWidth;
        int internalTileHeight = tileHeight - 2 * borderWidth;
        double imageViewFitHeight = (double)internalTileHeight * 0.6;
        double imageViewFitWidth = (double)internalTileWidth * 1.0;
        double nameLabelTopAnchor = imageViewFitHeight + 5.0;
        double imageBottomAnchor = (double)internalTileHeight - imageViewFitHeight;
        int buttonWidth = tileWidth / 3;
        VBox vBox = new VBox(5.0);
        vBox.setMinSize((double)tileWidth, (double)tileHeight);
        vBox.setMaxSize((double)tileWidth, (double)tileHeight);
        vBox.setStyle("-fx-border-color:  lightgray;\n  -fx-border-width: " + borderWidth + "px;\n  -fx-border-style: solid;\n  -fx-border-radius: " + tileCornerRadius + "px;\n  -fx-background-radius: " + tileCornerRadius + "px;");
        vBox.getStyleClass().add((Object)"product-vbox");
        AnchorPane anchorPane = new AnchorPane();
        anchorPane.setMaxSize((double)internalTileWidth, (double)internalTileHeight);
        anchorPane.setMinSize((double)internalTileWidth, (double)internalTileHeight);
        InputStream is = ResourceHelper.getImageAsStream((String)product.getImageFilePath());
        Image fullImage = new Image(is);
        ImageView productImageView = ImageUtils.getCroppedImageView((Image)fullImage, (double)imageViewFitWidth, (double)imageViewFitHeight);
        productImageView.setPreserveRatio(true);
        productImageView.setFitWidth(imageViewFitWidth);
        productImageView.setFitHeight(imageViewFitHeight);
        productImageView.setClip((Node)ImageUtils.round((ImageView)productImageView, (double)tileCornerRadius, (double)tileCornerRadius, (double)0.0, (double)0.0));
        StackPane stackPane = new StackPane();
        stackPane.setAlignment(Pos.CENTER);
        AnchorPane.setTopAnchor((Node)stackPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)stackPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)stackPane, (Double)0.0);
        stackPane.getChildren().add((Object)productImageView);
        if (product.isVegetarian()) {
            ImageView vegetarianIconImageView = ResourceHelper.getImageViewFromResourceName((String)"/resources/images/vegetarian_128.png");
            vegetarianIconImageView.setFitWidth(80.0);
            vegetarianIconImageView.setFitHeight(80.0);
            stackPane.getChildren().add((Object)vegetarianIconImageView);
            StackPane.setAlignment((Node)vegetarianIconImageView, (Pos)Pos.BOTTOM_RIGHT);
            StackPane.setMargin((Node)vegetarianIconImageView, (Insets)LayoutUtils.getInsets((double)0.0, (double)10.0, (double)2.0, (double)0.0));
        }
        Label nameLabel = new Label(product.getShortName());
        nameLabel.setFont(this.productTitleFont);
        nameLabel.setWrapText(true);
        nameLabel.setAlignment(Pos.TOP_CENTER);
        nameLabel.setTextAlignment(TextAlignment.CENTER);
        AnchorPane.setTopAnchor((Node)nameLabel, (Double)nameLabelTopAnchor);
        AnchorPane.setLeftAnchor((Node)nameLabel, (Double)2.0);
        AnchorPane.setRightAnchor((Node)nameLabel, (Double)2.0);
        AnchorPane.setBottomAnchor((Node)nameLabel, (Double)39.0);
        Button infoButton = LayoutUtils.createCircleButton((double)20.0, (String)"/resources/images/info_32.png");
        infoButton.setAlignment(Pos.CENTER);
        infoButton.setOnMouseClicked(mouseEvent -> {
            this.productDetailPopup = new ProductDetailPopup(this);
            this.productDetailPopup.loadPopup(product);
            mouseEvent.consume();
        });
        infoButton.setOnTouchPressed(touchEvent -> {
            this.productDetailPopup = new ProductDetailPopup(this);
            this.productDetailPopup.loadPopup(product);
            touchEvent.consume();
        });
        Label amountLabel = new Label();
        if (product.getAmountValue() != null && product.getAmountUnit() != null && !product.getAmountUnit().isEmpty()) {
            amountLabel.setText(FormatUtils.formatCurrency((double)product.getAmountValue()) + " " + product.getAmountUnit());
            amountLabel.setFont(this.priceLabelFont);
            AnchorPane.setLeftAnchor((Node)amountLabel, (Double)80.0);
            AnchorPane.setRightAnchor((Node)amountLabel, (Double)80.0);
            AnchorPane.setBottomAnchor((Node)amountLabel, (Double)10.0);
        }
        Label priceLabel = new Label();
        priceLabel.setText(FormatUtils.formatCurrency((double)product.getActualPrice(), (String)this.activeConfig.getKioskInfo().getCurrency().getSymbol(this.activeConfig.getSelectedLocale())));
        priceLabel.setFont(this.priceLabelFont);
        priceLabel.setAlignment(Pos.CENTER_RIGHT);
        StackPane layeredPane = new StackPane();
        layeredPane.setPadding(LayoutUtils.getInsets((double)0.0, (double)25.0, (double)10.0, (double)25.0));
        layeredPane.setPrefWidth((double)tileWidth);
        layeredPane.setAlignment(Pos.CENTER);
        HBox labelRow = new HBox();
        labelRow.setAlignment(Pos.CENTER);
        labelRow.setSpacing(0.0);
        labelRow.prefWidthProperty().bind((ObservableValue)layeredPane.widthProperty());
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        labelRow.getChildren().addAll((Object[])new Node[]{amountLabel, spacer, priceLabel});
        StackPane buttonWrapper = new StackPane(new Node[]{infoButton});
        buttonWrapper.setAlignment(Pos.CENTER);
        layeredPane.getChildren().addAll((Object[])new Node[]{labelRow, buttonWrapper});
        AnchorPane.setBottomAnchor((Node)layeredPane, (Double)0.0);
        anchorPane.getChildren().addAll((Object[])new Node[]{stackPane, nameLabel, layeredPane});
        vBox.getChildren().add((Object)anchorPane);
        vBox.setAlignment(Pos.CENTER);
        vBox.setOnMouseClicked(mouseEvent -> this.handleProductSelection(product));
        return vBox;
    }

    private void run() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                Platform.runLater(() -> {
                    long timeSinceLastPress = System.currentTimeMillis() - lastPressTime;
                    timeToTimeout.set((long)resetInterval * 1000L - timeSinceLastPress);
                    if (timeToTimeout.get() < 1L && !this.welcomeMainAnchorPane.isVisible()) {
                        this.resetToMainScene();
                        lastPressTime = System.currentTimeMillis();
                    }
                    if (this.welcomeMainAnchorPane.isVisible()) {
                        this.screensaverService.execute(timeSinceLastPress);
                    }
                });
                TimeUnit.SECONDS.sleep(2L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void handleProductSelection(Product product) {
        if (this.activeConfig.getIceCreamCategoryId() == product.getCategory()) {
            if (ValidationUtils.isListNotNullOrEmpty((List)product.getProductFreeVariantCategories())) {
                this.createIceCreamPopup(product);
            } else {
                this.addProductToOrder(product);
            }
        } else {
            List<Object> variants;
            List<MenuOption> menuOptions;
            if (this.activeConfig.isAlwaysFetchFromDB()) {
                menuOptions = this.menuOptionService.findByMainProduct(product).stream().filter(MenuOption::isEnabled).toList();
                variants = this.productVariantService.findByProductId(product.getId()).stream().filter(ProductVariant::isEnabled).toList();
            } else {
                menuOptions = this.activeConfig.getCurrentOffer().getMenuOptions().stream().filter(m -> m.getMainProduct().getId().equals(product.getId())).filter(MenuOption::isEnabled).toList();
                variants = new ArrayList();
            }
            if (!variants.isEmpty()) {
                this.createVariantSelectionPopup(product);
            } else if (!menuOptions.isEmpty()) {
                this.createMenuOptionPopup(menuOptions);
            } else {
                this.addProductToOrder(product);
            }
        }
    }

    private void createVariantSelectionPopup(Product product) {
        this.variantSelectionPopup.loadPopup(product);
    }

    public void refreshVariantSelectionPopup() {
        this.isPopupOpen.unbind();
        this.variantSelectionPopup = new VariantSelectionPopup(this);
        this.isPopupOpen.bind((ObservableValue)this.menuOptionPopup.showingProperty().or((ObservableBooleanValue)this.variantSelectionPopup.showingProperty()));
    }

    private void createMenuOptionPopup(List<MenuOption> menuOptions) {
        this.menuOptionPopup.loadPopup(menuOptions);
    }

    private void createIceCreamPopup(Product product) {
        this.iceCreamPopup.loadPopup(product);
    }

    public void refreshMenuOptionsPopup() {
        this.isPopupOpen.unbind();
        this.menuOptionPopup = new MenuOptionPopup(this);
        this.isPopupOpen.bind((ObservableValue)this.menuOptionPopup.showingProperty().or((ObservableBooleanValue)this.variantSelectionPopup.showingProperty()).or((ObservableBooleanValue)this.iceCreamPopup.showingProperty()));
    }

    public void refreshIceCreamPopup() {
        this.isPopupOpen.unbind();
        this.iceCreamPopup = new IceCreamPopup(this);
        this.isPopupOpen.bind((ObservableValue)this.menuOptionPopup.showingProperty().or((ObservableBooleanValue)this.variantSelectionPopup.showingProperty()).or((ObservableBooleanValue)this.iceCreamPopup.showingProperty()));
    }

    public void addProductToOrder(Product product) {
        OrderItem orderItem = new OrderItem(product);
        this.runCartAnimation();
        this.addOrderItemToOrder(orderItem);
    }

    public void addVariantToOrder(Product product, ProductVariant productVariant) {
        OrderItem orderItem = new OrderItem(product, productVariant);
        this.runCartAnimation();
        this.addOrderItemToOrder(orderItem);
    }

    public void addOrderItemToOrder(OrderItem orderItem) {
        this.activeConfig.getCurrentOrder().addOrderItem(orderItem);
        this.runCartAnimation();
        this.refreshOrderOverview();
    }

    private void removeButtonAction(OrderItem orderItem) {
        this.activeConfig.getCurrentOrder().removeOrderItem(orderItem);
        this.refreshOrderOverview();
    }

    private void refreshOrderOverview() {
        this.removeAllChildren((Pane)this.orderOverview_vBox);
        List orderItems = this.activeConfig.getCurrentOrder().getOrderItems();
        if (!orderItems.isEmpty()) {
            Label label = new Label(this.strings.getString("main.label.yourCart"));
            label.setFont(this.subtitleFont);
            this.orderOverview_vBox.getChildren().add((Object)label);
        }
        for (OrderItem orderItem : this.activeConfig.getCurrentOrder().getOrderItems()) {
            HBox hBoxItem = this.createCartHBox(orderItem);
            this.orderOverview_vBox.getChildren().add((Object)hBoxItem);
        }
        Platform.runLater(() -> {
            if (this.orderOverview_vBox.getHeight() <= this.orderOverview_vBox.getMaxHeight()) {
                this.bottomScrollPane.setMinHeight(this.orderOverview_vBox.getHeight());
                this.topHBox.setMaxHeight((double)this.activeConfig.getDisplayConfig().getResolution().getHeight() - this.orderOverview_vBox.getHeight() - 80.0);
            } else {
                this.bottomScrollPane.setMinHeight(this.orderOverview_vBox.getMaxHeight());
                this.topHBox.setMaxHeight((double)this.activeConfig.getDisplayConfig().getResolution().getHeight() - this.orderOverview_vBox.getMaxHeight() - 80.0);
            }
            this.bottomScrollPane.setVvalue(1.0);
            if (!orderItems.isEmpty()) {
                this.orderOverview_vBox.setPadding(LayoutUtils.getInsets((double)0.0, (double)0.0, (double)10.0, (double)0.0));
            } else {
                this.bottomScrollPane.setMinHeight(0.0);
                this.topHBox.setMaxHeight(1789.0);
            }
        });
    }

    @FXML
    private void activeFinishOrder_button() throws IOException {
        this.switchToCartScene();
    }

    @FXML
    private void activeCancelOrder_button() throws IOException {
        this.cancelConfirmationPopup.loadPopup();
    }

    public void cancelOrder() {
        this.activeConfig.setCurrentOrder(new Order());
        this.refreshOrderOverview();
        this.switchToCategoryView(1);
        this.welcomeMainAnchorPane.setVisible(true);
    }

    private HBox createCartHBox(OrderItem orderItem) {
        Label addItemLabel;
        double hBoxWidth = this.orderOverview_vBox.getPrefWidth() * 0.95;
        double hBoxHeight = 75.0;
        double removeWidth = hBoxWidth * 0.025;
        double labelWidth = hBoxWidth * 0.5;
        double imageWidth = hBoxWidth * 0.15;
        double imageHeight = hBoxHeight;
        double quantityWidth = hBoxWidth * 0.15;
        double priceWidth = hBoxWidth * 0.1;
        Label label = new Label(orderItem.getDisplayName());
        label.setFont(this.cartProductTitleFont);
        label.setWrapText(true);
        VBox labelVBox = new VBox();
        labelVBox.setMinWidth(labelWidth);
        labelVBox.setPrefWidth(labelWidth);
        labelVBox.setAlignment(Pos.CENTER_LEFT);
        labelVBox.getChildren().add((Object)label);
        for (Product addItem : orderItem.getAdditionalProducts()) {
            addItemLabel = new Label("     - " + addItem.getName());
            addItemLabel.setFont(this.cartAddItemsLabelFont);
            addItemLabel.setWrapText(true);
            labelVBox.getChildren().add((Object)addItemLabel);
        }
        for (ProductFreeVariant freeVariant : orderItem.getFreeVariants()) {
            addItemLabel = new Label("     - " + freeVariant.getName());
            addItemLabel.setFont(this.cartAddItemsLabelFont);
            addItemLabel.setWrapText(true);
            labelVBox.getChildren().add((Object)addItemLabel);
        }
        Label totalItemsPrice = new Label();
        totalItemsPrice.setPrefWidth(priceWidth);
        totalItemsPrice.setMinWidth(priceWidth);
        totalItemsPrice.setAlignment(Pos.CENTER_RIGHT);
        totalItemsPrice.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> FormatUtils.formatCurrency((double)(orderItem.getFinalPrice() * (double)orderItem.getQuantity()), (String)this.activeConfig.getKioskInfo().getCurrency().getSymbol(this.activeConfig.getSelectedLocale())), (Observable[])new Observable[]{orderItem.finalPriceProperty(), orderItem.quantityProperty()}));
        totalItemsPrice.setFont(this.priceLabelFont);
        InputStream is = ResourceHelper.getImageAsStream((String)orderItem.getMainProduct().getImageFilePath());
        Image image = new Image(is);
        ImageView imageView = new ImageView(image);
        imageView.setPreserveRatio(true);
        imageView.setFitWidth(imageWidth);
        imageView.setFitHeight(imageHeight);
        ImageUtils.centerImage((ImageView)imageView);
        Button removeButton = LayoutUtils.createCircleButton((double)20.0, (String)"/resources/images/red_cross.png");
        removeButton.setAlignment(Pos.CENTER);
        removeButton.setOnMouseClicked(mouseEvent -> this.removeButtonAction(orderItem));
        removeButton.setOnTouchPressed(mouseEvent -> this.removeButtonAction(orderItem));
        Button decreaseButton = LayoutUtils.createCircleButton((double)20.0, (String)"/resources/images/minus.png");
        decreaseButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> orderItem.getQuantity() < 2, (Observable[])new Observable[]{orderItem.quantityProperty()}));
        decreaseButton.setOnMouseClicked(mouseEvent -> orderItem.decreaseQuantity());
        decreaseButton.setOnTouchPressed(touchEvent -> orderItem.decreaseQuantity());
        Button increaseButton = LayoutUtils.createCircleButton((double)20.0, (String)"/resources/images/plus.png");
        increaseButton.setOnMouseClicked(mouseEvent -> orderItem.increaseQuantity());
        increaseButton.setOnTouchPressed(touchEvent -> orderItem.increaseQuantity());
        Label countLabel = new Label();
        countLabel.setPadding(LayoutUtils.getInsets((double)0.0, (double)10.0, (double)0.0, (double)10.0));
        countLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> FormatUtils.getQuantityLabel((int)orderItem.getQuantity()), (Observable[])new Observable[]{orderItem.quantityProperty()}));
        countLabel.setFont(this.cartQuantityLabelFont);
        HBox quantityHBox = new HBox();
        quantityHBox.setMinWidth(quantityWidth);
        quantityHBox.setPrefWidth(quantityWidth);
        quantityHBox.setMaxWidth(quantityWidth);
        quantityHBox.setAlignment(Pos.CENTER_RIGHT);
        quantityHBox.getChildren().addAll((Object[])new Node[]{decreaseButton, countLabel, increaseButton});
        HBox orderItemHBox = new HBox(20.0);
        orderItemHBox.setPrefWidth(hBoxWidth);
        orderItemHBox.setMaxWidth(hBoxWidth);
        orderItemHBox.setMinWidth(hBoxWidth);
        orderItemHBox.setAlignment(Pos.CENTER);
        orderItemHBox.getStyleClass().add((Object)"orderItemHBox");
        orderItemHBox.setPadding(LayoutUtils.getInsets((double)0.0, (double)5.0, (double)0.0, (double)5.0));
        HBox.setHgrow((Node)label, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)countLabel, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)imageView, (Priority)Priority.NEVER);
        orderItemHBox.minHeightProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> Math.max(labelVBox.getHeight(), imageView.getFitHeight()), (Observable[])new Observable[]{labelVBox.heightProperty(), imageView.fitHeightProperty()}));
        orderItemHBox.getChildren().addAll((Object[])new Node[]{removeButton, imageView, labelVBox, quantityHBox, totalItemsPrice});
        return orderItemHBox;
    }

    public BooleanProperty getOverrideMainDisableProperty() {
        return this.overrideMainDisableProperty;
    }
}

