/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka;

import cz.polreich.spagetka.DTO.AllergenDTO;
import cz.polreich.spagetka.DTO.AttendanceLogItemDTO;
import cz.polreich.spagetka.DTO.BranchStateItemDTO;
import cz.polreich.spagetka.DTO.CategoryDTO;
import cz.polreich.spagetka.DTO.CustomerDetailsDTO;
import cz.polreich.spagetka.DTO.IngredientDTO;
import cz.polreich.spagetka.DTO.MenuOptionDTO;
import cz.polreich.spagetka.DTO.OrderDTO;
import cz.polreich.spagetka.DTO.ProductDTO;
import cz.polreich.spagetka.DTO.ProductStatusItemDTO;
import cz.polreich.spagetka.DTO.ProductsGroupDTO;
import cz.polreich.spagetka.DTO.ReceiptDTO;
import cz.polreich.spagetka.DTO.SmsMessageDTO;
import cz.polreich.spagetka.DTO.StockItemDTO;
import cz.polreich.spagetka.DTO.discountCodes.DiscountCodeCreateRequest;
import cz.polreich.spagetka.DTO.discountCodes.DiscountCodeCreateResponse;
import cz.polreich.spagetka.DTO.discountCodes.DiscountCodeForClubRequest;
import cz.polreich.spagetka.DTO.discountCodes.DiscountCodeForClubResponse;
import cz.polreich.spagetka.DTO.discountCodes.DiscountCodeUsageRequest;
import cz.polreich.spagetka.DTO.discountCodes.DiscountCodeVerifyRequest;
import cz.polreich.spagetka.DTO.discountCodes.DiscountCodeVerifyResponse;
import cz.polreich.spagetka.DTO.discountCodes.DiscountCodesCustomerRequest;
import cz.polreich.spagetka.DTO.discountCodes.DiscountCodesCustomerResponse;
import cz.polreich.spagetka.DTO.monitoring.MonitoringDataDto;
import cz.polreich.spagetka.HttpRequestExecutor;
import cz.polreich.spagetka.models.SmsMessage;
import cz.polreich.spagetka.models.config.RestClientConfig;
import cz.polreich.spagetka.models.enums.DISCOUNT_CODE_TYPE;
import cz.polreich.spagetka.models.external.InfoExternal;
import cz.polreich.spagetka.models.external.UserExternal;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.PasswordDecryptor;
import cz.polreich.spagetka.utils.ResourceHelper;
import cz.polreich.spagetka.utils.RestClientUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.util.Pair;
import org.springframework.boot.web.client.ClientHttpRequestFactories;
import org.springframework.boot.web.client.ClientHttpRequestFactorySettings;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestClient;

/*
 * Exception performing whole class analysis ignored.
 */
public class PartnerServerRestClient {
    private final RestClient client;
    private final String baseUrl;
    private final HttpRequestExecutor httpRequestExecutor;

    public PartnerServerRestClient(RestClientConfig config) {
        this.baseUrl = config.getBaseUrl();
        String baseApiUrl = this.baseUrl + config.getApiPath();
        String apiKey = PasswordDecryptor.decryptPassword((String)config.getEncAPIKey());
        this.client = RestClientUtils.createRestClient((String)baseApiUrl, (Pair)new Pair((Object)"X-API-KEY", (Object)apiKey), (ClientHttpRequestFactory)PartnerServerRestClient.customRequestFactory((int)5000, (int)5000));
        this.httpRequestExecutor = new HttpRequestExecutor(this.client);
    }

    public boolean isPartnerWebAvailable() {
        return this.httpRequestExecutor.ping();
    }

    public List<ProductDTO> getProducts() {
        return (List)this.httpRequestExecutor.getRequestWithResponseBody("/products", (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<CategoryDTO> getCategories() {
        return (List)this.httpRequestExecutor.getRequestWithResponseBody("/categories", (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<ProductsGroupDTO> getProductsGroups() {
        return (List)this.httpRequestExecutor.getRequestWithResponseBody("/productsGroups", (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<MenuOptionDTO> getMenuOptions() {
        return (List)this.httpRequestExecutor.getRequestWithResponseBody("/menuOptions", (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public InfoExternal getInfo() {
        return (InfoExternal)this.httpRequestExecutor.getRequestWithResponseBody("/info", (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<UserExternal> getUsers() {
        return (List)this.httpRequestExecutor.getRequestWithResponseBody("/users", (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<IngredientDTO> getIngredients() {
        return (List)this.httpRequestExecutor.getRequestWithResponseBody("/ingredients", (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<AllergenDTO> getAllergens() {
        return (List)this.httpRequestExecutor.getRequestWithResponseBody("/allergens", (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public StockItemDTO getStockItemDetails(String qrcode) {
        StockItemDTO data = (StockItemDTO)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.client.post().uri("/stockItemDetail", new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body((Object)("{\"qrcode\": \"" + qrcode + "\"}")).retrieve().body((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return data;
    }

    public void sendOrder(OrderDTO orderDTO) {
        this.httpRequestExecutor.getRequestWithRetry("/orders", (Object)orderDTO, orderDTO.getId(), 10);
    }

    public void sendOrders(List<OrderDTO> ordersDTO) {
        this.httpRequestExecutor.getRequestWithRetry("/orders", ordersDTO, ordersDTO.stream().map(OrderDTO::getId).collect(Collectors.joining(", ")), 10);
    }

    public void sendAttendanceLogItem(AttendanceLogItemDTO attendanceLogItemDTO) {
        this.httpRequestExecutor.getRequestWithRetry("/attendanceLogs", (Object)attendanceLogItemDTO, attendanceLogItemDTO.getId(), 10);
    }

    public void sendAttendanceLogItems(List<AttendanceLogItemDTO> attendanceLogItemsDTO) {
        this.httpRequestExecutor.getRequestWithRetry("/attendanceLogs", attendanceLogItemsDTO, attendanceLogItemsDTO.stream().map(AttendanceLogItemDTO::getId).collect(Collectors.joining(", ")), 10);
    }

    public DiscountCodeCreateResponse requestDiscountCodeCreation(double amount, String phoneNumber) {
        return this.requestDiscountCodeCreation(new DiscountCodeCreateRequest(amount, phoneNumber));
    }

    public DiscountCodeCreateResponse requestDiscountCodeCreation(DiscountCodeCreateRequest codeCreateRequest) {
        return (DiscountCodeCreateResponse)this.httpRequestExecutor.postRequestWithResponseBodyAndRetry("/discount/create", (Object)codeCreateRequest, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, 3);
    }

    public DiscountCodeVerifyResponse verifyDiscountCodeValidity(String discountCode, String phoneNumber) {
        return this.verifyDiscountCodeValidity(new DiscountCodeVerifyRequest(discountCode, phoneNumber));
    }

    public DiscountCodeVerifyResponse verifyDiscountCodeValidity(DiscountCodeVerifyRequest codeVerifyRequest) {
        try {
            return (DiscountCodeVerifyResponse)this.httpRequestExecutor.postRequestWithResponseBodyAndRetry("/discount/verify", (Object)codeVerifyRequest, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, 3);
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
            return new DiscountCodeVerifyResponse(true, 10.0, DISCOUNT_CODE_TYPE.COMPLIMENTARY_PERCENTAGE, "99 - Web service unreachable");
        }
    }

    public void notifyAboutDiscountCodeUsage(String discountCode, String orderId) {
        this.notifyAboutDiscountCodeUsage(new DiscountCodeUsageRequest(discountCode, orderId));
    }

    public void notifyAboutDiscountCodeUsage(DiscountCodeUsageRequest codeUsageRequest) {
        this.httpRequestExecutor.postRequestWithRetry("/discount/usage", (Object)codeUsageRequest, 3);
    }

    public DiscountCodeForClubResponse requestCodeCreationForClub(String phoneNumber) {
        return this.requestCodeCreationForClub(new DiscountCodeForClubRequest(phoneNumber));
    }

    public DiscountCodeForClubResponse requestCodeCreationForClub(DiscountCodeForClubRequest codeForClubRequest) {
        return (DiscountCodeForClubResponse)this.httpRequestExecutor.postRequestWithResponseBodyAndRetry("/discount/create_for_club", (Object)codeForClubRequest, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, 3);
    }

    public void sendReceipt(ReceiptDTO receiptDTO) {
        ArrayList<ReceiptDTO> list = new ArrayList<ReceiptDTO>();
        list.add(receiptDTO);
        this.httpRequestExecutor.postRequestWithRetry("/receipts", list, 3);
    }

    public void sendReceipts(List<ReceiptDTO> receiptsDTO) {
        this.httpRequestExecutor.postRequestWithRetry("/receipts", receiptsDTO, 3);
    }

    public void sendMonitoringData(MonitoringDataDto monitoringDataDto) {
        this.httpRequestExecutor.postRequestWithRetry("/info/monitoring", (Object)monitoringDataDto, 5);
    }

    public void sendBranchStatusUpdate(BranchStateItemDTO branchStateItemDTO) {
        this.httpRequestExecutor.postRequestWithRetry("/branch/changestate", (Object)branchStateItemDTO, 5);
    }

    public void sendProductStatusUpdate(ProductStatusItemDTO productStatusItemDTO) {
        this.httpRequestExecutor.postRequestWithRetry("/products/changestate", (Object)productStatusItemDTO, 5);
    }

    public void sendSmsMessage(SmsMessageDTO smsMessageDTO) {
        this.httpRequestExecutor.postRequestWithRetry("/communicate", (Object)smsMessageDTO, 3);
    }

    public void sendSmsMessage(String phoneNumber, String message) {
        new Thread(() -> this.httpRequestExecutor.postRequestWithRetry("/communicate", (Object)new SmsMessageDTO(new SmsMessage(phoneNumber, message)), 3)).start();
    }

    public List<DiscountCodesCustomerResponse> getUsableValidDiscountCodesForCustomer(DiscountCodesCustomerRequest request) {
        return (List)this.httpRequestExecutor.postRequestWithResponseBodyAndRetry("/discount/customer", (Object)request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, 3);
    }

    public List<DiscountCodesCustomerResponse> getUsableValidDiscountCodesForCustomer(String phoneNumber) {
        return (List)this.httpRequestExecutor.postRequestWithResponseBodyAndRetry("/discount/customer", (Object)new DiscountCodesCustomerRequest(phoneNumber, true, true), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, 3);
    }

    public CustomerDetailsDTO getCustomerDetails(String phoneNumber) {
        Map<String, String> body = Map.of("phoneNumber", phoneNumber);
        return (CustomerDetailsDTO)this.httpRequestExecutor.postRequestWithResponseBody("/customer/details", body, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void queryTestServer() {
        this.httpRequestExecutor.postRequestWithRetry("/slow", Map.of("key", "value"), 10);
    }

    public void downloadResource(String relativeRemotePath) {
        this.downloadResource(relativeRemotePath, null);
    }

    public void downloadResource(String relativeRemotePath, String localPath) {
        if (!((String)relativeRemotePath).startsWith("/")) {
            relativeRemotePath = "/" + (String)relativeRemotePath;
        }
        String remotePath = this.baseUrl + (String)relativeRemotePath;
        int index = ((String)relativeRemotePath).lastIndexOf("/");
        String fileName = ((String)relativeRemotePath).substring(index + 1);
        if (!fileName.trim().isEmpty()) {
            Object finalLocalLocation = "";
            finalLocalLocation = localPath == null ? ResourceHelper.getBaseLocation() + "resources/images/" + fileName : localPath;
            File file = new File((String)finalLocalLocation);
            if (file.exists()) {
                System.out.println("Image: " + (String)finalLocalLocation + " already exists");
            } else {
                try {
                    ReadableByteChannel readableByteChannel = Channels.newChannel(new URL(remotePath).openStream());
                    FileOutputStream fileOutputStream = new FileOutputStream((String)finalLocalLocation);
                    FileChannel fileChannel = fileOutputStream.getChannel();
                    fileChannel.transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                }
                catch (IOException e) {
                    ExceptionHandler.logException((Exception)e);
                }
            }
        }
    }

    public <T> T createInstanceWithParams(Class<T> clazz, Object ... params) {
        try {
            Class[] paramTypes = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                paramTypes[i] = params[i].getClass();
            }
            Constructor<T> constructor = clazz.getConstructor(paramTypes);
            return constructor.newInstance(params);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error creating instance with specific constructor", e);
        }
    }

    private static ClientHttpRequestFactory customRequestFactory(int connectTimeoutMillis, int readTimeoutMillis) {
        ClientHttpRequestFactorySettings settings = ClientHttpRequestFactorySettings.DEFAULTS.withConnectTimeout(Duration.ofMillis(connectTimeoutMillis)).withReadTimeout(Duration.ofMillis(readTimeoutMillis));
        return ClientHttpRequestFactories.get((ClientHttpRequestFactorySettings)settings);
    }
}

