/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.DTO;

import cz.polreich.spagetka.DTO.ReceiptItemDTO;
import cz.polreich.spagetka.DTO.VatAmountDTO;
import cz.polreich.spagetka.models.Receipt;
import cz.polreich.spagetka.models.enums.PAYMENT_METHOD;
import cz.polreich.spagetka.utils.CalcUtils;
import java.math.BigDecimal;
import java.util.List;

public class ReceiptDTO {
    private String id;
    private String orderId;
    private List<String> header;
    private String dateTime;
    private String location;
    private List<ReceiptItemDTO> receiptItems;
    private Double totalAmount;
    private Double totalAmountAfterRounding;
    private Double baseAmount;
    private Double vatAmount;
    private List<VatAmountDTO> vatAmounts;
    private String footer;
    private PAYMENT_METHOD paymentMethod;
    private int userCreatedId;

    public ReceiptDTO(Receipt receipt) {
        this.id = receipt.getId();
        this.orderId = receipt.getOrderId();
        this.header = receipt.getHeader();
        this.dateTime = receipt.getDateTime().toString();
        this.location = receipt.getLocation();
        this.receiptItems = receipt.getReceiptItems().stream().map(ReceiptItemDTO::new).toList();
        this.totalAmount = CalcUtils.toDouble((BigDecimal)receipt.getTotalAmount());
        this.totalAmountAfterRounding = CalcUtils.toDouble((BigDecimal)receipt.getTotalAmountAfterRounding());
        this.baseAmount = CalcUtils.toDouble((BigDecimal)receipt.getBaseAmount());
        this.vatAmount = CalcUtils.toDouble((BigDecimal)receipt.getVatAmount());
        this.vatAmounts = receipt.getVatAmounts().stream().map(VatAmountDTO::new).toList();
        this.footer = receipt.getFooter();
        this.paymentMethod = receipt.getPaymentMethod();
        this.userCreatedId = receipt.getUserCreated() != null ? receipt.getUserCreated().getId() : -1;
    }

    public ReceiptDTO() {
    }

    public ReceiptDTO(String id, String orderId, List<String> header, String dateTime, String location, List<ReceiptItemDTO> receiptItems, Double totalAmount, Double totalAmountAfterRounding, Double baseAmount, Double vatAmount, List<VatAmountDTO> vatAmounts, String footer, PAYMENT_METHOD paymentMethod, int userCreatedId) {
        this.id = id;
        this.orderId = orderId;
        this.header = header;
        this.dateTime = dateTime;
        this.location = location;
        this.receiptItems = receiptItems;
        this.totalAmount = totalAmount;
        this.totalAmountAfterRounding = totalAmountAfterRounding;
        this.baseAmount = baseAmount;
        this.vatAmount = vatAmount;
        this.vatAmounts = vatAmounts;
        this.footer = footer;
        this.paymentMethod = paymentMethod;
        this.userCreatedId = userCreatedId;
    }

    public String getId() {
        return this.id;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public List<String> getHeader() {
        return this.header;
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public String getLocation() {
        return this.location;
    }

    public List<ReceiptItemDTO> getReceiptItems() {
        return this.receiptItems;
    }

    public Double getTotalAmount() {
        return this.totalAmount;
    }

    public Double getTotalAmountAfterRounding() {
        return this.totalAmountAfterRounding;
    }

    public Double getBaseAmount() {
        return this.baseAmount;
    }

    public Double getVatAmount() {
        return this.vatAmount;
    }

    public List<VatAmountDTO> getVatAmounts() {
        return this.vatAmounts;
    }

    public String getFooter() {
        return this.footer;
    }

    public PAYMENT_METHOD getPaymentMethod() {
        return this.paymentMethod;
    }

    public int getUserCreatedId() {
        return this.userCreatedId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public void setHeader(List<String> header) {
        this.header = header;
    }

    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setReceiptItems(List<ReceiptItemDTO> receiptItems) {
        this.receiptItems = receiptItems;
    }

    public void setTotalAmount(Double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public void setTotalAmountAfterRounding(Double totalAmountAfterRounding) {
        this.totalAmountAfterRounding = totalAmountAfterRounding;
    }

    public void setBaseAmount(Double baseAmount) {
        this.baseAmount = baseAmount;
    }

    public void setVatAmount(Double vatAmount) {
        this.vatAmount = vatAmount;
    }

    public void setVatAmounts(List<VatAmountDTO> vatAmounts) {
        this.vatAmounts = vatAmounts;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public void setPaymentMethod(PAYMENT_METHOD paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public void setUserCreatedId(int userCreatedId) {
        this.userCreatedId = userCreatedId;
    }
}

