/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import cz.polreich.spagetka.models.CountryPrefix;
import cz.polreich.spagetka.models.config.BaseConfig;
import cz.polreich.spagetka.models.config.CashierConfig;
import cz.polreich.spagetka.models.config.CommonConfig;
import cz.polreich.spagetka.models.config.CookConfig;
import cz.polreich.spagetka.models.config.CustomerConfig;
import cz.polreich.spagetka.utils.DebugUtils;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.ResourceHelper;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.image.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    @Value(value="${config.file.path}")
    @JsonIgnore
    private String configFilePath;
    @JsonProperty
    private CommonConfig common;
    @JsonProperty
    private CashierConfig cashier;
    @JsonProperty
    private CustomerConfig customer;
    @JsonProperty
    private CookConfig cook;
    @JsonIgnore
    public BaseConfig selectedConfig;
    @JsonIgnore
    public LocalDateTime successMonitoringReportTime;

    @PostConstruct
    public void loadConfig() {
        ObjectMapper objectMapper = new ObjectMapper();
        DebugUtils.printClasspath();
        if (this.configFilePath == null || this.configFilePath.isEmpty() || this.configFilePath.isBlank()) {
            ExceptionHandler.logException((Exception)new IOException("Config file path is not defined"));
            return;
        }
        try {
            Config loadedConfig = (Config)objectMapper.readValue(new File(this.configFilePath), Config.class);
            List prefixes = this.loadCountryPrefixes();
            loadedConfig.common.setCountryPrefixes(prefixes);
            this.setPropertiesFrom(loadedConfig);
        }
        catch (IOException e) {
            log.error("Failed to load configuration from file: {}", (Object)this.configFilePath, (Object)e);
            ExceptionHandler.logException((Exception)e);
        }
    }

    public void setCashierSelected() {
        this.setSelectedConfig((BaseConfig)this.cashier);
    }

    public void setCustomerSelected() {
        this.setSelectedConfig((BaseConfig)this.customer);
    }

    public void setCookSelected() {
        this.setSelectedConfig((BaseConfig)this.cook);
    }

    public void setSelectedConfig(BaseConfig selectedConfig) {
        this.selectedConfig = selectedConfig;
        if (this.common != null) {
            BeanUtils.copyProperties((Object)this.common, (Object)this.selectedConfig);
        }
    }

    public void setPropertiesFrom(Config source) {
        if (source == null) {
            return;
        }
        try {
            this.common = source.common;
            this.cashier = source.cashier;
            this.customer = source.customer;
            this.cook = source.cook;
            this.cashier.setRestClientConfig(this.common.getRestClientConfig());
            this.customer.setRestClientConfig(this.common.getRestClientConfig());
            this.cook.setRestClientConfig(this.common.getRestClientConfig());
            BeanUtils.copyProperties((Object)this.common, (Object)this.cashier);
            BeanUtils.copyProperties((Object)this.common, (Object)this.customer);
            BeanUtils.copyProperties((Object)this.common, (Object)this.cook);
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
    }

    private List<CountryPrefix> loadCountryPrefixes() {
        ObjectMapper objectMapper = new ObjectMapper();
        Collection countryPrefixDataList = null;
        InputStream resourceStream = ResourceHelper.getResourceAsStream((String)"/resources/countries.json");
        try {
            countryPrefixDataList = (List)objectMapper.readValue((Reader)new InputStreamReader(resourceStream), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            ExceptionHandler.logException((Exception)e);
        }
        if (countryPrefixDataList != null) {
            return countryPrefixDataList.stream().map(data -> new CountryPrefix(data.getCountry(), data.getPrefix(), new Image(ResourceHelper.getImageAsStream((String)("/resources/images/flags/" + data.getCountryCode() + ".png"))), data.getPattern())).collect(Collectors.toList());
        }
        return new ArrayList<CountryPrefix>();
    }

    @JsonIgnore
    public void setConfigFilePath(String configFilePath) {
        this.configFilePath = configFilePath;
    }

    public CommonConfig getCommon() {
        return this.common;
    }

    @JsonProperty
    public void setCommon(CommonConfig common) {
        this.common = common;
    }

    public CashierConfig getCashier() {
        return this.cashier;
    }

    @JsonProperty
    public void setCashier(CashierConfig cashier) {
        this.cashier = cashier;
    }

    public CustomerConfig getCustomer() {
        return this.customer;
    }

    @JsonProperty
    public void setCustomer(CustomerConfig customer) {
        this.customer = customer;
    }

    public CookConfig getCook() {
        return this.cook;
    }

    @JsonProperty
    public void setCook(CookConfig cook) {
        this.cook = cook;
    }

    public BaseConfig getSelectedConfig() {
        return this.selectedConfig;
    }

    public LocalDateTime getSuccessMonitoringReportTime() {
        return this.successMonitoringReportTime;
    }

    @JsonIgnore
    public void setSuccessMonitoringReportTime(LocalDateTime successMonitoringReportTime) {
        this.successMonitoringReportTime = successMonitoringReportTime;
    }
}

