/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.DTO.ProductFreeVariantDTO;
import cz.polreich.spagetka.utils.ResourceHelper;
import cz.polreich.spagetka.utils.ValidationUtils;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import javax.xml.bind.DatatypeConverter;

@Entity
@Table(name="ProductFreeVariants")
public class ProductFreeVariant {
    @Id
    private String id;
    @Column
    private String name;
    @Column
    private Double price;
    @Column
    private String imageFilePath;
    @Column
    private byte[] imageBytes;
    @Column
    private String remoteImagePath;
    @Column
    private boolean enabled;
    @Column(columnDefinition="int default 999")
    private int itemOrder = 999;

    public ProductFreeVariant(ProductFreeVariantDTO dto) {
        this.createFromDTO(dto, false);
    }

    public ProductFreeVariant(ProductFreeVariantDTO dto, boolean fromExternal) {
        this.createFromDTO(dto, fromExternal);
    }

    public void createFromDTO(ProductFreeVariantDTO dto, boolean fromExternal) {
        this.id = dto.getId();
        this.name = dto.getName();
        this.price = dto.getPrice();
        this.imageFilePath = fromExternal ? ResourceHelper.convertImagePathFromExternal((String)dto.getImageFilePath()) : dto.getImageFilePath();
        this.remoteImagePath = dto.getImageFilePath();
        this.imageBytes = ValidationUtils.isStringNotNullOrEmpty((String)dto.getImageBytesBase64()) ? DatatypeConverter.parseBase64Binary((String)dto.getImageBytesBase64()) : new byte[]{};
        this.enabled = Boolean.TRUE.equals(dto.getAllowedAtKiosk());
        this.itemOrder = dto.getOrder() != null ? dto.getOrder() : 999;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Double getPrice() {
        return this.price;
    }

    public String getImageFilePath() {
        return this.imageFilePath;
    }

    public byte[] getImageBytes() {
        return this.imageBytes;
    }

    public String getRemoteImagePath() {
        return this.remoteImagePath;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getItemOrder() {
        return this.itemOrder;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public void setImageFilePath(String imageFilePath) {
        this.imageFilePath = imageFilePath;
    }

    public void setImageBytes(byte[] imageBytes) {
        this.imageBytes = imageBytes;
    }

    public void setRemoteImagePath(String remoteImagePath) {
        this.remoteImagePath = remoteImagePath;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setItemOrder(int itemOrder) {
        this.itemOrder = itemOrder;
    }

    public ProductFreeVariant() {
    }

    public ProductFreeVariant(String id, String name, Double price, String imageFilePath, byte[] imageBytes, String remoteImagePath, boolean enabled, int itemOrder) {
        this.id = id;
        this.name = name;
        this.price = price;
        this.imageFilePath = imageFilePath;
        this.imageBytes = imageBytes;
        this.remoteImagePath = remoteImagePath;
        this.enabled = enabled;
        this.itemOrder = itemOrder;
    }
}

