/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.cashierController;

import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.models.Category;
import cz.polreich.spagetka.models.MenuOption;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.ProductFreeVariant;
import cz.polreich.spagetka.models.ProductVariant;
import cz.polreich.spagetka.models.ProductsGroup;
import cz.polreich.spagetka.models.enums.PAYMENT_METHOD;
import cz.polreich.spagetka.models.gui.buttons.CancelButton;
import cz.polreich.spagetka.models.gui.buttons.ConfirmButton;
import cz.polreich.spagetka.utils.FormatUtils;
import cz.polreich.spagetka.utils.LayoutUtils;
import java.util.Collection;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Popup;
import javafx.stage.Window;

public class NewOrderPopup
extends Popup {
    private CashierController cashierController;
    private AnchorPane popupAnchor;
    private FlowPane buttonsFlowPane;
    private Label titleLabel;
    private List<Category> categories;
    private List<Product> products;
    private List<MenuOption> menuOptions;
    private Order currentOrder = new Order();
    private MenuOption selectedMenuOption;
    private Button menuOptionConfirmButton;
    private VBox orderOverviewVBox;

    public NewOrderPopup(CashierController cashierController) {
        this.cashierController = cashierController;
        int popupWidth = 950;
        int popupHeight = 700;
        this.popupAnchor = new AnchorPane();
        this.popupAnchor.setMinWidth((double)popupWidth);
        this.popupAnchor.setMaxWidth((double)popupWidth);
        this.popupAnchor.setMinHeight((double)popupHeight);
        this.popupAnchor.setMaxHeight((double)popupHeight);
        this.popupAnchor.getStyleClass().add((Object)"login_anchor_pane");
        Label orderOverviewTitle = new Label("Objedn\u00e1vka");
        orderOverviewTitle.setFont(cashierController.titleFont);
        orderOverviewTitle.setMaxWidth(400.0);
        orderOverviewTitle.setMaxHeight(100.0);
        orderOverviewTitle.setAlignment(Pos.CENTER);
        AnchorPane.setTopAnchor((Node)orderOverviewTitle, (Double)0.0);
        AnchorPane.setRightAnchor((Node)orderOverviewTitle, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)orderOverviewTitle, (Double)0.0);
        this.orderOverviewVBox = new VBox();
        this.orderOverviewVBox.setPrefHeight(700.0);
        this.orderOverviewVBox.setMaxHeight(700.0);
        this.orderOverviewVBox.setMaxWidth(450.0);
        this.orderOverviewVBox.setPrefWidth(450.0);
        this.orderOverviewVBox.setStyle("-fx-background-color: gray");
        this.orderOverviewVBox.setSpacing(10.0);
        this.orderOverviewVBox.setPadding(LayoutUtils.getInsets((double)5.0, (double)2.0, (double)2.0, (double)5.0));
        AnchorPane.setTopAnchor((Node)this.orderOverviewVBox, (Double)100.0);
        AnchorPane.setRightAnchor((Node)this.orderOverviewVBox, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.orderOverviewVBox, (Double)0.0);
        this.titleLabel = new Label();
        this.titleLabel.setFont(cashierController.titleFont);
        this.titleLabel.setMaxWidth(500.0);
        this.titleLabel.setMaxHeight(100.0);
        this.titleLabel.setAlignment(Pos.CENTER);
        AnchorPane.setTopAnchor((Node)this.titleLabel, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.titleLabel, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.titleLabel, (Double)450.0);
        this.buttonsFlowPane = new FlowPane();
        this.buttonsFlowPane.setOrientation(Orientation.VERTICAL);
        this.buttonsFlowPane.setPrefHeight(600.0);
        this.buttonsFlowPane.setMaxHeight(600.0);
        this.buttonsFlowPane.setPrefWidth(490.0);
        this.buttonsFlowPane.setMaxWidth(490.0);
        this.buttonsFlowPane.setHgap(20.0);
        this.buttonsFlowPane.setVgap(20.0);
        AnchorPane.setTopAnchor((Node)this.buttonsFlowPane, (Double)100.0);
        AnchorPane.setLeftAnchor((Node)this.buttonsFlowPane, (Double)10.0);
        AnchorPane.setBottomAnchor((Node)this.buttonsFlowPane, (Double)0.0);
        this.currentOrder.orderItemsProperty().addListener((observable, oldValue, newValue) -> {
            this.refreshOrderOverviewBox();
            this.listenToQuantityChanges(newValue);
        });
        this.popupAnchor.getChildren().addAll((Object[])new Node[]{orderOverviewTitle, this.orderOverviewVBox, this.titleLabel, this.buttonsFlowPane});
        this.getContent().add((Object)this.popupAnchor);
    }

    private void listenToQuantityChanges(ObservableList<OrderItem> items) {
        for (OrderItem item : items) {
            item.quantityProperty().addListener((observable, oldValue, newValue) -> this.refreshOrderOverviewBox());
        }
    }

    public void loadPopup(List<Category> categories, List<Product> products, List<MenuOption> menuOptions) {
        this.categories = categories;
        this.products = products;
        this.menuOptions = menuOptions;
        this.titleLabel.setText("Kategorie");
        for (Category category : categories) {
            if (products.stream().filter(p -> p.getCategory() == category.getId() && p.isEnabled()).toList().isEmpty()) continue;
            Button button = this.createCategoryButton(category);
            button.setPrefHeight(100.0);
            this.buttonsFlowPane.getChildren().add((Object)button);
        }
        this.refreshOrderOverviewBox();
        this.show((Window)this.cashierController.stage);
    }

    private void refreshOrderOverviewBox() {
        this.clearOrderOverviewVBox();
        List orderItems = this.currentOrder.getOrderItems();
        for (OrderItem orderItem : orderItems) {
            HBox vbox = this.createOverviewItem(orderItem);
            this.orderOverviewVBox.getChildren().add((Object)vbox);
        }
        Region regionVBox = new Region();
        regionVBox.setPrefSize(1.0, 1.0);
        VBox.setVgrow((Node)regionVBox, (Priority)Priority.ALWAYS);
        HBox totalPriceHBox = new HBox();
        Label totalPriceLabel = new Label("Celkem");
        totalPriceLabel.setFont(this.cashierController.mainSceneButtonsFont);
        Region regionHBox = new Region();
        regionHBox.setPrefSize(1.0, 1.0);
        HBox.setHgrow((Node)regionHBox, (Priority)Priority.ALWAYS);
        Label totalPriceValue = new Label(FormatUtils.formatCurrency((double)this.currentOrder.getTotalPrice(), (String)this.cashierController.activeConfig.getKioskInfo().getCurrency().getSymbol(this.cashierController.activeConfig.getSelectedLocale())));
        totalPriceValue.setFont(this.cashierController.mainSceneButtonsFont);
        totalPriceHBox.setStyle("-fx-background-color: white");
        totalPriceHBox.getChildren().addAll((Object[])new Node[]{totalPriceLabel, regionHBox, totalPriceValue});
        HBox buttonsHBox = new HBox();
        buttonsHBox.setSpacing(50.0);
        CancelButton cancelButton = new CancelButton("Zru\u0161it");
        cancelButton.setFont(this.cashierController.mainSceneButtonsFont);
        cancelButton.setOnMouseClicked(mouseEvent -> this.cancelButtonAction());
        cancelButton.setOnTouchPressed(touchEvent -> this.cancelButtonAction());
        ConfirmButton completeButton = new ConfirmButton("Potvrdit");
        completeButton.setFont(this.cashierController.mainSceneButtonsFont);
        completeButton.setOnMouseClicked(mouseEvent -> this.completeOrderAction());
        completeButton.setOnTouchPressed(touchEvent -> this.completeOrderAction());
        buttonsHBox.getChildren().addAll((Object[])new Node[]{cancelButton, completeButton});
        this.orderOverviewVBox.getChildren().addAll((Object[])new Node[]{regionVBox, totalPriceHBox, buttonsHBox});
    }

    private void cancelButtonAction() {
        this.hidePopup();
    }

    private void completeOrderAction() {
        this.currentOrder.setPaymentMethod(PAYMENT_METHOD.CASH);
        String newId = this.cashierController.orderService.saveNewPersonalOrder(this.currentOrder);
        this.currentOrder.setId(newId);
        this.cashierController.confirmOrderPaid(this.currentOrder);
        this.hidePopup();
    }

    private HBox createOverviewItem(OrderItem orderItem) {
        HBox hBox = new HBox();
        Label titleLabel = new Label(orderItem.getQuantity() + "x " + orderItem.getDisplayName());
        titleLabel.setMaxWidth(300.0);
        titleLabel.setWrapText(true);
        titleLabel.setFont(this.cashierController.normalFont);
        for (Product addProduct : orderItem.getAdditionalProducts()) {
            titleLabel.setText(titleLabel.getText() + "\n  - " + addProduct.getName());
        }
        for (ProductFreeVariant freeVariant : orderItem.getFreeVariants()) {
            titleLabel.setText(titleLabel.getText() + "\n  - " + freeVariant.getName());
        }
        Region region = new Region();
        region.setPrefSize(1.0, 1.0);
        HBox.setHgrow((Node)region, (Priority)Priority.ALWAYS);
        Label priceLabel = new Label(FormatUtils.formatCurrency((double)(orderItem.getFinalPrice() * (double)orderItem.getQuantity()), (String)this.cashierController.activeConfig.getKioskInfo().getCurrency().getSymbol(this.cashierController.activeConfig.getSelectedLocale())));
        priceLabel.setFont(this.cashierController.normalFont);
        hBox.getChildren().addAll((Object[])new Node[]{titleLabel, region, priceLabel});
        hBox.setStyle("-fx-background-color: white");
        return hBox;
    }

    private Button createButton(String label) {
        Button button = new Button(label);
        button.setPrefWidth(225.0);
        button.setMaxWidth(225.0);
        button.setPrefHeight(50.0);
        button.setFont(this.cashierController.normalFont);
        button.setStyle("-fx-background-color: gray");
        button.setWrapText(true);
        button.setPadding(LayoutUtils.getInsets((double)10.0, (double)5.0, (double)10.0, (double)5.0));
        return button;
    }

    private Button createCategoryButton(Category category) {
        Button button = this.createButton(category.getName());
        button.setOnMouseClicked(mouseEvent -> this.loadCategory(category));
        button.setOnTouchPressed(touchEvent -> this.loadCategory(category));
        return button;
    }

    private Button createProductButton(Product product) {
        Button button = this.createButton(product.getName());
        if (product.getCategory() == 1) {
            button.setText(button.getText().replace("\u0160pagety", "\u0160."));
        }
        if (product.getCategory() == 6) {
            button.setText(button.getText().replace("Fusilli", "F."));
        }
        if (product.getCategory() == 3) {
            button.setText(button.getText().replace("limon\u00e1da", "lim.").replace("Limon\u00e1da", "Lim."));
        }
        if (product.getCategory() == 2) {
            button.setText(button.getText().replace("pol\u00e9vka", "p.").replace("Pol\u00e9vka", "P."));
        }
        if (product.getCategory() == 7) {
            button.setText(button.getText().replace("zmrzlina", "zm.").replace("Zmrzlina", "Zm."));
        }
        button.setOnMouseClicked(mouseEvent -> this.loadProduct(product));
        button.setOnTouchPressed(touchEvent -> this.loadProduct(product));
        return button;
    }

    private Button createMenuOptionButton(MenuOption menuOption) {
        Button button = this.createButton(menuOption.getName());
        button.setOnMouseClicked(mouseEvent -> this.loadMenuOption(menuOption));
        button.setOnTouchPressed(touchEvent -> this.loadMenuOption(menuOption));
        return button;
    }

    private Button createProductVariantButton(Product product, ProductVariant variant) {
        Button button = this.createButton(variant.getName());
        button.setOnMouseClicked(mouseEvent -> this.currentOrder.addOrderItem(new OrderItem(product, variant)));
        button.setOnTouchPressed(touchEvent -> this.currentOrder.addOrderItem(new OrderItem(product, variant)));
        return button;
    }

    private VBox createProductGroupVBox(ProductsGroup productsGroup, ObservableMap<String, String> additionalProducts) {
        VBox vBox = new VBox();
        vBox.setStyle("-fx-background-color: yellow");
        vBox.setEffect((Effect)new DropShadow());
        vBox.setPadding(LayoutUtils.getInsets((double)0.0, (double)10.0, (double)0.0, (double)10.0));
        vBox.setMaxWidth(450.0);
        vBox.setPrefHeight(150.0);
        Label title = new Label(productsGroup.getTitle());
        title.setFont(this.cashierController.subtitleFont);
        FlowPane flowPane = new FlowPane();
        flowPane.setOrientation(Orientation.HORIZONTAL);
        flowPane.setHgap(10.0);
        flowPane.setVgap(10.0);
        flowPane.setPrefHeight(100.0);
        flowPane.setMaxWidth(450.0);
        for (Product product : productsGroup.getProducts()) {
            flowPane.getChildren().add((Object)this.createProductGroupItemButton(product, flowPane, additionalProducts, productsGroup));
        }
        vBox.getChildren().addAll((Object[])new Node[]{title, flowPane});
        return vBox;
    }

    private Button createProductGroupItemButton(Product product, FlowPane flowPane, ObservableMap<String, String> additionalProducts, ProductsGroup productsGroup) {
        Button button = this.createButton(product.getName());
        button.setPrefWidth(180.0);
        button.setOnMouseClicked(mouseEvent -> {
            for (Node otherButton : flowPane.getChildren()) {
                otherButton.setStyle("-fx-background-color: gray");
            }
            if (additionalProducts.containsKey((Object)productsGroup.getId())) {
                additionalProducts.replace((Object)productsGroup.getId(), (Object)product.getId());
            } else {
                additionalProducts.put((Object)productsGroup.getId(), (Object)product.getId());
            }
            button.setStyle("-fx-background-color: green");
            this.menuOptionConfirmButton.setDisable(additionalProducts.size() != this.selectedMenuOption.getAdditionalProductsGroups().size());
            System.out.println("Map Size: " + additionalProducts.size());
            System.out.println("Group size: " + this.selectedMenuOption.getAdditionalProductsGroups().size());
        });
        button.setOnTouchPressed(touchEvent -> {
            for (Node otherButton : flowPane.getChildren()) {
                otherButton.setStyle("-fx-background-color: gray");
            }
            additionalProducts.replace((Object)productsGroup.getId(), (Object)product.getId());
            button.setStyle("-fx-background-color: green");
            this.menuOptionConfirmButton.setDisable(additionalProducts.size() != this.selectedMenuOption.getAdditionalProductsGroups().size());
            System.out.println("Map Size: " + additionalProducts.size());
            System.out.println("Group size: " + this.selectedMenuOption.getAdditionalProductsGroups().size());
        });
        return button;
    }

    private void loadCategory(Category category) {
        this.titleLabel.setText(category.getName());
        this.clearButtonsFlowPane();
        List<Product> enabledProducts = this.products.stream().filter(p -> p.getCategory() == category.getId() && p.isEnabled()).toList();
        for (Product product : enabledProducts) {
            Button button = this.createProductButton(product);
            if (enabledProducts.size() < 10) {
                button.setPrefHeight(100.0);
            }
            this.buttonsFlowPane.getChildren().add((Object)button);
        }
    }

    private void loadProduct(Product product) {
        List<MenuOption> productMenus = this.menuOptions.stream().filter(m -> m.getMainProduct().getId().equals(product.getId()) && m.isEnabled()).toList();
        List<ProductVariant> productVariants = product.getProductVariants().stream().filter(ProductVariant::isEnabled).toList();
        if (!productVariants.isEmpty()) {
            this.clearButtonsFlowPane();
            this.titleLabel.setText(product.getName());
            for (ProductVariant variant : productVariants) {
                Button button = this.createProductVariantButton(product, variant);
                if (productVariants.size() < 10) {
                    button.setPrefHeight(100.0);
                }
                this.buttonsFlowPane.getChildren().add((Object)button);
            }
        } else if (!productMenus.isEmpty()) {
            this.clearButtonsFlowPane();
            this.titleLabel.setText(product.getName());
            for (MenuOption menuOption : productMenus) {
                Button button = this.createMenuOptionButton(menuOption);
                if (productMenus.size() < 10) {
                    button.setPrefHeight(100.0);
                }
                this.buttonsFlowPane.getChildren().add((Object)button);
            }
            Button justItemButton = this.createButton("Samotn\u00fd produkt");
            justItemButton.setOnMouseClicked(mouseEvent -> {
                this.currentOrder.addOrderItem(new OrderItem(product));
                this.goToHome();
            });
            justItemButton.setOnTouchPressed(touchEvent -> {
                this.currentOrder.addOrderItem(new OrderItem(product));
                this.goToHome();
            });
            if (productMenus.size() < 10) {
                justItemButton.setPrefHeight(100.0);
            }
            this.buttonsFlowPane.getChildren().add((Object)justItemButton);
        } else {
            this.currentOrder.addOrderItem(new OrderItem(product));
            this.goToHome();
        }
    }

    private void loadMenuOption(MenuOption menuOption) {
        this.selectedMenuOption = menuOption;
        List productGroups = menuOption.getAdditionalProductsGroups();
        ObservableMap additionalProducts = FXCollections.observableHashMap();
        this.clearButtonsFlowPane();
        for (ProductsGroup productGroup : productGroups) {
            this.buttonsFlowPane.getChildren().add((Object)this.createProductGroupVBox(productGroup, additionalProducts));
        }
        this.menuOptionConfirmButton = this.createButton("OK");
        this.menuOptionConfirmButton.setDisable(true);
        this.menuOptionConfirmButton.setOnMouseClicked(mouseEvent -> {
            OrderItem orderItem = new OrderItem(menuOption);
            orderItem.setAdditionalProducts(this.products.stream().filter(p -> additionalProducts.containsValue((Object)p.getId())).toList());
            this.currentOrder.addOrderItem(orderItem);
            this.goToHome();
        });
        this.buttonsFlowPane.getChildren().add((Object)this.menuOptionConfirmButton);
    }

    private void clearButtonsFlowPane() {
        this.buttonsFlowPane.getChildren().removeAll((Collection)this.buttonsFlowPane.getChildren());
    }

    private void clearOrderOverviewVBox() {
        this.orderOverviewVBox.getChildren().removeAll((Collection)this.orderOverviewVBox.getChildren());
    }

    private void goToHome() {
        this.clearButtonsFlowPane();
        this.loadPopup(this.categories, this.products, this.menuOptions);
    }

    public void hidePopup() {
        this.cashierController.hideNewOrderPopup();
    }
}

