/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka;

import cz.polreich.spagetka.CustomerApp;
import cz.polreich.spagetka.utils.BugsnagSingleton;
import cz.polreich.spagetka.utils.ExceptionHandler;
import javafx.application.Application;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootApplication
@EnableScheduling
@EnableJpaRepositories(value={"cz.polreich.spagetka.repository", "cz.polreich.spagetka.service"})
@EntityScan(value={"cz.polreich.spagetka.models", "cz.polreich.spagetka.service"})
@ComponentScan(value={"cz.polreich.spagetka", "cz.polreich.spagetka.models"})
@EnableRetry
public class CustomerStarter {
    private static BugsnagSingleton bugsnag;

    public static void main(String[] args) {
        bugsnag = BugsnagSingleton.getInstance((String)"e8c5ff74682edb48da9e0f3a4cede7cb");
        ExceptionHandler globalExceptionHandler = new ExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)globalExceptionHandler);
        RetryTemplate retryTemplate = RetryTemplate.builder().maxAttempts(3).fixedBackoff(2000L).build();
        retryTemplate.execute(context -> {
            try {
                Application.launch(CustomerApp.class, (String[])args);
            }
            catch (Exception e) {
                System.out.println("Failed to start application, attempt " + context.getRetryCount());
                ExceptionHandler.logException((Exception)e);
            }
            return null;
        });
    }
}

