/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.utils;

import cz.polreich.spagetka.service.screensaver.ScreensaverResourcesService;
import cz.polreich.spagetka.utils.ExceptionHandler;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.media.Media;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceHelper {
    private static final Logger log = LoggerFactory.getLogger(ResourceHelper.class);

    public static InputStream getResourceAsStream(String filePath) {
        try {
            return ResourceHelper.class.getResourceAsStream(filePath);
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
            return null;
        }
    }

    public static InputStream getImageAsStream(String imageFilePath) {
        InputStream ret = ResourceHelper.getResourceAsStream((String)imageFilePath);
        if (ret == null) {
            ret = ResourceHelper.getResourceAsStream((String)"/resources/images/broken-image.png");
        }
        return ret;
    }

    public static ImageView getImageViewFromResourceName(String imageFilePath) {
        InputStream is = ResourceHelper.getImageAsStream((String)imageFilePath);
        Image image = new Image(is);
        return new ImageView(image);
    }

    public static String getBaseLocation() {
        String location = ResourceHelper.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (location.contains(".jar")) {
            int i;
            String[] locArr = location.split("/");
            for (i = 0; i < locArr.length && !locArr[i].contains(".jar"); ++i) {
            }
            CharSequence[] newArray = Arrays.copyOfRange(locArr, 1, i);
            return "/" + String.join((CharSequence)"/", newArray) + "/";
        }
        return location;
    }

    public static BufferedImage loadImageFromFile(String imagePath) {
        try {
            File file = new File(imagePath);
            return ImageIO.read(file);
        }
        catch (IOException e) {
            ExceptionHandler.logException((Exception)e);
            return null;
        }
    }

    public static String convertImagePathFromExternal(String imagePath) {
        int index = imagePath.lastIndexOf("/");
        String fileName = imagePath.substring(index + 1);
        return "/resources/images/" + fileName;
    }

    public static void transferFileWithSCP(String sourcePath, String destinationPath, String host) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("scp", sourcePath, String.format("%s:%s", host, destinationPath));
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    log.info(line);
                }
            }
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                log.info("File transfer successful.");
            } else {
                log.error("File transfer failed with exit code: " + exitCode);
            }
        }
        catch (Exception e) {
            log.error("An error occurred: " + e.getMessage());
        }
    }

    public static void syncImagesByNameOnly(String sourceDir, String destinationDir, String host) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("rsync", "-r", "--ignore-existing", sourceDir + "/", String.format("%s:%s", host, destinationDir));
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    log.info(line);
                }
            }
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                log.info("Image synchronization successful.");
            } else {
                log.error("Image synchronization failed with exit code: " + exitCode);
            }
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
    }

    public static List<String> getAvailableImagePaths(String resourcesImageFolder) {
        ArrayList<String> imagePaths = new ArrayList<String>();
        Optional folderPathOptional = ResourceHelper.getResourceToURI((String)resourcesImageFolder);
        folderPathOptional.ifPresentOrElse(folderPath -> {
            try {
                if (Files.exists(folderPath, new LinkOption[0]) && Files.isDirectory(folderPath, new LinkOption[0])) {
                    imagePaths.addAll(Files.list(folderPath).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> {
                        String lower = p.toString().toLowerCase();
                        return lower.endsWith(".png") || lower.endsWith(".jpg") || lower.endsWith(".jpeg") || lower.endsWith(".gif");
                    }).map(p -> resourcesImageFolder + "/" + p.getFileName().toString()).toList());
                    log.info("Loaded {} image(s) from folder: {}", (Object)imagePaths.size(), folderPath);
                } else {
                    log.warn("Image folder is invalid or does not exist: {}", folderPath);
                }
            }
            catch (IOException e) {
                log.error("Failed to load images from folder: {}", folderPath, (Object)e);
                ExceptionHandler.logException((Exception)e);
            }
        }, () -> log.warn("Resource path '{}' could not be resolved.", (Object)resourcesImageFolder));
        return imagePaths;
    }

    public static List<String> getAvailableMediaPaths(String resourcesMediaFolder) {
        ArrayList<String> mediaPaths = new ArrayList<String>();
        Optional folderPathOptional = ResourceHelper.getResourceToURI((String)resourcesMediaFolder);
        folderPathOptional.ifPresentOrElse(folderPath -> {
            try {
                if (Files.exists(folderPath, new LinkOption[0]) && Files.isDirectory(folderPath, new LinkOption[0])) {
                    mediaPaths.addAll(Files.list(folderPath).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().toLowerCase().endsWith(".mp4")).map(p -> resourcesMediaFolder + "/" + p.getFileName().toString()).toList());
                    log.info("Loaded {} media file(s) from folder: {}", (Object)mediaPaths.size(), folderPath);
                } else {
                    log.warn("Media folder is invalid or does not exist: {}", folderPath);
                }
            }
            catch (IOException e) {
                log.error("Failed to load media files from folder: {}", folderPath, (Object)e);
                ExceptionHandler.logException((Exception)e);
            }
        }, () -> log.warn("Resource path '{}' could not be resolved.", (Object)resourcesMediaFolder));
        return mediaPaths;
    }

    public static Optional<Path> getResourceToURI(String resourceFolderPath) {
        try {
            URL resourceUrl = ResourceHelper.class.getResource(resourceFolderPath);
            if (resourceUrl == null) {
                log.error("{} does not exist in project", (Object)resourceFolderPath);
                return Optional.empty();
            }
            return Optional.of(Paths.get(resourceUrl.toURI()));
        }
        catch (URISyntaxException e) {
            log.error("Invalid URI syntax for resource: {}", (Object)resourceFolderPath, (Object)e);
            ExceptionHandler.logException((Exception)e);
            return Optional.empty();
        }
    }

    public static Optional<Media> getMedia(String mediaPath) {
        if (mediaPath == null) {
            log.error("media path is null. Returns Optional.empty()");
            return Optional.empty();
        }
        try {
            Media media = new Media(Objects.requireNonNull(ScreensaverResourcesService.class.getResource(mediaPath)).toExternalForm());
            log.info("Created new Media with path - {}", (Object)mediaPath);
            return Optional.of(media);
        }
        catch (Exception e) {
            log.error("Appeared an issue in getting mp4 by path - {}", (Object)mediaPath);
            ExceptionHandler.logException((Exception)e);
            return Optional.empty();
        }
    }
}

