/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup;

import cz.polreich.spagetka.models.gui.buttons.CancelButton;
import cz.polreich.spagetka.models.gui.buttons.ConfirmButton;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.text.Font;
import javafx.stage.Popup;

public class ModalPopup
extends Popup {
    public ModalPopup(String text, Font textFont, String confirmText, String cancelText, Font buttonsFont, double popupWidth, double popupHeight, Consumer<Boolean> onDecision) {
        AnchorPane mainAnchorPane = new AnchorPane();
        mainAnchorPane.getStyleClass().add((Object)"login_anchor_pane");
        mainAnchorPane.setPrefSize(popupWidth, popupHeight);
        mainAnchorPane.setMinSize(popupWidth, popupHeight);
        mainAnchorPane.setMaxSize(popupWidth, popupHeight);
        Label textLabel = new Label(text);
        textLabel.setWrapText(true);
        textLabel.setFont(textFont);
        ConfirmButton confirmButton = new ConfirmButton(confirmText);
        CancelButton cancelButton = new CancelButton(cancelText);
        confirmButton.setFont(buttonsFont);
        cancelButton.setFont(buttonsFont);
        FlowPane buttonsFlowPane = new FlowPane();
        buttonsFlowPane.setHgap(20.0);
        buttonsFlowPane.setAlignment(Pos.CENTER);
        buttonsFlowPane.getChildren().addAll((Object[])new Node[]{confirmButton, cancelButton});
        confirmButton.setOnAction(e -> {
            this.hide();
            onDecision.accept(true);
        });
        cancelButton.setOnAction(e -> {
            this.hide();
            onDecision.accept(false);
        });
        AnchorPane.setTopAnchor((Node)textLabel, (Double)10.0);
        AnchorPane.setLeftAnchor((Node)textLabel, (Double)5.0);
        AnchorPane.setRightAnchor((Node)textLabel, (Double)5.0);
        AnchorPane.setBottomAnchor((Node)buttonsFlowPane, (Double)10.0);
        AnchorPane.setLeftAnchor((Node)buttonsFlowPane, (Double)5.0);
        AnchorPane.setRightAnchor((Node)buttonsFlowPane, (Double)5.0);
        mainAnchorPane.getChildren().addAll((Object[])new Node[]{textLabel, buttonsFlowPane});
        this.getContent().add((Object)mainAnchorPane);
    }
}

