/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service.monitoring;

import cz.polreich.spagetka.service.monitoring.model.KioskStage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SshCommandExecutor {
    private static final Logger log = LoggerFactory.getLogger(SshCommandExecutor.class);
    private final String logPrefix = "[SSH COMMAND EXECUTOR]";
    private final String neededFilesystem = "/dev/mmcblk0p2";

    public void setFreeSpaceInMBForStage(KioskStage kioskStage, boolean isRemote) {
        String[] command = this.buildCommand(kioskStage, isRemote);
        try {
            Process process = new ProcessBuilder(command).start();
            this.parseDiskInfo(process, kioskStage);
            int exitCode = process.waitFor();
            this.handleExitCode(kioskStage, exitCode);
        }
        catch (Exception e) {
            log.error("{} - Error executing command for {}-{}: {}", new Object[]{"[SSH COMMAND EXECUTOR]", kioskStage.getKioskName(), kioskStage.getKioskStageName(), e.getMessage()});
            kioskStage.setComputerIsReachable(false);
        }
    }

    private String[] buildCommand(KioskStage kioskStage, boolean isRemote) {
        if (isRemote) {
            return new String[]{"ssh", "user@kiosk" + kioskStage.getKioskStageName() + ".local", "df --sync"};
        }
        return new String[]{"df", "--sync"};
    }

    private void parseDiskInfo(Process process, KioskStage kioskStage) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("/dev/mmcblk0p2")) continue;
                log.debug(line);
                line = line.replaceAll("\\s{2,}", " ").trim();
                String[] elements = line.split(" ");
                kioskStage.setFreeSpaceMB((long)(Integer.parseInt(elements[3]) / 1024));
                kioskStage.setFreeSpaceInPercent(elements[4]);
                break;
            }
        }
    }

    private void handleExitCode(KioskStage kioskStage, int exitCode) {
        boolean reachable = exitCode == 0;
        kioskStage.setComputerIsReachable(reachable);
        String status = reachable ? "available" : "not available";
        log.debug("{} - Computer {}-{} is {}", new Object[]{"[SSH COMMAND EXECUTOR]", kioskStage.getKioskName(), kioskStage.getKioskStageName(), status});
        log.debug("{} - Command exited with code: {} for stage: {}-{}", new Object[]{"[SSH COMMAND EXECUTOR]", exitCode, kioskStage.getKioskName(), kioskStage.getKioskStageName()});
    }
}

