/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service;

import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.repository.ProductRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductService {
    @Autowired
    private ProductRepository productRepository;

    public List<Product> findByCategory(int category) {
        return this.productRepository.findByCategory(category);
    }

    public List<Product> findEnabledByCategory(int category) {
        return this.productRepository.findByEnabledAndCategory(true, category);
    }

    public void saveAll(List<Product> products) {
        for (Product product : products) {
            System.out.println("Saving product: " + product.getId() + " - " + product.getName());
            if (!this.productRepository.existsById((Object)product.getId())) {
                System.out.println("Product with ID " + product.getId() + " does not exist in DB!");
            }
            this.productRepository.save((Object)product);
        }
    }

    public Product findById(String id) {
        return (Product)this.productRepository.findById((Object)id).get();
    }

    public List<Product> findByIdIn(List<String> ids) {
        return this.productRepository.findByIdIn(ids);
    }

    public List<Product> findAll() {
        return this.productRepository.findAll();
    }

    public List<Product> findEnabled() {
        return this.productRepository.findByEnabled(true);
    }

    public void save(Product product) {
        this.productRepository.save((Object)product);
    }

    public boolean existsById(String id) {
        return this.productRepository.existsById((Object)id);
    }

    public void deleteById(String id) {
        this.productRepository.deleteById((Object)id);
    }

    public void removeAllCompositionItemsFromProducts() {
        List allProducts = this.productRepository.findAll();
        for (Product product : allProducts) {
            product.setIngredients(null);
        }
        this.productRepository.saveAll((Iterable)allProducts);
    }
}

