/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.models.ReceiptInfo;
import cz.polreich.spagetka.models.external.InfoExternal;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.Currency;
import java.util.Locale;

@Entity
@Table(name="kioskInfo")
public class KioskInfo {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    Integer id;
    @Column
    String kioskId;
    @Column
    String name;
    @Column
    Locale language;
    @Column
    Currency currency;
    @Column
    boolean currAtStart;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="receipt_info_id")
    ReceiptInfo receiptInfo;

    public KioskInfo(InfoExternal infoExternal) {
        this.kioskId = infoExternal.getId();
        this.name = infoExternal.getName();
        this.language = Locale.forLanguageTag(infoExternal.getLang());
        this.currency = Currency.getInstance(infoExternal.getCurrencyInfo().getIso());
        this.currAtStart = infoExternal.getCurrencyInfo().isMarkAtStart();
        this.receiptInfo = new ReceiptInfo(infoExternal.getReceiptInfo());
    }

    public Integer getId() {
        return this.id;
    }

    public String getKioskId() {
        return this.kioskId;
    }

    public String getName() {
        return this.name;
    }

    public Locale getLanguage() {
        return this.language;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public boolean isCurrAtStart() {
        return this.currAtStart;
    }

    public ReceiptInfo getReceiptInfo() {
        return this.receiptInfo;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setKioskId(String kioskId) {
        this.kioskId = kioskId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLanguage(Locale language) {
        this.language = language;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public void setCurrAtStart(boolean currAtStart) {
        this.currAtStart = currAtStart;
    }

    public void setReceiptInfo(ReceiptInfo receiptInfo) {
        this.receiptInfo = receiptInfo;
    }

    public KioskInfo() {
    }

    public KioskInfo(Integer id, String kioskId, String name, Locale language, Currency currency, boolean currAtStart, ReceiptInfo receiptInfo) {
        this.id = id;
        this.kioskId = kioskId;
        this.name = name;
        this.language = language;
        this.currency = currency;
        this.currAtStart = currAtStart;
        this.receiptInfo = receiptInfo;
    }
}

