/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.cashierController.inventoryPopup;

import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.controllers.popup.cashierController.InventoryPopup;
import cz.polreich.spagetka.controllers.popup.cashierController.inventoryPopup.ErrorAnchorPane;
import cz.polreich.spagetka.controllers.popup.cashierController.inventoryPopup.StockOutPopup;
import cz.polreich.spagetka.models.StockItem;
import cz.polreich.spagetka.models.StockMovementLogItem;
import cz.polreich.spagetka.models.enums.STOCK_MOVEMENT_ACTION;
import cz.polreich.spagetka.models.enums.STOCK_OUT_ERROR_TYPE;
import cz.polreich.spagetka.models.gui.buttons.ConfirmButton;
import cz.polreich.spagetka.models.gui.buttons.YellowButton;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.InventoryUtils;
import cz.polreich.spagetka.utils.ValidationUtils;
import java.time.LocalDateTime;
import java.util.EnumSet;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;

public class StockOutPopup {
    private final InventoryPopup parentPopup;
    private final Label labelTitle;
    private final FlowPane bottomButtonFlowPane;
    private final AnchorPane popupAnchor;
    private final CashierController cashierController;
    private TextField itemTextField;
    private TextField locationTextField;
    private TextField quantityTextField;
    private ComboBox<DropBoxValue> stockMovementActionDropDown;
    private final ErrorAnchorPane errorAnchorPane;
    private final String dropBoxPromptText = "Vyberte pros\u00edm stav";

    public StockOutPopup(InventoryPopup parentPopup) {
        this.parentPopup = parentPopup;
        this.labelTitle = parentPopup.getLabelTitle();
        this.bottomButtonFlowPane = parentPopup.getBottomButtonFlowPane();
        this.popupAnchor = parentPopup.getPopupAnchor();
        this.cashierController = parentPopup.getCashierController();
        this.init();
        this.errorAnchorPane = new ErrorAnchorPane((Pane)this.popupAnchor, this.locationTextField, this.itemTextField);
    }

    private void init() {
        this.parentPopup.hideButtons();
        this.parentPopup.setWidePopup();
        this.labelTitle.setText("Vyskladn\u011bn\u00ed");
        String locationText = "Lokace:";
        Label locationLabel = new Label(locationText);
        locationLabel.setFont(this.cashierController.subtitleFont);
        AnchorPane.setTopAnchor((Node)locationLabel, (Double)100.0);
        AnchorPane.setLeftAnchor((Node)locationLabel, (Double)10.0);
        String itemText = "Polo\u017eka:";
        Label itemLabel = new Label(itemText);
        itemLabel.setFont(this.cashierController.subtitleFont);
        AnchorPane.setTopAnchor((Node)itemLabel, (Double)250.0);
        AnchorPane.setLeftAnchor((Node)itemLabel, (Double)10.0);
        Label quantityLabel = new Label("Mno\u017estv\u00ed:");
        quantityLabel.setFont(this.cashierController.subtitleFont);
        AnchorPane.setTopAnchor((Node)quantityLabel, (Double)400.0);
        AnchorPane.setLeftAnchor((Node)quantityLabel, (Double)10.0);
        this.locationTextField = new TextField();
        this.locationTextField.setFont(this.cashierController.subtitleFont);
        this.locationTextField.maxWidth(550.0);
        this.locationTextField.getProperties().put((Object)"vkType", (Object)"none");
        AnchorPane.setTopAnchor((Node)this.locationTextField, (Double)150.0);
        AnchorPane.setLeftAnchor((Node)this.locationTextField, (Double)50.0);
        this.itemTextField = new TextField();
        this.itemTextField.setFont(this.cashierController.subtitleFont);
        this.itemTextField.maxWidth(550.0);
        this.itemTextField.getProperties().put((Object)"vkType", (Object)"none");
        AnchorPane.setTopAnchor((Node)this.itemTextField, (Double)300.0);
        AnchorPane.setLeftAnchor((Node)this.itemTextField, (Double)50.0);
        this.quantityTextField = new TextField();
        this.quantityTextField.setFont(this.cashierController.subtitleFont);
        this.quantityTextField.maxWidth(550.0);
        this.quantityTextField.getProperties().put((Object)"vkType", (Object)"none");
        AnchorPane.setTopAnchor((Node)this.quantityTextField, (Double)450.0);
        AnchorPane.setLeftAnchor((Node)this.quantityTextField, (Double)50.0);
        this.generateDropBox();
        ConfirmButton confirmButton = new ConfirmButton("Accept");
        confirmButton.setFont(this.cashierController.subtitleFont);
        confirmButton.setMinSize(160.0, 40.0);
        confirmButton.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.locationTextField.getText().trim().isEmpty() && !this.itemTextField.getText().trim().isEmpty() && !this.quantityTextField.getText().trim().isEmpty() && this.stockMovementActionDropDown.getValue() != null, (Observable[])new Observable[]{this.locationTextField.textProperty(), this.itemTextField.textProperty(), this.quantityTextField.textProperty(), this.stockMovementActionDropDown.valueProperty()}));
        confirmButton.setOnMouseClicked(mouseEvent -> this.confirmButtonAction());
        confirmButton.setOnTouchPressed(touchEvent -> this.confirmButtonAction());
        YellowButton resetButton = new YellowButton("Reset");
        resetButton.setFont(this.cashierController.subtitleFont);
        resetButton.setMinSize(160.0, 40.0);
        this.bottomButtonFlowPane.getChildren().add((Object)resetButton);
        resetButton.setOnMousePressed(mouseEvent -> {
            this.cleanAll();
            this.requestFocus((Control)this.locationTextField);
        });
        this.bottomButtonFlowPane.getChildren().add((Object)confirmButton);
        this.requestFocus((Control)this.locationTextField);
        this.scannerAndSelectingAction();
        this.popupAnchor.getChildren().addAll((Object[])new Node[]{itemLabel, locationLabel, quantityLabel, this.itemTextField, this.locationTextField, this.quantityTextField, this.stockMovementActionDropDown});
    }

    private void scannerAndSelectingAction() {
        this.locationTextField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((Object)KeyCode.TAB)) {
                if (this.locationTextField.getText().startsWith("sto")) {
                    this.requestFocus((Control)this.itemTextField);
                } else {
                    this.locationTextField.setText("");
                    this.requestFocus((Control)this.locationTextField);
                    this.parentPopup.playErrorSound();
                }
                keyEvent.consume();
            }
        });
        this.itemTextField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((Object)KeyCode.TAB)) {
                if (this.itemTextField.getText().startsWith("sti")) {
                    this.requestFocus((Control)this.quantityTextField);
                } else {
                    this.itemTextField.setText("");
                    this.requestFocus((Control)this.itemTextField);
                    this.parentPopup.playErrorSound();
                }
                keyEvent.consume();
            }
        });
        this.quantityTextField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode().equals((Object)KeyCode.TAB)) {
                Double quantity = ValidationUtils.tryParseDouble((String)this.quantityTextField.getText());
                if (quantity != null) {
                    boolean quantityIsValid = this.validateQuantity(quantity.doubleValue());
                    if (quantityIsValid) {
                        this.requestFocus((Control)this.stockMovementActionDropDown);
                    } else {
                        this.quantityTextField.setText("");
                        this.requestFocus((Control)this.quantityTextField);
                        this.parentPopup.playErrorSound();
                    }
                } else {
                    this.quantityTextField.setText("");
                    this.requestFocus((Control)this.quantityTextField);
                    this.parentPopup.playErrorSound();
                }
                keyEvent.consume();
            }
        });
        this.stockMovementActionDropDown.setOnTouchPressed(touchEvent -> this.stockMovementActionDropDownAction());
        this.stockMovementActionDropDown.setOnMouseClicked(clickEvent -> this.stockMovementActionDropDownAction());
    }

    private void stockMovementActionDropDownAction() {
        this.stockMovementActionDropDown.setOnAction(event -> {
            DropBoxValue selected = (DropBoxValue)this.stockMovementActionDropDown.getValue();
            if (selected == null) {
                this.requestFocus((Control)this.stockMovementActionDropDown);
            }
        });
    }

    private boolean validateQuantity(double quantity) {
        String qrCode = this.itemTextField.getText();
        String location = this.locationTextField.getText();
        if (quantity < 0.0) {
            this.errorAnchorPane.create(STOCK_OUT_ERROR_TYPE.NEGATIVE_QUANTITY, (Object)quantity);
            return false;
        }
        if (qrCode.startsWith("sti") && location.startsWith("sto")) {
            boolean stockItemExists = this.cashierController.stockItemService.existsByQrCodeAndLocation(qrCode, location = InventoryUtils.trimInventoryLocation((String)location));
            if (stockItemExists) {
                StockItem stockItem = (StockItem)this.cashierController.stockItemService.findByQrCodeAndLocation(qrCode, location).get(0);
                if (stockItem.getQuantity() - quantity >= 0.0) {
                    return true;
                }
                this.errorAnchorPane.create(STOCK_OUT_ERROR_TYPE.INVALID_QUANTITY, (Object)stockItem.getQuantity());
            } else {
                this.errorAnchorPane.create(STOCK_OUT_ERROR_TYPE.ITEM_NOT_FOUND);
            }
        }
        return false;
    }

    private void confirmButtonAction() {
        String qrCode = this.itemTextField.getText();
        String location = this.locationTextField.getText();
        Double quantity = ValidationUtils.tryParseDouble((String)this.quantityTextField.getText());
        DropBoxValue dropBoxValue = (DropBoxValue)this.stockMovementActionDropDown.getValue();
        if (qrCode.startsWith("sti") && location.startsWith("sto") && dropBoxValue != null && quantity != null) {
            if (quantity < 0.0) {
                this.errorAnchorPane.create(STOCK_OUT_ERROR_TYPE.NEGATIVE_QUANTITY, (Object)quantity);
            }
            try {
                StockItem stockItem;
                location = InventoryUtils.trimInventoryLocation((String)location);
                boolean stockItemExists = this.cashierController.stockItemService.existsByQrCodeAndLocation(qrCode, location);
                if (stockItemExists) {
                    stockItem = (StockItem)this.cashierController.stockItemService.findByQrCodeAndLocation(qrCode, location).get(0);
                    if (!(stockItem.getQuantity() - quantity >= 0.0)) {
                        this.errorAnchorPane.create(STOCK_OUT_ERROR_TYPE.INVALID_QUANTITY, (Object)stockItem.getQuantity());
                        return;
                    }
                } else {
                    this.errorAnchorPane.create(STOCK_OUT_ERROR_TYPE.ITEM_NOT_FOUND);
                    return;
                }
                stockItem.setQuantity(stockItem.getQuantity() - quantity);
                this.cashierController.stockItemService.save(stockItem);
                StockMovementLogItem stockItemMovement = new StockMovementLogItem();
                stockItemMovement.setStockMovementAction(dropBoxValue.stockMovementAction);
                stockItemMovement.setQuantity(quantity);
                stockItemMovement.setStockItem(stockItem);
                stockItemMovement.setTimestamp(LocalDateTime.now());
                this.cashierController.stockMovementLogItemsService.save(stockItemMovement);
                System.out.println("Saving new stock item with id: " + qrCode + " to position " + location);
                this.cleanAll();
                this.parentPopup.playSuccessSound();
                this.requestFocus((Control)this.locationTextField);
            }
            catch (Exception e) {
                System.out.println("Failed to process with id: " + qrCode + " to position " + location);
                this.cleanAll();
                this.requestFocus((Control)this.locationTextField);
                ExceptionHandler.logException((Exception)e);
                this.parentPopup.playErrorSound();
            }
        } else {
            System.out.println("Read invalid data with id: " + qrCode + " to position " + location + " and quantity " + quantity);
            this.cleanAll();
            this.requestFocus((Control)this.itemTextField);
            this.parentPopup.playErrorSound();
        }
    }

    private void cleanAll() {
        this.itemTextField.setText("");
        this.locationTextField.setText("");
        this.quantityTextField.setText("");
        this.stockMovementActionDropDown.setValue(null);
        this.stockMovementActionDropDown.setPromptText("Vyberte pros\u00edm stav");
    }

    private void generateDropBox() {
        this.stockMovementActionDropDown = new ComboBox();
        this.stockMovementActionDropDown.maxWidth(550.0);
        this.stockMovementActionDropDown.setStyle("    -fx-font-size: 16px;\n    -fx-pref-width: 550px;\n    -fx-pref-height: 50px;\n    -fx-background-color: white;\n    -fx-border-color: #c0c0c0;\n    -fx-border-radius: 5px;\n    -fx-background-radius: 5px;\n");
        AnchorPane.setTopAnchor((Node)this.stockMovementActionDropDown, (Double)550.0);
        AnchorPane.setLeftAnchor((Node)this.stockMovementActionDropDown, (Double)50.0);
        List<DropBoxValue> dropBoxValues = EnumSet.allOf(STOCK_MOVEMENT_ACTION.class).stream().filter(i -> i != STOCK_MOVEMENT_ACTION.ADDED && i != STOCK_MOVEMENT_ACTION.USED_IN_RECIPE).map(i -> new DropBoxValue(this, this.cashierController.strings.getString("STOCK_MOVEMENT_ACTION." + i), i)).toList();
        this.stockMovementActionDropDown.getItems().addAll(dropBoxValues);
        this.stockMovementActionDropDown.setCellFactory(lv -> new /* Unavailable Anonymous Inner Class!! */);
        this.stockMovementActionDropDown.setButtonCell((ListCell)new /* Unavailable Anonymous Inner Class!! */);
        this.stockMovementActionDropDown.setPromptText("Vyberte pros\u00edm stav");
    }

    public void requestFocus(Control element) {
        Platform.runLater(() -> ((Control)element).requestFocus());
    }
}

