/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.passwordEncryptor;

import java.io.UnsupportedEncodingException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class MySecretKey {
    public SecretKeySpec generateSecretKey(char[] password, byte[] salt, int iterationCount, int keyLength) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        PBEKeySpec keySpec = new PBEKeySpec(password, salt, iterationCount, keyLength);
        SecretKey tempKey = keyFactory.generateSecret(keySpec);
        System.out.println("Key:" + this.base64Encoder(tempKey.getEncoded()));
        return new SecretKeySpec(tempKey.getEncoded(), "AES");
    }

    public SecretKeySpec getSecretKeySpec(String encodedKey) {
        byte[] decoded = this.base64Decoder(encodedKey);
        return new SecretKeySpec(decoded, 0, decoded.length, "AES");
    }

    private String base64Encoder(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    private byte[] base64Decoder(String string) {
        return Base64.getDecoder().decode(string);
    }

    public String encrypt(String dataToEncrypt, SecretKeySpec key) throws GeneralSecurityException, UnsupportedEncodingException {
        Cipher pbeCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        pbeCipher.init(1, key);
        AlgorithmParameters parameters = pbeCipher.getParameters();
        IvParameterSpec ivParameterSpec = parameters.getParameterSpec(IvParameterSpec.class);
        byte[] cryptoText = pbeCipher.doFinal(dataToEncrypt.getBytes("UTF-8"));
        byte[] iv = ivParameterSpec.getIV();
        return this.base64Encoder(iv) + ":" + this.base64Encoder(cryptoText);
    }

    public String decrypt(String dataToDecrypt, SecretKeySpec key) throws GeneralSecurityException, UnsupportedEncodingException, NoSuchAlgorithmException {
        Cipher pbeCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        String[] split = dataToDecrypt.split(":");
        byte[] iv = this.base64Decoder(split[0]);
        pbeCipher.init(2, (Key)key, new IvParameterSpec(iv));
        byte[] cryptoText = this.base64Decoder(split[1]);
        byte[] decryptedData = pbeCipher.doFinal(cryptoText);
        return new String(decryptedData, "UTF-8");
    }
}

